"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsServiceRoller = exports.RollTrigger = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * The rule or schedule that should trigger a roll
 */
class RollTrigger {
    /**
     * Schedule that should trigger a roll
     */
    static fromSchedule(schedule) {
        return { schedule };
    }
    /**
     * Rule that should trigger a roll
     */
    static fromRule(rule) {
        return { rule };
    }
}
exports.RollTrigger = RollTrigger;
_a = JSII_RTTI_SYMBOL_1;
RollTrigger[_a] = { fqn: "cloudstructs.RollTrigger", version: "0.6.1" };
/**
 * Roll your ECS service tasks on schedule or with a rule
 */
class EcsServiceRoller extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const rule = props.trigger?.rule ?? new events.Rule(this, 'Rule', {
            schedule: props.trigger?.schedule ?? events.Schedule.cron({
                minute: '0',
                hour: '0',
            }),
        });
        rule.addTarget(new targets.AwsApi({
            service: 'ECS',
            action: 'updateService',
            parameters: {
                service: props.service.serviceName,
                cluster: props.cluster.clusterName,
                forceNewDeployment: true,
            },
            // https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-supported-iam-actions-resources.html
            // arn:aws:ecs:<region>:<account>:service/<cluster-name>/<service-name>
            policyStatement: new iam.PolicyStatement({
                actions: ['ecs:UpdateService'],
                resources: [aws_cdk_lib_1.Stack.of(this).formatArn({
                        service: 'ecs',
                        resource: 'service',
                        resourceName: `${props.cluster.clusterName}/${props.service.serviceName}`,
                    })],
            }),
        }));
    }
}
exports.EcsServiceRoller = EcsServiceRoller;
_b = JSII_RTTI_SYMBOL_1;
EcsServiceRoller[_b] = { fqn: "cloudstructs.EcsServiceRoller", version: "0.6.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvZWNzLXNlcnZpY2Utcm9sbGVyL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQW9DO0FBRXBDLGlEQUFpRDtBQUNqRCwwREFBMEQ7QUFDMUQsMkNBQTJDO0FBQzNDLDJDQUF1QztBQXdCdkM7O0dBRUc7QUFDSCxNQUFzQixXQUFXO0lBQy9COztPQUVHO0lBQ0ksTUFBTSxDQUFDLFlBQVksQ0FBQyxRQUF5QjtRQUNsRCxPQUFPLEVBQUUsUUFBUSxFQUFFLENBQUM7SUFDdEIsQ0FBQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFpQjtRQUN0QyxPQUFPLEVBQUUsSUFBSSxFQUFFLENBQUM7SUFDbEIsQ0FBQzs7QUFiSCxrQ0E0QkM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSxnQkFBaUIsU0FBUSxzQkFBUztJQUM3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxJQUFJLEdBQUcsS0FBSyxDQUFDLE9BQU8sRUFBRSxJQUFJLElBQUksSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDaEUsUUFBUSxFQUFFLEtBQUssQ0FBQyxPQUFPLEVBQUUsUUFBUSxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO2dCQUN4RCxNQUFNLEVBQUUsR0FBRztnQkFDWCxJQUFJLEVBQUUsR0FBRzthQUNWLENBQUM7U0FDSCxDQUFDLENBQUM7UUFHSCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksT0FBTyxDQUFDLE1BQU0sQ0FBQztZQUNoQyxPQUFPLEVBQUUsS0FBSztZQUNkLE1BQU0sRUFBRSxlQUFlO1lBQ3ZCLFVBQVUsRUFBRTtnQkFDVixPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXO2dCQUNsQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXO2dCQUNsQyxrQkFBa0IsRUFBRSxJQUFJO2FBQ087WUFDakMsdUdBQXVHO1lBQ3ZHLHVFQUF1RTtZQUN2RSxlQUFlLEVBQUUsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO2dCQUN2QyxPQUFPLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQztnQkFDOUIsU0FBUyxFQUFFLENBQUMsbUJBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDO3dCQUNuQyxPQUFPLEVBQUUsS0FBSzt3QkFDZCxRQUFRLEVBQUUsU0FBUzt3QkFDbkIsWUFBWSxFQUFFLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUU7cUJBQzFFLENBQUMsQ0FBQzthQUNKLENBQUM7U0FDSCxDQUFDLENBQUMsQ0FBQztJQUNOLENBQUM7O0FBL0JILDRDQWdDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YWNrIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgZWNzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lY3MnO1xuaW1wb3J0ICogYXMgZXZlbnRzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1ldmVudHMnO1xuaW1wb3J0ICogYXMgdGFyZ2V0cyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZXZlbnRzLXRhcmdldHMnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYSBFY3NTZXJ2aWNlUm9sbGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRWNzU2VydmljZVJvbGxlclByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBFQ1MgY2x1c3RlciB3aGVyZSB0aGUgc2VydmljZXMgcnVuXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyOiBlY3MuSUNsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBFQ1Mgc2VydmljZSBmb3Igd2hpY2ggdGFza3Mgc2hvdWxkIGJlIHJvbGxlZFxuICAgKi9cbiAgcmVhZG9ubHkgc2VydmljZTogZWNzLklTZXJ2aWNlO1xuXG4gIC8qKlxuICAgKiBUaGUgcnVsZSBvciBzY2hlZHVsZSB0aGF0IHNob3VsZCB0cmlnZ2VyIGEgcm9sbFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHJvbGwgZXZlcnlkYXkgYXQgbWlkbmlnaHRcbiAgICovXG4gIHJlYWRvbmx5IHRyaWdnZXI/OiBSb2xsVHJpZ2dlcjtcbn1cblxuLyoqXG4gKiBUaGUgcnVsZSBvciBzY2hlZHVsZSB0aGF0IHNob3VsZCB0cmlnZ2VyIGEgcm9sbFxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgUm9sbFRyaWdnZXIge1xuICAvKipcbiAgICogU2NoZWR1bGUgdGhhdCBzaG91bGQgdHJpZ2dlciBhIHJvbGxcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVNjaGVkdWxlKHNjaGVkdWxlOiBldmVudHMuU2NoZWR1bGUpOiBSb2xsVHJpZ2dlciB7XG4gICAgcmV0dXJuIHsgc2NoZWR1bGUgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSdWxlIHRoYXQgc2hvdWxkIHRyaWdnZXIgYSByb2xsXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21SdWxlKHJ1bGU6IGV2ZW50cy5SdWxlKTogUm9sbFRyaWdnZXIge1xuICAgIHJldHVybiB7IHJ1bGUgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSb2xsIHNjaGVkdWxlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gcm9sbCBldmVyeWRheSBhdCBtaWRuaWdodFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHNjaGVkdWxlPzogZXZlbnRzLlNjaGVkdWxlO1xuXG4gIC8qKlxuICAgKiBSb2xsIHJ1bGVcbiAgICpcbiAgICogQGRlZmF1bHQgLSByb2xsIGV2ZXJ5ZGF5IGF0IG1pZG5pZ2h0XG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcnVsZT86IGV2ZW50cy5SdWxlO1xufVxuXG4vKipcbiAqIFJvbGwgeW91ciBFQ1Mgc2VydmljZSB0YXNrcyBvbiBzY2hlZHVsZSBvciB3aXRoIGEgcnVsZVxuICovXG5leHBvcnQgY2xhc3MgRWNzU2VydmljZVJvbGxlciBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBFY3NTZXJ2aWNlUm9sbGVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgcnVsZSA9IHByb3BzLnRyaWdnZXI/LnJ1bGUgPz8gbmV3IGV2ZW50cy5SdWxlKHRoaXMsICdSdWxlJywge1xuICAgICAgc2NoZWR1bGU6IHByb3BzLnRyaWdnZXI/LnNjaGVkdWxlID8/IGV2ZW50cy5TY2hlZHVsZS5jcm9uKHtcbiAgICAgICAgbWludXRlOiAnMCcsXG4gICAgICAgIGhvdXI6ICcwJyxcbiAgICAgIH0pLFxuICAgIH0pO1xuXG5cbiAgICBydWxlLmFkZFRhcmdldChuZXcgdGFyZ2V0cy5Bd3NBcGkoe1xuICAgICAgc2VydmljZTogJ0VDUycsXG4gICAgICBhY3Rpb246ICd1cGRhdGVTZXJ2aWNlJyxcbiAgICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgICAgc2VydmljZTogcHJvcHMuc2VydmljZS5zZXJ2aWNlTmFtZSxcbiAgICAgICAgY2x1c3RlcjogcHJvcHMuY2x1c3Rlci5jbHVzdGVyTmFtZSxcbiAgICAgICAgZm9yY2VOZXdEZXBsb3ltZW50OiB0cnVlLFxuICAgICAgfSBhcyBBV1MuRUNTLlVwZGF0ZVNlcnZpY2VSZXF1ZXN0LFxuICAgICAgLy8gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvbkVDUy9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZWNzLXN1cHBvcnRlZC1pYW0tYWN0aW9ucy1yZXNvdXJjZXMuaHRtbFxuICAgICAgLy8gYXJuOmF3czplY3M6PHJlZ2lvbj46PGFjY291bnQ+OnNlcnZpY2UvPGNsdXN0ZXItbmFtZT4vPHNlcnZpY2UtbmFtZT5cbiAgICAgIHBvbGljeVN0YXRlbWVudDogbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICBhY3Rpb25zOiBbJ2VjczpVcGRhdGVTZXJ2aWNlJ10sXG4gICAgICAgIHJlc291cmNlczogW1N0YWNrLm9mKHRoaXMpLmZvcm1hdEFybih7XG4gICAgICAgICAgc2VydmljZTogJ2VjcycsXG4gICAgICAgICAgcmVzb3VyY2U6ICdzZXJ2aWNlJyxcbiAgICAgICAgICByZXNvdXJjZU5hbWU6IGAke3Byb3BzLmNsdXN0ZXIuY2x1c3Rlck5hbWV9LyR7cHJvcHMuc2VydmljZS5zZXJ2aWNlTmFtZX1gLFxuICAgICAgICB9KV0sXG4gICAgICB9KSxcbiAgICB9KSk7XG4gIH1cbn1cbiJdfQ==