import tkinter
from tkinter import *
from tkinter import filedialog, ttk, scrolledtext
import tensorflow as tf
from tensorflow import keras
from io import BytesIO
import base64
from PIL import ImageTk, Image

try:
    import xml_parser as xmlparser
    import hmod_parser as hmodparser
    import neural_network_parser
except:
    import sbml2hyb.xml_parser as xmlparser
    import sbml2hyb.hmod_parser as hmodparser
    import sbml2hyb.neural_network_parser as neural_network_parser


logo = "iVBORw0KGgoAAAANSUhEUgAABKIAAAEfCAYAAAByCG6GAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAMsAAADLAAShkWtsAAP+lSURBVHhe7J0HYBTH+fZPjeLuFMdJnPY5+SdxgmTHcVziuDeqdCeJYsCYXgzuvWFsMBjQHSC6QL333hESHfWKJNR779L1u+eb2VthLM7Y2CAjeH/Kw+7tzG2b2R2/T2bmJARxOQBBEMRPgPgKIgiCIAiCIAiCIK4nxJiQIAhiVBFfQQRBEARBEARBEMT1hBgTEgRBjCriK4ggCIIgCIIgCIK4nhBjQoIgiFFFfAURBEEQBEEQBEEQ1xNiTEgQBDGqiK8ggiAIgiAIgiAI4npCjAkJgiBGFfEVRBAEQRAEQRAEQVxPiDEhQRDEqCK+ggiCIAiCIAiCIIjrCTEmJAiCGFXEVxBBEARBEARBEARxPSHGhARBEKOK+AoiCIIgCIIgCIIgrifEmJAgCGJUEV9BBEEQBEEQBEEQxPWEGBMSBEGMKuIriCAIgmDYyRQgkUgkEunHSmxWCOLqRowJCYIgRhXxFUQQBEEwzAUTJBKJRCJdqsRmhSCubsSYkCAIYlQRX0EEQRAEw1wwQSKRSCTSpUpsVgji6kaMCQmCIEYV8RVEEARBMMwFEyQSiUQiXarEZoUgrm7EmJAgCGJUEV9BBEEQBMNcMEEikUgk0qVKbFYI4upGjAkJgiBGFfEVRBAEQTAomCAIgiAuFWo7iDGLGBMSBEGMKuIriCAIgmBQMEEQBEFcKtR2EGMWMSYkCIIYVcRXEEEQBMGgYIIgCIK4VKjtIMYsYkxIEAQxqoivIIIgCIJBwQRBEARxqVDbQYxZxJiQIAhiVBFfQQRBEASDggmCIAjiUqG2gxiziDEhQRDEqCK+ggiCIAgGBRMEQRDEpUJtBzFmEWNCgiCIUUV8BREEQRAMCiYIgiCIS4XaDmLMIsaEBEEQo4r4CiIIgiAYFEwQBEEQlwq1HcSYRYwJCYIgRhXxFUQQBEEwKJggCIIgLhVqO4gxixgTEgRBjCriK4ggCIJgUDBBEARBXCrUdhBjFjEmJAiCGFXEVxBBEATBoGCCIAiCuFSo7SDGLGJMSBAEMaqIryCCIAiCQcEEQRAEcalQ20GMWcSYkCAIYlQRX0EEQRAEg4IJgiAI4lKhtoMYs4gxIUEQxKgivoIIgiAIBgUTBEEQxKVCbQcxZhFjQoIgiFFFfAURBEEQDAomCIIgiEuF2g5izCLGhARBEKOK+AoiCIIgGBRMEARBEJcKtR3Ej8bOXvFHcxWJRCKRSCSSeU1ylC8Qm1GCGNOYq99iEkEQBEGYhdoO4kfDKs2ukZWIRCKRSCTSt0meLTahBDHmMVfHxSSCIAiCMAu1HcSP4p+yHX8zV4lIJBKJRCJ9ixzlM8VmlCDGPObquJhEEARBEGahtoP4UdjKFO7mKhGJRCKRSCRzkh8Vm1CCuCYwV8/FJIIgCIIwC7UdxA/G1nH7feYqEIlEIpFIJPOaJN06Q2xGCeKawFw9F5MIgiAIwizUdhA/GDuZPODCCiRvvX/ZPhsxyxVF/AErgiCIUUV8BRHERbGVKopHtpG2MnmymEwQ1wwj6zmXmEQQBEEQZqG2g/hB3Ou49RFzlcdWpnhTzHLFEWNCgiCIUUV8BRHEt2InVSw310beK932rJiFIK4ZzNV1MYkgCIIgzEJtB/GDsJXKI0ZWHFuZvEZMHhXEmJAgCGJUEV9BBPGt2EkVVSPbSDvZtigxmSCuKS6s6xRMEARBEBeH2g7ikrGVyp8yV3EmSV1WiVlGBTEmJAiCGFXEVxBBmMVOqnjdXBtp67DtUTELQVxTmKvvYhJBEARBmIXaDuKSsZPKEy+oOFJ5qZg8aogxIUEQxKgivoII4gKcnYOtbGWKppFtpK1UESRmIYhrjpH1nUtMIgiCIAizUNtBXBJ2UvlUc5XGTuqyUMwyaogxIUEQxKgivoII4gJsZYoPzLWR9znK/y1mIYhrDnN1XkwiCIIgCLNQ20FcEnZSecYFlUYqzxWTRxUxJiQIghhVxFcQQXyDe5x33sTaw+4L2kiZwlPMQhDXJGbqPL0nCYIgiItCbQfxvZkklTuZqzC20m2zxSyjihgTEgRBjCriK4ggvoGdo3yduTaSbf+HmIUgrknM1XsxiSAIgiDMQm0H8b2xlSlOj6wstlLFcTF51BFjQoIgiFFFfAURxDnuddr+S9YeKi9oI2XyvWIWgrhmGVnvucQkgiAIgjALtR3E98LOcds8c5WFyUHMMuqIMSFBEMSoIr6CCOIctlL5ZjPtIybJ5P9PzEIQ1yzm6r6YRBAEQRBmobaD+F6wilE4sqIwHRKTfxLEmJAgCGJUEV9BBCHwD/utvzPTPvLeUAoxC0Fc05ir/2ISQRAEQZiF2g7iO7FzUCw1V1FsZYrnxSw/CWJMSBAEMaqIryCCEGDt4Y4L2kepXH/fDNffiFkI4ppmZP3nEpMIgiAIwizUdhDfia1UUTGyktjKFLFi8k+GGBMSBEGMKuIriCAktg5b/29k+yhIKv9SzEIQ1zzmngExiSAIgiDMQm0HcVFspYpXzVWSSTLFY2KWnwwxJiQIghhVxFcQQfD/iHIb2T7aSeUDk17cfbuYhSCueS54BpjEJIIgCIIwC7UdxMWwsJPJG8xUkhAx/SdFjAkJgiBGFfEVRFzn3Ct1sTPTPsLWQfGpmIUgrgvMPQdiEkEQBEGYhdoO4luxk8nfNVdB7Bxc/iNm+UkRY0KCIIhRRXwFEdc5tjKF78j20VYqb3/IyWWimIUgrgtGPgdcYhJBEARBmIXaDsIs/D+kbWXyzpGVg/1Hto+Y5SdHjAkJgiBGFfEVRFzH2DoqHhzZPop6R8xCENcNZp4Dek8SBEEQF4XaDsIstjL5WnOVY5K9yyQxy0+OGBMSBEGMKuIriLiOsZMqQs20kfViMkFcV5h5Fug9SRAEQVwUajuIC7jHyeVntjL50MiKwbbtF7NcFYgxIUEQxKgivoKI6xQ7R8UTI9tHoY2UyteIWQjiusLc8yAmEQRBEIRZqO0gLsBWJt9krmLc5+TyZzHLVYEYExIEQYwq4iuIuE6xlcrjzLSR5WIyQVx3mHke6D1JEARBXBRqO4hvYOfk8ls7qcJwYcWQbxezXDWIMSFBEMSoIr6CiOsQW+n2Fy5sHxWYJJUvEbMQxHWHuWdCTCIIgiAIs1DbQXwDO6lim5lKYZwk3X6XmOWqQYwJCYIgRhXxFURch9hK5Wkj20hbmSJfTCaI65KRzwSXmEQQBEEQZqG2gzjHvxy2322uQthKFV+JWa4qxJiQIAhiVBFfQcR1hp3URWqujbSTyueKWQjiusTccyEmEQRBEIRZqO0gzmErVewbWRnYNuUDDq4/F7NcVYgxIUEQxKgivoKI6ww7mfzEyDbSTio/JSYTxHXLBc8Fk5hEEARBEGahtoMQsJVu+6e5ymAnVXwmZrnqEGNCgiCIUUV8BRHXEffKXF4010baylwcxSwEcd1i7tkQkwiCIAjCLNR2EAJ2UoX3BZVBquiyfXbLjWKWqw4xJiQIghhVxFcQcR1hK5XnjWwj2bbDYjJBXNeMfDa4xCSCIAiCMAu1HYTkXum2B8xVBDup4j0xy1WJGBMSBEGMKuIriLhOsHVULDLXRt4r2zZFzPKjePq1o09wiR8JYsxh7vkQkwiCIAjCLNR2EBJbmTx4ZCWwlSoaJWvXWopZrkrEmJAgCGJUEV9BxHWCnVRROrKNtJPJE8TkHww3n55549jhZ948hqffOHrVDoMniO/iwueDggmCIAji4lDbcZ0zyVH+P3OVYJJM/pqY5apFjAkJgiBGFfEVRFwH2Enlr5hrI+1k258Us1wy5xtQwyIjihjLmHtGxCSCIAiCMAu1Hdc5djJ5zMgKYCuTV4rJVzViTEgQBDGqiK8g4jrAVqqovbCNVISLyZeEOQOKjCjiWmDkM8IlJhEEQRCEWajtuI6xc5Q/Z64C2Mnky8QsVzViTEgQBDGqiK8g4hrHVrbtLXNt5D8dFA+LWb4XFzOghkVGFDGWMfeciEkEQRAEYRZqO65j7KTy1AsrgLxITL7qEWNCgiCIUUV8BRHXMH9+Yft41h62jWwjbaUKPzHLd/J9DKhhkRFFjGVGPidcYhJBEARBmIXajuuUex3k9uYK31Ymny9mueoRY0KCIIhRRXwFEdcwrD38eGT7KMhZca+Y5Vu5FANqWGREEWMZc8+KmEQQBEEQZqG24zrFVqo4NrLgbWXyTDF5TCDGhARBEKOK+AoirlHs7BW3sfawb2QbaSeVHxSzmOWHGFDDIiOKGMtc8KwwiUkEQRAEYRZqO65DbGWKWeYK/l7pNmcxy5hAjAkJgiBGFfEVRFyj2MpcNphrI/8p2/o3Mcs3+DEG1LDIiCLGMuaeFzGJIAiCIMxCbcd1CCvknJGFbidVHBGTxwxiTEgQBDGqiK8g4hrkHuedd9pK5dqRbaStTLFTzHKOy2FADYuMKGIsM/J54RKTCIIgCMIs1HZcZ7ACfnlkgXPZOmybJmYZM4gxIUEQxKgivoKIaxA7qdzFXBt5n2zLH8Qsl9WAGhYZUcRYxtwzIyYRBEEQhFmo7bjOsJXJz4wscFupIklMHlOIMeGPx8jF/hFlHBb7MzDphaUJIeuPlZHtVZRpy3lckJmJ823bv8FwAt8vP3Nx/8Obuc7jG5vOXT9f/xZdRobv8Y+Bf9t0pSMRU4T7e2HqtQS/uuHi+ebdPP/unJ/j2/R94PvSm8TvrSD23WEJH3m904n5+HbTYvgQ562OacRXEHGNYeu05U8j20dBUvlWnn4lDKhhkRFFjGXMPTdiEkEQBEGYhdqO6whbmWKluQKf5LjtaTHLmEKMCX88PDI2sH9EDZskwybUsBE1HET/aBnZHkWZtpzHBZm/h4ST4ysmk8AIrSCDsOTugJiPS+Sbm9i//FzONxb4Ps+XKeNlYfj+DuuHwr/Jr/jC0xNTjDomnuPaZfjah2VCvH7BEOI6vyC/Td8Hvk8Nk5Ydgt9bLvbd4WeH33KDni3U7Az4cfl2tuAST46vXgslIr6CiGsMO6l894VtpFz9+OpUhytlQA2LjChiLHPhc0PBBEEQBHFxqO24jrCTKqrNFHikmDzmEGPCywMPlIclcv4mQeyf79L34ZtGjLhxBHzzOX3jw3k6zzyDgfewMplb3IAa1td9uS4Gz6Nl4haBKH5QQezjsC4T37z+H7dj86fHPw27H99MudZgd1D4O3edwir753xTUbgX36XvA8/HDSZeR4QDmRZC/eNLvmpgqTq2eTjta/FTMbA/blWNdcRXEHENcZ+D4u8j28d/v3gAT6xJqTVnHF1umTOizOUbKd5LS8x+Aebyj9QV/f73MO9+8u9fxAAc69/naea+c74u1/dHPjtcwk4IgiAI4lugtuM6wU667Q1zhW0nk/9XzDLmEGPCH81wzyfTYDaTOSIYJOcZPUY9S/k+Er97cZmC8vO3jYzauS00LKFPi/id87KYNp4TP/aFRhT/dL51cI7hffEE9l0YNUy8p8uweG8XbkixNPEY55/vt+n78EO+Y57hixiWCb71fF3LDJe5UFa8HIfrAy/XYX3jHn2bvhtWWuLf1/d2+HDnDsvKU8f2x2qjabfD58AS+bA9vVAnea0e24ivIOIawlYq9xjZPj68OFj11OtHvjQXgF9umTMEzOUbKTKiyIgSs18ATzP3nfN1ub4/8tnhEnZCEARBEN8CtR3XAY8/vtbaTipvuaCwpfJAMcuYRIwJfzQ6FiCrDSw8ZtLxoUV6kww6FkGLMjLptbqLi+dj8fd3SfB9hHUenJsCdMFMECJ3bhvpoGb/qkTxwVBiLC/4QsMBvlHPvnvOBGPna9AJ0hs158SvSc3yc2mY+OWwLCaHi++YS8dtA815Mg3tMxp1wnl9reHz/XZ9H37Id8zDLmh4iJhwU0zwPfJPw3f02oVXiGHjkBcsu9pzjhBLNlUlBr8L36Xvhufiux3W8O6HpWWH5eLr/BS+8QVulAomlJqJV7qxjfgKIq4RJknl/7qgfWS6V7rtQ57Og+3vE5T/GF3MECCIqx1zz4+YRBAEQRBmobbjOoD9R/aH5gqa/8e3mGVMIsaEP5phI0rzHUYU/3xxGaBnwfd3ycCCcgM7DjeNvjZ5+HAmkwHEQ3luRCmZLjCizgvwv5cRxfatYl9SM2nYDnTsOwad6Bhwadg++Lmzo5zfk4r3o+L9V3jfFm4hcI00kMzp+/BDvmMediOucyPqXJ0xZ0Rx8Vsj3IXv0nfDc/HdfVPs6Oz5+Vqm2aEubkTx2j22EV9BxDUCaw8DRraP/P+8uX/ZPhsxi8CVNKTIiCLGMhc8P0xiEkEQBEGYhdqOa5y/zvjqZluZvGdkIfNhCGKWMYsYE/5oeIjMLRc9Wxq4OcKiaMEgEQJ6k/g2nnYx8WFJWhZ8X1w8r+Yb+mbPI3Y2PKA32QuChMCeie3etHJO4jkK4t8z7cNkJHFp2HdNA6G4YcDPj58nv5bh6zJdG7edeM5hmSwofj+GvQy+HGkgXS79cPh3zzkdfIMA38ol3DO+4RrGZBgKpcvuJa8D7Iq/UUdMub5b343pbgtHEsXqCKtvOkFaUbwmcfOSwf85Vzy8rPVslYbmEVcXfHj6yPZRaCNlijfFLBdwJQwpMqKIsYy5Z0hMIgiCIAizUNtxjWMrlX9hrpDvnbHlHjHLmEWMCS8LPH4XJH4W4B9E8Ziah/vfJh6Yc/NIxTKqWP5vE++ZZMAg0xCLzVVMaib2TQM3Eniwzg7H9qFnAT03hQxsySWYVbwH1Xn6Rg8Ys0aUqWfTsG3wtSsgiuXl4paTqT+U6RqGDbDzOk0JS1NProvrfIPp++rHwPZw7u9r+Pr5ujbhVzZcZjp2H7n0rPLwCcMNvFzFdVZy30PfB3aX2f5M9YzVK1ZvDQZupvI6rGKfVez4albj2Haejxudpm5TQnUzsHrKbSr+N9YRX0HENYCtTBF5QRspVVSLyRflchpSZEQRY5kLniEmMYkgCIIgzEJtxzWMrXTLHfynpy8oZKl8t5hlTCPGhD8eHtEPx+Pn+Rbnb+bBPgu1BbGw+5xU35ARgyzvxTTE8ujRx3L3Mw0KAbwQzAtGFDsmO5hJGia1IAhL/vnrbUaDim3nGdlO+QkKhg5fMbBN3HwyGVGCrWTUnNM354EyrXPDS82+zg0nPgyQL899Pm/dZDYZzUg0ob6PESWc6je3/VD4N01XbFr/Gr5FNNqE9WsTfs3Dc4nxpalUufXIS1Qr/PHl13fpYvoe8Ipp4PVJrFOsPkKoh0PsM5NhgNXnQXZEbkix+sXqNDuBc+LVVcfKm/eYGuuIryBijDPJcdvTF7SPTLYyxUoxy/fichhSZEQRYxlzz5GYRBAEQRBmobbjGoYV5paRhctl67TlT2KWMY0YE/54uBli+FrDBsmwpcPjaB7Sq1mArWbhvoqtK1kql2BIsQCdzy/F55kSej6xfahY1M2XvAeUmu3DJG4Y8F4qPezfXugFM4rthQftgvvEj8+DfW7q8CCffcPIjSgW7OuHYNQNwaBTwaDXsKxaMS/7jvA/fr586BP74z1VhB4rerYfFvbr2P713Bj4uveKTrgKLrXJsGDHHhYfwmfqQ8U/G6Bjx9ELRhk/T74vdnwduyIt25dOw9J04HNR8ftgGqbIh2zxJT8r4fRM58j2Y9Cx8xGGA7LPPF1I/GFwm4kbZ9xqGbacTLvj/3Ijihsm7D7wnjncFGFXy3vymEw/MSdb6vVjs4cOv78qHatX7MJNRhTv2catJ25F8SFwpi1CLeamHL/pvM7waxeun5cP/+N3bhi+nX/mtd+0HNbwvGbCnFy8brL6CMOgIKNeXBqHWNmzOspNT1bnDFp2r9k58jLQs7rKe9aNzbv9TcRXEDHGsZPKEy9oH2XyM2LyJfNjDCkyooixzMjniEtMIgiCIAizUNtxjXK/87bfmytcW5mLXMwy5hFjwh8PD8q5oSNqOE7nH032BV9yC6mHLQeFUH+4txCffFzIIGxgH/hEUGr2LbWWfWZLnkFwXXhGlkfYYz9bG2AB+xD7Kp+8mQ+PMxkCw0PwTL2ZuImgZCcywI7Rx/bXB71GaZpIne2F71v4NT8Dtx1MlpLSqIZKz9bYdsF74J6ByY9hn7nBxY0oJdvzEMuvZns3nQE3sQSxL5mG830twdAxqFgqN874ufSz6+sBVN0wavrZJSuFvfUJZ8F74/Dz4XvhhpTYW4qdM7hppRyCnt0j7gt9wxP5AfA7NMj2bzL4REPq3L74HWL3z8COqWLH1/Kp39k9Z/dSzdb5/WFfZ+ehh0rJrmmMYTLQDNAoubnHroPdBw0raDUrJy2rA8M94Yx6kykkTIzPr1mYqIxdOFvl8AUvJ6EMhMJg+YSec7yeDFuoQj85aNm94l8XbpyO3U9eB/SsLugHodexcuXH4JWO1T9hPzpWD1l9FQwsdn6mifN5zR77iK8gYgxj67Btmrk2kullMcsP5ocYUmREEWMZM88RvScJgiCIi0JtxzWKrUyxc2TBsm26e5x33ilmGfOIMeGPhwfg3zCiTGLhuSBTzyDea0gJobcRy6Nj0TSLs8HifKHTkhBd8yhdyT6odCYTihsETDr+kUnFNvE5pISeQWwf3LcaYtv6udg61yA7Bd6rSrCA2LG0ehbg63iPkyF2ANOBeLDPf92P9ywycDOCnYySnYjSoIRar2Tf0UDPe6Jwc4yfFzu24DiwY3IbQMM0xNTHNnaz4/SybPy4fez4ney8O1RaQV3spHvZ/gdYWj875w7VAHq0SsHo0jHpBSnZ+iC79EFojIPsutTs/ISbAT1b12gGoRrqg1rZD6OW3yzeI8nUK+nckD7BBbl0+ETZGrY/fmnD+npPfN+8xxa7Z+y69LwnGQZZHhVUGg1UanYP2Rd4TzSedjGG68PVhFA/uZPH/sfLlZuRalbuKlYPuBmlYZVSw9c1vN7w2sQulpuBrI4K9YLXCQa/KsGIYvvhvZaEsmHfPV+mYZy8lx27p/wL/F7wHnGsbPkDYGD1QMM+a7jJxM5Jp+PGFb+vrB6qeZnzkmFfYV9WspuuZnVqrCO+gogxjJ1UnjGyjWTKEZMvC5diSJERRYxlzDxL9J4kCIIgLgq1Hdcgk5wUfzVXsEwbxCzXBGJM+OPhwbUY0HMJQ9p44A0+hTeXmgXYaqiFYWUsIw/iuXfB4nBjnx76Pi00/RpoB1kArlbziFvYn5bF3wNsU4cSaGJ5G9iygSU39zH1A/UDQDXTWbZexlTB8lSz/I3su70soB8wmHqQcKtluJcSN5L0Rg07BDcGeC8qU4CvMeiEbUJPGH5wfp68Z5aSiTtgWgP0ej7HFe+PBbQx1bLrOKs2omTQiNxuA061qZBe24Pks21ILG9BSkU7Dtd042hDP040D+J0Uz/yu9QoVxrRwL7bwQ7Rp2PnqFVBz3sc6dTQKQdg1LB1PbsQPryQGxXaAfaxnx2fXSA7A4Ph/Inaee8bfkPZzi4RYUgg2z+/C0IRmopPWDd95gYNN7rYbdDy4ZTchDNCyQ7Fi0rDb5WQk5t75s2mYcNHMH2uIr42oti94z3k9FpWxDphKCi7+8JcZFy8vLkNdO7K2Fe4L8RHI3IzVcNumNCLjS9Z/eB1SM97vzHxnnPDZSTUQuE+mO6xltVxFSt7XnLcHh1gG7lhOcjS+XBBfjw9OyedalDolcbPgFVnqFh9U3IjbIwjvoKIMcq9UrmTmfYRtlKX2WKWy8r3MaTIiCLGMuaeJzGJIAiCIMxCbcc1iJ1UftBMwfbb2StuE7NcE4gx4Y+G+w8mcdPCZEKZhsVxk0PJxCdgVkLFe99wd4k7GQNMvAsTW+oHdRga0qJfo4OS7Ydvbmexd9WAHrkdKmQ0DiChtg/R1X2IrBpASBnT2UGEVKgQXK5CIPscXN6LyMo+JNcPIaNVg8LOIVQP6dDOD8POkfdr4cPQBnQqoUcSH/ymZSct/Jodvwb2Z3IZuNiq1gAdOycDN6LYuWiZ+pjYrnFWCWT2aJHU2I+ws+3wKGrDtuwubD7RjM8PVeHDhFK8G1ss6P2EMnyYUolPD1VjS0YTtmW248AZdr71GiS263C6S4vKXi16VOy+6dhdU+uYtNBp1Oyzip0St0KYhLmDBqDV9kNn4JO184mtTYaUyTy7dDOK997R6/n+DYIx0jegQSc7l152fQNsl31MXSyZFQGaBvVoUevRxra18G0sD7s97Jv8mGrB1LmYGWVu+0+JYETxHk7qQcEA5L3suL/De7XxutfMrrGZlzfL0snWu9n18vvSx9TDvtLFKlVPvw4DvLzYvnjvPC4du6cm84mbUMNGFK9r3OjkvZ3Y06A2oJ3dz2a2nw5WbC3sPtaxClrDPjcMsG1D/OnhBpgRahUrZw3byOco0xv5QjDBxjriK4gYo9jK5Jkj20hbqeKYmHzFuJghRUYUMZYZ+TxxiUkEQRAEYRZqO64x7OwV95orVKaPxSzXDGJM+KPhHoNJ3IzgPY/ON6J4v5IB8P40KrZdo1NBP6SEcYBF90qWnwXVfChdD9tPA1vmDmpxsluFxIZu+Je1YHdeLTaeqMBH6aV4M6UEq5NKsDytCisP12B1eh1ePVyH11Oq8W5yBT5LrcSWjFrsPNmIoKJmxFd34Vi7CkUDBlSxgzTwYXNaLQbZQfkZKnUGqHVG8B4qvKuKUaeBgaXr2XZuGAyp2VWwJf/Vu1Z2uiVdWmQ0DSG0sht78pqxPqMS78TmY1lEIWZF1MI5pAL2/mWY4l2EZ70K8ZRnIZ4YlnsBnt2fjxfYukNwOV5KYOd9pAmbslrhW9yNjHoNSruBNg3QqTWiV2vAkE4HjUEDHe/9xO6eng8IZOt6I59rimvYiOK2xaUbUdzq4L2Z+DxUHd1KFJY1IyO7Fodzm5Be1IG0ki4kF3YioaALsQWtiC1sQlR+PeLzm5FZ1Y/mPnZWenYPtby3lmmo4NVmOH0bJiOK1dWhXsHk0bPT7lQaUdysxOHSDsSw8o3KZ9dc3ImkgnYkF3QiNb8Lh3I7kZbdhozcZmSVtqK2o5/VJ1MvKlZFWEkY2F0V+o0JdZ8bUUJPK24isWMo1XpUt/bjyJkWxLH9x5f0ILq4FxG5HUztiM9rw8myTjT26wVTVqMZgl7Tw+omH16qN43Su9RivgoRX0HEGMRWJp9vpn3EvQ5yezHLFcecIUVGFDGWMfdMiUkEQRAEYRZqO64xbKUKPzOF2vbnF7aPF7NcM4gx4Y+Gew/czDGw0Jv3kDGZUdwcUbNEHp7zKb2V7E8DlVEjzMmk1ekEA6qdqVRtwIleJaKae7CDBeibc+vw0dFyrEkpwqL4fMyJzoU0IgeTQ7LxTHAWHosuwZMxZ/BsbDleiC7D9PASOIYUYh7TsrAivBpVgk8PV2D9sSrIT9fBs7gNCXUDyOnWoo6dUjc7Jp/Tic+3w89DCPA1GmiHBqFRqgXTgJsAfezMW1jgXzpgREbzEPxL2rH1ZB3eP1SJ5TGlmBNcCHvPTDxzMBf/8arCA56VuN+jAvd5VsDWoxL3MP31YAXu3l+OP+wuwe9ccvBbeTZ+tz0Hf9lXwPIW4Vm/YrwUUYaPDjVge3Y3EprUONkDVOiADnb8AW5nsPup5PMWMfFhYHyS9uHeUNzoMPWI4g4FO+lLgpeWHv0qLQrOtsI76hQ+3RWH1xVxeNU1Dat3HcHyHUewbHsGlu9MwxLXRCxwiWFpydgbU4Kc6kH0aPgvzw1Bq9VCx+7lsCF1tXPOiFIPsA+8pxyQXzcIb1a2H3ucwPLtqVioOIRF7Ppf2XUMq3YybWfr8jS86pKED9m92BV8HBlF9WhRGYR5wvjQOiXbl1YYiqdkGmJ3V83KTS/MbcZ737X1KJGcVYlNfhlY5ZqCZa5Hsdj1OBYpMrBsWzre2p0B17AcHDvbjXb2XCj1g+y+dsGg6xHm6+LD8y65mK9CxFcQMQZh7WHhiPYRdlJ5qpg8qpxvSJERRYxlLnimmMQkgiAIgjALtR3XEJOk2x8yV6C2UvnbYpZrCjEm/NFw24EPIzIZUXwYFv+XRcy8uxOfg4f3QDJq0c/FcvDeT81MZ1hkntqlgXtFD77MrMObaeWYn1CKWdHFcAjPx5SQPDwbWoBnwovxVEQpHo8ow2Ns+UjUWfw3ugL/i6nGE9HVeDqyEs+Hn8X00DI4hpzBrNASzI+rwPzYMiyKLsGbSWWQn2pAeEUvsju1qB00sCDfCKVGw05PBWjVMCqHoBkchEqlE0yqdnZ+NXoDjrLz8yvvhSKrEW+nlOOliGLIQs9gavBZPBtQgSd9yvGw51nYetYImuRdi3/61uMev0b8n28j/uTdgLs86nDngSrcua8Mt7sW4eZt+bh1ewF+sT0Pv1Gcxl92nMB/9p/Gc/75ePVQNTbldSCkRYkspV6Yh6pdb0SXToMBJjUf3mVg583F7qdBMP1+mDvBhyOqDUa09GqQdLoa726PwlPLduCeFxX48/x9+NPLXvj9S974/XxP/GGBO343fw9+O2sb7BbuxbLNSQg9Wo+6bi2G2HmpVCqo1XxydY1gSF3tZpRgRBm4aaYW6m9jHxByrBGvKNLw31d88X/zD+KP87zYNfvi7sX+uHsRW7J78ec5B/C3Wa545GVXLP7cH17JhSjt1KFVC3SycurTa6HiE9AbB9h++eTufBJy01xT3Hg929SDvVEn4PiRJ/6+YBf+NM8df5jnjT/N8cRf5njgoSVeWLopGn5HqnG2R4UebS+U2lZodW1M/YJxeg3MVU6N5BjFTiZfZraNlCmeF7P8JAiG1GtHnxA/EsSYw9xzJSYRBEEQhFmo7biGYP8xHT6yMG2l8jox+ZpDjAl/NNyE4nbI10YUF0vgAbPJpQKfzJlPyNzB1svVOhzqGsLByg58eqoeSxIq4BhagsmBJXgq+CyeDK7AkyEVeCK0Ck+EMUXV4MnYBjwV34xnEprxQmQdXohqwPMxTXg+rhUvJLZiclIrpiQ0YWpcHabFVmFKfB2mxNRgRuRZvBh5Bq/FlWILC+7Di1qQ3TiAml4dBgf7YVD2wDjUB+NAP/RKlTBBOjfKStV6pLd3Y19RA95Pr8LyuBJIQwvwXNAZPBVWiycj25i68FhoJ/4b1IKHA+vxYEA9/h3QgPsCGzGJ6W+BTbjbvxG/96nDb31q8Fu/SvzC7Qxu21OC23eX4jbXEtzkkomJGw/jpq+S8fNtqfjnnnQ85XcSSxMLocitRUJ9J4p7BtGs1KCPndyg1jSfE//VQEHD9/oHwItmiP3T0KtH+PFaLFwfirsdv8KEZ76ExeSdkNh7QeLgC8kMb0imH4Rk6m5IntmKW6e44Kk1/tjin43M8ja09vazezmIoaGhc4YUN0yu5qF6w0YU773ETaKiJh22hhTj6VeD8MtpuzDu+X2wnuIDyRR/dv1esLD3hhVb2kzZj4nPyvHbaZvw/OtucAnLQlazDjVDQKNKi3a1EgOafmj0veBzevFfGeTDQPmE5EPsVhTWdWGj32E8vGIPbpq6FVZT98Fqsgesn3bDuCf24jfTdmPa2/7YHluKnJY+NA22o1tZgwF1PZTaLqi0GuEHJcc64iuIGGPYShUVI9tIO5k8RkwmCOIHcuFzRcEEQRAEcXGo7bhGsJO5PGmuMO2k8lfELNccYkxoFm4fnK+LweNiHmzreHDPjREDD/TZRr7kE+Mw8WFJ3IQq7NUjtKoLG06WY0lsNmYEZuJp3wI8GVCFJ4Ob8GRoM56KaMOz0Z14JqYDT0W34omoZjwR3YInY1vxbHwbHMPrIYtoggNLc4jvgH1yN2Yc6sW0tG5MTm3HcykteDa5ja13YHpKG2RxdZgXUYZXI4uxLbUUCcWtKGlRo7uzE+ruVmh6u6EbGIBBrRHMgjqtASnN3diXX4Z304rxUmwpnCKK8VxICZ4Ir8YTsW14MmEAj8cP4JHIHvwvjJ1vRAOeDGvEo6H1eCioDv9isg2sw98D6vAX/xr8ya8Sd/mW4FcHivDL/SW4Y385frmvHLe45sNm6zFYbEmDlUsqbvkqAXdsjMY9WyIwbX88Pog9iaDCahR2DKJNzeeOgvBrbQY+aTVf8g5n3FHisHMXTMBzpTas4X+/Cf8aN2GahwyIONWK+V/G4fezdsJKMKH8IJkZDYs5CbCaHQ8Lp1BYSH0hmeqG8VN24x8LPLFyaxJCDhfjTG0jenp70dfXh4GBfqiUSmi1Guj50Leryoz6+p7wXnt6gx5Kdo49rF4eOTuIt/adxD8XeGHC83thMdkHVg5RkMhimUIgcQqDpXM4bGRBmDD9AH4lc8VTr3vjq5BsnKhToaJbjbqeQbQO9KFX1Q2lphsawwB7JjTCsyHMScaOXNDQgy8DjuPBVzxxo8N+WEsDYe0Qxu55AKye8cYvph3A028EYHNkCdtvF6q7mtHSU4HugRr0K9sxpFGJRtTVck9/GOIriBhD2EoVr5prIyfJFI+JWQiC+IGYe7bEJIIgCIIwC7Ud1wh2MnnCBYUplZeJydckYkzIYloW1Bq+FjeTtCxQ5zPd8JmetEzDXoeAGAPzBY+JdUz8F8NU7B+tim3hX2ALvd4AlUELDQvG6/V6xPYY8NWZAbx4qAnPRp7FU8EFeCYwH08HluKxkEamLjzn345n2fL5yB48G9uFZxK4Opna8Gx8C16Ib4I0vh5OcY2YFduMF2Pa8WJsJ2bF98IxaRAzUoYwNU2NGRk9mHG0D1OOKfH8USWmpnZjNvvOOwnV8DrRhGNlA+ho7MZgWze6+RAodqG97LQrVUbEVnfgqxM1eDWpBnOiamEfUYcZ0Y14IaoJT0ax84xuwBPxzUyNeDSmBv+LrMDTYRV4iunp0Go8GVKNxwJr8LBfDR7wq8W/AupxX2A9bP2r8FfvCvzpYCl+s68Iv9hbjNv2nsFNe0owYVcxbFyL8Mttp3DHV8fwyy8O4c51ifin4hBmhuVDkd+GI2161AwYoVGyW9xrhLpDDz13UXh3G14IOj00OrUwDHJ4ji5ugehZ6fFkPqTLZBDycuYGkV4wD1v69Ag70ojZ65Pw+5d9YO3sC4ljGCxkMbCSJcB6ZiLGy8Iw3t4X1lJfWDkH4Jb5fnj4vVBsDDqJ3MpWNHf0oKG5Ce3tLdAIE4APManYcfiRTYc09ZT7WqPB18fiNVi4SaI0bLuG3SED2tnHoNOtcPwiEXfO9oCVgxcsnIMgmRkMyawQtvRh8obFTF9YOPrBUuqDn83xxuNvh+FL3xM4kleDqopmtDQ2o7O7BT3KNvSqu9GrGYLwOLDj8+nx+axReXU9WO+bhYfWhOMWxwB2j9n+nUNg5eQPqxk+uM3JHf97OwDrg/NwrLgRNQ2NaGlrRGdXK3r7ujE0xH85UX3B8MfRvq8/FvEVRIwV1q61tJUqGke2kbYyRYiYgyCIH8HIZ4tLTCIIgiAIs1DbcQ1wr8xlirmCtHVULBKzXJOIMaHJnfiBRhSXhgXEaj7fDu+aw/fBe0Gx//HvdmiNqBlSIbG2B18cb8WyxHo8G1yJR/zK8Kj/GTwZUIqnA6vxVGgnUy+eDWjCc8GteE7oFdWKZ2Nb8Xx8M6YkNmN6Ugvsk5vhlNiGmUxz4tswN7YDc+O68GJCL2Yl9UOWOgCHw0rYp3dhWkY3Jh/pxwsZA5iW0o05sQ14O74S+zLqkJjfgaqzDWipb0JDZz9qB3Uo6VcjraETe3Mr8U5qCebHlEMaWQP7KG5+tWNGUhcmJ7TjqdhmPBXXhCfj6vFEDDv3qEo8G1GD5yJr8XxEPVMzng1vYdfTgseCW/BwUDP+E9iMB4IaYedXj7/5VONuz0rcdbACv3Arx817SjDetQAW2/Mx3iUTE746iRu+PI5b1mfgjo2HcM+2ZEi9j2JjxlnEVvahtk2D3h4DlPxX/YfYTebiExBp+ZxRauiM3PLgfZ1MRhSfkpxbL7xXGi9boQsVKy9uRHGTZNiImrM+Cb97yQtWTj7nGVHxsHSOxThZMMbNYGn23pBIvTF+pjvs1vjivQMpSM05i6rGdlTVNaG5uQmDfV2mScC1g8IvEXJz5OoworiGrVMt264FO0PU9hvhdqgKkz+KwC+c98PS3gMWzoGQzAyCZBY3pHzYPfBh98UXloIR5Y3bZnrgkdcCsfbgYSSfKkNpcQ3qqmrR0lqHrr5m9Cq70K8egpobssJTomMlYkBuXTe+EIyoMMGIspSFwGJm8Dkj6nYndzz6lj/W+mUiNbsSZ85WoK6+Eq1tDeju7hCGk5IRRYw2dlLFe+bayHul2x4QsxAE8SMw93yJSQRBEARhFmo7rgFspfLDIwvRVibPE5OvWcSYkEexJgPJjBHFO9uIHZyEbOfieSb+mUul4/PWsJzC5OQsN/vM8/MeRvl9BkSc7cTa1Co4+VXgWe9K/MejGvd71+FR/zo8HdSE50M78ELkEJMKUyLaMSW6E5Oj2/FCTDMmxzRgSmwdZsTVwjGhDs6JDZiZ0oXZSZ14MaET8+M78RJXQhfmJffgxdRezE7rg2N6O+wzOjE9oxfT0vsgTeV56/FWXCW2s3MJOtGAnIJSVFZXobytF7ldKiQ0dGJ/fiU+zSjC0sQSOMVXYAY7vn1sB2TJvZCl9GF6Ujeej2/DC3FNmJzQiKmJ9Zga34AXopvxXHg9u55aPOVfgyd8avEYu8ZHPOvwgHst7nevwb0eNbBl1/53jyr8memPTL92r8TP3Mpx454S2OwshMXOEli4FMDiq3zYbMnDuE0nMO6zWNy5LgTP70/FeylnEZ3fiOLGAbQP8QnX2f0f0EPVNwSjRsXKQAm9rhdGwyBbV7Py+dqI4uJzeMHISuecEWVACyuj0IwGzF6fcJ4RFQoLWRSspDGwZMsJfEiavRes7T0hcfCCpcMB/GmhGxZuDoN3YhbyKhpQUlmHuvpG9HS0Q9PfBYOyFwYNOx8DOwOhrnxtloyWYfLNYw1XXm4NsTrK7k0fS8pp6seGkCw88qoPbnbYBQt7d1jODITFbG5G+Qu9oSydvWHl7MfuiT9L98EtTu54YJU33tkdj/DD2cjLLEFlcRka6yrR0VWPnoEODKr4L96xc+CHZHef977KqevG576ZeHB1KG7m+5IGQ+L8TSPqv2/64n33o4jKKEBmXh7KyotQ31CF9o5W9Pf3QsPKmYwoYrS4f9q+G1ib2DmyjbSTKrzFLARB/EgueL6YxCSCIAiCMAu1HWMcWweFzFwh3itzeVHMcs0ixoQ8imXx+df6Zo8o3qeG/y6bGOSel49/5qGwjgX0eiMfhqWEQTsINQvAu1kAXjIE+FUo8U5SFRx8SvGoRy0e8qrHAz7NeDCwA4+HduLZ8C5MjujF1MhBTIlR4oX4PkxhmprQg2kJbZge1wyHuAY4xddhTkId5iXU46XUbixI6cTCpE4sTmjHUpZvWWI7liV1YOmhDixJ68Tc9GbMzmjFzCOdmHWkG/MOd2BZcgPeja/A1sRyHEyrwJGTuSg8U4rs+k4k1/XCvbAR6zKK8VpKEV5OrYDzoSZIU7ogTeqHNHkA9ol9mJHYi+kJnXBIaocsuRWypEZ2jo14OrQRj3hV4L6debhnyyn8dcMJ/N+GU/jLl6dx95eZ+NOXWfjdxkz8bnM27pLn464dRfjtnlL82u0sfnmwErcfPItbD5TD6kANJNvPQLKlGJbbSmG1vQiSr47Aam0E+34EHtufgfcjT8A3uxqnW1VoVAKdAzoM9A3CwO47dAPQqzth0PWzclXDKPy6nl7opDZsRPH5kUxGFP81QwNa+vUIPVKPWV/E4a6XPGHl6AWJLPicEWXlGIGJjoG4QeqF8TJvWDh4QzLDDXfM2YNpH3hjo3cKDudVIaesARU1TWhracFQdxt0g93QCWaMTjQyvzZLhLp0heFHOHcs4XimY5qMOS3U7N92Vo+TSpqxZncy/rFoH8ZP2wGJvTusZnEjKgCSmexeOHvC0skbVk7ciGLbZvjiZpkH7l3hiVcVEfCLy8CpIzkoyylEXUUp2ttq0NvXjiElKxPTTWfSQcXKIae26xtGlMSMEfXQa954Y08q/BNOIP34cRQU5qCquhytrU3o7e2GSqUkI4oYNeykis/MtZGT7F0miVkIgviRmHvGxCSCIAiCMAu1HWMcO6n81IWFKD8pJl/TiDGhKUg/z2A634jiJtTwL+IJQe55+biE4FfIpYbeqIRSO4TWwSHkdajhXz6Atw614AXvM/j3wXL8268FDwa04OGQFvw3rB2PR3Tgqch2PBfRjsnhbXg+qgNPJvTjucR+TE3qgzS5G86J7XgxoRkvJTRiYWIdljItS2zGcvZ5VXwDXomrw5rYGrwWV43XE2rwelItXk+uxfK0Siw+XINF6fVYktGElYebhbSPYs9ga2wh9iYWISXtFE5nFiC1uBF+Ba3YmMH2EV+I5YlleDmtAbMPd2BmRj+cDg/CPqkX0+O64ZDQh5nJ/ZjNe0jFtGBKSAX+512CSTuL8OdNJ3Hn+0m4dU0EbloRyhSBm1+Jwc2r43DjmjhMeC0eE99Mwg3vpeGmtcdwy8bTuE2Ri9t3F+Pn+8vwc/ezGHewEhY7SiDZWgQLRSksd5bBwjUXlpsP4Yb1kfjV+nA8tSMSr4SdwP68Jpxo06B+0IA+pRYa1SD06j6mLhi1/YBeaTKihGGTJiOKG4rcmDIYWKkatWyb/pwRNfPzGPx2vjusHD0hcQyChSwSVrIoWDqG4QbHANwk88QEJ2/22RcS+4O4xXkXHnllH16VhyHiaBmOs/tYWtWCpsYm9He2QjvQA51qABoNqxtCNfvaLBHq0hWE753bNMJxhuureEi+ndftQVbHa9RGeB85C+fPQ/D72a6wnroLEgdPWM4MgMUsf0icPZjcYeHowe6LL7sfgbCyD8DNMi/YLvfEqq0hcI9MxrHUUyg5lYuasmK0tVSjt7cNyiFWHkJ3QnZgvQYqvQ7Z3IjyOS0aUX7fNKLsfXCb40E8sNoDq3ckwCPyMFLS05Gbl4nKqlI0N/PheZ0Y4vvV8zIkI4q4sjzg4PpzW5l8aGQbaStV7BOzEARxGRj5jHGJSQRBEARhFmo7xjB2UvlccwVoJ90mFbNc04gxIY9ivw7Wmb5pRBnAJ7sW+j4JPWm+KR746o0a6FhuFcvZYdAjr0sFr8J2rImrwPM+ZfiXeyUm+TTgX8EteCS0EY+H1zPV4fGIBuEX8Z6JbsbkqHq8EN2Ap5L6MJmbPExzkrqwIKEZS2JrsTy6AiujSvFKZDFWh+Qx5eK1kBy8EZyFt4Iz8XZIJt4Ny8J7YZl4PzwTbyZm47WkfLyWXIw3ksvwTlI5PowtxrqIbMgjTmNfdBaSkk4g/WgBwk/VYvvRJryTWI2lMWVYnFSDlw+3YnZaF2Yd6WPiPaK64BDPPicNYl6yCjNjuvG0VwXuk5/AHz5Lxq1vJ+DG1RGwWRQIyVxvSOYwzfWDxUtBsFgQDAnXwjBIlkRAsjIalq/Fw+rdZNh8ehgTNp7ATfIs3OKah/F7CjDetRDjFEWwkpfAYnsxLNh2y+3HMe6rBEz4LAS/XReEh3bEY3lkHjwL25DXqUOb0oi+oSGolH3Qafph1PI5mviE4WpWTF8bUdxU1PMeUiOMqJCMWjivi8Zv5h2AlczDZEQ5ciMqUhg+NlHqixsdDmCCI+8d5CeYNROlu/D3l13h/LEXDsblIyWnEYUVraira0RPazO0/T3QKvuhUit/EiOKH1MYiniubpuqOr8PfAatHvY5r9OIr8Jy8dhrnviFzBXW0/ez6/WBhVMAJM7sOh35vTgAC0d3WDv6Cr+aZ+0QiJudfGC73AMrtgZhX3gcMpKPo/BENqpKC9HaXGUyopSiEaVjB9KpodRpkVXTiXXep/GfV0Jwk3TYiGL7dPKHtb0vbpUdwL9WHsAKeQwOhKYiKS0NOXmnUVF5Bo1NdejsaBfmiSIjihgNbGXyTebayPucXP4sZiEI4jJg7jkTkwiCIAjCLNR2jGFsZYr8kYVnK1WkicnXPGJMaIrOzwXrI40ovfDH5xPiw7lYBGwSX+fbmDRGFQaNGnSy7xUP6RFY0YvXEyrw1IEc2O47Azu/dvwrrBv/DuMmVA2ejziLZ8PL8HRUDZ6Ka8ULCW2YkdAI+0Sm1C44p7bhpaRWLImrxcqIM1gdmI01PsfwqmcaXj2YjNfdovD6gWi8xfTOwWi85x6DDzxj8aFXLD7yjMbHnjH4KDwZH0am4aOoo/gk6jTWRp7GutDj2BSQjp3B6XCPOIaE5NNIPFICr6MN+OJwK1YlNeFldg4vH2bHP9KB2eldmH20C3OOdWJmWidmJ3djXvIgZkb34RmPOtzz5Sn84rUo2Cz0M5lPXLOZXvSFxdwAwYSSvBzCFGrSwihIlkRDspwtVzGtiYHkjThI3k+E1dpDsPkiHdYuJ3DT9jzcuuMMJm47A0t5ISSKXEh2nIa1IgMTvkrAuM+i8MvPY/DfXYfxdlwxws90oqRdjaaeQfQMDECpMQ2RhIZPFq6CcYQRpeNGlFF3rnRNRlQNnNdF4dfz3GAlOwiJLBCWw0aUQwDGz/DExOl7Md7hICyd/Fm6L2wc9uK3sxR4Ys0ebPQ9hojjtcgqbUFFRR06Ghug6e2CdqjPZMgI1Wy0jShTT76v67Zpwec94/O7t7OTSqnU4bU9R/CPBXtw8/RdsGbXKQy/c2Tihpsj++zIzTl32Dj6wVoWAmuHYNzk5CsYUcu2+GN3aDTSko4i/3gWKkoK0NxUge6eVqHnkk7LzuU8IyqzugOfeZ/6ViPqFtkB3Lt8P5ZuicT+4CQkHjqE7NxTKD9bjPr6GrS3t5IRRYwKk6Tb77KTyY0j20i2bbuYhSCIy8SFzxkFEwRBEMTFobZjjDJJKl9irvAmOSgmi1muecSYkEex5wXrI40oHXTctOA9aPiEN3omPgMzWwqfmbgR1cNUPqhGeFU33jtUiRe88mC3Nx//8KjFfaEDeCCqH/+NaMLzEZWYEV6CqWEleD6qFs8ldmNqah8cUjrgnNyIeck1eDnhLFbElGB1SBbe9E7HO/tj8c7OYLy3zQcfbPPGB64H8dFOd3y6xwuf7fPF525+WH/AH1+I2sA+fx4QjC+CwrEhOA4bg5OxMTAFm3wSIPeKg1tAEgLDDyMmJQshGaVwPdKE94/0YklGP+Zn9GLesV7MPdmNWSe6MedEK+adaMK8o22Yd6gLM2O68Kx7Lf7xRSZufyUOlvPEeYRmMXEDal4QrBaEwWZRBGyWRMJqaRQslkXDYnkMLFakwOKVZFisToSEfVfySgwka6IgeT0akndiYflBPCSfH8KEzZm4ZVspbtheAatt5ZBsK4ZkZz4sXbMwfvsJSDbyOaOScNfncZi6+zA2JBQjoaQZpc29aO4ZRLdSBa16EFAPwKhVwsDKihctN4O4EcXtJ60wr9fXRlRwevU5I8ryPCPKmslSyo0od4yfuhPj7N1gNTMQEmeW7uCG2xy24t6FCry1KxHeqeU4kteAopJKNNfUQN3VAe1AH4aGBoRjn2+WXGnDhB2BXSufDYqt6Q2miz/PiGJ3By1aICBrAHPWx+Eu6TZMnLwb1g4BsJCFQiLlPcIC2D3gv5jnBmunYSMqlOUJwU2OvvjnUk8s3uSDHayeJcenI/vYaZQW56G+sRwdXc3oH+yHRmNkj4rJiBoaNqK8TuGBVcEmI8oh6JtGlNQN9y7bhyVbIrA3KBEJqanIyj6BM6UFqKmtFIwo4X6SEUVcYbjhdEEbKVUY7JxcfitmIQjiMnHBs8YkJhEEQRCEWajtGKOwgiofWXC2UkWcmHxdIMaEFxhRPJg934jivWe46WQcNqGGJZpRepannQXaR5u7sPlYJaQ+WfjXnizYelThvpBu3Bc+iAfCe/FERAumRVTBMbQY9iFn8EJkPZ5L6MPklCHMSO6GU1wN5kecxsLQE1gRkI7XPRPw/t5wfLLDF58rDmCjYi++2rYPm/fsx9Z9B+Di5o7tHl7Y4e0HV58A7PQOgKuXv6DNfj74KiAAWwLCIPePhtyHySMSO5m8AhIQEXkYIUmncSCtBBvSG7H6SC/mH1Ni1olBzDzZB+fTPXA83Y3Zp5qx4GQ9Xj7eivmpbZgRVI/7N+fil6sTYfViMCQzAyCZEwTLl0IEA2rcogiMXxSFcYujYLU0GpYrYmH1Sjys1iTCek0abF49DOvX0mD1WjIsXkuA5NUYSF6PgsXbMbB6Nw6SD9i2tRmw+TIP41wqYeVaB8muGqZSSHbkQbItE5ItbLnuKG54Pxq26yKw1D0N7hlncLqqA9WdA2jsG4JysB9Q8SF6KrNGlEYYlsd/3fB8IyoSv567H5ZSkxFl4RgBayYbJ/6LeQcxYcpOjHdwg83sYFjMCmX5DuDmGVvxt7lbsOyrCOyNKUJqZg1yC8pRX1kJZUcb1P09GGDnwmrLOaNkNAwTdgR2TPNGlIppgH2sZyt70zox9f1Q/HyKC8a9sA82UnZdsghIHNg1OvoLE5TbOB/AOCd3jHNk6yzdyiEEN8p88I+lHli00RuKgGAkxKXh9JETKC7KRk19Kdo6G9E30Au1xgA9O75Rr8aQXotMVkZrvU4KRtSNDr4XGlG8R9SyfVi8ORx7AhMQl5yMU6ePobgkD9XVFYIRJfQwIyOKuILwoXcj20ehjZTJN4lZCIK4jJh73sQkgiAIgjALtR1jEDvZttXmCs7OUfGEmOW6QIwJRXgAywNbPqCJTz4+PE05HwbUB4NOw10MYZiRTquGxsjEU1lkz4P6vC4lFJnNeDG6Bg94V+BvHpW4N7AJ/w5tx0NRffhfVAeeC6+EY3gp5kaegVNUI56N7cMT8SpMSejE/MSzWBWdiWW+KVjqHoPVu4Lx7nY/fCZ3x6ate7DNxRVuO3bBa99+eHm7wc/XA0H+PggNCkRYSAhCQ8MQHBaJgMhoBETHIiA8Eh5BIXALCsXBkDB4BgfCO8APwSFRCI89htCEAvgeLsfO9FqsPdyB1UdUWHRcj3knNZh7agCzT/dgVk4f5uZ04+XTnXjpSDdkEY14RJGPu15PwLi5wZDwyaznhcDq5SiMWxADm5eZFsbCekkcrJbFw2JFEixeSYHF6lRI1qRAwo2nN5IhefMQJG+nQ/IO07uHYPluCsa9l4wJ7yey7SzPe+w7nxyH1fo8WG8tg9WOGljsrIFk51lIXEsh2VoK66+KcfO6Y7jrw2g8vCECKwOP42BuHY409aG814i2AZXpV9vUrNA0rGz1phLmc35pDXzeKDUrbr3Qwa2xTwffY6WQbgjCb+bthZXUHRIZN0giYTkrHOOdvWHt4IaJzgcxYbY3LGf6QuLkAytnD0x02oOfOyng8HEo1gfkIuJ4DU4VVqKqqhI9HU1QDnRhUNkv9ELSi3OKjQaCEWXQQaXjtptpi04zxK5Xw+ot0M6q+vFmPd4IrsI9y3xwu/QgbKZ4Y5xDOCbOjIaNLIBdM7te2X62zQ3j7T1g4+APS/sQSKYHYYLUG/cs8cDijX7YGRiFlNgU5GQcRXlhNhrry9HZ0YL+/kFo1Eb2/LBrNmoxpNMjs7IL67xO4z+rwsSheXwuqkBYOfmy43nhVkc33Lf8gNAjak9gEmKTUnDq9HGUlBSgpqYa7e3tpiF/I341jzOWzCjxFURcpfDJyEe2j3zS8r85uP5czEIQxGVk5PPGJSYRBEEQhFmo7RiDsEKqH1lodjJ5mJh83SDGhCI8eB1pRHENQKfvZwG81mRm6NhWbkSxPz7hczcLss+ylaDyPqyOrcDTvmWw86rAJO9q/DuwFg8G1uB/YY14PqIODqElmBOSh5fD8jEnugrTEnrwQtIgZHEtWBRVhDXBh/HqgRC8ujcAb7t64jPXg9ji6obdO/fCY+9eBHm4IcrfCzFhPoiP8EdydAgOxUUiLSEGaYnxSE1ORHJqCpIOpyI+NQ0RickISUhCBFNMbCxioyIRH5+ChMM5iEwvh/eRCmxLr8Un6R1YfVSJxcf1eOmUGvNO9mPu6V68mN2HBbn9WJLZh7mpHXjGoxR/ej8F4+cHCCaUxbxQWCyKhtXiOIxbGAebxfGwWRoPq+UJsFyVBIs1KbB4LRUWrx+C5PVUWL6RBKu3uPGUznQUFu8dgeX7GbB+/zAmfJCKGz5MhfU7LM97h2D98THYrMvBuE0lsHE5C+ttFbDYXg7JjlJIXM7Aemsxblh/Ej/7IA5/+TgM03cn4+OEPAQXNiC3aQiN3f3o6++FZlAFwxArRzUvV1OPKI1eA4NBw4qb99YBGvu1ghHlcL4R5RgEycxwWMwOgY2zN9t2ABOc3DFxFjegfFi6DyydvDDOcT9uke3AU6/74r0Dx+F3qBxHcstRVlGG9rZa9PW1YkDZDV5jho2o0TBKBCPKqINazyfb5yaNDjpVnzBnFu+d1cqqc9LZfszafhq/mbULN05j1z3ZGzbSSIyfGQNL/ut47D5YS/dhPNM4dv02Dt6wtA+EZEaAaES5Y4lgREWLRtQRlBVdzIgymDeinAJEI8rzIkZU4TkjanBwSDCieK+okZARRfxYJtm7TLqwfRSMqLViFoIgLjPmnjkxiSAIgiDMQm3HGIMV0DsjC4zL1lHxoJjlukGMCUXMG1F6DEGjNwW+prnJ2Va9BmoWzrOwHs1qLVJb9fjseDtm+Bbj3+6luM+vDv8JrsdjodV4POAMngsthzSiEnNCSjA/KAcvh2RhXnQpZia2YmZCB16KrMQK/+N482AYPtq1Dx/v3I/1bLltnxvc3A8iwNsdUUFeSI4MQEZCGI6nRuLU4TjkHElEwbFUFJ5IR8Gpo8jPPI687JPIyTmFk/n5yMjOQcbpbJw8kYmsI8dw+vBhnDyWybZXIC67Ee4nqrHlSC0+PNKBVUeHsOikFgtPqbHgRB8WnOrFS1kDWJqjxLKTg3CMasR9W07ipsVBsOBzKM0JhNWSWFguT4TlsgTYLE2A9YpEWK1KgtUrybDkBtSbabB4+zAs3kmHxbvpGPfOYYx7/yjGfXgc1h+dhNVHJ2D98XHYfMK2fZqBCWszcMOH6Zj4EVv/+BjGf5aJ8RsKMH5zCcbJy2CzrQxW20shURTDSl6EcV9mYcJHqfjZ+1GYtCEaM/cnwyUpH+mlHahs7UZ7dxcGe/uh6R2EbkAF/ut5vFTVep3wq3kwcpOEG1Fq+B4/A+n6IPx2Hp8nyTQ0TzIzFBazggWThA/Xm+DkgQkzvYV5kyQyP1g4+sHK0RMTHXbj/sVuWLY1CbujcpF8uhjFZWfQ1FSBru469A22Qmngw8lMvXhGy4jSs+vl0zPxWm3QqWFQ9bHqrWL3AKjr1yHwZC3++14Ubpq6FTaTd8Nymi9sHKNhMzMGEmkgK2dPdt172XXvwjjZHlize2Bhz67d3g8THUcaUanfz4iq6sJn/FfzzBpRF+sR9bURNTRERhRx5bCTKrwvaB9l8s77p+27QcxCEMRlZuQzxyUmEQRBEIRZqO0YQ/xhwdoJtlJ5+8gCs5UpfMUs1xViTChi3oji/Z7UBjULfA3CD+Xx+W7UBg2GWGqrwYiyniF4lPZjcXwdHvcoxH2eFXgguAX/i2jGsxG1eDr4DF4IL4M0sg4zQ+sxJ7QU88IKMT+6FPPjq7EwugKrAk7hrX2R+Hj7AWxy3Yatu3di54F98PTxQHCwH2KjgnEoKQLH0+OQdSIFhdkZOJN3HJWFmagtyUHdmXzUlhah5mwxqipLmEpRUleL/MpqlJRWoqq4HHW5hajKysWZgjKcLmtB3Jku7MtqxPrjDXjneCdWnBjCklNaLDmtwpKTfYIWZw5hZbYWi9P78bxXOf70YRIsX/SCxMkLFgsjYf1KCixXpUCyIlHoAWW5ms/7lAqLN5jeToPFe+mQfHgEko+OwOKTI7D56BhsPj2BcZ+dhvXnWbD6PBOWn5+C5fqTsNxwElZfnsIt60/h5s9P4oZ1JzBh3WmMX5+D8ZsKMF5eDJvtZ2Cz4wwstuXDQp4Hy025sPj0JKw/OIRffByLB76MwBu+RxB+uh4FtW2ob2tHd2cPVF090Pb2w6jjc0Lx8tNDKxpCvJdSY78KvsdLRCNqD2wcDsJC5g+LmUGwmBUIC6cAWDt64sZZXrhxtg+sHH0FA8VCFgxLPoRtuhvunuUK2Sfh2OB3HJFH85F7pgi19WfQ1n4WPX31UGq7odNrhfozKmYU271BzyfeN9VsPf8lQWUv28hqNKvHxY392BaRhb8s9YH1c1tgNdUNVvZ8rqZoWDlHsmsLwLiZvuy63XDDzB0Y5+gKK+k+WDh4QuLggxucPHHP4oNY/KXvJRhRemRWdZIRxRBfQcRVhp2Dy39Gto+CpIr3xCwEQVwBzD13YhJBEARBmIXajjGErYPLp+YK7F6pi52Y5bpCjAlFePB6oRHFh1SpDVroeFDP4l6t3oAhFlT3sJwVSgMy6nqw/mgdZEFFeMyzEA/51eDBoCY8ElKPpyPr8WRYNZ6IqMEzkZ2YHDkE++hOzIxpwLzoSiyMKMKqgON41y0S6+Ru2LxFAdfdrth3cB+8/b0REhGCmAQW5B9OwtGT6cjMPYk8FuifPVuCqqpSNNRWorm+Bq2N9UyNaG5uQmNrMxrbmlHT2YGq5lbU17egs6YRvWer0Fl6FvVVjchh5xxTOYAdOa349EQz3jjZjeWnlViaqcHyrCGsONWH5Sf7sTxTjdWZeixI6MZD27Pxi9XhsJzrC8sFYbBemQirVw+Z5n96JRmSV1OE4XcWb6VB8i7TB4ch+SQDks+OQvI50xdHYfnFCVhuOAWrTVmw/CobFpuzIdmcBckWpq1s3SUHt7jk4ma2/YaNvDfUaYz7MhPjNufARp4Pqx2FsHIthmRbDsubC8lXBZBsYPo8CxPWHsYfP43C7J3J2JVYhvQzjShvakNbWw+GOnqg7WElplOxMuUTleuh5iYUE59HqbFfeV6PqH0YZ+8OS6k/rPgv480KECZk50PyfjHfj8kf4525gRIIiSwMFo6hsJjuhTul2/HE6354Z/8h+B/KxqniApytKUJT8xl099RCpW6Hjs/XpDdNsn3FzSju/bD6OmxE8fmh+NA8bgj1qgxIL2zCu3uS8Jv5nrCavB029l6wkgbD0ilCuCYb5wD87OUQ3PKiJ26aswPjnLaz9N2wkHowcSPKA/csccOiL32+MUfUxY0onWhEZZIRRVyV2MoUIWbayAbWWliIWQiCuAKYee7oPUkQBEFcFGo7xgiTpm683U4qHzBTYG5ilusOMSYU4cHrhUYU7xPF59oxsIjeyJI1egP62OdmlvNUtxY++a1YHZGHye4n8LR3IZ4MqseDvjX4t3cFHg9rxOORrXgksgMPRqvw3zjguUQDHBN6MT+yCkv9T+INtwis234A8i0u2OOyFW4HDsLHzw9hkVGIS0lGyvGjOJqThaySYhRUnsWZ2hrUtLSivrUDLR3daO/qRWf3ADp7BtHeO4i2/iG0DnANoqWbpXX0YKitA5rGJgzVN6KttQt5rSpE16ggz+3AByfb8OqpXizLHMKyHCVWZQ9i9ek+rDo1gFWZOrx62ogXo9rwj/XpmLDID5YvB2L8yjhYr0mGZLVoQL1xSJyA/DAk7/JeUBmQfMrEDagNxyDZeBySr05AsvkkJC6ZsNyWDavtObDckSvIYkceUwEsXAtws2shbt6WjxtdcjBxcybGbz6Ncew71gpTfolrPiTs+xKXPEi2FLN9ljGdgc2Xmfj5x/F4bFM83vLORuDJauTUtKG+pRcD7b3QdXcB2gFWzGpWnqxcjby3EDei9KYeUcfKIPsiBL+b64bxMzxh5RAAaz6J9qwAWMz2w23z/fDHZUH445Ig3DbHD1Yyf0i4CcWNG/sA/Nx+F+5b5oGlili4JZxEen4+iioKUFdfgu7ueqiG2qHVagTzZNiMuqKGCa/KWrbQc3OGrWpVghllZJW4sUcDv9RSzP40CLe/6AOrGfthLfWFhTAcLwTWjoG45cVA3L0mGnct8cGtc3diPDeiHEQjSuaDG509cM/S/Vi0wRuuARFkRF0i4iuIuIqYJFM8ZqZ95L8m+6qYhSCIK4S5Z09MIgiCIAizUNsxRrCTyr80V1i2Dlv/T8xy3SHGhCLmjSg91DCwIBrcOGBS6bXoNOpQwXLGNamxIa0Gs71P4un9R/GMTwmeD2vBo751eMjzLJ4Ka8ZTMT14LE6Jh+J1eDjRiOeT9JgZ34PFIcV49UACPtrhgc2KHdjrqoDnvt3w8Q5EWHg0Eg+l4/DJ0zhRUIjcsxUorWtEdWs76ju60SQYTip0DmrRp9RjQGVAPxPv6dKjZtIa0afWoXdIjcFBJbT9/TD0dELd1Y6OviEUdOkRVavFlvwevHeqA2tO92JZ1iCW5yjxSk4/1mT1YU3mENZkG/BqphGzwpvw50+TYbnAE5KF/rB5JRYWr8RDwiQMw3s3A5J3mIaH4n3Ke0Edg8WXJ2CxmWnrSVjIT8FiezasdmZjwu5c3LQvH7fsLcTNe4tx474S3LCvlKkMt7Pl7XuKcbtrHm7bloPbFNm4ZVs2JvLvbs8R9mGh4D2i8k1G1NZySOTlsNqUi4kfx+Ovn8bAXp6OLfElSClpZvetG91t3dB2tgPKLla87F4YlEymOaK0BiPqBzTwPVYOx88j8bsX3TFhujds7IMwzjEYNs7+sJrtgV8v9oPt66GYtDoIv57vg/F8snI+NM8xAhYOwbjNfi/+PH8fnD8PwdawI4jLzEFOSR5qqkuFX89T9bFz0GgEA4VrNIwoo5pdrqnqQs9WeI8sVl1Q2DiETYHZeHjlAUyc6QtLez7czleY+8lK6o+Jzn74zaIg/Of9ePx9pTdun7cP4512wdJhL8vnya7bDzfN9MI/lrph4QYvuAaGf08jiuaIGkZ8BRFXEaw9jLmgfZQqKsRkgiCuICOfPS4xiSAIgiDMQm3HGOBfUvmvbWUK3ciCspXKXcUs1yViTChi3ojipoWR/9S/kW036KDUqdFq0KOIxcC+1UNYFVaMye7ZeOxgHp7wqcDz4Z14JrgFT/nVYmpYCybHdOG5hCE8kzSI5xK7IE1ox8LISrzqfQwf7QzEl/Ld2LFzJw56uCEgwB9RoZFISTmE46ezkVNYgqKzlaiob0RTexe6egfQ2z+ELpUavRp+LgZo2XnomNhHqNlSZeBDBw0sUGfbNOwKWAY9O2e9pg8qZS86NFrk9wIRNVp8lduDd051YXVmH5ZnD2FFrhKrc/vwanYvVmcNYU2uEatO6SALrcdf1qXAerEXJIv8YLUqChar4yBZEw+rt1Ng834GLN87BosPj8Ly0xOwWsfnezoJ682nYC0/DettmRjnmoUb9uThln35uONAMX57sBi/P3gGfzhYht8drGCqwe/ca/HbA1X4vVsl/uBWhj/tLcGf9hThd7sL8aud+bh5Rw4mbssV5oeycCmC5ZZiWGwtgcSlGJKvTsPqowTc+UE0/vNFKt4MzEbAqSpklrWjrbETqrYWoK+N3aROGLR9rDhVgkOjZUVe36+D79FKOK6Lwe9n+2DCdH/Y2IdivGM4bJz9YDN7L/643BsPvxuGB98MxB8XuOMG2QFYSn1h6RgCS4cQ3Gy/D3c6u+KZd72w1icZIRmncTwvB2fPlqG7tRXqnn7BiNJquSFkMlGuuBGlMkKn5OXPPrJDaZm6WFU+XNaP1/ccxd1zdsPGKQASB9EQsvfDOEc/3P6iL/66IhBPfxqL+1fsx8/nuWO80z5YzNjP8vA5sgJx8ywfwYha9KUnXANDkRKbTEbUJSC+goirBNY+Pj+yfTRJvkzMQhDEFcTc8ycmEQRBEIRZqO0YA9jK5ApzBfUP+12/E7Ncl4gxoQgPXi80oqAfZJtVLFkHo0ErGFHNLLLPY0lu5UN40ScPT7oX4yHPSjzoVYunw3owObQTkwNqYR9Si+mhdZga04kZic1wTijBS9HFWB10Gh+4xWKDwh1yhSv27t+Pg0GBCIyOweG4RJw6dhyFhYUoO3sWVbU1aGpuRk9XN1QssFcPDGFQq4Rap4GpVw87Z97lha0bDBroDWrojRrhUviwLD78jF+HzjiAIX0f2lkAn9sHhFVqsDGnF2+f6sHq0/2CEbUybwhr8nvxGts+bEQtO6bCjOBq/H3jYdz4SiAslgXCcnUkLF+Ph8WbibB+OxnW7x2G5YcnYP3JcVivPQWbL07CZpNpSN24bVmwcc3CxF05+LlbEe48UIg/epTgr55l+IdnOSZ5VmCSRw1bNuKfnk34i2cD/s70T49a3OteiXsPnMU/3cpx994zuNO1ED/flg+rrXxYnmhEbS5kYp+/PA7JR/H42QcxmLT+CJZ6ZmJ/2hlkFDajvrYNg02N0Hc3wjDUAoO6E9DxcuWTlnMjSg/fozVwXBeL38/2xcSpgbCZHo7xsgiMc/LF+Fk7cfcqLzzxURgeezcId7/shhsd9sDK3gNWsiBYOATihhn7cNt0Fzyyxg3vHoiDb8pxpGdmo6y0HD2tXVB3KqFRf21EGfSmHna4UqYJ37XSAO0AOx7vFcU2sVqBNlaV44v6sFB+GL+Q7oDVzFBYOYfA0oldh2MAbpwTiDsX+MN2dQCmrI3Cv5e64hfzvDDe8SAsph+AxN4XVo7BuIXdp38s3Y+XN7iTEfUDEF9BxFWCnVSeaqaNLBSTCYK4wph5/ug9SRAEQVwUajuucibJ5P/PXCHZSuWbxSzXLWJMeA4evnLbRsfCdv7ralw6vYoFtiyE53MLGZQYYOsNBiMSWo34KKMF9j4leMi3EvcH1eGRwGo8E1KPKSFNmBbchumhXZgS1YnnEzoxPaUFc5IqsCgsB294JmPtnmB8tfMgduxzg4evD8Kio5B86BBOHj+Ogvx8VFZWorGxEe0d7ejt64VSqYSWGxkaDQy8dxafiVowzUxiZ8r++JxW/I93geHnzIJ1dr5awyC0+j6ojYPoYN/L7tMjtEaJzbk9+DCzG2/m9GJVXi9W5vVjTc4gXstS4vVsDd7IMWL5cRWeD6jE7z9LxIRXAmGzOgKWa2Jh9SbvCXUEVh9kwOKjo7BanwObL3Mx7qscTNiSg4nyXNy4Ixe37skXDKhfeZTiD96l+LNPOf7pX4F/sXv1n8AaPBRQhwf9G/GgbwtTK1tvxf1+Tbg/sAEPBPL5tmrxoEcVHnCvxqSD7Dx2FuPWHUWwURTASl4Ia0UJrFwKIVl/CtafpuH2T1Lxy4+S8Oy2DKyLKEJUZg3KymvQWV0GZVMV1D0t0Cj7WLnyUtawO6VCfb8B3qwsHdam4a5ZQZgwNQjjpodiojQEExx8YOXgiv+3fA9e+MwD9p9744FXPHGHsxdspvlDMiNY6FE0frobbpPuwt9e2oXZ6wKwPewY0rLLUFLCyrG6HurOXqh7u0zH1qmFCdOVRgNUTFpe77h58n2NKaGimgyXr2uASQaeyPehY/tSamFk16nVDmFQ3Y8+dqyCdi3kMaV45u0g3GG/A5IpnrB0DofF3ARInENwo/NB/HOpB6Z/FAanz6Lw31Ue+PnMPZjo4A0re36tAbCUeuAWx4OwW+iLJRuCsCPYH0lxicg+Z0SdRWdXK/r7h6DWsPPS83PVYJD/al5lF9Z5jTSiAkUjyvOSjCg+vHEkZEQRl8q9jnJ7s22kTD5fzEIQxBXG3DMoJhEEQRCEWajtuMphBbJnZAHZSRWqe522/1LMct0ixoQCQmzPxENbHVsblt6gYf+ygN6ogtagFCYqr9QAARWDWBF1Fi+4F+ABvyr8K7Qej4ZW49mQakwNbcCM0E5MD+/DlJgePJfI1lNbMDexEkuDM/HOgQR8sScA8r2e2OfljcCwUCQlJ+H48ePIz89HRUUFmpub0dXVhYGBAajVaqH3hynI5mf4tbj9wC0z/scNqGFBz/u/aKA3qqHVcyOqn21Xoovly+nXI7xOCXl+H9Zm9+Dd/F6sKezD6oIBvJajwpvZGryVrcNbOQasOKXBc8HV+M2n8bBaGQCrNZGweC0elm8dgvWHx2HJJPn4OKw25mDcV/mY6FKAm7YX4hbXQty+pwi/OnAGv/euwP/zr8bfAiphG1SNB0Lr8Gh4Ix4Pb8Ljoc14IqQNjwd34LGQTjzJ7tsjoa14OKIFj0a24LFgls+vDo/7N+BBvwb81e0sfrnnDMZv40ZUPqwVxbCWF8FiQybGfXYUt3+Wjls/SMQjm9Lwtn8u/I+eRUFxOVrKC9HfcBbKrhaohvqhYffTAHZvjIPnjCj7ten4zawQjJ8aiHHTg3CDQxDGO/jAcoYr/t8SV0z9zA2zNvrgiTd98Ps5Phg/3R8WM0IgkfrD2t4NNznswV0zd+C5t9zxhVcaEk6Wo6CoCvUV1VB3dkHd3Q7NYA90OpVgRA2x8uTDKPnE6UK5Ds8s/l3wPAZxsnVT7Twnvo0tYNBooe0fZOu8R9QABjT9aNcbkFbZjbcOHsW9i/fj9qkKWE7xgOXMSEjmxguG0G0z9+PBVzzw4heRmP15FP632gs/c3LFRD4kzz5MMI4sHA7gFqkb7ns5AEs3hGJ7iC+S4hK+NqLYfe7sakP/gMmIEn5x8nsZUdQjihh9bKXy4yPbSFuZPFNMJghiFBj5DHKJSQRBEARhFmo7rmLsHOX/MFdAdo7b1olZrmvEmFCAh65cI40og1HHtnAjSg2tQYVeox4lgwbsz2vGvMA8POWWg3/7VeH+0Ab8N7QGz4bVYGpoI6aHdmB6eA+mxXTjhaQOOKQ2YkF8OVYEnMIH++OxeU8Q9h70hV9gEGLj43D06BHk5uSivLwc9fX16OzsFEwolUplJuD+biPKyA00oUcU+6Rn+zCw4B1qdBkNghEVWa/CjqIBrM/vx0dF/XireBBvFCnxdp4a7+Rq8E6Onq0b8Eq2HlMim/Dbz5MhWRkIyeooSN5IEiYnt/zwJCw+OgXJp6dgtTELEzbn4ZZtRfj5rlLcsa8Uvz1Yjv/nU42/Bdbjn+z+/CukDg+GN+CxqGY8G92G56Pb8UIUU0Qnno/owfORvXiB3a+n2PYnY9vwdFwbno1sxnPsfvJJ4B8Pa8V9vjX4zYFy3LCjEFbyPFjKC2HpUgiLL7Mw/ovjuH1dBm79OAX/Xp+Cle4ncTClCJm5Rag7k4eeujIMdTZDOWgyovTQmIyoPj28M5phv/Ywfj0rGOOm+cNmeiAmSIMwzsEblvY78adFrpi+9iAWbAnElA/88Zf5XrhhhhdLC4ClYyBsZB4YZ78bP5fK8fDKvXhrZzyCUwuQlXcWteXVGGxth7K7DZohkxGlY+WgZhWO94ji67wc+fBKwWT6LngeM0aUqb6yNJ6s1kLbx4cf8mGAanYcHRpUeoRk1+GlzTH4f3O24+apCoyb4QNLp3BIZkWypS9+PdcNT73pg0Usz7wN0Xh0lTt+5rwTE7gR5XCeESU7gPsWciMq5FuMqFbzRhQNzRMQX0HET4yt1GW2uTbyXqncScxCEMQoYO45FJMIgiAIwizUdlzF2EkVnmYKqPse5503iVmua8SYUICHrlwXGlF8wJPJiNKxYLqXBbkFfTrIj1fBmQXUT3vk4z8Btfh3aCMeDa3Fs+G1mBLWiOlh7Zge0YXpsR2YktQK55R6LI0pwRqf4/h0TzR27AmCj3cQoiOjkH44DTnZWSg9c4YF2zVobW1FX1+fMBxPozH95P9wcG1afrcRxeeL4sP39FzCuorl0KCbfT+vT4+YRhX2lAzhq6JBfF46iA9Lh/BeiRIfFKjxQa4G7+Xq8E6+Hq/lAw4JnfjDpgxIVodA8moMJO+mQfLhCVh8kgWLz3Jh+UUOxm3KxE1b8/EL1xL8dv9Z/MmjCn/1rcGkoAb8K7wF/4lqFXpBPRHZgudjWjEtrh32cR1wiO2EQ0w3ZkT3wj6mHw7J3ZiS0I4XktowObkVU+OaMD2yCTNi2tn3OvBwaAP+6FONW3eXwFqRB4m8ABJuRG3KxvgNJ3HbF0dx8yep+MfaRMzblY5tMdlIP5GLioIctFefQV9bEwb7+6Hik7jzYYvGQdRxI+pIC+w/O4xfz+a9oXxhPSMA46SBsJZ6w0q6G39c6Ar7tR5YuS0Usz8Pxr1LPHCLw35YzvCEtRPLO9sP1g77cMN0Oe5ZsAsvfxmBfeGZOHKqFBVnKtBV14CBzmaoB7uh13JjkPeEAjSsPHgNE8rzshlRRhh1bK8qDcvHa4YBQ+xrpd1quCYW4fn3/HCnTI5bHfZgotQflrIgSByDMcHJA39d6AbZRwF4dXs8Fm6Mxn9XuuF2550YL+W/EhjO8gXCQsp7RHEjyh9LNoRgR4gfGVGXiPgKIn5iWHuYM6J9hJ1UniEmEwQxSlzwHDKJSQRBEARhFmo7rlImOWy/31zh2MoUH4hZrnvEmFCAh65cI40obuQYjFroDSqhd9EAy5Tbq8WmjLOQep7G876leDi4Cf8Obcb/wurwTGQtJkfUY0Z4G2ZEdWBGfCumJTdhTlI1VkYU4A2PdHyxMwL79gQhzDcMh+ITkHnyOIqLC1BV9fWQPB5s8yF5fHLrYSOKyxR8f7cRZeoRZRCMCYMw5Esr5Os2GJHPzj+uSQW3siHIS4awqXwI68qV+LRUibWFKnySp8GHTO/ma/F6ATDzUB/+uiMTNm9HQfJmnDAnlOTTTEjW5cHqyxKM/6oIEzdn4TZFAX6zpwx3u1fi7z61sAusxwOhjfhvZCsej+nA0xHNeCGqBdNj2yCLb4cz08w4ptguOMf1wimuD86pnXBIZnlSmzHjUDPsExvhENMo5J+W0In/RTbir4F1+IVbGcZt50YU09YCSL7Kgc2G07hx/XFM/PgQ7v44HjJFKjaEnkR8RiZKcrLQdLYEXS2N6OvtwZCa3SV2j3SsXOv6DPA62gL7dYfw6xf9hV5CVvb+sJH5w9rRGzZO+/CnBbsg+8Qbb++KxPItYXhszUHc4bQT1tP3w1rmi3HzgmHp6A6b6Tvw+zm7MeODYGz0OoqEjBKUFJejsfIsetsaoOrrhE6jFIwoPStCHfeNWEkKZXkZjSiezg9gZPWF97zqZFXgWG0/PvQ9gX+tdMOt9nLc4ngANzgGQOLgy+SF25z34z8r9mPx+kB8uDsByzZF4NEV+3DbzJ0Yx67xnBElOyj2iPITekTt/N5GlA6ZVZ34zDuTjCjiJ8dO6rLQbBvpsHWamIUgiFHC3LMoJhEEQRCEWajtuEqxlSqCRhaMrUzR/Pjja63FLNc9YkwowENXrguNKCaDVhjepmXLPpbOJ/ten16G6Z4n8VxAOR4JbcYDoS34X0Qdno6qweSoOkyPbIF9dBvs45sxI7UecxPPYnVINt49eAhf7QyH594gxAVG4nhKCvKzT6G0tBB19dXo7u4+F2jzyZhHBtWmz99tRHHjych7w7BswpzO7HsG9tetNSC/R4OERiU8yoewo3QIW8+q8GWFCuvLVNhQrMHn+Rp8wvRegQZvFBgxN2MA93sU45bPkiF5LxGST49B8nkWLNYXYNxXZbhJXoZb5bn4lWsR/uhWjr9718DOvw7/CW7Ao2HNeDKqFc/FtGMKW9rHtMEprhVzEtrZPWnHPL5M6MSLST1MvZif1omZaa1wPNwMp/RmOKc0YWZCE2Yld8A+pRNPxjbjH6EN+JV7KSa45kGiyIXEJR+SzdwUy8SE9Sdh81Eafv9RAqZuTcGnAccRkXoKuZmnUF92Bu2NDeju6saAUgOtTgutXiMaUU2w/zwZv3nRFzb23rDkk5RL+S/E+WDCzIO4e8FezP7YD5/ujcP7rpGY/u5B/PHFbZgwfRcsZ3jAem4wJDIPWEzbjTuc9+Px1wLwzq5UhKQWIK+4HJVnS9DZVINBPjxPOSCYKLxcvi7ey2xEcROKzxPF1M92WzcERBa0Y6lrCu5+aTfGTVFgvPQgJjoFQDLDC1b2B3DXnD14/o39eNslCBvc4rFqcxgeXb4Tt87aCRtHX1gMG1GO7oKJxY2oFV+GkhH1AxBfQcRPiK1MfmZkG2knlSeKyQRBjCIXPItMYhJBEARBmIXajqsQW4dtj5orGDup4nUxC8EQY0IBHrpycc/mfCNK2GbQQ6NXQS0MzQOyenX4PL0cL7ifwP98S/BQSDMeDG/D/yIb8Ex0LSZH12N6dDMcYpohTWyA7FAtXkosxWshmfjQIxXbd0cg8EA4DoXHISv9MIoLsnG28gwam+rQ398v9IQaDqZHBtamdZMJxfXtRpQeRm5W8M5QghHFr8OITpUW+V1KJDQMwPvsEPaVDcG1QgmXSjW2lKux+YwaGws1WFeoxYdF3IjSYuGJQTwdUYu7tp2E9doUSNYdgeSLTFhsyMf4LeW4bftZ3LmrAL/fX4a/eVbhPr9a/CewHv8LacLT4S2YHNUuDFF0jO/CrMQuzE3uwoKULixM7TTpUA9eTuvDwsMDWHykG/OPtGPusQ7MPd6JuRlsPbUd81gep7RePJvQjn+G1uHOgyWYuDMXFrxXlKJAMKIkG7Mwbv1JWH58GL/+MAHPbE7GO75H4J9wFCdPnERVSRGa6+rQ3taJ3gE1NFp2p/QaNPSajCiHL5Lxm/ne4L/eZiH1gQXvBeTkgxtme+AvC9ww/5MgbHJLxJdu0XjpCw/YLXPFbY67YDltPySzAiCx94Jk+gHcKjsIuyW+eHlTLA7G5uBUcRmKzxahqa4CPe1NUA/0Qa/RmsqGeylC8V5OI4rl0bFPKiW7Rj0G2DHKegH3Y/Vw3BSP38zdC8upOwTzabwTn3DdAzdI9+OehXvw4ocH8cXOYLi4x+DVLSF4bPlO3Dx7J6y4EeUYDolTEFseFH41718LAy/RiKKhecOIryDiJ8JWplhpro2c5LjtaTELQRCjiLnnUUwiCIIgCLNQ23EVYieTR11QMFJFlZhMiIgxoQAPXbnMGlFGg2BEKQ1qdLHPp/t0+OJIBZ73PImHvQrxn6BGPMSNqKhGkxEVW48ZsU2QxjVDllgH2aEqLEgswVshp/GZ1yHsPRCLGN9oHI9NQsGJ4ygvZUF2YyWaO5rQ19cvTFDOe0MNazi45vq+Q/N4mjA6i5sdw0aU3oiOITVy2wYRX98Lv4ohHKxQYU+VGjuqNNhWoYGiXIutZ3RYX6LDJ6UavF2kwSs5GszJ6MV93mdw08YMWH1xDJYbs2C9MR8Tt5bjF7sq8aeDpfg/ryrY+dXjwZBGPBbWjGciWjE1uoPdhy44J/bgxZRezEvtxcK0Xiw53I2l6V1YmtGNJUd6sOTYAJYeG8LKE/1YcqIHC091Y/HpXiw+ztbTuQYwO2MIk5O6cE9QFX7pVoAJrtmQcCNqWyEkW9hyUzZsvsyE5dqjuOPDRPxvYxJe9cyAe8wRHMk4hrLCQtRX1aKlpQM9/SqoNexe6bTnjCj79Yn4zXxPWEndIZF5Q+LoAwvBiPLE3xZ4YNEnYVAcTIGrTzxe3+aHJ97eh1/P3QOr6fthMTMIEuEX9nwx0d4Lv599EFPeDcTmoCNIzStCdmk2aqvOoLO5DkO93dAp1TBqeAGZykYoLwOrcd/HROF5vocRBbVSyNrPPp5u1GB9WCEefzcYP5+1B9YO+4XeXtyIsnJwx89m7sdDK/dj5eceUOwPxk6vGLyxNRhPvLIbN83ZCStnP1g4R0Di/E0javmXodgV6o9kMqIuCfEVRPxE2MrkNSPbSFupIlJMJghilBn5PHKJSQRBjHFWbjX+btVWPLrSxThvuYtx+fItxjfYto/Y5w0rthrXsvW32bZVK7YYF6zcbHxu5Sbj31etBc1nTHwn1HZcZdwr3fqsuUKxdZCvELMQImJMKMBDVy6zRhT7U+tUGNSr0ck+Zw/psfF0Hab6ZolGVBMeimjH/6Ia8ExsLSbH1WNaXCOkTM4JdXBOrcTChCK8HXISn/um4aBXAhKDEpCZlIqSzJOorCxGXXstWvvaMNA/AM239IgS1oVxduaNKA07428YUSzLOSOKyaA1on1AiZzWfsTX9iCgcggelWrsr9FgV40WO6t1cC3XQXHGgI2lBqw9q8d7JTq8U2zAqgItHmfX93PFSdhsPAGbr3IwbnMhbnIpx517qvF/3lW4x68O9wc34b/hrXg6sg1Tojsgi+vG7KQ+zE1hOtSLl9L6sCS9F8syerDiSDeWH+3GsmM9WHZiAMtODWH1SbY83oslp/uwLGsAy0/2Y2lGHxZnDGFOhhKTk3vxV/8y3L4nG+N2ZEKyPfc8IyqXnVs2rD4/iZ9/lIwH1ydihdsh7A9PQ+qhIyjOy0PN2Wo0N3EjSg2NYETpRCOqUTCi7uRGlOwgJDIvwYiSOHlh4iwP3POyF5Z8GglXj0PYF5SID/cHYcon7vjDwgMYZ+8Om9mhsJAFwtohEOOmeeL2Gbvx8MoD+Mg9EdGns5FReBxVFUVob6zBYFcHdENKQMMLiJWNULyXYkQxGUz1gtfRYSOKi9cI/r9zRhRb7WGricWdeGXXIfx98V5MtN8Oa6k7xs0OEowo/ot/v3rxIJ541R1vbPLBbvdQ7POOxttbg/H0am5EucLK2fdCI2oR7xEVJhhRF/aIaiMj6iKIryDiJ8BWpnjTXBt5r+P2R8QsBEGMMuaeSTHp+iJrz5wfpBy3v4t7GD3Mncf31Q9k1VbjnBUuxtkrthhnr9xqnLVKbpy5fItx5koXOP8Yrdlu/KV4iCvK8PH4OfNz59fAr4VfE7+2H6q1a2EpHuInZ+lm493Lt+LlFVuNB9h1lbNr1LJrxg8R+34LWwaz5atsf/eJh7gqWM7uOy8/dn68PJ1WbjHKVm6FAzvPGWx9OltOu2zaYpy8cjOeWelifJwd85HVLka7Zdvw+0VfGW8WT+e6hdqOqwxbmTx5ZIHYShXFYjJxHmJM+A1MMb6pZ4mpxwm3CIzQG3RQM3UZgOxeA746WY8Zvnl4xIsPzevAo5F9eCqyHS9Et2BaTBumxXdgelI7ZKmNcDpciZeSi/B62Cl86ZMGH694pIYkIPPwYRSwwL2isQLNPW3oGRyAUqVigbvpd9SGz4X/cUzbhK3fkMl++NqQ4n9CTpaVG1dGPf8Jfx1UGh2a+pXIbelDanUHgqoH4VWjgUetFm51Ouyr02N3tQHbKw3YclaHDeVafFqiwwdnjHijxADHw134u3sebt1yBBM2HcWN8hz8bFcZfnegCv/0qcR9gfV4JLwFT0e1YXIM/1W8djgndGBeimno3eK0Lixm+1hypBtLj/Vg+fFerDjZh5VMq070Mw1gxakhLM8cxPLsfizL7MGyk91YdrwPS04o8eLhIUyL68bd3uX42e483LgtG9byLEjYeQhyyYbNxtMYv+4EfvlhLP7zRQQW70vE9pBkxKekoTj3NBoqStHa3IiugX52P1TQatSo79XD81gDpq1PxC9f8oCl7AAkMk9InLxhyTTR2RN/X+COpWuDsM8jDv5BMdjmFY7FWwPxzzUHYemwHVZSb4xzCoGNUwTGOYTiVqkP/rnYg+UJh2fqMWSUZKK8shhNjbXo6ujCUL8aOjUrJlbB+PA8PoySz+nFy+274HVCbzRAx6QVlzr+64h8Yn22Dy5e5tBpoGW7bB4Egk41Q7YuAr90VsDCwRUWL/rCcm4wrBwCMM7eDf+3wA2zPvLAeldveHgH4oBPOD5UBGDKqztw29z9sHYOhAW7NokzN40O4GdM9y/yx8ovw7A7LAgp8UnIOXIM5dyIqj+Ljs5W9PUPQaVm56bndVE0oiq7sM5rpBEVKBpRnpdkRPHegiMhI4q4GPcv22djJ1W0jGwjmQLELARB/ASYeSavv/fk6f33SrL34Qcpa/974l5GD3Pn8X2Ute+EuIdLhgXiGecbFZdRn4mHuKKs2GpUmzn2ZZDxcfEQPwnLtxjvYefxGbu+Mxee22XUVmMdu9bdK7cYp4qH/slY4WLsNHuOo62tRi2771XsfFLZ+n6mNez+PCCe5jUPtR1XEbYy+XRzBTLJUb5AzEKchxgTXsBwMMvFR0+Zwl0WUEOPHvYhp0uPTcfqMMM3H//1KcPDYT14LGoIz0Z0Y2pkB6ZHd2JaQi+mpXTBIa0ZjhlVeCm5GG+GZWKzdxoCPeKQFpaAU0fTkVOWg9LWKjT1daFPqYJaqxFMBpPdZDIc+JJ/Ht5mOqPv0Lkv6AC9igXuavRp1KjrG0Jecw8yKlsRWj0In1qtIM9aHQ7W6bG3zgDXGgPkFVpsLlNhXYkaH5To8XaJAYtOD+CJiAr8YfdJ3OaSgdu3n8Yde4vxJ/dy3OdTiQeD6/FEZAteiG3H9Lh2SBPaMCupA/NTu7HwcC+Wpndi6ZFuLDnRhyWn+rH09CCWZw5h1ekhvHpKideYlmersCKPKacPyzI7WJ5OLM8ZxNIcLWYfUWIyu7d/9KzAz/YU4ubtuRjnwo0opu3ZkCiyYL3pJMZ/dhR3fhiJh9aHYtH+RMiDUxCXfAjFOSfQWFGA1uZqdPZ3Q6kehE6tPGdETdmQgJ+/5AELmRskjmzpzI0oH0xw4kaUG5Z95ouD7hEID4qCZ0AM3tsbjYc/8IK182ZIprjBRhYEK2kErOwjcaM0CHfP94TDx75wCUtCYt4pYZ6ouoZatLV3obdHwzssCT2iDFq20LLCYmVtKrSLw+sAN6CGTSiDYELp2JKbM6al0ch2ypZKDVDewco1uRJPvRuAm2Xb2LWx/xB8KRCSucGwsA/ARPv9uH+ZG1Zs8MJ2Nx/4+gfAwy8Un24PgP3rO/Dz+Qdh4xwCC0fRiHI+gF/MdMO/F/lh1Zdh2BsWgtSEZOQc5UZUDhrry9HR2YK+/kEyor4F8RVEjDL3Srd9aLaNlMr/JWYhCOInwNxzKSZdP5AR9Z1cKSOKBfJZ4iGuGCs3G23NHfvy6KcxolZsMc5f4WI8bv6crrC4KbXV+O6qnT/NEL6rxoj6VhmHmNyYnhRP+ZqE2o6rCDuZ/OiFBSLPFpOJEYgx4QWcb0QJP6/PA1uDqcdJH1vN7dFj47EaTPPNxaP+5Xg4vBuPRQ3guchOTItsw/TodkxL6MH05C44HGqBY3oNFiedwUchWVD4pCPEKxGHI5Jw6lgGssuycaalAvV9behWDkCj0QhDjngozeem4j/zb+oVZbIo+Dq3Ir5LgqfBJ4nivWz4r/7pNOhRqVHdPYjshm6kn21FePUgAmu18K/RwpvJvVoHt2o9dlUZsK1CB5dyNT4vUeKjYg3eP6PHKwVqyNLb8Z/gMvw/txz8dlc2frs7H38+WIr7/avxcGg9no5uxZT4DtgndMAxqQNzUrrwUloPXk7vxYKjvVh0chBLs9VYlqvBshw1VmSpsTpLgzdz9HgnX481BRq8kq/EypxeLMvuxPK8Pqwq1mJpESA7rsLjMW24y+ssbt1biBtd82CtyIFEkQ3JDr7kRtRxjFuXgd98FI3/fRmDFQfSsDP0MBJS0lCQfQI15blorq9Ed3cn1Ox+69QqM0aUqUcUnx/Kwskb4xw98PeFB7B8nT/cPCIRERID//AkfOGdgsnrg/Gzl7bDcqo7LGf4QzI9BJKpIbCZ6oPfztyPZ99yw6ceYfDPSENuUS5qaqvR0taJnm4VlINGwScUjCgNK3Oh0Hj5Xhyea3joKK8pvCccl/CJ1VFTPz4NK34N+tm+T1X3Ya3vafxnjSducdoJS2d2jfxX/mYHw0bqi585H8Cjr3nh9a3+2O3hj8CgYHgHRmKtazAc3tyNn80/ABvnYAhGFJ9TiuX/2cwD5xlRwef1iLrQiNLS0LwLEF9BxCjynxe232IrVfSObCNtZQp3MQtBED8RI59LLjHp+oGMqO/kShlRXOIhrhjcNDF33Muj0TWihLmcXIxF5s9ldLXCxTjI7u0Xa9diVH8V/uo3os6XsWSVi3GpeOrXFNR2XCXYOcpnmisMvl3MQoxAjAkvYDiY5RI6XXBjSMcCe4MOgyzGzevT48ujlcIcUY8FluG/ER14LKoHz0W2YVpkC2bwX4mL50ZUD6SHWuF4uBZLk8qwNiwX2wKOIdA/FYeiD+H0iWMoKMtFRXMFmnpa0DPYB41KDQML2MGOY+Q/wc8kGEo8tmarwjZuNnyHDDp2/nr+PZM0OgM6B9Q4296P07XdSCtvQ1T1IEJrNAiu1sCvSg3PKg0OVOmwt1IH17NabCvXYGOJCmuLVfi4RIN3z+iwPF8F6eFOPBJahX+4F+Iv+/Jxj/sZPBhQg0fDGvBsTCumJXZAmtyFmaldmJvWhQV8svEj/Zh3oh+LslRYXqDFqkIdVudr8GquGm/lafFxkQHrzgDvFfMJ0pV4Pb8Pa/J6saZQhVdKgYVFRryQMYD72DF+6XEGN+0rxETXfFhty4VkB5MrnyuKG1HHMG5dGu76OA5PbUzEawePwi38KBJT0pGTdQzlZ7LQUFuO3o4OaAdNRlRDrx5eRxswdUMCfsGNKKlpjigLJ1/BiLKRHcQ/Frtj+fpA7POIQGR4LCLj0rAr4hhe3hGHv67ah4kO3rCy92cKg8X0MFhP88EvHffikdW7sdrVD/uSUnAyJwsVFZVobG5DV+cgBgf0fPQc9Ew6jVYot++DUCXPk2lopsmeGhbvgaRj6mb1ICa3CQu2ROMvC/biJqf9sJnNrmtOCCycg3CD1B2/f/EApr7vj493BcPdLxBhYaHwD43D53siIX3LDb+YdwDjHYNhKYuAxNEfls5uuH2WG+5f5CcMzfsuI4rmiLoQ8RVEjCK2UvkX5trI+xwUoz+3CkEQ38DcsykmXT+QEfWdXEkjis/rIx7misDO/bDZ414WjY4RtUpu/Ac7VpT5c/hptcLFWM/ObbF4qlecsWVEidpqLLvWDClqO64SbKWKrAsLQ35UTCbMIMaEF3C+ESVE+nyiHa2arWvBR1MV9OqxIaMcU7xP4n8BZ/BoRAsej+rAc5HNmB7ZCIeoVsyI64F9Ug9kqW1wPtSAxSkVeDe2EBvCT8M9LAOJiUeReeo0ysoK0dRYid7uFqgGer82ovicQd9iRJ3rATPCfBKMDFF6Lf+uKSDnFsWg1ojmPg1KWvpxqrobh892Iq56CJE1GoRVqRBYqYIPk0elBm4VGuw+q4FruRpby9RYf0aFT4qG8F6JCm+dMWBZnhqyQ+14PLQKD3ifYSrDfwNq2OdGvBDThhmJHXA61IU56d2Yf6QbLx/rxeIT/ViY1YelOX14JW8ArxcM4t3CIXzM9HmREpvPaCAv12NjiRpfFKvwWbESHxWp8E6xFq8UGfDiaQ0ei2/H/7Fj3XqgABP35GOcax4stvFfzWPawaTIhNXGDIxbm4o/fhKPyZtS8O7B4/AOO46U5AyczjyKojNZqKstQ39bO4z9g9Cr1Wjo4ZOVN2D6+gTcMd8LlsKv5nEjyg8Wjj6wcjyAfyzzwLIvg7DHMwIREdGIT0mHX3IW3vM8hMfe9cQtzr6wnuGLcdJwWEsj2LofbpPuhe3SXZi7yQtbY1Jx+ORJlJSVo66xFR0dfejv10LLTSgtq17aSzOiRLtJkKk+8KnKNaJYHWLi/7ayeuCeXoFn3vHBL51cMVF2EDYzAyCZGQxLpwDcNmMP/vaSG+Z8FoSNbqHwDQpEZFQYgiKTsH5/PKRveQkTmY+XBcGCXRvvEWUx0w23zNyPfy30xYqNYdjzvY0oHTKrOvGZdyYZUcSo8s/p235lJ5VrLmgjpfLdYhaCIH5CLng2mcSk6wcyor6TK2lErdhq3CMe5opg7piXT1feiGL3Z4n5Y19dYucZvWoz7hRP+4oxJo0oUezcA5dtxS/ESxnTUNtxFTDJQb7AXEFMkipmiFkIM4gx4QWYNaI0KrauAfsXRX1abD52FtO9j+MxvwL8L7weT0Y344WoOthH1sMhqgUOsT1wSOyFY0oHZqc24aVDNViRWoZ343Mhjz2O0EMncSozB1VnStBdVwsdC7CNff1Qq9TQa/l4LZMRxU0pwYzisTUTX+dzVZkzo7gBJYgPI2RBuoHtg5sWfJ6rbpUBNd1q5DUN4nhNPw5X9SGxWomYahUiqpQIqVQioEIJL94rqlKN3WdVcC1XYXulFpvKNfg4vw9v5fbhzUI13igyYPFpJRyT2zE5vA5PBVXjiaA6PBPWiCmxrXBIasfMQ12Ye6QHC473YBGfE+p0H1bldGJ1djveYPogrwvri/rgUjqAneUD2Ht2EHvZcnepBrvL9dhRYcSWcuDTYiNWZakhTenBA4E1+NPeAty4Lxfj9uTBekc+LBT5kHBxM2rrKdhsOIzxnybh/z6OgeOmZHx24Bj8w44iJeUwTuYcQ0F5JmrryzHU3gX0D0EnGlE+R5owfX2SyYhy8IBE6gMLx6+NqHuWeWDpxgDs8gpDREQUUg4dRlRGDraEHIPzF0G43dkTVlMOYJwsGNa859A0X4yftgt/nLsdz31wAB8FpSH+8DHkF5agqq4Zre096O1TmowaHRfvxcRL67tNFO4vagwGJr0gHR96aVRBbxgSNcjqiAoDLG/loAGbo4pgt/wgJs7YCRupJ6wdA4Vf+Bvn6I9fTd+Gfy/Zj2WbgrDNMxTBIQGIjwlHeGwaNrqnQfqOH+6cw74rDYIlN6Kc/WExyw03z9qPexf5YsWXodgdev5k5WREfR/EVxAxSthJ5VvNtZF29oo/ilkIgvgJMfd8iknXD2REfSdX2IiqEw9z2Vm2xfiYuWNePl1ZI2rlVuN288e9OsXKsmml/MpOaD6WjShBW42Ny1yML4iXM2ahtuMqgP8q3shCsJUpksVk4lsQY8ILGA5mBfGonxtB/CfORCOqbFAH18waOAecxpN+uXgsvBpPRTdgcmQNHCJqIY1qglQwovrhlNyNOcktmHu4AfMzqrAypRifJWXBIz0b6acLUFFchp7qOhha2mDs6YNSzX81Twc+2IrPD8V/Qc80eTkP5o3QceMBJpk1oli6aT4r3kcGwvn26oCmQQPKOjTIbFLiaN0Q0mqHkFStQlyVCtHVSoRVDpl6RVWp4c60p1IJ1/IhbK/U4asKHT7O78UbWV14LWcAb/BhdblaLDo+hBdTu9m1tuL5yCZMiW6BfWybYFDNPtyFeUd78PLJPizKHMCy7H68ntOBt7La8F5mCz7P64DiTC8OsON6VzNV9cG7ooet6+BVC7gzuVYAn+brsSijD89FNGGSZzn+sCtfMKJs9jDtKICVoggSeQEkLjmQbD6FievTcdOnSbD9JArzvorHV27pCA9JR1pKGk7kZSC7OgvVTRUY6ugB+lXQqzRo7BaNqC+ScMc8b1g6eApGlJWjH5MvrJzd8LflB7Fooz92ciMqMgJpaYeQfCwH7nGZeG1HLO5a4AvraXswXuYHG6cwSGaw707bhzucd+KB1fux6sBhhMYfxqnsApRX1aOxpROd3fxXEnXQaPXQsjI32Ybf14gynjOjdAa1aEQpBRPKYOyDBkq0sXI/0aDG6wdP4A/z98Nq+l5YSn1hKfOHhYMPbpB54W4nBZ5cfRBvbQvFXr8QhIX5IikuAjFJx7DF+xjs3wvGr2cfwA0OQey+8Dmi/GAxaz9umu0Gu8UmI2rv9zaiaGjeMOIriBgF7pNt+cPI9lGQVO4iZiEI4ifG3DMqJl0/kBH1nVxJI4rrSvUSWbHV+KW5410+XTkjauVWY6j5Y44BybFMvIzLzpg3okSxujmmO61Q2/ETYydVLDdXCPdKtz0rZiG+BTEmvIDzjShuBAkmj14NIxMf7lSpMsCjqBmLIgrwgl8+Hg+rwFPRNZgSWQlpRDVkUY2CESVLGMDMpB7MTWrHvLQWzDvSiMWHzuLtlHy4puch9lQh8gtK0VRVi/6WFih7uzGgUUFt0EHLjqNhx+USfh0NRtPgK/6ZfeLif8O/lmYUfh1PFAvSeV7BhNIb0azU4WyPGrltShxrHMLhOiUO1auRVKNEfPUQYpjCq5UIrlbBt0YN9xoN9lSpsOPsIOQVGmwq1+GTwkG8ld2L1Zm9WJOjwqt5OrySrcfyExq8dHgATok9cErqgnNSJ2alduHF9C7MP9aNl0/1YmFWvzAk7/XsbrzD9HFuD74qHMDucjW8anUIaOBSwa9uEH7Neng3AW51Rmwp0+GNU2zf8a142L8S/3fgDH67twg37c/HhL0FmOBaBGtFMSRypq15sNp8GjevT8fPP0vGQ+ui2Ms1BtsPpCAmOBkZKUk4UZSBrIYcVLZWYaizF+hjpakcNqJaMOOLZPxqno9oRHl/w4j685L9WLDBF67eoYiKCkd6WirSj+cgIi0PX/lk4N7XI3CTbC8mOvsIvzAnkQYKxsrtzvvxlwV7MHNrCrxCk5BxPBNFZVWoaWxBa0cP+odU0Gi10PA5yMCNle9jRBlZHeFGFNewEaVk2weZ+ll96IXSOISKfgMCTjdBtiEWP3PaA4sZB2HpFARLWQBb98DNsgO4/6XdcHzPG+v2RcIrOBQxkX5IS4pGYtppuPhnwv69CPxm1gHc6BAEK3s+NM8PEm5E8R5RZET9YMRXEDEK2MoUO0e2j7ZSufYe581XvOs+QRDfj5HPKJeYdP1ARtR3cqWNKLb/KzLHEAv288wf73Lp8htRq9biJrbfZPPHGzta5WJcLV7SZeVaMaJEOYuXNeagtuMnht3wypEFYCdVRIvJxEUQY8ILON+IUvOA16hjGzUmI8qoR53WiKCz3VgdVwr7wCI8FV6Jp2KqMTXyLGThFXCKbIBjTA8c4wcxM7EX8xLbsfBQOxalt2NxShVeTynElsO5CDlZgOMFJSirqkJdWyNa+zvRr1VDyY6hggFK6AWpuQHFzosv+WeNaEQJZhQ3okaYUCYjChhk6tDqUNOvRmHHEE40DyC9fgipdSqkNGiQVDOE+KoBxFQPIqJ6CMF1SvjVqXGwVo091UpsrxjAV2VDWF+qxbozWrxfMIQ1WX1YdXoQa3J0eC0PeDUbWH5Ch5fSlZiXPogX03rx4uFuzM3owvzj3VhwugcvZ/dgcXYvXs0cxDu5KnxWqIVLmR77qozwqjfCv5ndz1YDAlv18O3Swb1Vh+21GnxSOIBFGW14LqIak7xL8Du3ItzBdPOBAty0rwg37SzB+G0lsHRh2lqA8ZszcduXGbhjXSoe+yISrysisedAIhKCEnEkOR5HSzJwqjkX5e3VGGjvBXq/NqJ8M1ox/Ytk3DFsRDn4wkrmLxhRfHLuPy7ei/kbfODqG4romAgcSUvC8ZNZSD5ejP2R2fjf2kTcPnMfJjp7wMopABJpEGwc/XGLkzvucHLFs5/Ewc03BmnpJ5BfchaVdU1o5L+eNzAIlUYNjU7FypLbh9/DiGLiwy01rH5qWfnrWd3UCTVjkNWaPpbaA6VBiYI2dh9jS/DI6z6YMH0nuyYfWM8KgzU7P4vpB3Crw348tfwgFqwLxlbveARGhCMhxh9HDsUi9UgOFEF5sH8vGnfNOoCb7INgec6I2ocbmGwX+WL5hguNqIYRRhT9at6FiK8g4grzT9nWv13QPjLZylw2iFkIgrgKMPeciknXD2REfSdX2ohasdUYJh7qsrFsH2zMHevy6vIbUStcjGHmjzUGtdX4mnhZl41rzIjC8s3G/4qXNqagtuMnxE6qeN1cAdg6bHtUzEJcBDEm/AY8hOVD4ASxT1oW7Br4cDfeI0qngpoF/s3sY1KTCmszajAnuBDPBxfhmYhyvMB7RUU3YXJUG6bHdMExsRezkrswO7EVc1Nb8XJGK5am1uON5AqsTy3F/oxSRGWV42R5LUqbWtDQ04U+dT+G9Ow40AqGk5r9q2ZBvIYdlxtPJsuBzwCkZWLb2ZIbZcLwPIMBet5Dhp3zELuOTr0RNQMaFLYP4lRTPzIaBpDWYDKhEus1iK9VI7ZGhagaNUJrVQioU8O7Tgs3tm1XlRLbKgawsXQQn59R4/NSLT4sVuP13EGsymTK0mBNjgGv5oB9NmLJCS0WHlfjpSNDmJ/Rh/lHe/HSiT4sON2Hl7P6sDh7AKtylHirQIPPzhghrwT21QEezYBPG+DbAXh3AntaDdharcKH+d1Ymt4E++hqPBJQhr97luAut2Lcsb8YtxzIx417C3DDjhKMV5TDUl4Bi63FGLfxJO74IgV/WRsPh68i8cnuSHh4xSAlPAon02KQVZKOgqZC1HQ0or9rAEY+NE+jQWOPAb5HmjHj82TcOdcb1g6esOBGlKPJILGZdQB3L96NBes9sds3DLFxsTiSkYYTp7NxJLMEoakFcHZJxZ8W7sdExz3g80pJHEPY94PYZ0/cMXMf/r0mEF+6RSAy+Tgy88+gsqoaLS1N6Ovvw5BKJYiXnakGXhw+95dOz8qaZdUK5a1i9XWIlT/vDcXNKCV69TocrVbi7f0n8bcFnrCZvoedkx+sZ0XBms9jNW0ffum8EzNe98SrWyOx0y8OIZFhSIoPxpH0/8/eeQDGUZxt+NRsUwMJIQlppJEQwIb08ickJJAQwLYkdwPutlwB07sp7iruXZYsyepdtrosq/fee+9dp+vSPf/s6UzAHLZsjLHDvcrL7u3Mfju3O3vreTIzG0d8egl7goqwfS2E785z46bpnljN8EWarFw25ziT5xzl/uXuOGz144hfIPGnY8lLThnvEdVSTU9vpwFEKVWifNIbHPXacRBV28d7J84HUb5mEGXWF6Jpts6un3o+2jkP/Xr2tq8Zs5hlllnXgM6/TyUbk746MoOoi+qLBlGrHfUq46GumKShTyaPdUV9ZUHUFz+U8Op71U79FX2L/P8aiBLfp37tdv1dxq933cj87PiSNHu2v5X4B3Xb+Sd/qq2LnzGLWReRsU1okNR0NUAoYWkY3DkbNkpzRGlU6LUKNKJB3S0+Zg3oOVDQyeqQQmaezOTxwDL+daqTv0eP8NfTwzwW2WeYqHxuQiezYjqwTWhlbkoLyxM72BjXwZvRbWyJbeRwaiOnilrJr+ulqWOAvuEehlVDaMakPlESZFKLRreSUWGpVxZim1KUQSXWJUBl6BEjckplVYtUCUMM6sfoEmWsV45R2K0gtWmAxIZBEpoUJLRqiWkd5XSTjojmUcKaxwgS9msaxVP4eKOOQ/Ua9tSqcK4eYVulgvfLVbxbpuL1EhUbC5Wsy1PikC1Zw5qcUdZkj7Eyc5RlGRqWpKlYnKrg2TQ5i9LlLM4cYUm2gqW5ClYVDrO+UM7rpSq2VOrYVTvG/sZR9jfr2N2sxalRwxvFKtal97IgsoHHfcv5y4lSfnOigvvdqvixaxV3HSrnVtcCphzIx8a5BCvHWiydG5HtLMPmw7P88N1w/rQpEIddoTi5heHtF0hSpD8FaWGUlyRR31JJZ18vQ8NKtGoVo6MaWobG8BTXZub70dy18AQ2M93H51Ky98ZylhdT5rty74oDLP/AlUOegUTGxJCclkZ6TiGZ+eUkppfw0vGz/PE5V261343M/gSyuSHjMErs/91nPblnsSsOzv4cCU8iObuAusoyelrrGRnqRz6iElYbANNEpNeKq62R3rInqqVWj1ajEHVULqrGgIihNgzJbBGVITi/hznvxnGXvRc2M45hIcpiaR+G1ZNBTH7yMHc/48L8107w9v4wjngFExTiT1xMmPhu6cRkVbE3rIhZb/rynQUe3DjjiIhxHAt7H/G9fJg0+zj3rTzKmu1eHDsZQvypOPJSUqgqzaOtpYbevk+CKKneKsR9dGEQ5X5JIGpsTLpbPykziDLrnKbNdnnw/Oej0W8Zs5hlllnXiEzcp2YQdSk2g6gr5jXO+vuMh7siEmU+YOo4V9ZXDkQ57NQvMn2MK28HR73SwUmvM5V2pS2OM+bgrP+L8Wt+bv2vgSjJ4jvFG7/edSPzs+NL0lS7Xa+ZOvkP2Tv/xpjFrIvI2CY0SGq6Sj4fRBnatFLPC60K/ahKbNPRL7YVDMOJij5ej6tkYVABM4IqeSKik8ei5Twq/Hj0ADNju5kV38nsBLFM7GBeYgtL4ztYL7wxrpU3ExpxTGnkZF4LcWUdFNR309rTS8/QCAqNaMCLg0s9s6SeH2PSO/6lYXeGskgWJZUsNkntcZUo04Bwh26UJo2WavkoRb1qQ0+oxIYB4uoHiW0cIaZFQ2SzjlPNo4Q3jRHaNEqgsI8EohpHcW3QcbBey+5aFU7VCrZWqHivXM07ZSpeLVHyfKGStbkShFKxOlvDWgOIGmVlppYV6RKIUhpA1KI0Oc+mDRkmK1+cKWdxtpxl2X0iXz8bsgd4OXuQN7KHhAd5JauX5zM6WJfayvzIemYGV/KoVzH/d7yA37kW8Su3Cu53r+bHx6v57pEKbjlWyJQDBUxyLsbasQorx2ostxdwy4fx3PteGP/YHMxze4LY6xZEQEAgaTFBFGecpqI8lcbWGrr6+xiSq9Cq1eMganAcRM34IIrvLHQ3gCgL6a15dtJb86QeUa78YsUhln7oxqGTQQYQlZqWTk5eMQUlVWTmV7ElIId/v+bFnXP2Y2nnMQ6iZgdhNesk35jnzg8WujL3vRM4eUcTk5pDeXkpbY21DPR2MyxXoFCqJwxQpDcpjkkwSqxrdaJ+SBPp65UiQZojSmt4W15pn4r9sTU8tjGc26cfx2L6MWTiu8hsg7B4wp+bZhzlF8v3s2TTST44HI6rdwjhoYGcjT9NenY28Xm17A0vwe4tX8M5uXHGYSbNcMXSAKJ8mTzLjftWHmP19pMc9Q4i/lTsx0BUNT0fA1FSGaUeUQYQZR6aZ5DxJ8isL1DTbJ29P/2MdO765Wz/ScYsZpll1jWiT9+rZhB1STaDqCto/evGw10RiXjdpo9zJX1lQJSDk/4PpuN/Pjs46tUidpAo57KVjvp/rNqp/+XqrdxuPKxs/W79N1fv0k8V+f4lDaMTeU+JpdZUrM9jEb925WFuNB72c+mKgChH/ajUC0+Ua0i4V6x3CveJdbmwdM7GTO73BVoc82XjV7wuZH52fAn65ex3bxb/yO7/9Ml3PmHMYtYEZGwTGiQ1XSV/CkRJG0SDVxqWJ4Eoqe/RsNhUI9r+EY0j7M5qYU14KbP8yngyqIlHw3v45+kB/h3ZxROnW5ke1YpdQjdzznSzML6NxfGdrBSfHc50sC6plVdTmnBMb+ZEdiuRhe0U1nVT1T5Cx5CeQQ0odKDSgkasa4VHpU5R0uRPEm0Qy1GlyCPco4D6ET3FQxqyBhSktg1xtmmQhMYBYuoHiKwb5nSDklNNaiKadIQLhzTqCGwcxVfYq0GHe72WYw1a9tWpca5RsaNKzuYKJZvK1LxVquTlEgXPFSgMIGp1joo1Uo+obB2rhVdlaVmZqWF5uool6SMslnpEpQ3xbNqgwYuEn0np4tmkTpYmdrI8voNlse0sjm5hwekG7MOqeSqonMcCqvj7yXL+7F7E748X8xu3Ch46Uc39J2r5kWsV3zlUxi3SZOX7C5jsUsxkxzImbS/mps3p3PV+FH/6MJRZO0N4+4A/rh6+hIf6kXkmmLLsaGors2htb6BvcJARhQadOKkTAVFWc47z8xVHWbrFg8M+IUTFRJOWlkpBYQmVlfWUVzZxIq6cxVuD+ekzB5ls745sTohwOBaz/LjR3o1vzDrG3547yKsHQwmKz6KouITmuiq6O9oYHBwW11BzmSBqjLFRaUYwCURJgzXH6BYfz9b28fKJdB5a6sOUfx1HNkOUSZrfaWYAVk/48PXZx/jt88fYsMMPJ/fTePmFERkRQtrZWHILC0kqbuJAZDl27/jx7afdDCDK5iMQ5cfkWSe4f4UrayQQ5TNREGWeI+qcjD9BZn1Bun+myx8//XyUhuXtetGYxSyzzLqGZOp+NSZ9dWQGURfV1QBRoiGeYjzc59b6zfpvmjrGlffnB1GGuawc9ZWm41+u9V4Ojvrps/2xMh5mwnr3XawdXPSPizj+n457+RblOWY8xOfSZYMoR327McSEJF2Xp3fqb5LA3Ron/U8dtuv/ImLMFf5AfJdwk8f4vN6hn2o8/DUv87PjS9A0e+f3TJ14sf2Kdif9X5exTWiQ1HSVfD6IkkZLSXMvGQiQaOhL76wzDH3SQUqHCr+yHt6NqWaRXwnTvSt41K+Bx8I7eSKynSdONYllM9Pju5id0MPTMR0sju9mcWIfi5N7WZTSyaqUVl5JaWZrcjNH0loJLeogpmqA9FYNJX16aoehaQRahTuEuxUwOAD9wj190Cby1PWOUtylIb1DQXzLEKeaBjhV3cupGrGsGzJMRh7eoCSsQUVog4bgRh0hTXoCJAhVP8rJeh0nJAhVp+FQnZY9tRocq1VsqxzhgwoV75Speb1EyUZpsvKCEdbmq1hthFGrs9U4ZGpYlaFiZaaKFRlKlqcrWJI2wqJUaa6ofp4WXii+77wz7cyPb2NBbBvzo9uYF9nKrFPNPBUqzllQLX8PqOKRoEYe9m/gz951/MGrlt951fPQySZ+6dHA3ceq+fbBUm45WMyU/UVM3iXsVMBN27L41gdx3P9eGNO3BbJmdxhOR3zw9vIgKsKXnJRQKgrP0FBTQJdhXqYRlGoto1oNo7oJgKjZJ/jpSleWbjvJYZ9QA4hKTU2msKCI2ppG6upbicmq5bV9kfxm+RFutT+GxexAZHNPGXpFWdt6cIPdMR5Yto9l2wNwi8ggu6BU7FtFS3MjfX19hh5Ro6NjH4GUC8GUUd0oOq30tkRQie+h06pF3VSKfTQoxLYG+Sj+uS3M3xnDj+Z6YvWvE0jzQ8nm+iCb6Y/N9JN8/1k3Hnvbk7f2BnDQ+zT+QWHER0WQm5ZISVkFaeUdHIyuwG6TH99eeIwpMw+K8+KKlZ2vOC/+TLH3MIIob45IIOrcHFEXBFE6sut62eSRbQZRZn2hmmrnEnz+83GqrUujMdkss8y6xnT+/SrZmPTVkRlEXVRXA0RJNh7uc8vBWf+MqfhX3p8fRElgw3TsS7eDoz59tbP+MWPozy0R6wkRM8fUsS7HDjv1zxhDX7auFoi6mF5w0n99lZN+hagD0SaPd1nWRxjDX/MyPzuusn493/EO8Q9q5fknfaqd8yFjFrMmKGOb0CCp6Sr5fBClk7YZJgLXCEuTQmtQM0q3Vk9xj5Iz9X0cTG/ipbAKFvqU8B/vcp4MbcIuug3b6FZmxLQzPaGPWQkDPB3by6L4ARYlDrIwZYD5qb08ndaJQ0obL59tZVNSK05Zbewr6MW9YpiABg0RLTpi2nWc6dSR3D1KareOlE4tye0akttUJDYriWsY4XTdMKE1gwRVDeBb1Y9/5SABNXKC61WENGoJadIR1DiKf4NOxNXj36jHp17HyVotHsLHazUcFt5Xp8W5RsPWKhUfVMjZVK7kzTI1r5QoeL5o5CMQtSZPNQ6iMpU4ZChZlakweGXGCMvTR1iWNswi8R2fTupj4dleFiT2Mj+ug3mx7cyNbmd2VAf2kR3MON3O4+Gt/DOkmYeDG/lzYDN/9G3k9171/Maznl95NTLNq5lfeDRxt2sd3zlSya0HSpmyr5hJuwu5wSmHr29L4p4PTvGPDwNY4eTHu4dCOOzqRaCPG7ExfmRnnaaiNI2WhkoGOvtQyjXGnkQTAVEnsZrjwU9XHWfpNm8DiDodFUly8lkK8gsNIKqxsY3sknpcPBP41/Nu3DnnCJb2vsjmRgiHYmnnxWTb49z97EHsNgWwOyCNlJwyqiqraayvp6uri5GRETQaCUZJk+OLsgl/FlAZE3l0ulFGx/So1BoDiNLrlKLujjIodinuVbMvvpJ/vBHMHbYeWP7HF8s5AeMgaoYXN4nvd+/y48za6sn2YwG4+UcQGhJKcsxpirLSqKiqJaOyiwOxldi+58u3Fh5miu1+cV6OGUCUpW0AN4jvdP8KNxx2eHPIN4g4M4i6JBl/gsz6AjTV1vmR85+PBts6rzVmMcsss64xmbpnjUlfHZlB1EV1tUCUOM7fjYf8XHJw0nubjn+l/flA1Gpnfmw67qV7jZN+lTHsFZc4ny+aOualWsSpN4a8bF0rIOrjWuuof1TEvyK92sR1/Lcx7DUt87PjKkv8I3uHqZN+38wdPzFmMWuCMrYJDfosECUNepKWY3ppMiYJRqnRiuWQRkt9v4LCll5CCltwjK9ifWAhs7wLsA2uZHZkI7Oim5kZ085T8QPYxctZGDfMs2K5KFHO08nDzEsfYF5GL4vSuliV3MF64Y0ZHbyW3cM7BX1sLh5kR9kwzhVD7K0a4lDNMIdr5extGGJ/nfhcO8wxsf14xSBuZQO4C3uKvJ5VcryqVXjXafBrHCOgWS8Mfk16fBpG8akfE8sxPGu1nKjRcrxGw5EaNfvFcrfYtlOsb65S8V7FCO+UK3m9VM2LxQqeK5SzrkDO2nzFOIyS5orKHGFVunx8KbwyQ87y9CGWpg6xOHmAZ5L6WZDYx/wzvcyTJm+X5s2K7sQ2qoPpkR08caqDx8LbeSS0hYdDWvi/wBb+6NfE70828GuPeh70aOD+Ew381K2e7x+r4c7DVdy6v4Ipe0uYtCePG53S+O7WWP64OZQFW/14a48Pe48FcNLDk/AgDxISQ8guSqCiOp/2pmbk3XJ0itHx3kfiOk6oR9Rcd37hcJzl205yyDuEU5GnSU46S35+ETU1TTQ2tFNeWYdPZCbPfhDAj55xxVqaJ2pOMJbzQrGyP8kk2+Pc+fQxHn7Vj3eOnyEyqZCS0ipqqmtobW1laGgIpXIErVZ7URAlbZfmDtOJZLUEpEbFPjrpXYpj9IxCctMIb/nnMnWNFzc/5YHFk4FYzPVHNssDyxlu3DHrOL9bd5ylzp7scffFNziMqPBQsuJjqMzLpaaumczaXg7EVzLzfW/ufPYgU2z3GkCUtZ0vVrZB3CjOjfTWvFU7vDnoN1EQZR6ad07GnyCzvgCJ52HU+c/HabYuFcZks8wy6xrUp+5ZYWPSV0dmEHVRXTUQ5ah3MR7yc8lk7AvYwVGvN7X94v6cIMpJ72Y67sQtyq4Wnm4M+YVJlHWZqeNfsp31rxhDXpauRRAlSRrKJ8p20OSxL8n6RGPIa1rmZ8dV1H0zHL9v6oRPtXO+Ij+YXzUZ24QGfRaIkt5EJ8Eo0fQX/xkfnie9mUypUdM1KKe+s5eUyla80qt5P6qIZYF5zAssYk5YBfYRNcw83cqT0sTlcQrmxSt5RnhJgoIlZ+U8nTrI/Iw+Fmb2sjijh6UZ3SzL7GFlVh8OOf2sze1jQ14/L+T381JBP68VDvJG8RCvVAzwRvkQmyrkbC0fxrFsiN2lQxwQyyOVIxyvVeJeN8qJej2eDeDVKNwEJ8W6p9jmUafjhLBbjQbXag1HhA9WadhbrcVFeJv4/EGlknfLFbxpmKRcbRyWJ2et8BppnqgCFWtylKzKkLMqfRiHzGGxPsyKjCGWpw2wJGWQRUn9PHO2n4WJ/cw/0ye+fz9z4nqxi+5melQnT5zu4N8RbfwztIW/BTfz16AmHg5u4S+BzfzJt5HfejUYQNQv3Rr4kaE3VDVfP1DBLXsrmbKnDJvdudzsnMRPd0Ty721BPOfog8sBbzxcvQn19SYmKoCzWdHkVGVR2VRFV1svqj4NYwpxNUdH0etVEwJR1nOPc++qo6zY6sEh72BOR0eRkpJCfmEpVbUt1Dd20FRfx5nsMl47HMc0Bw8m2bkim+2D1fwArGd7MNnuKLfMd+P+1Z7iYR2O9+kMcvPLqKiopLGxkYGBfkZGhj7RK8oUUDGAlvHaKOonaMYk8DIqvocatUhrUkJQkahH++P54bNHmPy4O5bTgw1lkdkeZfLMo9y98DiPvuzGc/s9OOx5kpCwEM5ERlCYfIb6kmIamjrIrh/gwJkqbDf78M3F+0X594jzchQbWz+sZwZzk623AURJPaIOTrhHlHmy8nMy/gSZdYX1oN2u/5h8Rtq7LDVmMcsss65BmbpvjUlfHZlB1EV1tUCUaMhXGQ952Vq1Xf8zU7EvZAdHfZGp7Rf35YOoNS76v5qOeSnWt6x10f/RGPILl7g+9qbLcUkeXLmNrxlDXrKuVRB1TqIubTF5/EuwiPEvY7hrVuZnx1WUOLl7zj/ZU22dRx+avvcuYxazLkHGNqFBnwWiRLseaX7w8aa/WNOrYFTFqFbFkHyYzp4+ShrbiS6p52BqBS+dLuLZ4HzmBBViF1KBbUQbM6LlzIjXYB+vZmGsimUxIyyPH2ZJ0gBPp/ezIKefp/P6eCa3j6ez+nk2a4BF2YMsyRlkWe4wK/OGccgbB0DrC1VsKFHxYqmaN8q1vF+hYWuFkp0VI+yqHGFv9QgH6pS41sNxYde6cR8Xdhd2q9VzvFaHa7UW1yoNR6vUHKpUc0Cs7xbbnIS3iPVNlUreKh/hjTIVr4hjvVCkYF3+CGvyRTmkN+cVSEPzFKxMF+VLG8Ihc4hVGUOsSBtgWeoAS5LFdzjbx7OJ4nsljsOoBWeGmBs/gG1ML09FdvH46Xb+FdHCP0Ob+HtwIw8H1vNwQB1/8avjzz71/N6rgV95NHCfewM/El/mO0dquP1gJbfuqWby7nKsd+dxi8tZ7t0Zgd2OQN7Z5cuxQ974u3oQFehP4tlIUoqTyG0qpqqzhZ4uOdq+MfQjEojSMKZXfApE3fUpEOXJpHnHuHflIVZsdufwyeDxt+alp1NQUkFlfTt1Td10t9RRWNOEY2A2f3zRh8n2R5DZe2A13webOceZYncA69lufPfpY8x+y5tDfgmkZxVSWlpGfX09ff29jMj70WhU6EZ1jI5JoMwEUBHbxvRj6IS1IlmyVDt1OjUKnZ7Kfj1HkuqY/n4A35q9F+vH3LCeESrK4o1s5kFuFuW6b6kHdu948MYxD1xPehJxKpjU2FNUpCfTUlFJS2svOQ1DHEysxm6bL3cs3sck+13ivBwR9sdmRgg3z/Qx9og6yUHf4PNAVA29ZhB1QRl/gsy6wppq53zWxDOywJhslllmXaM6/76VbEz66sgMoi6qywVRDk76RlPbL2TjIS9bq531603FvZAdduq9TG2/uC8fRIlzE2865iX4S5jcWpR7gcmyXIJFjMt+Q9y1DqIkiXoRYbIME7T4jt7GUNeszM+Oq6SpMx3vMXWyp9k6bTVmMesSZWwTfiSp+SqasYwizbYzvjwHosbEn4SmDL2ipLfn6ZQoRobo7+ujqb2LnLo2ggrr2ZFcwYbIQhaFFDA3tAL7063Yxg0zM0GNfZyahTFqlkWpWBkzworEIRan9fNMdi9P5/XwdG4/z2YMsyhzmMVZIyzLUbA8V8mqfDWr8zWsKdCwrkjLxkIVrxZreLtMywcVOrZWaNheqWRn1QjO1XJcahQcqh3jcK2eQzV6DgsfrYFjtZLHxLpw1ShHq7UcET5YpWVvlQZn4e3CH1ZqeKdCzZtlCl4tVbKxRDk+LC9fztq8kfEeUfnSZOXSULwhVqYNsCpjgJXpnwRRz0o9ohL7efpMHwsSpOF5Q8wxgKgenorq4j9Sj6hTbTwa3sIjIY38LaieP3lX8kevSn7vVc1vPGt50KOeXxpB1F1HavnG4Wpu2VvHpD0VWO/K5nanOB5yDGGxSwDb9/ngfcSLCDcPzkQEk5qZQEZlDgUdtVT39dLbp0U7KC6mchxE6SUQNaqmZWjUCKKi+c6CE9jMcMdiphFEzRoHUb9YcYAVm49z5GQw0THxpKVnkV9STUV9J7XNPfR31FPf3o1bQjlPvBvC7XPFP7ZmHsVy9gms7V2ZbH8IS7sT3DbrEI8878aW49HEp+ZTXFxCXU01Pd2dDA8PolGp0Wl0onxSD7xzNXL875wkCKUeGzP0htIZwIsOjU7NoBZy2jRsCSnmrxs9+frMvdg87o6VbTAy6W13M49wx5xj/GG1J4u2efOBpzfuvq5Eng4mMyGa6qwM2quqaW3vI69ZzuHkOuy2B3Dn4r2GHlHWM12xtvUT5yeAm2d688BSL1Zu92O/f6ARRKUaQFTreT2idEYQNTI6SnZtH++dOB9E+ZpBlFmfW1PtnOxNPSMfsHeZb8xilllmXaMyde8ak746MoOoi+pyQZRo/G80uf0CFo3wecbDXpYcHDlrKu6F7OCoP2Jq+8V9eSBqtSO/Nh1v4l61U/+CMdxVl/jerqbKNFGL811qDHXJuh5AlMNO/Z2inJcMYT/uDbv03zKGuyZlfnZcJYkTe/T8Ez3N1kX+wIIDtxuzmHWJGu//9GlLQ53OWYv+o54nEpyScNTomGj4axUoRgYZHuqhv6ubpqYOMmoa8S2swCm1hFdiilkWUcqsU9X8J66JGXHdLIga4ekoHUuiYGWs+PE+o2RVcj/LU7tYlNbBotReVqSqWZmmYlWaGod0FWsyVazLUrIhW8lzOUqez5Xzam4Xr+f38HbRAO+VDPFh6TBbSuVsK5Ozs1yBY7kS5wo1uys17K3UcqBylMNVYxyu1nO4Fg4KH6gTywaxrNezt3bU0BNqm8j7QbmGTWVaXi9R82qRiufzh1mTN8i6/CHWFwwbJiuXgNQaUQ6H7CFWZg6yIqOfZWm9hiF5yzMGWZY+yOK0QZ5JHmBBYj9z43qZHduNvbCt8MyYLqZHdfCk8OORHfwzopWHQ5r4v6AGfu9fz298a/mVTy1TT9Zxr0cdP3Gr4QfSG/MOVfHNfWVM2d+I9b5Kpjil8N1tofzdyZeNh/w4cMSLkOMeJHv7knnmNNnFqRQ0VFDe00PDkJqeEVCrQVxW8R9xrfVKQ6+o1mHtOIh6P5bvzPfCevoJLGZ4YWHnjTQ0z3LOMX6ybC9LNx/l2MkQYqKSSEsuIC+/lrK6Nmrb2hjobKJ7YJDYwiY27I/jvmVHuXH6biyeOIDlDFdumHOSG2d6c5NY/8UKD1bujsEnoYCComLqKopob66nb0COZliHXiHKphEVToIqosbpRC3Uiv9KdU+SNFRUJdXJsTFGRzVoRuUoxdZ2sS28fIi1B7N5YIkXX3vyEDdIc1XZ+yKT3nRn68mP5h/l3xuP8fxeb5wDAvAN3UdsdDDZicnU5BbTVl1La1cHhT2DuGaKersllO8schL7HsRypgTmfLCyd+NW2+NMWxLAiu1huAT5EBsVQ35KKlUlebQ2V9HT22EAUSq1KP+oBIc0jOguBqLcLwlEScMXz5cZRH11Nc3WOfNTz0g758tu8JhllllXT5++d80g6pJsBlEX9Gx/rExtv6Ad9SeNh70smYx5ATs46nuvPojS7zAdb2IW5T1lDPWlaOl2/S2fF7Rc7tv9rgcQJWmNo36hyXJM0OJ7Xnavsash87PjKugh+11TTZ3oqTNd3jFmMesyZApCSf44iJLgkzQXj2Sph5TUV2pUr0OrU6JSDiMf7mewp4v29jaKmxuJrqzALaeYbYmFvBhdyKJTJTwVUcb06CbmJQwxL07B/DgtT8dreObMEIuT+lia0mfoRbQifcjw1rlV6SM4ZMhZkylnXdYIG3IUPJ8zYoBQkl/MG+DlggHeKBzi7eJhNpXI+aBYzuaSYbaVjrCjXIlThRqXcjV7yjXsq9Cyr1LH/qpR9lWPsrt2lF0SfKrRsrNazbZKFR+Wq9hUpuKdUhWvFSt4qXCEjXlyNuQNs1ZYgk/jEEox3itKlGdV5rChzMvT+1ma3m3wktQenk3t5ZnkHhac7WFuYg9zErqZHd+FfXwPtrHjEOqJyHb+HdnKP0+18PewJv4a0sCfg+v4g389v/Wp41feHwdRtQYQ9a2Dldyxr5xJe2ux2l3GlJ3JfHd7GP/Y5c/LRwM45u5H5EkfcoICKEiJoaAim9KWGqr7+2ke1tI3AhqVuJBacR110sTzIxMCUVZzjvHTT4CoRNKS88nPr6Witp36tg6GetvpHRohtbqXd7xz+NNGX26bfRCrGYexsfPkxnn+WIuYU6Yf5ydLTjB/azhHIzLILiimpqyIpjqpV1Q/6iFRLoWogxq9KJ+EnsbQojGAKKn+SYhFqqU6sSK9NU8CUdoxJQqRXq8cxSurQ8SO50fzjnHT9CNMsvdANssPma03N9q68fNnj2H3ujuvH/RnX2AwgafcSIiPJD8lm4aCSjrqG2nr7aaod4hjmQ3M2BzEt5/dxZSZR7Cc6SPOhy+W9m7cYieBKD9Wbg9hV7A3MZHR5Es9oj4DRElvmzSAKPPQPIOMP0FmXSFNs3VeaOoZOc3WydaYxSyzzLqGZer+NSZ9dWQGURfV5YKo8X1Np32WHRz1A4aDXoZW79T/1lTMC9nBWf/GlwCimkzHm4Ad9foVO/Rf+ouyVjsy02T5Jmy9mzHUJel6AVGSxHesNVmWCVkfawxzTcr87LgKmmrn4nX+SRbbev4wy+kGYxazLkPnA6hz/iSIOgehJCTwXxAlvalMrZGGHg2jGuxF3tdBW08LRaIRHltWhHdmHrsSC3ktppglYQXMO1XJgvh25sX3MDthmFmJw8xJ7mN+ai+LUgZYljzCilQFK7OGDYDHIUvO6qwh1orP67OH2ZAzxHPZQ+PLfAXPFSh5sUjFK0VK3ihS8HaRnHeFPywZYUuZkh1lCnZKQKpchbNkCUxVaHCqVLO9Ss024ferVLxTKfaV5oIqHeHVkmFeKZbzYuEwL+SLY0o9oQwQSpofSjhPxdpcpWGS8tXZoqwZwyxPE04fZEVWN0uFl2T2sCith2dSe1iY3MO8s13MMVh87zN92MZ381RMB/+JbONfp1t4VPgfp1r5W0Qzfw1r5A/+dR+BqAe8aviFRy0/dqvlu0druPNgJbfvkyYpr8LSpZgpO5P47o4w/rk7kDeOh+DpHcyZAH+KIwIoy06ivL6Mmq5mGuXDdCh1DCvFtZR6RKm1jKmV6EflEwRRx/np0v0s+fAIx8QxYqIlEJVHQUENVXVtNLZ10N/XSffQCPktCvbH1TP9wyi+teAIFk8dwsrOi0mz/ZFN98FmpiffWejGY6/6stUzgaTsAipLCqirLKWrowvVgIqxEQlECY+N1zcJRGn0WnRSnRR1UfKoBKKkN/9ppbmu1ChEzpJuJbtPV/Loi8Hc8eQBJklvuZvtZQA9sukefM3Wld8uP87S973ZcjwY1+AQwqP8SUlOoTSrjNayFnpbuukaGKK0bwQ3CUR9GMh3nj7AlBlu4pwEGKCWxSwJRB1l6lJvVm4PZHewJzGRUeND88wgakIy/gSZdYU01da56PxnpHCCMdkss8y6xmXi/jWDqEuxGURd0NK+Do76OlNpF/L63frJhgNfotY46t82Fe9Cfs6F264miJJez2861kStdzWG+tIlzlux6TJOwJcJhq4rEOWof8lkWSboF5z01yxvMD87vmBNtXf5vamTLHxNd5W7HmQKQkn+OIiS8NM4gjICKOGPekWNqlHr1IwO9zPW34Gir4XW1koKynNJys4hNLWQA/HFvB2ez9qQPJaeKmFRVB0L4juYndzDrPQu5mR0MT+1n6fPjrAoScmyzCGWZw4bvEKCUsIO2dIwODmrJWeNsLpAx9qCUdYXanm+UMPGAhUvF4zwepGct0sUbCpVjAOp0hG2ivWtZePeIvx+uUivUPBOxQivVSl4uXKEF8vlvFAm5/nSYV4oEcuiETYUSABqiLV5cgN8Gvf4m/JWZytZlalgRbooZ6p8fE6o9HYWpXcId/JsahdPCy9I7mTu2U5mJbZjn9BugFAzYjs/glD/jGjiH+FN/F34L2EN/F9IPb/3a+B3vnX86mQdD3jW8fMTtfzoeA13Ha3mGwcq+Nq+Umx2l2Ozq4gbHZP57o4I/rE7hNfcwjnpG8bZkEBKIwOoLkinprWOxr4u2lUq+tRjKA0QSlxitYYx9Qh63dCEQdTPlh0wgKgjJ4OIjkogPTmXwoJqautaaTGAqC46B+RU9Orwy+9hyYEUfrjYFcsn9hnmm7K0D0A23R9rO19unevGQ2vceGFfOKdEnKKiIipKiuhsaUfZp0A3LOqZSnpz3vhsZR8HUYbaKPWE0ogUtaiLmvGp9OV6SG8Y5C2PPH6z3Icb/30QSzs3LOZ4I5t9EtkMV75lf5h/rHVn405/9nqG4BUawqmYU2Sk5lCV10BXTQ+DnUP0yZWU9ys5kdGI3QcB3LXwCFOme2IxPQjZLH9hN26yP8rUZZ6s2u7P7mCPCYIoHdl1vWzyyDaDKLOumB6wdV5u4vnIVFunfxuzmGWWWde4TN3DxqSvjswg6qL6PCBKNMafM5V2QYt9DAe+RIlyNpiMdwFL+11lEPWh6VgT8ypn/Z+Nob50Xda1/ZhXOel/Zww1YV1PIOrFnfqbxHEVJsszETvrnzKGuuZkfnZ8wZpm6xJo4iQ3G5PN+hwyBaEkfxxEnds2JtY/DqLGYZQWrZRveBj6e9AOdNDXUU9TbRmVRaXk5FRw6mwZxyLy2BqYzhuBmWwMLcIhspJnEmqZm1zL7LQG5qS2MS+5n2dS5CzNGGJpupxlGcKZCmEVy7PULM+WrGF5jpZV+XochFcXjLI2X8f6PDXP5SnYWDDCK8UKXitR8FbxCO8KbxKfz/kdsf2NkhGRLueVUjkvVCh4rnKE9eVy1pUOs15sWy/SN4j91hcOs06CUSLuuV5Q53pCOWQpDUMIDb2hUkdYnCS9Fa+ZhWdbeSapU7iLp5O7WCCWcxO7mJ3QiX18BzNjupke3cUT0tvyTrXwz/Bm/h7axF+DG/lTQD1/8KvlD771/Na7joe8arn/RC33uNfyQ9cavn24mtv2l3PznlIm7RLeXcQNzul8e2c0f9kdwUb3aE4ERJF4KoLS+HBqS7JpbG+gbbCHHrWaIe0YWonZSNaKa6iVekQNTxBEuX0Eog5/DEQVF1RTX9diGJY5PNRHz6CcZrmexHpxnn0LeXDdSW6YfgDLmZ5YzQpBNjNYLIOZPMuDHy06wjNb/PGKziAzt5CSomJam9qQ98jRDGrQKbWMSrAFHRq9ehxEGcCUNEeZqH3ShOZq8VkzDmP6dRBR2MEKlyTumX+SSf8+jmyWJ7K5Pshme2A94zA/mn8Qu40n2LQ7gGM+gfiGBhAVF0tWRhE1hW30Ngwh71UyoNRQNaTBM7OJWR8E8t35rtzwlA+W08V3sPcX8Y5z46wjTFvmycod/uwJ9iDWDKIuScafILOugKbaOlef/4wU204bk80yy6zrQOffw5KNSV8dmUHURfV5QJT4V7+FqbQL2cFRHze+76XJVKwLW18r7Xc1QdRqR32C6VgTsf6yr+EXoTX7uFmcO7Xpsl7cYt+3jaEmrOsJREkS39HTZHkmYPFdtxvDXHMyPzu+QD04c/fDpk6w+Ef2emMWsz6HzkGm8/1JECWWEniSINTYx0GUaGCLdAOIUmvRK1WolAr6hwbp7OqlvamH+spOcrMbiU0owzcim8NB6TgHZfN2cC7rwrJZGpnF0/F5PHO2ksUpbSxP6WNVsnDKoLD0NjrprXQqVmZqWJGtY0XOGMtz9awUy1Vi6ZA/xup8HWvyNMJK1hUoea5IyfMlCl4slqDUCK8WjfBaoXCRQqwreFl83lgk9XqSs750hHVlCtaK5ZpiOWtF2joJQonl2sJh1uYL58oN80FJb8hzyJLmhZILj4z3hkobMsCopcmDPJvYxeKkXpYk97NUlH+JKP+ipCGeThxkfsIAc+P7mR03hH3MADOjennydDf/juji0bAOHglu4+GAFv7s18gfvOv5jVct0zxq+KV7DT9xq+a7R6u442Alt+4t44bdxVjvKsZmdxFTXLK4Y+cZfusSjcPxBHF+E4mLTaQ0I4mGinxa2+roGuiiX6VAoRXXTJrlW/KoNLeSuI5jiomBqNnuBhC1ePNRDnkHEhUdT3pKDiUFVTTXN9Pd0YpyZIDB4WG6FKMUdGrZE1vNv94K4euzDmMp4lnPChXxwkSscKxsvbhz3iH+84YXLv5niEvNpaCglIYGadLzQVT9SjQjanRajahj2k+AKKk2SpN063WirkoTRQlLtbZVPsax+EoRM5w7Z4rv8IQPsjm+whLoceNm+4M8uOQIS97ywvFQAJ5+/gSG+RB7JkHU0RLqSjvoax5BMahmSKOjRpyTk1nNzHk/kO/Nd+eGJ/3GQZTUI8oAog7zwDIvVm0PZG+g1yWAKPPQPEnGnyCzPqekZ6GpZ6T07DRmMcsss64DmbqPjUlfHZlB1EX1+UDU5QCiS39er3LUP2oqzoWtXyPte1VBlNPl95BZ5aRfYQxzzUicu/2myjohO+ov+f+8ut5AlLjeS0yWZwIW5zbKGOaak/nZ8QVK+n91zz+50v/7a0w263PKFISS/EkQJc0QpRXr2nEYZYBQ40BAKxq8mjGpzwqGoVHNaigfGqWsb5TqDuE6BaXFneTnNJB0toTwU1n4hGaxPyCND/wSeCUgmudC43guMoMX4svZmNDICzEtPB/XxvPxnTyX2MOGlAHWpclZm6FkXbaWNdk6VmXpcMgZZU3eqAFEOeSrWZWvwqFAxeoi4RIVa4sUBm8oVPB8gZIXhDcWKsW62CYsTTy+XqSvk/KJPGvFZwk8rZMmJDeur8kdYnXOIA7ZkodYlSm9JU+aUH3IMEn5irRBlguvFOVzkN70l6pmRbKSpWeVLEoYYWH0IHNO9WMX1svMkG5miuV0sXwiqJN/BXTwqPA/hB8x+mH/Dn53so5fedYw1b2Gn7tV80PXKr59uILbD5Rz455SbFyKsHAuxGp3ETa7crl1ZzK/3BnPgsOJOAakE3Emm4LCQpqqSuhsrqK3r41h5TBqrXYcQkkXS1wr6S2IOr16AiDqJNazT3DPORDlE0BUjASisiktrKS1vpn+jlZU8n6Ghwfolauo6tXgl9XCYpc4frDwGJaPH8NqZhCWdqHCIchmeHLrrEP8aYMrrx2KIDA2k6z8Cqpq2+hp7WOkW45ySIlGo0Y39l8QNaqX8KcRtBg8/l3UwmWdI7zvncG0FR5M+Y8nVjNCkc0NRDbLW9iVO+cf4W/r3Hl+ix8HjgfiF+hL6ClvzqScobCgjMaqLgbaFSiH1QzrdNQO6/DObGbee4H8YP4JbnjKdxxESXNdzXFlyqzD3L/sJA7bgtkX4ENsZLR5jqhLkPEnyKzPKfFMbD7/GSn1IjYmm2WWWdeJPnUfCxuTvjoyg6iL6vOCKNGgLjeVfiGv3MUPjLtPSGucLx2ISG9/k/a9WiDqciZT/7iXb9N/zxjqmtFqR/1cU2WdiB2c9B3GMBPW9QaiVm3lbpPlmYDFd20zhrnmZH52fEGS5rcwdXKl+TCMWcz6nDIFoSR/CkTpJRClESliKaWLP52wZkyPdnSMftHuLVXriepU4lEzwImKQYJLhojJ7yEtt4nCwgZys8tITMghKiob/5A0XP1i2OUTxjbfED70j+b9oFTeCc7lzeBi3ggp4fXwCl6LquXVuCZeSuxgY3IvG9MGeCF9mNWZKtZka1ibq2VNvhaHfA0rC1QsLxQuUrGiWM2yIrXhs0OBmnUifb3whgItG/LEUnhdrprn8tU8n6/iuTwl6/NGDBOTr88fEZYb1iUQ5ZDdz8qsPlYJr8zsZUVG37jTpbf8DYr1ARzSFaxPgVWJOhZFyZkd3MsTXq3842gtf95Xzm93lfBr50J+7VLAg065PLAzl/sdc5nqUshDUvqRGv5wvIE/ubfwW88aHvKo4X63Ku5xreQHRyu581AFt+4rY9LuYiydCpE5FmC5R6zvLmDy9lS+vyWe/+xJ5G3vDHzi8kkpqqKhqpTexlIGeptRKAfRSq/LM9AncUnFQnp5nkb8jelHLg1EeQcQGRNHRmo25YUVtNU3MdTeinq4F8VwHwPyYZoHVcRX9vKaRzb3rfDA+l+HsZkehJVtMLLpfsiedOcGu0M8sOIQy7f6cjw0mdS8Koor2+ho6mW4cwjFoAK1Wi3qlzQ/lFiKgo9jKAm2jNdR6YOofgyJ75Re38e6/VF8b/Y+ZI95Yj0rFsu5IchsvbC0O8bdi9x46hVf3nQJ5phXMEFhvpyO8SElK5Gysgpa63sY6laiVGgYHh2lTq7DJ6OJBZsC+eF8N258SpyL6aL8s0X55x5j8uwjPLDUG4etoez3DyD2dIwZRF2CjD9BZn0Oiefhy+c/HyVL8yoas5hlllnXiUzdy8akr47MIOqi+rwgao2Tfp2p9AvZwVG/xbj7hGQqxsVs3PWqgShxHlaYjjMBO+pbjWGuKa3arv+ZyfJO0BsuEThebyBKkqgnIybLNAGv2cG3jWGuKZmfHV+QxIlMOP/ETrV1LjImm3UFZApCST4HoaR5oRANaIMNvaJ042niTwJR6jE9KtEYLlXp8Wsd5oPselZGFbM8ooRXTpXjGFGEd1w+CZklpGYVcTYpm4SEHGIiMwkPicfXN5zjJ4PY7xGMs1sE29xj+eBkMu95p/KuXwZvB+fxpoj1elQVr8bX82piM68ktbE+fZgNWSNsyFWyPl/NWqlHlBFELRNeWqxmcZGGpYVasU2LQ4GWtXk61uUL52pZLywtX8jXsFHs+0KeiufzlDyXq2BDvlJ4ROSXQJQ0UXo/KzN7WJnRw4qMbuFelqdL6/0GCGWAUsnDLItUMz+on/+4NfLnXSXc/34GP3wlgTvXn+J2hxBuWREk7M8NK3yZvMxbLP25dW0o33wphu+/k8JPt+Zyr1MRD7lVMc29mvuOV/HTY5V870gF3zxYwS17pbmhirBwKkAmbLmnBIvdRVhtS+OO9+L404541rmmcOh0LlF5VdRUljLQWMpQTxNKRQ9a9QhoxLUTl3RUDwpxRdUGEHV+jyhPrKe7mwRRSzYf5YC3P5ExMWSkZlJRWEFHfTODHa2MKvrQqQYZUQ7To9CQ1zYirn8Ff3o+gCn/OcIU22BsZgRh8aSPAURNnnmInz67n9lvu7PH9wyJWVXklLbS2tDNUOcAIwNyNCoV2jEJRGkMIGq85knwSYIwUn3Uo9FBj3KM2NJ2ntkezNenix/gf3thM+8MlnPCkInvYW13lJ8vc2Pu2/58uD8UD98QQk/5Ep3gT1Z+CtXVVQYAJu9TolaqkY/qqJNr8cloZv67AfzAAKKkOaKCkM32/S+IWuaLw9YI9vsFEXcRECWBXDOI+q+MP0FmXaakN8ZKb4791DPSzsXLmMUss8y6jnT+vSzZmPTVkRlEXVSfF0RJMpV+ITs46Sfc9pLmKjIV4yLONe5+1UCU+E7bTce5uEUZw41hrjmtdtT3mSrzRLzKSW9rDDMhXZcgylFfaLJME/KlD/+8GjI/O74ATbN1sjV1YqfZOi80ZjHrCui/zVUJOGkNlobgjYpGs9T/Seo1o9cpjSBKghhiq0YuVkfQib9usbVcrSe4YYB30xqxC6/kQe8SHvQr5p9B2SwMPsPG8AQ+jMvkUFIeQel5xOUUk5JewNnYJBKCo4gJOE2Ebzi+bgEcOxbI7pOxOHtGs8U9ivdPxLLpZBLvBmTxbkgBb4cW82Z4KW+fqeeds828k9zO66ndvJzRx/NZQ6zJld6op2JlsZoVBXqWF3Ke9awoHDX0knIoVI3DqVwda3Ol3lVq42Tk0lxQclaJeKuypCF5Azhk9rI8tYelyd0sS+1nVab0Nj8Fy9NGWHx2gPmR/Tzh0c1vdhbz/Zfi+MaaMG5ZEcjkRd5YzndHNvc4snluYimtC88R6/PE8mkvLJf4MXl1KLc8F8ntL8byo61F/GxXJfccquPHro3cdaye2w5UMHl3IdYu47bYU4hsVx42znnc5JjLzR+k8s03ovnT9ljeCMwhKKuGvIom2pvb0HS2QVcjKLrRiys6Iv4rQSipN9vYqJaxMS2tQ2NGEBXDdxa4Yz3DzfCmOwlCSbaZ5cnPlx9kyZYjHPT15XRsFKkp6ZQUlNNa30pfRyeK4S6Uyj5GFP30KZRUdKvwSG7A/sNwvjVrPzc8dQiL6X5Y2Qdibe/NpJnHuHPuIf72kg9vuqUSlFxDekkL5bVttLd1oRoYAJUoqU6DTlTP8R5cEibViDqqQj+mNqwrxfeo6NSxL6yWf7wYwS22rsjs3LFcEIrN7ChkM09w45y9/HbtAdZtPsGhwz6E+voRHeFP3Jkw8orzaaxvZ6BNgbZfnA+VDilyg3qMk9lt2L0byF3zj3PTE97YPBFogHOy2UeYPOcQ963wwmF7CEf8/EiIjCEvZQIgqraP906cB6Jm+xpBlPuEQNTIiLj/dNIcXxI4/qTMIOqroakzXd4x9Yx8yH7XVGMWs8wy6zqSqfvZmPTV0ecCUYf0V92myjERX2cgSrJx14tK5J19/r4X8ypH/Udtu6s2NM9RH2g6zoS8yRjmmpODkz7ORHknZkf9Jc2/fJ2CqMu/7o76ucYw15TMz44vQNPsnNM/dWJtnTONyWZdIUnN1fEm6zkQJTXypQmiPw6ipHf+S+O5xhgT66NaucijRDTZaRG75Qzr2JvbxtLQch7xLud+zxqmBTTwt5BKZgZmsSgohVVhGbwVk8XBpBx8M4qIkXpHJWeREp9CavRZEk7FcyowkgC/U3gGRnPc7zQHvE+x2+sUO09GsdUnjg/9EnnfN4lN/sm8HZHN26cKeCu6jDfia3ntbDMvpnWyPquf1XnDOBQoWJ6vZVm+TniUJQVjwqOG9WVi+8o8JavyFaw2wCeNsJrV2SrjZOTD43NAGXo79bNKxFyZ0c3SlA6WpPQYJitfJ/I7ZKhZEN3Df/xq+eP+In72ZgbfXBfJ5Gd9sV5wEuuFJ7FYIL21bRw+Wcz3QCZ9PueFXsieOYlskQ+Wy/yxWhGIzapgbn85kTvfyeA72wq4a085dx6oNLwt7yapR9TuYmykXlF7irHYVYiNYx5TtmVz43up3P5mLA9+EMkq9yQOJxaTXNxAc1MHys4ORjsbQN4prqEaOToDjFJLw8XOB1EfRJkEUdazx0HU0o+BqJSUdIoKymk2gii5vAOVqg+lepAhtYq6AR1BuZ0s253ITxa5cfPMI1jM8MbK3h9rCW7NOMY37A/wu7Un2LAvDvfoIs7k1VNS2URrUysjvT0wMiyKrEInqqZGVNTxUYXSf8d76ElzlcnHILtewTvHc/nVch+mPCX+kWfnhuX8kI9A1G0LDvDwxiO8tNOLY65+hEtD6aKCOJsSSUFJIU0NHQy2K9GJMuvV/wVRXh+BKFduekKU+RMg6qABRK3eHsJRPz/iL6FH1HvmHlHmh+Tn0AMLDtw+zdZF/qlnpJ3LUWMWs8wy6zqTifvZDKL+V/2lgyh9vqk8F/RO/W+Nu19QDo760yb3v4BXvsuNxt2vXo+oz9EzRuw73RjmmtPn6eklzuFWY5gJ6boEUc76vSbLNBE76p8zhrmmZH52XGE9YO8y39RJnWrnZG/MYtYV0meBqE/0iBqVhuaND8mTQJRepxD7aA29asoUo0S1y3kpuo7HXEv47bEqfunWwjS/bv4c3MYjARX8yz+PJ4LyeDo8m5djMtieVIB3dinxuSVk5hSSl5lDVmo6qYkpJMYmEhsVw+lTpwkKPYVXYBjH/UI55BvGXt9wXHzCcPSO4D2f07zvH8P7QWfZFJ7F29ElvHamjo2pbWzI7GVNzgDL8+QszVOwJE/FonwNz+brWJSnZWmummW5ClbkynHIVuKQJQEohQEwrcwYNsz7tDxN7G/0sowelmZ0sDilnSWpvSLfCKszNDwTM8Q/3Wr45ZZk7twQwZSnA7Ga7WXojSOb44XFAh9hX8PScqEfVs/6Y7nIV1isLxbrwhZLhMVSttgPmUiToJTV8lCmrIvillfPcvuH2XzdqZjb9pRx894ypuwpwWZXMRYuJVjuKsF6Zx42H2Yy6d00vvZ2Ene/GcF/nCN5MziT8OwqquvaGWzrQNPeiH64E92YgkEJiIgrqJGAxdhEQdSJT4KomGhSUjIoKqykqaGdns4uA4jSaPrQaIcY0ahok4+RUDnCG14l/O65YG63O4bF9BNY2nljbecljnGMm2fu594lh1nwQRC7AjI5lV5FQWkNTfX1DHe1iTL3gULJqEbUOJ2ohoYKK/UCkmCUNGE+9Gr1RBX2sGRrHD+cfRirxw8gs3fDan4gk+xPYW3rzvefPcz0tz1494A/7l4BhAcHkBAXSnpWPMUVJbQ2dTHcqWJ0cBS9elTU+/N7RH02iDrXIyr+tHmy8kuR8SfIrMvQNFunrSafkTMd7zFmMcsss64zmbqnjUlfHZlB1EV1hUDUGlN5LuRVTnpX4+4XlKl9L2bjrgZdRRAlNx1nAt6hv2Z7Hjs46Z83WeaJ2FHvYQwzIV2nPaLeNFmmCXjVzksDdVdL5mfHFdZUW+eC80/oVDvns8Zks66gJgSipN5Q0tvKpFfna0VjXacUuXX0ibSUXhVHy7pYGFDNHw6U89ChWu472sY0r15+69fN7/3q+WNgBX8Jq+Sx8ELmRKTzXHweezJLOVVcRVZ5BUXFxRTn51GYm0t+dhZ5qWfJSk4gOSGO2JgoIiJPExhxCu/QCDxDwnEPDmOvjz+7fQNw8QtjZ0A0m0OTeTcqn9cTqngxqZkNqe2szOpheXY/S3OGWJSr4JlctbCGRTkqluTIWZY9zMpMOasyJAB1DkKNvw3PAKBS+1meOsCStG4WpbezOL2LZWL7kuQh5p7u5R+uNfz83RS+tiIAy3keyOZ4I7P3Qjb7JFZPBzBpcQjWi4KxXBSE1ZIQbJaHYrE0EKtlwVgvF59XhGK9MgwrsbQQ22QiTbYkANmiACxEXpv10dz4ehK3bs7hVqdibtpVwhRhK+ciZI5i6VKK1fZ8LN7NwPrtdG55N52vvxLB1HcDWeh2hqOJpeRXtNHR3MlIWxPawQ7UumEGx5QoxLXVGS6+NLzr4iDKas44iJKG5h3y8TPMEZWSkklhYTWNDZ10dfUwJG9Ho+1DNzqEWqukVzVGXusoe2PaeerdBL5j74rlU8ewnHkCK1tPLGccZ9L0A3xv3n7+9ZIH77qeIeBsJVlFFdTXVjDY3oR+oAfkCvRKvah749VUFH28Poo/hVivG9TjGtfAoy8EctsT+7F68gjW4npYz/Nl0oxgbrJ1475lR3l2iw873UPw8g8gPNSfxMQI8gpSKa+poKNNelOfqPHiPEjzaKnFXdGgHuVkduslgKiJTFauI7uu1wyihIw/QWZdoh6avvcu8YwcPf8ZKbzHmMUss8y6DmXinjaDqP9Vf8kgSpKpPBeywwTeqrZ+m/57pva9sPXxxt0NuhogauVhbjQdY2KW3r5mDHXNSZyHJabKPBGLa/yJa3ExXY8gStSvpSbLNAE7OOuPG8NcUzI/O66gptq7LDV1Qh+02/UfYxazrqAmAqLGDG8ok4ZxiYavEUQZhuWJNntws5w3k+v5z8kqfnuoml8fruPBI8085N7BQ16d/Mqnhd8FN/B/p5t4+FQF/w7LZmlMPlvTSwkuriKjspLi8lLKS4uoKC+hsqKE6uI8yotyKMrLIjc7g/T0VBKTk4hNTCTqTCKn4uIJDA/CNyQQj8AgjvqHsCcwku2hZ9l0OpfXYsp4Ma6adaktOGS0syKjhyVZQzyTreDpbJVhuShrWGyT3ng3ZBiGZxiKZ4RQ4yBqvFfUstQBFqdKIKqLZZkDLE0dwj6ikz8fLOXuN89w87IgLGZ7IrP3xGJBABYLA7B+NoTJyyKYsuIU1svCsVgaiuWKcKxXnUK2QqyvChMWn1efwmbNaYOldSvJDhFYLAvFYoXII6W9GM+Ut9O4aWseNzgWMcmpCEvHAmQ7irB2KsNqi1h/KwOrtzK56b0cbng5iu+84stf9kbxQXg+Z/KaqK3roK+lGWVfG0r1AIO6EZQGkCN0MRBl918Qdc+KA0YQ5U9kdCypydkUFNZS39hNR3cfAyOdqLR9op4MotXJGVbrqOmDgJxhlu3K4qfz3Jj01CEspx81wCjJNjOO8g27/fze4Rgv7InCI66C1EJRB2pK6G+rZ6yvC4blMKIfn6ZM6ggleUwaoDdGr9iW2ajm3ZPFTFvqzQ2PH2GS7QkmL/Q0lHnSkye5w+4of1p9lPXO/uzzDsE72J+wiACSkmMoKs2luqGGns5BlL2j6MWh0Ix9DES1YP9u0BcAorLNIMqsy9JUO2cXU8/I+2Y4ft+YxSyzzLoOZeq+NiZ9dWQGURfVlwWiJBt3/UyJRv5aU/tdyGKfJ427G3Q1QNTaLfpvmI4xQW/ldmOoa04OTnp7k2WeiB31WcYwE9L1CKLW7NTPMlmmidnfGOaakvnZcQU1zdalwsQJjTImm3WFNREQJdrQhoatAUTp1GKpFtv1VGj0HK7o55mwcv54vIwHj1bxm2PV/Ma1jl+5NzLNs5UHfdv5XVALfw1v4pHwSp4IL2RFTDHbU0oJyisjo7SM0rJSqivLqKuroqGxjqbGBtHgrqO2rpaq6mpKysrJLyomK7+QjLx80rNzSU1JIPFMNFGREQSGhuERHMHBkFh2hKew6VQOr58u4OXEap5PrmdNShvL0vp4NkPO0xlKns6S80zmMM9mDrA8Y9AIoQY/8jiEMjp1kCUpfSwxDNOTMz+2l4ePV/L9N+KZJA2nkyDUHD8sFwRj8WwwlktCsVl+ikmrIrEWtlh5CpkEoFZHYrkuGtm6SGRrTxuWFuujsFwfjbWwzYYYJj0Xa7ClSLdYLfZZK/I8H4vVq2ex2ZTJ5K352OwsxEpYtr0Q650lWG3ON4KobG54rwDrV+K59aUA7tkWzlqvdPyTasgvb6Otvonh7hbkil761UMopWGW0pUX13yiPaLuWbGfpZuPcFh6a150HCnJOeQX1lHT1ENrzyADin5UmkHGdAOMagdRqlW0D0FCpYbX3Ev4zXJPbrE7gNX0g1jMOI6l7UlsbD24ZeYhfrnoEEu2hXHgVDEJuUWUVxXT3VKLrqcDBoeRJoLSi8ooVVG0otxjYwYe1SK2B+f1sMQljbsX+DD5SQ8mzzrJpPluWNod5oYnjnH33EM8udGVt/f7c8Q/CO8wf8KiQ0lJS6KsvJSGlkb6e0fQDOjRj0jxPw6iWrHf9EWAKHOPKONPkFmXoPtm7viJieej9DbZHcYsZpll1nUqU/e2MemrIzOIuqiuFIhycNSnm8p3IZ8Pjc6XSC81td+F/O67TDLubtDVAFGrnPTfNR1jYp49GytjqGtOq535p6kyT8iO+hJjmAnpegRRq5z1M0yWaULWRxjDXFMyPzuukKbZOq81dTLFP7IfMWYx6wpLaq6ON1kvBqKEReN/bFSkjakZ1o+RIx9jS34Xj3oV8rNDhfz0aCn3Hy/lQfdyHvCs5j7vZh7w7+B3/i38xbeGf/uVsjCkmBejStmXWEx4eiHZ+YVUl5fSVFdDc0szrR0dtPf00SHc3t1DS0cnDS1tVNc3UV5TR2lVDaWV1VSWFVFckE1WWhKJCXGcjo3DLyqRo5EpOJ9OZ3NEFu/GFfP6mSo2JjaxOrmbJalDPJOuYGGmBKSGhPtZmn5uLqh+41LyoKEn1DKRX/LylCGWnh1mQXQfj3nV8ostadywMhDZ7BPC3tgsOsWkZVHIFgUhWx6GxarTWK6RgJPYtk74uRgsNsZj+VICspfikb0YN+6Nwi/EYSFs+UI8VhsTsHoxQeSNNewj2xAtlsJiP4u30rD+IIdJ24uYtLMYix0FWG4vwPrDHKzfzsDmrWwmv5OH1WuJ3PBqOHe+G4z9vnj2R5SQmNtIXVUdve2N9A920KPoRSGuoWHIpfTmuTHdxXtEzXX/BIiKioojOTmXvMI6qpp6ae4dZlCpRKmWM6YdRK8eQKsaoW9kjNyWUZzC63n8lUC+teAwk2YcwGK6q4jtg7W9L1NmHuP78/Yx8y1fNvtmEZGeR35ZIS0NVag6W6FvkDG5jjGlKK5URXXSUNFRw+TlVb1a9kbV8Y/XIrljth+TbP2xmuWNxewjWNju5VZxrAeXHGbJ257sPOrPiaAA/E4HciohiszsPKqrGmgRxxgeUKMbEgGlic8+AlHSHFHtVxhEmeeIOifjT5BZl6Cpds6HPv18dFH+er7jHcYsZpll1nWq8+9tycakr47MIOqiulIgao2TfpWpfBf2hRvipve5sI27fqSrAaJW7ND/xHSMi1uUT24Mc01KmlTeVLknYvHd6oxhJqTrcmiei/5xk2WagMX3vaShi1dL5mfHFZL4B3Xj+Sdyqp1LsDHZrC9AUnN1vMn6SRD18bfm6cYMI6HE9jHD5NYSpOofGyV5YJTXMtr51dFcvr43jzuOFnO3WwE/8SjgR17l3O3bzC/8e/itTwd/da9mxvF8Vp/M5f2wItxj8ok9k01+Zg4NZeV0NLfQ3tVNW08/PYNyeodGGJCP0Dc0RFdfv0jrorW9lZa2cTc3N1Mv9ZgSjfOS/Fyys7JJTM8mNCkH9/gc9sdksyM6n/djS3k9vp4NZzsNQOnZNCVPZyjGQVTmAIvTelma2i0slil9RvcLDxo9wIokBYuihnjco477t6Rx+/pQLKS33c33RvZsKJOWxzFpVSyyFWHIVp/GYn00Fs+JzxJoeikei1cSsXwjCcs3k5G9cRbZm8Lis2SL18X2185i8arII/JZvHwG2esi/RWxlKCVBK9eEelvpmL9Xg422wqZvLMEi50FWGzLxWZzNlOk3lJvZmHzhvDrKdz4eiQ3verP3zZH8P7JLMJTqigrrqK9qZbu3hY6hzuR6+SGnm0IXxxEeWE11+1jICrAAKJSknPJLaqnsrmfxr4RBtU6RlQKRjXDoB0QoYcYVmmp6h3jRHIXi3bEcveS49xgJ4GoYyK2L9azg7CZ6c43ZuzibxuO8eKheLzi00ktyKGmqoyh1ma0PX3oBtVolXp0unGgMybq6oiornnNI7zplccvl/lyk20A1nZh46Bo1kGsZ+3mm7P28vCaY2zc6sOBEwGcDPMnMCaYmJRE8gqluag6ae/pYGRYy5g0LE8p/DEQ5Z3Twaz3gg0g6kYziLqiMv4EmTVBTbN3vu/856PB9s7vGbOYZZZZ17FM3d/GpK+OzCDqorpSIEqSqXwXsmiIjxl3/ZQcdurvN7XPhezgqA8y7v6RrgaIWuOsv890jAnYUd9qDHNNymG7/ucmyz0Bi+t70XnAPq7rEUR9nh5j4vumGcNcUzI/O66AptrtetHUibx/pssfjVnM+gJ0KSDKkFPkkdJ6RsdI6NbwfEo7v9ifw5Q9BdzgWso33fP59okc7vAo4ps+TfzYv5/f+HTzd9cGZh/I4/mjqezwy8U3Ipv46FSKUrJoKaukp72Dzt5+2voG6R8aZnBEzohKyYhyhGH5EEODfQwN9DDc181QXw8dPf20t3fR2tBIU3U1NeWVFBVXcDa3jKC0YjzOFrI7MpdtkcW8E1vLC4mdrEweYpERRC3MNIKo1B6WpHQLi2VyL4uTeoSlZb/RA6xIVLIwpJ8/uhRw54YwZAs9kC04idWSUCatiMZmZRyWq2KQrTuF5YYoLDfGYin1eHo5HtlrCcjeTPyv30lD9m46FpvSsdqUgc27mdi8k4H1W2lYvZmG5ZupIi0Ni7dTRH7h15OxELaSekS9l8OkLQVGEJWPbFs2kzZLc0NlMeXNbCxfzWDSG2nc8lYsNht9+M1bgbxyLAW/hDIK8itorq+io7uJ9sF2hjXD6LRKcXFVlwiiDnP05DiIknpESSCqokUCUQoRU5pXXM2YRg7aQcakIYAaNY3DeoLy+tlwMIWfO5zgplkHDPNEyez8sJwdgsVT7tz0uCO/WXGAFTvDOBZ5ljPZGZSVFtHXWI+yswt1vwq1cgytqHcSJlLrFPSOaEirHWDd/iTumnMcm6f8sbKLQDbTG+s5R7hpwX7umreXx19w522XAFxPBuIb7kdwQijxWWkUlTSIczJAR28nypHR8WF54pTozwdRm8wg6ouQ8SfIrAlqmp3ziU89I22d+385+92bjVnMMsus61ifur+FjUlfHZlB1EX1ZYIoycZdP6XVjvodpvJfyA479Y8bd/9IVwNErd6ln2o6xkSs7zKGuSa11ln/K9PlvrgdnPRtxjAT0vUIolY56h81WaYJWZ9vDHNNyfzs+Jz65Wz/SeIf2V2fOpG2zt7GLGZ9QTK2CYWkBu25maC1ohmuFQ1nqfEMY5ox0TgXKzqxFI1fzdgoLWoNgXVdPHuqkJ/uT+Dru9O442A+3zpaxHfcKvjeiSZ+5NHNz706mHaylt94F/OYewKrjgWz1esUAQFRJEWcIe9sHmXF9dQ39dLRNUJfv4KRkRE0Go2hoa3VaQ3rGo0atVqFSqlkRC6nv6+fvr4+ekSjvKOjnaaWFqrqGigqrySjoIik7FwC4nM4EJHB+2G5vBhVzaoznTyTPMiCDAXzs0eYlznI08niOyS28fSZFp5JbDX0jFp0todnEvpZlqwWyxEWRip53L2DH72RwqSlwcieDUC2OBiL5RFYro7CYnUksjURyJ4PR7bxNLJXopG9HovsrXhk755B9t5ZZB8Kb0lGtjVv3FsKsJC8WfiDfGTv5wpnG2zxQZZYZiLblD4Ort6RwFUGViLNZnMek7cViX3FPluysPowCet347B8SxzvjbNYvJGK5aviWBuiuPfVEFbuj+F4VDbZeYXUVZbR0tJER18vg4oBcX4HxcUdYnRUScvQKJ7Jbcx4P5bvLPDCZsYJLGy9sJx1EotZ4xN/37PiIEs3H+XIySCiouJJS8qhqKCahsY2Ort7UKhHhFWoR0X90esY1SpQKcS1kmvJbRzBKSibv77kyW0zdzBp5n6s5/ogs/fDYro7t9gf5Ufz9vLU6/58cDKJ0KwqcqtaaWxqY6S/m8GOZrSKYVEfRw21Uy1qacOQmmMJ9Twpvv+dzwRgOfMkMjtPbOZ6YT3LnSkzd/PzZ7fy9Htu7HT1x9PHl+DQQCLPxJKcl0tBTS0NHV3I5b0oFCp0alHHpfF+Wp04wihtqlE8Mpuw/VAamnf8okPzEiJjyEv5bBAlAV4DiKrt470T54MoXyOIcr8kEDU2Zphy/hMyg6j/PT1k7/ybTz0fhafa7XrNmMUss8y6zmXqHjcmfXVkBlEX1ZUEUQ6O+jOm8l7QO/XLjLt/Qg5O+hGT+S/g2f6fnmvpqvSIctL/1HSMi1uUT20Mc01KnIe/myr3RCy+W40xzIR0PYIoce3/Y7JME7C5R9T/qMQJe+v8E2jwbJcHjVnM+oJkbBMKSSBK+5ElEDXeoBUNW6lLlE6sa/WMiXX16BgNShUeZc3YB2by/V2x3L4rlTsO5nHn0WLucq/m+yda+Yl7D/eeaGeaZxW/8ing0RMxrDziw9YTQQT4hZEcFkvu2RyKi+qpa+qno0fBwJAStVqaEH30owa11Ng+Z6nxLaWrFEpDY1wulzM4NERPfx9tnR0iTiPl1dUUlpcRl16MZ2wejqcLeC26GoeEdhae7WVO6iBzM4aZldbHgrMdPJPYxsKEFhbEN7M4qYtnznTxdHw/y1O0PBuvYrp/L792KuMb0pxNT/uNg6hl0lxQp7BaF43l+igsnotE9rJIfzUW2ZvxyN5JRLbpLLL3hTcnY7EtFcsdGYaJxq12FmCzowibncLSpOPbJBdgvTUf6815YpmL1ZYcLD7MFPunI3svwwCmLN/PMswJZbM5V6TlIPsgHcv3zmD5dhSyN8Tx30hA9noKFi+JY66L5ScvBvKMcxgHQlNIycylrKSQ+voGWrp66B0aQKPpF5ddAlISiNJ9BKLuWnASmxkeWMz0wtLeCwt7j3EQtVwCUcc4LIGoyHEQVVxQRWNDK93dXSjVwyi1alE/pInQxZ/0dkWVHIV6jNp+HR6JlTz1XhDfmu3I5Jl7sZ7rPQ6iZnpy06zjfMt2N39Z78krRxLwTakktayFippG+rtaGWivY3Skn9FRLSpRJwdFlcxt6uO9k1n8fn0gt8w5icWME8hsT2Az3wub2R7cYr+PX6/cyYrtnuw+4Y+3ny/hEaHEJ50ls7CIEnEuGkW5FSMSiFIaQJReAlE6qf6P0mEEUTM3TwxEGXpEfW4QZe4RZdanNdXWxe/85+NUO+e22bP9r9kJU80yy6xL0/n3uGRj0ldHZhB1UV1JELXKSb/CVN4L+jPerGYy70Vs3PUTEvEPmcp7cU8cRK3drr/LdIyJeZEbU4yhrjmtdmSmqTJPxA5O+iJjmAnpegRRn+v8OOrjjGGuKZmfHZ9Dv5697WviH9RDnzqJts6uxixmfYEytgmFPhtEoRetfmlokXaMMbFUiY+1cg2HC5t4wieTO50SuHlXOrcdyucbR4u4062K77o1cbdbF79wa2OaexW/9irgseMxrDp0km3u/gT4BpMcHkXe2QxKS2ppaOmjq0/BoFyFVjt+7HM6f11qfI+KBr3UEJd6S6lUKuSKEfoHB+jo7hKxWqhuaCCntJGIjCoOJ1bw3pl61p5pZX5cO/aJXcxK7sc2qYd5Zzp45kw78+NbmBvbxMIEsR7bwYK4XpYmaXg6TsnfXOv5wRtJTFkRjGyBD7LFQVisjDBMSG69IRZrabJxaT6nN89i8XYylptSsfxA+MM0LLakYbU9g0mO2Ux2yeFGl2KDb9pVwi2SxfotLmLpXMLNTmLdsYgbnQuZ4piPzfYcLLdkYvFhBrIPxNLgLBE7S3wWfk/EfzcBy7ekHljCr0nzS4njvpSMbH0sP3zOl9lb/XHyTyAuKYP8vFwqqmupa++iY2CAEdUAeukNd4YeUf8FUd/5GIiysJPenDdRECVHpdMYQOU4iBLXUq0Qn6FNpSeyqJOl+87ysyWHuNFuH5azPJDN8hfx/Zhi78bXnnThviVHWeUUjltsMYkFDRSVVtHZXMtwZz16Zb+45moDiOoRQRNKW3hubwz3LnFnsu0JZDM9kYmyWs/1ZNJsd745/zCPbDzAhl2+HPAKwj8ogOjoU6RkpJJfXkZlczPtvT0oFX3jPaIkCPUxENX+CRA1kcnKoz9zaJ7WPDTvUzL+BJl1EU2duev/PvV8NDwjXZ43ZjHLLLP+B2TqPjcmfXVkBlEX1ZUEUZJM5b2Yjbt+pLUu/M1Uvgtbb7KdJxr7B03nv5gnDqJWbuNrpmNMzBt26b9lDHXNSZyHZ02VeUJ21GcYw0xI1yWIcmL2p8ozYevDjGGuKZmfHZ9DU+2cNps6gffbOf7CmMWsL1DGNqHQhUCUWErwRzsmGr56w7xR1SOj7C9o4bGTudzhksbkXZncuD+HWw7lc9vRMu48Wsv3jrTysyNNPHC0nIdc83jsaAyrD3uz3d2PQN8gUiJOk5+URnlZNY1tvXQPKBgekUCUNE/VZzekz/WOkhrhUmNcAlcqtYoRhZwBCUb1dNHa0UZtUw9ppS345TTgmNrE82eamR/diG1sK3Zne5iR2M2chHYWnGlnXnwLs0Ta3Lg25sS0Mzeml2cSVcw6PchDu4u5bcNprJb4I3vWH4uV4YbheBbrorF6IR6blxOwfv2sYd4ny/czsfowC5st2dhsz2bSzhxucMnnpj2F3LqviG/sLzP4mwfEORL+1sEyvi35QDnf3l/Ot/ZX8I0Dpdy2t4ibxH5TxP4227Kw3JKFxeZMA5Aa7yElDd9Lw2pTItZvxWLxWiyy16XJzzOwfjkVq+cS+MF6b6a/f5ItXtFExCWRmZlFUUU1Va3i/AwMMaQeZlR3bmje5wdRKrUczZjOwHJG9eL6aKUeUSOotKP0iGqVXj/MWwFl/GGjN1+bvV/Ed0U2yw+LOYHYiGNMeWIX35t3APt3fNkVlEV0Vg15hWW01FYw0iWBqD5xrdUGENqm0BGSU8ezm0P54byj2NiK8s7yQTbHE+s5x5ky25W7l7iKWO68diCIoz6hhIQEcyYhmuy8bEprqqhva6WrvweVagClUi3KKwpuBFGi9IaheScyGi8BRE1kjiidGUQZZfwJMusimmbrEm7iGVlrTDbLLLP+R2TiPjeDqEtzqPCaq2xT5bi4ryUQ5agfNZX/Ql7mpP+6cXeDxDb/8/Nc1M76x4y7f0IOzvr9JvNf1JcAog5jYzrGxLzWUX+PMdQ1J3E915sq88SsjzaGmZCuRxB1eW+LNNpR72MMc03J/Oy4TP1y9o5vT7V11p5/8qbauewzZjHrC5axTSh04R5RBhClEx4zgijlGAcK2nnMu4g79+Rh7ZKN1e4sJu3P4caDRdx2sJJvHWjg7v113HughKkHs3n0UCxrjgWy0zOY4IAQ0k5HUpiWSmVlFc0d3fQOyZErVIb5oCTQJEkqg7T+8Yb1uc/nYNQ4kJLmkpKG6w0zONRHX383nV2DlDZ0E1XazsHsFl4508DTkTXYRjcaekVJIMo+vo25CW3MEbaPaWZ2rLTsZFZ0L3Nj5fzLv52fbc3khrWhWC4PRLYiFOt1UcjWRyPbEIPlS2eY9NpZbN5KweIDcQ6koXPbcpm8I58bnQq4Zbc4F/tL+cbhcr51tJLvH6viB8cqudu1nLuPl/Nj4Z+4VfCT41XCNcJ1fN+1iu8cKeOO/cXctquAm53zucEpl0nbs7GUYNR7qYahehbvp2Gz6SyT3ozH6lVpWF4qlq+La/CK2P78Gb6/7iRPvuPJ++6nCYk+Q0pqOvnllVS09tAyKGdQrUA3KhfnT3FlQJRKxGLMUINGxfUZlXpEiW1KtZo+sbGwTcH+pDae2nyKby/Yj+VTB5DZiWPMDcB6tjeTph/g67MP8df1brx59AxBSeVk5ZdSX1mMvKMG9VAnapWaEVFVK/tUHIot4fGXT3KH7SGsbaU4/ljM88B61iFumXuYqWs9WL7dhw+OhXDCL5TwsBBSzsZTWJRPdV0tze2t9A50o1YPirJrGNOJOibBKK0EonS0KXVfEIjqZZNHthlEmXVRPWi769Hzn48G27qsMmYxyyyz/kdk6l43Jn119HlAVM6RV41Rrp5MlWMivrZA1GlT+S9s/evG3Q0ynefCNu76KYnY+0zlv7gnDqIkie/daTrOBOyif9YY5pqTg5P+LZNlnoAdHPXHjWEmpOsRRInv+K7JMk3Aa5z1+41hrimZnx2XqWm2zk6mTt5Ddjt/aMxi1hcsY5tQ6AIgSqTp9aOiMS0a1EYQVasY40hRD0/4lPLtXXlYOuUi25WD5d5cJu8v5OYDZXxjXy3f21vNPXtLuG9fDo8cSmS1exQ7vSMJCT1NRmwMJVkZVNdU0drdQf/wACOK8YnKz4EoaXk+iPp0I1v6LOXRiTIqUauGUY4MMNw3TENbH6m13XgUtvFOUh2LTldiH1nHrDOdzEzsZUZMC7PiWpmd0I59bKtwO7bRndhF9THz9AB/cqvlrk1nsVkbjMWqICzWRGD9QowBQsleiMXqtbNMfjsFG2li8Q9zsd6ax5SdBdy8q4jb95Rw58Fyvnuskh+41/Bjjzp+4Sm5hnu9KrnPu5L7fSqZ6lPFNO9app1sEG7i5151/MS9mh8eK+euQ6XceaCEO8Q5vMW5wNA7SvZ+imFYnuUmcdx3zjDp9TisXk7E4uU0rF7NxOalVKw3xPG9tZ48+Y4777uGEXQqlqTkFHJLyilr7aZ5QM6A6sqBqK4uaa6lYcO1McxrL12VMS2jGgVKtYoBsaG6V01g8SArD5zlnsWHsHliF7LpUq8on3EQZefKzbOOcd+iQyzfHsHxyGJSc8uoKiugt6WKwe5W5Co1faICJtX08cqJZKYtO8wNT+wXcTyRzfYxvN1vst0e7lywn7++dJKNu4NwdA/DOyCEqIgwMlPOUlZSRH1DHe0dLQwOdKPVDos6p2NMKrTUI0oryi3+WhVmEPVFyvgTZNYFNNXOJfb85+NUW5dSY7JZZpn1P6Tz73XJxqSvjswg6qK60iBKNMyXmsp/QTvqG4y7y6QJx03muYiNu39KDk76PabyX9yXBqLE984zHWci1q8xhrnmJMoWZrrME7Cj/gNjmAnpugRRTpc79NPgTcYw15TMz47L0LQZLnebOnHTbJ0djVnMugoytgmFLgSiJCgk9UDC0KBWiGW9Qo97ST+2vqV8xzETyx05yHblY7knj0n7CrhpXylf31PDd3fX8NM9pdy7N5eHD6Wy/MRZtvgmEhQRT+aZM5TmZ1PbUEV7bxsDw70oldJQsf82rqUynA+iPi0pTeyjF2UeVTGmlaNVDaIeGqaze5Ciln5CyrvYmtrAitMVzDpdg11CO9MTunkyqtkwVM8+oYMZMa3MiG5jepRYj+rnifBeHjxQxu2vxmDh4I9sVSCydaew2hhrgFCylxOweTuVGz7IZPLmbGy25XODYyG37ZYAVCXfPVrDj9xquceznl/6NPKAXzO/9m/iNwEN/Caojt8HV/OHkCr+EFzDn4Ia+FNgC38MbONXAc1M8xH7eIl9T0i9pGr4/uFKvrmnmBvFebZ8LwXZ28JvJWH1RgLWr8Rh8UICso2pyF5Mx+r5s1isieb7q0/w1NuuvHcsiMDwSBITzpBdUEJpYzuNfQP0jgyh0VyBoXmN4yBKPjxo6DGnkeqJsd7ox9RotSpGxLbWER2JdWreOZnLH9e5cct08UP5n4PIZrgbjjNpljTX01F+MO8Qdm+HsTukiOT8airKi+lsqqCnu5VhnY6WYT1+2a0sdI7m7gUHmTL9+DjMsffCetYRbpixnbsXuvDUm968fSiM/V4RBAaHEx99mtzMFKoqSmlubqCnqxXFcA863Ygo46ioO6LIxh5RBhD1hfSIMs8RdU7GnyCzPkMP2LpMN/WMfGCm8yJjFrPMMut/SKbud2PSV0dmEHVRXWkQJclU/ovZuKtslSOLTaVfyA5Oeifj7p/Sakf9blP7XNyXDKLCTce5uMW+J4xhrjlJkMdUmSdi8b1WG8NMSNdpj6hQk2WakK9NAGl+dlyGptk6H/jUibN11tz/1K5rdgK4/0UZ24RCnw2iRkULXayJhrQEokChgyalHv/qYRYGV3G3Yxo227KRORdgsSsP6z0F3LCnlFt3V/HtXVX8eHcJ9+zN4Y+HMljonsG7vmn4n04lPTmFksJc6hqr6ehrY1DehVI58FFvKEmfBaJGRRYp26g0MbbUlUUvWSM2KAwgalQ9gF4+jHxATm23nFjR+HfJbMAhsow5EVXMjGnh8eg2/h3RyIyoVmxjO3jydAtPnBKOaDeAqP+E9fHA3lJufjkS2SofZA6ByJ6LxObVM1i8cgbLN5KY/F4mN27J4aYdedzsUsLX95Zx15EafuRex889G7nPp4kH/Zv5dWALvw9q4y/hHfwlrIW/RjTw8Ola/na6hr+frueRU808Et4u3CXSO/hzcBu/E/s9JPZ/4GQj97jVcdf+cm7dnovVO0nI3kw2TI5u9VoC1i/FY/HCGWTPpwinY7lOrK88zd2r3bB/x5XNxwIJDg3nbHws2fkFlDW00NDdQ+9wHxpxnq4UiFIMDYproUclLoVauj4SwBTXZHRUmmBcT6+oWvkdOg5EVTLzbX++N3cfNk8eQPbkMSxnejBltieWM47yzVlHeGRjEO975RCXU0NJWSnNDRV0drUxNDpKeYeSPSLGo++Gcefsw9ww2w/LOaHIRFkn2+3nazM+5L4lLiz80I8trhG4+kdy6lQUKQnRlORlUl9TQXtbE0N9HaK69InyjaATFfsciNJrRZm/sKF5ZhB1TsafILM+Q9PsnFPOf0ZOtXXJMSabZZZZ/2M6/36XbEz66sgMoi6qLwJEOTjpR0ztcyGvc8Qwl+9qR32WqfQL2cFZ/4jhwCYk4rmY2ufivmQQdZlzURlAWoUxzDWl1c782FR5J2qHnfrHjaEmpOsRRIljF5ss0wS8xlk/yxjmmpL52XGJemimy72mTtpUW+dL6hJo1ueXsU0o9NkgSjOmFc1yA1YQjV89Su0YHRo41axmZWQ99+7JYtL2HGSOBVg652K9K49Ju4u5yaWCO1zK+YFLET/dnc3vDmQx+3gOb/pk4HMqldSUNEpEo72upZqOwVYGRzpQq/oMMOOc9GPj80B9HE4ZwJRYSmXTi7x66a1+hsFgolB6pfgqcvFxCBRyVMMjtPSPkNQ8wL6cJtZElTE7opynohp5NEI4tM7QK2p6TBuPi8//Cmvk3+GtzIga4ImIAQOIuunl08gcfJGtCcbqxVhueCMJmzeSsXknjRs+zOGGLTncvDOfO/ZX8u3DNfzYvZF7vVuY6t/OrwPb+X1wG38KaTMApkciu/lHVAf/iG7mn7H1PBZbx79iGvhXVCv/juwS7uXR0z38I6Kbv4Z08Eex/29827jPo4kfHqzg1m3ZWL6ViEyak+qtZKxfTzRMlm75/Flkz6Ujez4Dy/UifWUEP17rxtz3jrPteCChYeEkJ8SSl19EeUMzjd099A33oFFLIOZyQVT2RyCqu6sLlXzIACwVogoptHrDhOX6MQ0ajQLFqI5e3RjVA3AypZFFO05x75Jj3Gp7GMunjmJld4Ib555E9tRhbplxmF+v9Gbj/rOEJZeSk59PZUURDa3N9GjGyKjp5XXPDO5b68mk/+zBxt4P2awQZDNPMMV+L3fab+YPq/eyyjGEHe5ReATHEBMVTWZSPBVFuTTXV9Pd3oJioAvUEvhUiHMgKpNUjc6BKL0Eoi51svKr+Na8EQVarQkQJd0TZhB13WuavfMcU89Iabsxi1lmmfU/JlP3vDHpqyMziLqoviAQFWRqnwtZ7LNL2tdU2sVsOOhnyMFR72xqn4v7EueIctIvMx1nYl67V/8NY6hrRg479fNMlXWiXnaJbwO8TkGUwmSZJuA1zvr7jGGuKZmfHZeoqXYux88/YVNtXQZ/9+/dtxqzmHWVZCA6kiRogE5Ymqh5fGiSNLxKsmZMmh9Kx5iwflSDZlRFp05HYq+OVxPbeGhHBl97OxWrzWnInMVydza37Czg6x+W8PUdFdy+p4zbdufyk72ZPHo8F4eAAvZF5xOZmktRURGtTbUM9EmN9j6GFcOGY0kQQyqRwWLd8FlqYEt/hqWhzW3wuKS1McP3MEz2I1mjQ61U0zGsIqtjmONFLbwQV8as8DL+daqBv0a08ejpTh6PbBefW/hHWAN/C67jkZBG/n2qj0cCe/jlnnJufS0e2boQZM9FYPFyHNZvpWC9KRObD7O4YXsutzgV8o29pXz3aAU/cq/ll95NPBTQyu+D2/lLWCePRHTz2OleHo/q4T+xbTwR18ZT8W1MP9PK9IQWo1vFNvE5vh272F6ejOzkXxEdPBYhQak+fufXwY8PirJ8mIHVG2fGQdTrZ7F5OYYpL0QzaUMcluvPIlt7Fqs1cVg5RPGLde48/Z4rO92CCAsPIzUhgqLcNKrqamjo7qZNPoJcM8KoTpojahSvlHZmfhDHXRKImn4Ci5meWNp7YTHL0wCifrb8AEs/PGoAUdFRCaQn51JSWP3RHFEjwxq0GlGLRsX1Eudfj0ZYLdZFndGNMqIapUEOsWU9bPJI5f9WH+Xmxx2xnnEcC1txzDm+WNq6ccNTe/n5kuM8sz2GQ+EFJGWVU1pSRmNLF7V9OkJy23nGJY7vPHsMq+mHRTl9sZobxg32ntw23ZGfz9vMU68c5tUDIRzyDuVkyGmiY+PIykihqryItuY6+ns6UAz3o1NL81opRHUZNVQdvajwYzqNuBN0hqF5Hun12H4QyF3zj18cREXGkJfy2T2i9OdAVG0f7504H0SJ73AORM06wjRxbsZBVDSR0bFkZ6ZSVlZIQ2MdXT1dyJVydOIcjxl6K0p3ybm/j+6a8U8i/UpYinWlZfwJMsuEptk5557/jJR6SBmTzTLLrP9BffqeN4OoS7IZRF3Qxt1NysFZv8jUPhe2XuGwU3+n6bTPtoOjfsB4WJNa7ah3NLXfxX3JPaIeMh1nYl7lpP+PMdQ1IwcnvZOpsk7M/533a6K63kDU+t3675ksz4SsHzaGueZkfnZcgh6wdf6VqRP2oO2uN4xZzLqKOte+lHoVjemlfk8ShBrvAWWYLkdYMybWReNcr1XBqBKdaLh3jWlIHxrjg7Ru/m9nJt95I5kp7yUjc0rGck82X9tawDfeLuSWLaVM2VOKzZ4cvuGSykMH0pjjncfm04UEnc0jP6eA1uoqBjvbGBqUQJRoYBuHHH0EnIw9PM7ZUN6P+ROSNhh4lFjRjqJR6egZ0ZLfM4JnWTsvxZVhH1rCP8Ma+L+Idv55uofHIjr4R3gzfxfbHg6p428hTTwa0cNffDr5xa5ybn39DLLnwpFtjMLilXis3knF+sNsJm3NNbwZ77a9ZXzncCU/cy3nPo9afuXXzJ+D2/l7aCf/Cu/hyVN9zIwaZFascEKHwXMSu4zuFBafz7YzO7HN4HmJvdjGdDI9Sjh2gCdihvm/oC5+eqCcW95Px/J16Q15SYbhgZNEmW54/jSTN8RitV6Uc3UC1qtjmbQmhgc2nGDJ+644uwUTERFKWnwoJTmJ1NSWG0BU84iKQY2SUd3IJ0DUdxZ4YT39BDIjiLI8B6KWHWDJh0c+AlEZKbmUFNXQ2NBCZ2cXclEf1Cq9sfea1KtOJawWFtdTN4ZGOUqLErKbRzgUUcwTL57ga49vx2amG7IZ3ljO9sPK3hPrJ3bxvfkHePKtYDZ7pBCZVEhBfil1DZ3kNY5wOKGWJ96P4PYFx7C2l8rph/W8MG6ZdYI7n9rKb57dysJ3XXn/aAhuvsH4hpwiOiGR7JwsaqvK6GxtZLBfGt4mTVKuEJVFAlG6cYYpDfUc/S+I8jSAqIAvAUQdYZmjBKKiiIqOISczlfKyQuoba+ns6TSAqFH9+Nv9PgmfPmlpiOGV8PideGVl/Aky6zw9YO+8yNQzcqqd81PGLGaZZdb/oEzd98akr47MIOqi+iJAlCRT+1zMDpf1BjL9ZuMhTcrBSb/T9H4X86WBKEliH43pWBe3KKevMcw1I3E9LvtNgOL7BBnDTFjXG4hy2Kl/xmR5JmR9ojHMNSfzs+MSJE6Oz/kna5qtS8evVx62MWYx6yrqXPvSAKJEg/OcpebnORClFWkSiBrTKEGnQKdX0ity5IyAU24/Tx7M56fvpHHTplRkO9KwdMnj5i3FfO3tAiZvLsBqj/DebG5wTuYHLok8djydt0Ly8IsvEA3sQhpKy+hpaWB4sFs02ofRSxNHiwY7EkySyictP+7x/33kT0hiICKPXppESqVmVKVlUD1G6YAG74ouXowtxS6wiH8G1/CXMAk+tfOPUGGx/s+wRh4JFQ5p4dHwbv7s3c49zmXcLIGfFyKQvRyD5ZtnsXk/E5ut2UzaKb7n7mK+friCH7pW8+Dxan7r2chf/dt4LKSLJ8N7sY3oY/bpARZEDfFM7DCLkwZ4NrHvIy9OEk6Wlr0sSurmmcQuFor12Qk92Cf0YX9mmCdjh/hTQBs/3lfCzZuSsXg1Ftmr0lvy4rHeGMWUF6KY/HwClhuSkK05g/WaWKasjeY3L3iweosb+04EcToihIy4UEpyz1JbW0ZTdwdtcrmxR9R5IGr+OIj6VI+oi4Io3UcgyjC00wChJGsNYFGjGqVLCxU9o/gmNfL0+yF81343k2e4IpvuhdVsf6xneSN7Yh/fmLWPh5/z4JU94QSfTiYvu4DK6hYSy3p537+AP70cwK1zj2Mz+ySyWcFYzgnmZttjfM92G39dsZNVW9zZ4RaKh18YgeHRxJ9NJT8/n5R6MWwAAIgVSURBVPraKro7WkVd60elUqLTqUUl+m+PqM8GUVdxaN7HekQdMgGiuno6GZFA1Ngo5+Zv+6w/6a6+En9SrCst40+QWedJeive+c/IqXbOscZks8wy639U59/3ko1JXx2ZQdRF9UWBKAfHS4cKDk76flPbL+wLAyMRc7vp/S7mywJRiaZjTdCO+u8bQ33p+nyQRdhRv9EYasK67kCUo/6YyfJMxI76a/ZlauZnxwT1oP3uP5k6WVPtXC658pt1ZWRsExpB1OhHDc+P94gyDNMTDfZRtRK9VgJRKgbEtlLRhnctlbPkZBm//iCD295ORbYlA8udUk+oMm7dVID11lxke3OxOJCD1Z5UbtudyG+PprLOLwePmFKyMiqpL6mku6me4aEONNohA4gSrexP0qbzYNS5zZI/kvThXLq0v0KBXq1FIcJVy0fxrephozjmDL88/hFQwf8F1fPXwFYeFv57cDP/DG3inyFNPBLUzCMhnfzeq4Ufu5Rx0xuJyF48jeXr8VhvSmXS1hwm7cxlyq58bj1YzJ3u1dzjVcefPep52LeVfwd3MTOijzmn+1kQOcCzMUMsixthxZkRVqcqWJUsZ8XZQVYmDeKQOsTqtCEchFcm97P8bA/PJPXwdEo/C1OGmSvyPhndx2+96rnLMYcpb8YjeykS2ctxokyxWEkQ6oVYbJ4XZVyfhMwhHpvVUdy89jQPv+LJy47uHPEMJDoimKz4UEpzzlJXW0ZLVxtd8iGUGvmnhuZdNoga1qBWidrzEYiShuZJS50BRGk1Y/RpoXkY4op6eenAGR5YfJibph9B9pQH1nMCmTzHH9mMY9wy6yC/WnkEhw888Q6IIS8zn5LyJoLSW1i+N5GfLj/BZPvjWM8LQDYvXJTRn5tnHOSeOTuY8dwuXnXxYr9XGD6B4YRFxpGUmkFxSSmNjQ309nQzMiJHo5EAmU7UmysFoq7QZOUXAFENH4GoERHz07fJ+f7YLfO5LP53xWX8CTLrY5o609nB1DPyQVvHR41ZzDLLrP9Rmbr3jUlfHZlB1EX1RYEo0dA+aWq/K23j4T5T4vttNbXfxX3pIMrBkddMx5qYpR5hxlBfukRZzpgq40R9OfMfXW8gShy3yWR5JuKd+ieMYa45mZ8dE9RUW5fQ80/UVDvnSx6TataVk7FNiDTkTcIH5ywNxjH0hBLWSyhKNM5HNSrGtNLQPDVDIketaAgH1Sl581Qd/9yeybffOIuFNHRsaxG3bKng1g8KsdqZjWx/NpYHc7E4mM2Ug2n8bH8ys4+n4RJWTGJaHdVlDXQ2NTLQ34pC1YdGpxONbGlumo8DJ6khL809NGbYfq6cn2ggSx9Eq1mCUAYQpVQYhucpxfZKxSheFb2sjyzhCZ8c/uZXxp8Ca/lzQCt/9mvl//ybeTiwib8FNIj1Rv4voI1fezbzoz3l3PhOCrJXYrF+6yw2H6YzaUcOU5zzuGlvAd84Wsp3vWu5L6CRh/0a+WdwO0+c6sY+qp/5MQM8GzfI0oQhViaOsCZZwZp0BQ5pclamDLEqbYjVGcOszRRpmXLxeYDlUs+o1F6WZAywJEvJglQlj0V0cu/hYm7dlIjFS6eRbRR+MQ7ZCzFYPReFzXPxWD+XZJgfSrYimhtWhfKNdSE8+bYX7+/15IRPEHGngslKCKc8L5WG2grau9rolw+i0QyjuyIgqhP5sNoIoqTrIvXUkSCUNPm9uJbiuunEtRhQQ7cS8uqGcfLL4e/Pe3Kb7QEsprtjM8uPG+YGYGF3ghvsj3DPMweY/+pRjnhGkpFRSHp+AwdOVfCvN0L42qxDyGa6YTk/BIsFEcjsTnLr9D386mlHFr+xny0HvXHzDSEoNIzI2HjSM7Ior6iipbWd/v5BFAo1GlEe6a2LVxdE6ciu62WTR/YFQdSDDkdZYQRR0VEx5GakUlH6MRClkN70J87yx0DU+eDoy/ClyPgTZNbHNM3Wpe78Z+Q0O+cwY7JZZpn1P6xP3/tmEHVJNoOoC9q4+2fqc/eomYgdLz4PkYOjfovJfS/qSwdRa3bwoOlYE7ODk77RGOpL1WpHfm2qfBO1OOc1xlCXpOsJRK3ayd9MlmWCXuTGFGOoa07mZ8cE9ID9rn+YOlFT7VxWG7OY9SXI2CYcB1EfAzyfBFHS/Dla0VjXotdJr7ZXI0dLs2h5JrSp2ZPSyuzdGfzo9VgmvXUWi0153PxhGV/bnIeVUzqyfRlY7s/B4lA+locyud0pgd+5xPGcRw4+CbXklrbS2NRGV1cLvcOdDI6K+HotSlEStSibNNOQtH7OKuFz5ZR8rgFsmD/KCKIksIBK7CnWh8XmgkEdh4u7WBZWyKMnc/iLXzm/D6jhDwFt/M6nVbiBP/rW8wfvWn7rVSM+NzHNq4UfHarhls1ZWLyViNW7yVhvTmfyzhxu3JXP1w4U8G23Mn7sX8u0kAb+GtzIP0+181RMN/Zn+pmXOMAzZ4dYkixneaqclelyVmWKZcaw8JBYH2Z19ghrckZwyB5iRUY/y9J6WZY1xEqxbXmuhrlJw/zFt4Hv78zE5pVIZM9HINsYjcWL8WI9BssN0VhviMdqQ6KhN5TF0jBuX+nPjzf4sfCDkzgd8cUnIISEyDCyz0ZRWZRFY2MNXT3tyEcG0GmvHIgakavRqMU1ka6BVG+kYWPC4qIYllKvqGFxQYc0UNOhwCu+gvkfhHDXvP3ieEextvNi0iwfcVx3rGcc5tuz9/LPtQfYejCCqDNFhCfX8vaJPKat9sT68d3InjyO5bwQQ48o6Y1537DdxV9X7uK5zUfZ4+qDt38QEeGhxMfHkp2bQ1V1Le0dXQwOyVGqNAYQJQHPaxVErdxhAkQ11NLd3YlCAlEipgSizoGncxDq3Ocvw5ci40+QWUZNs3V53uQzcuau/zNmMcsss/6HZer+NyZ9dWQGURfVFwWiJJna70p6lZP+feOhPlNrnPQfmtr34r50ECXJwVFfZzrexOzgpH/LGOpL02pH/WlTZZu49fuMoS5J1xOIkr6jybJMxI76BGOYa1LmZ8cENM3WOfr8kzTVzrncmGzWlyTRbBVNQgkUSA3l/zZkDSBK/FeyoWeLBKJGxVIvzR4lGtTC7WItp1dDYHEvz7nn8uB7MdwoDR17M4Mp7xZw8weZWO44i2xXElYuWVjuy0e2P4fJ285w95YYZuxPYXN4ORG5LZQ0dNLS1U7XQBe9GgUDoyrk4tgKUTalKIFCeESsj4hjKqQeNuLzOUtlN1gU/FxvKAOIkuYl0ulpU8GZDjVbM5uYFZDL/3nm8lvfcqb51fCQfysPebfyoGc9v/ISnz2rmOpewbSTDdx3spkfutbzNacCbN5PxfqDNKy3iO/mmMutu/O581AhPz5Rzv0BdfwurImHI5p5NLqNp870MDtpgPnJgzyTMsiSNAkyDRsg1KqMAVZnD7M2d5j1+SM8VzjChkI56/KHWJPTi0NWD6vzlDjkqlmcruCpU508eKSUb2w6i8Xzp5GtP43FxgSsXjyD5XOxWKyLwmpdLFZrE7BYGcWkpf78wMGD37/sxdqdPux3DyIgOIKzMafJSz1DVVkhLa1N9PR1oVQOifMkTQ5/ZYbmGUCURur9xHh9GvsviJI8NqZDoxW1SYe4zkri8hp48XA8v1hyiBtmHsRiuisWM04ge+o4lk8d5mu2e/nVskM87xLJ8YgSDoVXsnpPOvcs8cDqX/uQPeEuyhWKbG6IKKsr3527hydeOMjbLh4c9fQnMCiQ+OgQUpPjKCrOo7apjs6+HgYUI4xo1Kh0WjRjGlHYa2xonv0RHlo1DqKO+EQRGxVDfroUt1Cc63MgSo5W3I866b403A/ne/zuMJ126RZnx/BLcCFLV/lSZPwJMkvo4YfftZ5q59L+qWekrYufMYtZZpn1P67z73/JxqSvjswg6qL6YkGUvsXUvlfKaxy56P+xIhr9H5ja9+K+PBC1xlH/tul4E/cqZ/2fjeGuusT5eslUmS7Fq5z0vzOGuyRdLyBKfL/vmizHBO3gqL+mO82Ynx0X0dSZjk+aOknTbJ2WGLOY9SVJQk4SJPg0iJLeeyaBKI1I0xga53pD7xHRqBbbhlHSJVLLh7UkNQyz/VQ5j+0+yx2b4pC9lsykN7PHJ9beGoNsZwLWOzKxdspHtjuHSduT+ebmBB7aeYZF7lnsiqskvrSFipZ22nq76JMPM6hSMKJVoxobRSOOqZYs1qXPaql3jfg83tT+NIiSoIIBRIltQ1ooG9ThV93PxvhK/umVwUMncnjAt4Kf+1Rzr3cL93o2c++JWh7wqBKu5F73Mu71quVnPs18z6OR2/eXMWVHDtZbxXfYmsGNjtncsbeAHxwr4b6Tlfw+qI6HI5p4NLKF/8R2YJfUy/zUAZ5JG2CxNNwuYxCHTGkI3hDrM3rZmDvEq0VK3izT8Ga5mtdLFbxSNMzLhYO8VDDI+gIdKzIV2Ed18scTFfxwRzo3vRqDxYYoZOvF+X3+LJYbE7F4TpzbtVFYronFenUc1ivC+dqyk0zb4MaMdzx4ba8vR7zCCAmNIik+hvzMNGqqq2jt6KBvsA+1ekScL2mI1+edrLx1vEfUiBKNRmfsESXqkWE5DqEMdUzUFwOcGtMxKJeTV9eBY0g2v3/OldvnHUI2XfzjbMZxcdzjWNu6cqPtYX7y7DHmfhjNJq9i3nArwP79BO5eeBybxw9g+dQJLGcFIpsVgJXI/5NnDzHvbXe2HvLjhE8wYaFBJMcHkZ0eT1lFHk1tDfQM9TEsvrdCpxJ1SYVG+HoCUU0NtfQYQNQw2rHxYbJj4n4ck86twVKPxfHPEh767/bPYymmdN9/Gj593NIVvhQZf4LMEppq5/K6qWfkAzN3/9qYxSyzzPofl6nfAGPSV0dmEHVRfZEgSjTYXU3te6VsPMwF5eCsf8/Uvhf35YGo1Y7675uON3E7OOrzjOGuqj7vkDzJDqI+GcNdsq4XECWO52KyHBOyfuRaHpYnyfzsuIim2TonmThJX8pNa9YnNY6cpJ4r/wVRos1s2HoOROlGFWi10mv+xVbRWtehZkg/Qo9Iq1eNktepwjW1gfknsvjetiRkr6cy6fVMbn47AYst4ch2xjJpW6ZwjlhPx2ZHBjdvOct3P4jhr06xvOCTjndqGTmVDTS2tyMfHEQhl6NWqQzHHIcD43DJYLEugahzMEqCHlIbWAIJeqnBr5NglNSPA3o0enJ6lBwpbmN5RCF/Op7MvW5Z/Nynkrt9qvjJySZ+eqKee9yrud9TcgW/cC/jnpO1/MSvmW97NXD7kUpu3lVkmBvKamsGNznl8K39hfzMtZRfe1fzcHA9j51q4j9RLcyI62ReUi/PpvazNHWQFYZ5oIZYlynnuaxhXs7o4c18OR+U69hWo2dL9Sjvl6vYVDIiLOe9MpGvGBanyHnMv45fOGfy9TdimPT8aSw2xCBbf8YwF5TFxkRkG2KRrY7CYnUMNqvjmLIinDtXePHnjW4s3ebJ+4cCOOZ9mrDwWJLOJFCQk0VdXQNt3X30DQ+La6oSF1y6tv8FUbYmQJTlREBUlwRHVMYeUeIaSFDHAKKMF8dwpbRiVSMqlwL5yCCV7T24ninhH2948u1Fx7CyPYKVnTs29seZNOs4k+2O8c15x/nba5Es35vDoh0pPPxCCHfa7mfSv/cxeaYop30gMjs/sY8b9y0/xuIPvXE6HoyXXxgRYcFkJAWRnx1HVU0+bV3N9Cn6GdaNoNQrRS1WoRXLKweiLuWteecPzfP9GIg6agBRq7aHctQnirioGArSU0TcAprqa+jt7kCpGEIzNmJ4g+X4YFW1qO/ifjFa+ixNFv/xbZ/HUj9I6TfBFIA6Zwk3XoqMP0Ffef1y9r6bxfOw/7zno/Q2WXdjFrPMMusroE/9Bggbk746MoOoi+oLBVE79XNM7Xsl7OCkLzAe5oISeTedv+/EfHkgStJqZ72P6ZgTt4Oj3tkY7qro5e36W8Q5TTNVlkvxKkcWG0Nesq4HECXVC5NlmLAvb9ji1ZT52XEBPWjrPMvUCZpq6zTPmMWsL1HjzUe9+BuHUOPzREloyjDFtLAEFkQjd1Q0bnWiuSka6qNjOpRjWgbGRmlTjVIzoCaivI+Xwst4yCUO69fDsXwtlhvfOcuU985i80EaN3yYj83mAiy25DJlaza3bk7mtg+j+e6WMP6yP4pXgjIITq+hvKqL/s5+hvvkaOTimAoNqIQ1WlEg0RSWLMEpvdTbQyqdVvyp0OgV6MYUonwq9DolaFViu55WBUTVD/P22Tr+czKPB47m8LMTZfzkZB13uZXzPbcmvu/Wwg/d6vmJew0/da/gx25l/NCjiu97NnCnRyO3Havjpv3lWDvnY7U9i1ucc/ju4RLu96rmjwGN/C2kmX+FNzE9sgH7uFaeTupkWWoPDqm9rEvr44X0fl7JHOD17EHezOpjS4mS3bU69jfo2FevZk+tml01WhyrNGwpV/FcpoaZQY084JTCHa+f4saN4Ux6PhLL9dFYrInGao00J1Ss+BxjGJpnsSYCyxWB3LDUg7sdjvLvN9xZuysAl+OB+PiFEhkZS2pKMkUFedQ31NHV082Q9NY4nRr9mFJcWyWtw8YeUe9/nh5RCsOb6D7ZI0qqWZLGYZRGAorStVHJaevpJzijmoU7I/jxcncm2R1kst0Rpsw6weTZnljbHeeWOa5MXRvAk5vi+PfrEdy/zIvbpu/H+klXke6HpZ03VnZu3Db3KL9f58HqHSHs9TyFb2AoUREBZKWEie+dJL53KZ29bfQrBpCL+qHSa5D+tHr1BEHU8YuDqMgY8lI+u0eU1LPQMEdUbS/vuWfy+9UB3GzrgWymF7JZJ7GyP4H1TFe+Zn+QhxwOs2pnMId9ooiKiiU7I53ysnLqm1vp6B1iSCnujbFhcR9Ig1alwavnBrCes7gHpG1jIxf1mP7C1gtLvawkGGX4PZDuPfEbMKaX1sd/JaQ0CQtL1/i/lq75+PX/79p/ZfwJ+sprmv2u90w9I6fZO1/yG2zMMsus61emfgeMSV8dmUHURfVFgihJpva9EnaY4BvmxPd7x9T+F/flgygHJ/0fTMe8VOtdjSG/UK3ZwbfF+cw0XYZLsb7MGPKydK2DqDVO+p+K79hgsgwT9Mrt+t8Yw12zMj87LqCpds7Z55+cqbbOacZks75knWsgSpb6rJzzx7ePYylpnijR+JR6G4mPWtHOHNFBl3KUVrmarDYt+9NbsXNL4Nvv+WD1ehBT3kri1rcLuOmtEia/W4LVB2XYfFjKre/l8I0Pkrhlayw22yL4+s4wHjmSwKaQIk6lt1AuGupN7SMMDmlRK7SMqbTigBKIEmXQadBrJIAize0j0kRDXD02iHK0D83YgNguH29gaxQMivIVdOk4mNXFAr8yph4s4AeHKvi+e5PB3zpcwZ1Hm/n2sXa+49rIXa5VwmXCJdx5rJQ7jlXz9WMN3HK0nskHq7DaXYS1kzQ/VB4/OFbONN96/hjc+v/tnQdAVFfa/gdQbCmbzfZsyZZvSxJmzGZLdvfb9t/db7ObIneQtE1vdk1ijEaNXWOBGbB3AUFARCwoIirSQYqKWJHee2eGAeb5v+dySFiciBVB3p/75N6558xp98w5vO+eey7+uLsIf9+bDyUsGy8cyccb0aUYE1eOiXFl+IA0PaECn56oxPzUGixOb4LxkhkbcszYktsEr4Jm+JS2YmsJ4HEZmJtqwishhXjSmIBvfLQbQybuhOMH+zFkajjsJx2E3dhQDJpwCI4TSZMOYdCkA7AftwuD39qGB99eiyemrMfLi30xY/1+bPYNxj6xT9LhwziRlICzGenIzb2MyqpSNDU3wNRqRmt7M7WhSXVEbY8uwqgFh//LEWXnIuRzTY6ohoYGtLSIRzk7eo36uOTnjqgOGtVbSTfGYkJtTS0iT+Zj2tYEOE3YgRH6NRg+ahWGjfaBo6s/Brl4YcTzm/HDt7zx2/cD8avxfvieWJn03CbYj/KHRr8LGmexcmoNvvvKevzto0B86HkIG/zDsTtkNyIOBuJEbBgyziQgvyATZdWlqGmspTKYYbaKB0yFu0ms0uotR5QFTa0WJGeWY8G2BDw5bifucfZSN1pX29hlq7pJ+30uq6Aduw7vuAVjrX8Y9h+MQFx8Ek6fv4xLhfTbqG5BZTMVtk04kpopXbGdP/0mxFF8/vyaWPHWfA0SjydeRRTe+fifuqpN/PaojdAu2o5EbdX54J44/0IdDqmuY0nX3iCHoAHNyNGeX9cpRlP3OZK0TkZhGGaAYGMcYEfU9YgdUVeV/HqPjHWzZtr6/s3qveXW38ksrgrlf4N7Nt24I0pA399kO93r01h3a7BGAzuZ7C3n3eXWH49zs56xlff1y/qaTPaG6MuOqHEG67NUvmyb+V+j6Ps7ZHJ9Gp47vgSt3vCqrcYZ6WIYJaMwd5hO47CrE6pTXxiOYr8lMkLbOhxRYv9pstdhIluz2tSO0voWZFa2I+xSPWaFn8X/rjmEr80OwfCPD+Oe2ckYOjcDdnMy4DD/LEYsPIv75yTjgTlRuGfRMQxaEoFhyw7iJx6H8K+NR/HRrhMISClARGYNMqraUWIGGik/yhbikTyrpQVWM10kgx6tZAyLRwZbGuhjI8Uxk5ncikYqYI25FamVVmw/XYtJezLxxw0n8fDKdHxt9SV8ZX02vroxF1/flIuvbc7G1zZl0vkF0hk6P4kHN57E/RT/nnUZGLb2PIauu4ghdBxM3x8i3pa3WuwPdQ6P+Wbht0H5+INwRO0vhmtEMV46Voa3YqoxNqG6Yz8o0vQTVZidWoOF6Q1YlQOsyW3DhtwWbC0ww6+iHTtqgI3FwNyTLXjnYBF+7ZaIh2cewn1TQjB48l4M+jAcgz46Cs2UCGgmiH2hwjFs0hEMHX8Ig9/dgyFv+ePBd7zw2KStGDV7O6Z6BMFt8374+Yfg4P59iDoeiZNpKbh06QIKC/NRXVuFZnOT6ohqa29Ge3vvOaKaqc+IVVNWiwlNjc1IzazCZ8Fn8KcZIfjaixswfNRKDFG2wtHVj+SDYa5b8c3/bMX/vLUND/9nE+53XotBT2+G3ahA2ClBsB+1BcNd1uDHb2zEs7N2Ydb6I9i26yj2Ur2Phu9GauIRXDh3AoVF2aisLUdtcz2aqN+0UB8RfUU8Ztqbj+Y1tbYiJbMCC7wS8eSEINyreEPj7AMNtbPqiHLehHtd1uKxMRvw1oo9WON/CPsOHkG8cESdvYRL+WXIr2xEZaMFLW0daqW6CFlILWJDeJKlveNax3qlq0v80nv+J5zR0sFkJQknlFDnNZvqdESJfx1jSdfeIIegAY1WMSy3NUc66Q0/klEYhhkg2BoLZNDAgR1RPXK7HVGU/o2/Xewqksn3yDg36yxb3+9ZN+eIGr/C+gPb6V6/xrpb48a6Wf8pk75ljF1hfZXSvam3/H0ha6JM9obpq44oSv8m9oT6QuOXY6RMsk/Dc8eXQA2R3r1hdIrhiAxm+gCdxqEwF7vrC+OxFWI1R3sbHYVHiGxMsnHFAiU0NltRW9+KippWnCtuRkBaIcb4J+Cx+fvwlQ/2YsT0eDjMyYDm03MYPPcC7llwDvfOOoF7Z0Zj+LxYdc8lzbJoOC47jK8tD8Xjqw7hzeA0zI7KhvelekRVtuFiE1BOeTVJBxgVDlazWBlloSMFWMSjQmJNCFBBYRdMViRWm7AytQHv7s7C71efwPdXJONBz4u4d20eBq/OhuPqy7h/Ux7pHO7beAr3b0jD/euTKfwERqxJxtBVKXDwTIPGeAoOKzPguOoshnimY7jHKXxldTq+S9/7xfYs/GpnIf4QUop/HCjH6COVeDmyFm/G1KlvyJuUWIepSbWYnlKLWSfrsOBsE1bnAhsKAa8ywK8S2FENbCoRTigTXtyVjd8Y4vDg+/txz/i9cBwfCvuJh2D3/lHYfRClblKumXQEmokRGDbhCIa+E4rBrwbg3le24Ufvbsbfpnlj7NIdWLZuJzZs3ongnbtx9HAYEhPicO7sGeTmZqO0vAT1jXUwi8fj2lpUJ1RvOqLM1HfMJupLLWZYLG3IKm+B1/E8vLA0HD98YxPuec5Aea/H4NHb4fi8HxxHe2OEfiO+Onod7h21Cvb/XgvNKCqTPhj2zoEYNGoTHhi9Err3NuGVRXuw1Ps4/PdFIzQsDJFH9+N0ajSyLqWjtKwA1Q01qDc3o5n6MZWAuvGtdkT1vFm5cEQlX67EAu9EPDleOKKoLuLRPBdfOIz2wiDnzbh39Ho4jduMd9z3Y33gERyktk5KSMT5c+eRW1CEkopq1DRSPahpTaJNpcR5V3Ve70ktJOFS+jKJcDEedPzw1Ea6UmoYHcUKKSnxxkQhalH1+x1jyhf9QQ5BA5ZHR6353hXzI0mrNxhlFIZhBhC2xgMZNHBgR1SP3G5H1Fg363O2vn9zuvYNsSn/mbbT6Ek354gSjHW3TrOd9o3KGjh2hfUxmfwNI942SO0SYTuPG5X1rzL5G6YvOaLGr7D+idpoHanGZp7XLesmmXSfh+cOG+j0hvdsNYxWb7zlHmLmxhFmYYeJ+d9OqA6jUYYJo1K8Jr6LI0pdIEH2ZqupHS0N7WisakBpSTWSLpZiZfgZ6D0O48fT9+DeaUdgPzsNmrkXYLfgPOwXnMSg2QlwnBmDIfOTMGjpadgtPwXNskTYfRaJYZ+F4wfu4fjdtkS8EZaJJcllCMisR2yJGZfq2lBOlnM95V9tsqKWrO068Zks5Uq6lkXliaprx9acOsxPzcMzgefx2MpEfG1JNIYtT8XwddkYtrkI9muzoFl5Fo5rLmL4+mRSPIatS1A1dG0iBq1Ogr1nMjTGFGgMKXAwnsRgsVk5STii7vU8ja+vOYOHt1yC1r8AT4ZU4m8HauF8qBquR+vxWowJY5JaMDGlBR+ebMH002bMOmPGnLNmrMhsxeqCDufTujwrPstoxqRjJXjaOwO/WBiFBybvxbBxoRg6IRyDJh2F3SThfIqCZkoMNO8L0ecpERg8JgyD39qNIa/64BuvbcKvJmzGi3O8MctzB9Zs8oPXFh/s270LMccjcDIlCZmZF1FUUoyqmmo0m4UTyoI2uqfW2+iIam+nXtTNESX2IbOYLSQzWqkvVVDfCT9ViQ83xuLxcdtw37MrYP/vlbDXb6M8d6gbpQ9SNmGo80Y4PrsOds9uheb53bB/YR8clB0YOmotvvOCAX+evAmT3PdjlX80gg9G42B4GKKOh+FcRjJycy+ojyPWNdej0WJS377Y8TBZK9queY+oW/XWPLlHlHcifjNB7BG1HRqxYflo4YjyhoPzVtwn9ogaswHjVoRgc0AYIg4ewsn4aGSdPYXivMuoKi1EY30NTNS2wkkkfo5CnU6jTseSuGaie9CTzJTO1STyEY5e9eaJfb+EN1iI2kxtNzpXJRxSNh1RtscVOQQNWLSKYZWN+bH1l4rh2zIKwzADiO7jgZAMGjiwI6pHhFPHtuF8dcmvXxO2vn9TcrPOkkn3yFg3zLCZRo+6eUeUYKybNdx2+jchN+vu8W7Wt8ausH5DZtMj7y3F98etsI6n7x60meZNiOq4RGZzU9yMI2qC0fq7Me7W37xnsP7qejTGzfoP+v4LVIcJlNY8KsMOOr+lj5OKelHZHpLV7PPw3GEDrWLMtNEw+2Uw00foNAq7G4tdDUZhYIr9oTokVkDQVemIspooXpMVrdU1aCorQ0FeBQ6fyMG8wBP4x9LDeGjGAThOj4bm09PQLBRKhGZuDOzmxMBhfjIcFmXAbsl5aD6j44o02C+Ph8PCo7hveSR+viYO//RNxrj9GfgsKgteqUXYf74Sx7LrEFNhRlx5C2JKW3Cs0Ix9eWZsvtSIWcnFGH0wHb/yicS3V0bj3hXRGLyC0hT7O63PgsOmHNito/zEaifPZAxeHY0ha4/DcU0MBlN+qhNqVQrsPFOh8SAZU2BvSMMgw0lSKhzdUjBkRTJGrEjB1yjNhzdfwqM7CvHbXeX4+55KPB1WB9dIM15PaMeYZCsmprVjysk2vJ9mwYdpLZiRZsLMtCZMjS/DW6EX8cyWRDyxLALfn3kA979PbTXhAIZOPIqhk6Mx6P142E2Oh2ZSHDSTSe/HwH7yEWjGhULzttgXagcefMcbj07chn/N3IaJK3ywdKMvtm73g7+/L8IP7EZS3DFkpKchJzcHJRWVqGloRrOlFW3tdIdVz8vtdUQJdae1tVV9PK/V0o566jspl2uxYmcK/jFtB76uuMHhaQ/Y67fCwdVPXSlk5+wNR/02OCrbYKf4QvNCCJVnL4YofrhPvwY/fdUI5+lb8OmafdgcFImQsOMIiwhHXNxRZF06g8LCHNTUVaNRXQ1lQQvVm3o0/RP/baFO3FuOKAsaKf8TWeWY59PVEeVP6e1QN4W3V7xxv34dfv3OKkxYFggv3z04tm8PzkSHI/d0IsouZ6CuMBPm6hJYWqkNSerG4fS7FC8RaBMORlXimrjPPavj+1cX/Uf93Yt723lfO6Xeb9VJxY6oa0Xr7PZTG/OjWDF8S/44ZBim/2FrTJBBAwd2RPVI7ziibtUeRB0SDgeZdI+MdbdOt5VGz7o1jqgxK6yPjHWzWm3ncfOitCPHuVnXU3nn0Pk7492t/x5jsI4aZ7COpXZaQNc3keJtffdWiNr3hKzqTXPDjqg+rjFu1v/IKvYLeO7ohlYxTrbVKE56459kFKaP0GkUdjcWuxqMqoFJxmiHYUkGKV20CqNULLlooQ9moK2uFi0VpagrKseFc8XYGXkBE7zi8MSiUHxlWigGTTsGu9kx0Cw4Ds38Y6QoaOYlwG7uSdI5OCw8D8elGRjsdgqa5SmwXxyLEQuP4ntLD+MJ4xE8tT4KL3vHY2xAMj7Ycxqz43JVzTiejSkRl/DWwQtQ9pzF7/zT8P31xzHMLQyD3KPg4JkIh1UnYb/qDDSrM6ARx5VpsPekvI0xGOx5DI4rj8JhZRTsVibAfmUqHVOh8aSjdEQ5GFIw2D2VykbnS5Ngtzge9gti4bg4Afe7peGbq8/hR5suQ7ctB7/2K8CfdpXjqdBajDrcAJeIeow+XAOX8CooB8vxTFAu/ul7Dn9clwDtZ2H4wcwgPPhBIEZMDMHgCQdhN+EIBk2MhMPkGNhPSYBmyglV9u8n0LXjGDTuAOze3Am7V7binjc24ycTtuGvM73xxmdemL3aG6u8fLFjVwD27A9C1LFQnDoRjYsX0lFQXIjyGvG2tRaYVKeIuK/CudC7j+aJziNW11gs7RS3HU1NbbhcWIsdhzPwn0V78PDLq+A4ahUcXLbBwVVsSO4Pu1G+GDLaD0OFU0o4bsTb8lx2YajeF19/fh2eeHcl3pzvhWWb9sInKAJ7Dx7B4WMRSEyORU7WBZSUFqC+sR5NVDaxAohKSP2b6i7WDPXmiqh26YjKrsD87Un47cRdGEHt2+GICoC96w7YU/0ecNmI3723DpOXB8Hbbz+O7d+H9JgI5KQnoSznHOpLc9BSV4Y28dZDKqvq+FHrIla4Ue3kRv4da6KuQeKHfFUJxxKNCHQrRb8RPmi6qkqcf36H1bGhZ0cUXVUlh6ABCc2Hm7rPjzrF0OD09GcPyCgMwwwwrhgTSDJo4MCOqB4Z1xuOKDerm600blQy2Wti7A0/HndrHFECKsOLtvPo53KzFo/xsP6PrOZNc3c6ovrPI3md8NzxX8COGqCge4No9cYgGYHpQwgjUqi7sSjUGYY24YgSqx06zE5xTRiS6uv5pUVqaa6HuboMppIyVGSXIOV0AdZEZODlLcfx2ML9+Pq0EAz7aD8cZh6Cw5ww2M2NgGZuNDSzkmA38xTsP01XH9tz+OwUBi8Tb9hLguOcKNw79wi+MT8M31twAD9ZdACPLA2Dzv0IfrM5Ab8Rq4no+Oj6aPxo9XF8Z1UUvuoZi6GGGNgvE46lFDisOQ2H1Wdh53kWGvfTpDTYu5/AYEM8HN1j6HgUg0j2hmjYGZOgMXbsC6UxnFQfy9MYEmHvlgiH5ScwaNkJ2H+WCM2i2I6yz42hcsZjyGfJuG95Kr7udhLf9jiNH1B+P91wCY9tzoJ2cya0Gy/gsXXn8PNV6XhoUQK+M/cYvj4jFA9M3YX73w/EiCnBcJy8H5qJ4dCMPwq7icfoPAqaSWJFFOVJGjwxVn0cb8jbQRj6mg/u/c86fP+d9fjDVC+8stAXMzx84b5hO7b5+iJkbzDCjxxAcsJRXExPRG7OBZRWlKGqvgn1LW0wC4eLehPpfrb17mblnX2olQ7CEWVqakFFeT0iU3Ixdd0xjHx3M4br18BhtHg0L0B1OtmN2oEho/0xbLQv7BXxljkf2On9MZTK9t2X1uGvk9fi/RXbsdprD/x3hSE07AgiY6OQdiYZuXmXUVZegvqmRjS3tlLdKW8qkujhHUv6etkRRTqRU4l5nzui/KBRAqEZvRP2rv5UP198her+5HhvTHAPxWb/Izh0IALJsXG4kHEG+Xl5qKiqRENzI6VJpaTfpXCqqb9ZqkCbujKKrtG5uNZG7d2T1FVNPYiaRX1TJt0ymKj9mqn1hMRjgOKOitZUHU/SESb0+YoqUa5OiXsvJYegAcdIxV3XfX5U50hn9zkyCsMwAxBb44IMGjiwI6pHesMRNUE8/mQjjRvRWDfrMZnsNTHOzfqRrXR61q1zRAnGG6wf2M6n/0rsoySrd0u4+xxR1qi5czFIVq/fwHNHF3SKcbqtBtE5u1/zskym9xBuAiEyN69QZ9gXjijV3FQNTwsdW4WxKzwawjhtbUZzQxXayytgKahAcW41Is6VYMGx83h2czQenReCb7wfhBFT9mD4jL0Y/Gko7OccgWZmPDSfpNKR9GkSNHMTMejTVAyefQLD5ybgKwtJi6Jw7/wIjJh7CMPnh+OeRUdwz8IjuH9pFO5zj8bQFcfgsDQC9kvpuCwWjiuSMWxFGuxWn4PdSpLxPDRu52G/4jwGrcjAkOVpGLY8CfesSKDzo3BYfoTCYijOCdJJaFacJqVBQ3E0y2Oh+SymYxXUZwmqI8pucQLsFsRBM0+Iyj8/AQ7z4zF4PuVN14eRRlC571uQiPso7N45sbhnVhSGTY+E/RTK7/1wDJ6yH0OnhGDY5GA4TtoD+8kHoZl8FHbvU16ThROKNDEOdpOSYD8hHg7vHsGg13dj+Gu+eOB1Lzz81ib8ZvI2uM7xxzT3IBjWBWLr1h3Y5R+Awwf2IybqGM6kxiL3YipKCrNQVVOFmiYz6i1WmMXtFLdSvHmwrQntVtuOKM3njqjtcHjhSkdUfEyqdEQVoOyaHVGUp+hDdFmsimqlMplqG3HmUjkW+53AH6b44Z7Ra2A/eisGvbgTGv1O2I0STid/jHDdjsH6bbDXe8NO8cNQOj78ynr8+6MNmOm5A5u278HOXQcQFn4EcckJyLiYjry8bJRVlKK+WTyWJ5xwHXl3uE66OqLEY6eim1Pfv8IRtQvfeXkLhj+9A4M6HVHPb4Tj8+vwyLu+GLdsDzYFBvyXI6og/yLKK0tQ28URZRV7RLVbkJRTgbm+ifiN6oiitFyonq5Bnzui7h3tA+34QLztfhRrAmIREhqDqLhUnDyXjYuFVcirbUFli1Vd2WaiMnfuCSWOZqqbeo2O6mc6v5pEXOFg6knq1nDUdmqapE5HVKczirqV6tSytpuvcER1OLy+cEYNdEeUVm/07T4/ahVD+Q9enztURmEYZgDSfVwQkkEDB3ZE9UhvOKIEttK4EYk9n2SS18Q4N+uHttLpWbfWESWgNBfbzqv/aYzB+rys1i3jbnJEjXWzZlzPHl59CZ47JE88s2G4Vm+ovKJBFKOPjML0MYRN/oW6/5PXxaoIMiCFe0r8VyyCEo4oizAqSWSjwtxmQrO5Hqb6ejRU1qgbl5/Lr8SBM0VYHHoar6wOx68+DsS3xu7AVz8IxvAZBzHk0yg4zEqA5pN4aGaKfaOOQ/PpMWim0fUZcRg2NxH3Lk7DvZ+lYOjCRDjMj4P9AtIi+s78WDgsSYDDcjpfHgfN0hholsTC7rMkDF56EkOXpcNu1SVoPC5As+Is7Jadw+Bl5zF82VkMX3oKIz47gXuWJmIofXcQyW5ZIqWRTEqDHcl+qVj9FA+7xVSmhVEkymNJIl07AYfPkul6EjQLSPPoe3MSYfdpHBxEfWZHwX5WFOxmRMLuY/ruR5HQfHgUmvcjoJkcAbspx2H3wTEM/jACQz84hMGT98Nu4j5oJh6EZsoR2H0YDfvJ9B11VVQ07CbEwH7MUTi8FoKhL/nga//ZjIff2Iw/TdoM15nemLw0AMvX7MKWLYEI9NmBg7uCEHfkEE4lxuLyuVQU559HRUURahobUdfShka6eXRQV/7AYgZaG9HabkZhfTv8YkqgLIjAt1/0waBnvWDvvB326qNjXnAYvVV1RL2xaBPW+wbhUNhhJMUkIeP0ReTkFKG4tOKaHFHqqhm1JwFtYhWSyYTWhkZk5ddgfegF/OuTYHzlpU2wEyuiXgiCnetuyj8Ag112YMQL2zHM1RuD9T5q2Ybrt+Jnb66H6ycbsWjNDnj57cbu4P2IOHwUyanJuJR1CYVFBaiorkSj2Qwz9WPVYUJ5i17bbhWrdcQjZOaOFVHCWdRC11rN/+WI0s8PxHdf3IJ7n9kOx2eoTHqxgmkblWUDnN71wthlQdgYFIyIg2FIiYlSHVFF+ZdQWVmC+voGmEyUWivVub0VDW1tSMquxHzfJPxuYjDuc/Gj9AKgcd1JdQ6AHdX1Htcd+Pl7/pRvGGZviMRKv0hs35+A3VHnEJpWiIgLtYjNaUZafjVOFtTiVGEdThfVqxLnnZ/TixuuSacL6bsF9B1xtCUKO1PUgDMlFL+U4pdR2qV1uFDZgCKTBXXUpo10n81UN7HqS7zYoHM/OXXvKjlOtFIcIdEDhOQQNKDQuhh/e8X82KFpMgrDMAMUG+MCO6KuR+yIuqrk168ZMsyTbaVzvZpgsP5SJnlNjFlxoyuRbr0jSkDpfmI7v/4iq2nsCuu/ZHVuKXeNI8rNmjfOaP2FrFa/g+cOiVZvmGurMZxGuTvJKEwfQ/UO9EDnCoYvF2CxmCDeSFZChv0lUz0ulBaiOCcX5RfykRJ7Hj67YjHWbS9+/aE/fjhpNx748BjunZmMwdNjYDf9IOxn74fDglDYLwiDwyfiTXvHYT8nHpq5ydDMSevQp2mwE5p7EpqlUks6nEIOpEGLT5BS6fwU7Befhmal2JT8HDTL02G/5BSGLEzDiIWpuIfiDKPvDVqYiMFuZ+Hgfh52Syn+olRSChyWnICj0MI4DJoXCft5sdAsPEH5nKB0klXZLUqiciRSORNgPzMBgz6Jw9AZxzBkRiQcSYM/PoZB0yLh8NEx2E+NhN2HlA5pyEcxpCgMnnoMjtQGgz+kun4QDrspYbATq6ImhcJu/AFoxgmFwX7cQTi+E4x7XvHCt15ei8feWIM/jN2At2auw8eLN2Gx0QfrNvrBd7sfQgIDcPTAHpyMO4Ks9EQU519CRVUxqutrUdvSiiZrx2NVYnWLtc1CN60J7S0NMFnMKKhtR0BcGVwWROCbo7fC4d+bMUjxxSDx6NhzW+GobMLP316H1xdvwVq/nQg/GIqU6CicP3UWl3NKkFNa2+Nm5eK68H+JK8JBYW0zURnoO/V1yC9rxt6kCryx9BAeelu8Rc4bdqMDMeil/epjaxrFG0Ne9sVQV284PuuFQc9tw1de2oxfj9uIMfM3wXOjL/wCd2HP3gOIPBaF9NTTyMvOQ1l1FWoa6mFqtagOKCHRZ4UTVbw9r0U4SqhE6pvgxNKfZjO1iRktdC1fOKLicjB6ji8eHr0ZXx21FUOd/WGn7CYF4l7XLRj57jq8u9Qba4PDcCj8IJJij+LCmTSU5GehtqIEzfU1aBHOtlbKhzKvox9LYlYVFvkk4c8TgvCgs6jLdtjr/WHvEkTHPZRuIH702lb8cqwvnvo4CC/NDcZbi0Lw7vJQvOdxDO+tS8b4zafw/rY4VR94xeND74QO+SRi6vYkfCT1sV9yjxLf+fz7X6JJ25Mx0TcNk31T8L5PAqb7RMN9XzKOXCpFnrkVFdZW1FGfaqF2FI4nqCslrWq7ij5gEY4qanuxcqsTOQQNKHR6Q7CNOTJfBjMMM4CxMTawI+p6xI6oq0p+/ZoZ625dZCud65VM7poZ52adYiudnnV7HFGCMe7Wibbz7Nsa62YtGO+G/5XVuOXcHY4o+j25Wb8nq9Qv4bmD+Lnzqge1ekNT94bQKsYNMgrTB5E24VURqxeudD51Exn6zW2tqKL4he0WFDXUorqsAjX5ZTh/Jh/hsRfgGXIa765JxF/mHsYPph7EfR8chOOUPRg0dTccP9mLwXMPYtCcw3CcJVcWzY6D5tNEUjIpFXZz0ijOSQyelwbNwjTYLUrB4PmJcJwXhyGkofPiMXR+EoYuSMXQhafU1VGaxUmwX3CC4qRg2LyTGD4/HcMXnsXgRWcpjQwKJ312hpTeoSWnSCdVh5TqfKLvOixIwqAFCXSMh9188TheDDRzYmA3OxoOM6MweGYshnxyHEM+PoAh0w9KHerQx+FwnEZ1mhaOIXQc9mEkHN8/AvuJYmPyA3CYdBCD3z+EwR+Ew4GOmini80E4TNgLuzHBcHjbH8Pf9MK33twAp7Hr8a9pW/H6In98vHw7Fnn6wXPjTnj5BiNk9z4cOXQQyTHHceF0MgoyM1BWko2q6lLUNtShwWJRHVHCGdDhiGqjk2ZYLQ0wmU3IrbJge1QhRs05hK/qN0Pzry3q6hz70UHqhuFDX/TFL8ZuxRvLtmOt/26EhR3AiagonDt5BtnZBcgrLrPpiOq6IqrTESWuiJUz7a1NVIYGWM2NqKpvR/TFZszySsNjk3bC0WUz7Ef5wEEfDM2oQGie2QoHZQscRm3AkGc3YgSFP/TGVvy/qV6YuoLK5BWIoF0hOBgWjvi4eFzIOIvC/HyUV1ehtpHqKN4wRzl3OqOEI0o4oYQsbS3qiijVQ6au6mlT2ym7uRVbYrLh/KkfHnLdihHPecHhOX9onMXjeYG45/lteOy9DXhziTfcd+xH6KFwJMTF4FxGOorzc1BTUYqm+hqYzWa0UsWFn6uejslZpVjoFY3/HeuDrz6zEY7PbsVgvS+GuAZhuGsIBjtTHk9vxHC6D99+fiN++NJa/OjFlfj+i6vw3f9swEOveeM7b/riO69v/UJvbMND1E+EvvumN7771rXroTe8Or7/ZaL0vv3ySnznRTf84GUDfvrKCvzybTe8MN8LG8JP4VRZA4osbagRY0BrC1rUN/Z1OKM6HVHiEV6xN5dwWncih6ABg87F+Jfu82OHPCbKKAzDDGBsjQ8yaODAjqge6TVHlMH6R1vpXI/GulkjZHLXzDiDdZKttHrW7XNECcYZ8HeqT5btvPueqKx73vawflMW/7bQ3x1R1EYbZVX6NTx3EFq9Yamthnh8tPtPZBSmDyJtwqtyLY4oMxnyDWR0VlP8cjLyK01NqK+sRG1hKfIzS3D6XBEikkuxIbQAEzek4P8tCsfPZuzG16Zsxz2TvTB8aiAcZ4TCbsZh2E8/BvsZxzv2j5otnFBp0MwVb9c7BYe5p1Vn1NBPUzBkdhKGzUrAULEaiTRMSHym6yLccV40hsyJxrDZ0RgxOx73zEqh4ykM+fQs7EiaOedJqdDMO6E6tjSLKA9xXCCuUb5C81NhPy8Bg+Ych/2nx2E3m8o1O5LKRsdP6BqVc9D0KDh+HIEhU/eQ9pL2d1GoKscP98PxAzpOOgT7caHQvLcXmrH7VIfU4CnhGDSFrk8Sq6D2wnHcTgx6dzsGvbkFw19bj2+9sQpOYzzxr4/WYswSL3y6JhDL1/pj5YYAbPYOxs5d+3EoLAJxMTFIT0tG9qXzKMrLRlV5MerqqtSNrZva2mCie9PpiGqnz9ZW+tRuFg+poaTOisD4SrguOo5vv7gD9s/6Q+OyB5oXqKyjd8NhtA9++N5WvLzEDyv99uLggXAkR8fg0ukzKMzNVzcrb2xsvOqjeepncSS1tVnQJhxRbQ2wWhrRaLbiTBmw7nAu/jpnH7760mYMG+WDoXpqD9eDcHAJwiAXbziMWocR+vV44IUN+Mnbm+A82wdzVu/AZr8ABIcE4/CRCKSknEDmBWqDggJU1NagrqkR5rbWz51Qor9aqM7CGWWxCkeU6QtHVLsVbVTORjrNbG7D1rhCjJ63m9rED8MUP9grO6k99sDhxRB89VU//HLiNrznvhOewUewLzwKcXEncDaD8s7PR01FGRobaqhNTOpKIbF/E9UYpwsq8JlfLP4yYTu+oWzCcGcv9a2AQ/QBGDIqUHVEOdDnYS7bca9+C77ivB73j1qFEaNWYwidD1K2wkEv9vDygl2nFLFvFknsn6UXm7lLdV6/CYnVaI76zRjhsgn3umzA/c6e+JZ+Of46ZQuWhaQivrAJuRagzGJGnbkOjZZmau8Wusdi1ZtYbUb3ndpWdIWO/iDcUa0DbpLUKsYDNubIizKYYZgBjo3xgR1R1yN2RF1V8uvXha10rkdj3a3X/dj5ja8+ur2OKMG4z/AA5bXzyrz7lsa6WT+VRb6t9FdHFJX7/DiD9VlZjX7PgJ87dKPdH9IpxvYrG8LgKaMwfRSyCHuk03lwNVna29FAqiKDs4KM+VoyvhtqqlBbVICirAJkXS7G6YwKhMeUYf2+C/h4+wk8vzocv527HQ9/uAEPTvHCiPd3weH9UGg+PNyxt9In8eqjePbzMuAw/xwdz8Ju7hm6dgqOn6R0aOYJUpKqwaRB9NlhVooqx3mxGDonGsNnRWPEJzG4Z0YMRkyPwbAZsXCcHo/BMxIwdNZx3PPpMdw39zjunx+Nr5DunxeFe+Ycx9BPozCEwgfPPNrxuOAnx2A/8zgcZsfBfnY87GeRZtD5x9EYNO0Yhn4UTjqMIVPD4Sj2fyI5CAfT5DB1M3L7SWGwG38ImvFhpHDYTYyAw+SjGDRFrJCia8I59VYQHF/diuGvbcSDb6zDD99Zi19PWINnP1qLd+etx2y3LXBb44O1G7Zjy1Z/+PuHIHT/IRw/Ho2UlBScP3cOebnZKC4pRG1tJZqb6tUVT2KTbvFYVIcLAOqb1SBe/d9mQoulBQVVbQiMLcMLiyLx0Es7YP+cHzT6EGhG0/1wDoa9fht+8M4WvLzEH6v89+PQoaNIi41HVvoZlObmoLK0SHVEWSxizyXRI6hfCMeTPBd0nItdxsTKKAva2oQjqh5WUx2aza3IqgGCkkvgsvwQvvXyRgz610bYPbMbjq4RGPR8KOzEY4JPe2LQc0Z89YWVGDl2PV5d6INlmwLg7R+gvi0wMuoYTqefQs7lSyilvldTV4fG5ibqn+IBvI6+2k7l6Lp5tuqWUveIorBWq9pW9RTvcnM7vBPK8dLiA/j6C75wHOULO+cAaFyCYPd8AO55aSucxm7Am8sDYNx1DCHhCYiOO4UzGZkoyC9EVaVYJVYDs0W0f4cjsMbaioTsIszzOY7fj/fGV503YvAosQH7dtg95wvNU9sx6N/0W1C24J7n1uPeZ9fgvmdXklbh3lFrMFzZgCH6Leqm7YP0Pp9L7Js12GX753IcTeUldY3zZRpMeXf97pUSe3JRn9DvpPNADHluG+6n8vxmvA/mBZxGZHYzztdbkddYh/KmMlSbalVnlEVdGUV3u9MDqN4AdbRQJYegAYGTs/FfV86PRjgphndkFIZhBji2xggZNHBgR1SP9K4jyhptK61r1Rh3q04mdc1QnuNtpdWzbr8jqpPxK6yjx7pZz9kux52UNWjMCusjspi3nf7miKLyXhy3wjpeFv+uYcDPHcLhdGUjGKxOiud3ZRSmj0IWYY8I07EnCTtT7D9UT8amULN4vMlUj8bKYlQW5qMkrxg5F0qRllyIQzGX4X30PD7bewLvbdiHpxZvx8gZPvjelB24b8IuDHr/IAZ9cAh2Ym+l6Ymwm5UKu0/TYTcnAxo6amafgt0nybCbmQyH2amw//Qkia7RUUOfNbNSVNnNjqHvRmHQjKMY9vEh3DctFA9O24NvfxyC738SgodnhuCReSHQzd+DkfN2Y+T83Xh8IZ0v3ItHFuzDj+fsxw9mheDBGfsxnL4/dNphDP74KOynR8Hhk3jYf5II+xkJ0HwcC/tpMRgyLQ6O02IxeGocBn0YC4cPYmE3JQaaydHQTKLjxChoxh2m41HYTT7eITrXjDukOqHs36a6vxmIb76+DT98eysen+iFf0zzwX/m+GDKEi8sMHjDuNoH69Z6w2frduwKCMLB0DBER8UhNfUkzp47j6ycbJSWlaK6rhaNTQ1oMTfB0trSsVG0vE8dxzZYrXTW3qI6onIrzPCPzMOL8w/h+y9sw5BnvdRVSPYv7INmdBAcR2/GT8eIR/MCsG7nQRw+HIm02ARknT6NkuxMVBRl9+iI6qDDI9GmvlHNTIVpQHtTNZqbm1HQYMXhjDKM2RSP/xnjC8d/0x9rTwXAYTS1+0thcHD1h+a5VXBQVuKhV1bhr1PWYcIKX6zxCULgrp04ELYPCUlxuJh5ASWFeaiqKEVdYwOazSa0Un/8vK92cUKJf6Jl2lqpPJZ2Kn8rTMKpSvEuN7fBO64YL1Ff+M6L3rhH74UhLr6wH+0HO5ctuGf0Kjz6tifeWLoDHsGR2B1xAlHxZ3AmIwuFBcWoqSxHU6NwRDXBTG1topwqKM/jOaWY5RON30zww336LXDQb4f984FweF7sEbULjsoOymsrho8Sq8I2YajzJgxTNmMoXRtMZbBXxEbyXhikbL9CqlNJ7/u5bMW5Xok07cQKued2wU7ZBYdnt+Pep9fjl+/6YKZPCsLOViOtpAGZFSUors1DeWM56sWLC6hfiYVmVGXh/RvQjiitYjzWfY7U6o2nZDDDMH2Mv02J+cvfPoiZJz/2Ct3HCCEZNHBgR1SP9KYjauwK62xbaV2rZDLXxVg36zhbafWs3nNEdTLW3TqdynvHH9ejckSMcbcqsli9Rn9xRIn2ob78uiz2XceAnjvEo3e2GkA8qiejMH0YsghvCWKVi3B2tJCxKaS6G9pNsJgq0VxVhvrSclTmlSLnfB5STmbhcPJl7Iw5i1V7Y/CJ10G8YgzBXz4NxCNT/fHdj/bgGx8E456JIRg0fi80YrXQ+8eg+SgGmmlxsPs4jo7Hofk4uuONe7OSoJl9gkTHmQnQTI8lUdi0w7CbFoah0/bigY924nvT/PDoDC88OXsr/r5gC55ZshkvrvDGq6T/LNuKV5ZupXMvvGLww/NuAXjmswD8Y6EfHp+zC9//ZB++OW0P7v1gLxwnh8J+Sjjs3j8KzYdUrqlH1c3IB70fB4cpsXCYHAf7ybGwn0RlnUhlVZUAuwl0bUwY7MVqqPGHoXmP6vXmHmhe2wnH13fgK2/74Vtj/fHrib7429QAjJ69E2MWB2ImlWX5Sn+s3xgAr60B8N0WgD0BOxGxfx/io6Jw+uRpXLyYieycPBQUF6G6thpN5ma0tJjR2iIfkaJ7o/oDVLeLULtwRdGVNrS2W5Bf1YwdRy/ixdm78LDigWFPGTHkuY3qahixN9MIuvbIOyvx5hIvrJMrolKi43GZ8i7JuojyoqwrHFE2sYpc29VVSeJtjGg1wdpcC3NzEypMVpzIqcaCPRn43+nBuP+5NdD8bSPsnguAo2sgaSsGjzLiXhfhAFoLlxkbMMPDD5t37ELInt2IOHIQKeLRxJxslJcWo0a8La+pSd2jSawAE6US/bRdOKBIqqNM/deqlrvVIhxkbWJ9lPpoXlZDK7yPZ+HlWQH4nn4VHnh2JUaMWgNHRcgDX9Uvw8i33PDOMl+sDYlCyJFkRCWkI+NsFooLilBfWQpzQyWl24QWqncL5VRJ6UbnVWHW9nj8esIOjHDeCM2oLdCMpnZ23YHBrgGkQDoPhP1ooZ2wf34X7F8Iht2LwdDQubp5u3hzn17s39VNYrVWF4nP1yRbaXWRWA01iOI5uuzEsOd88MAz6/DE21swfWM09ibn4kRWMS4UZqGg4iJKagpQ3VSDRovYL6rTESUknFHiZGA5onSKh2JrjtQphv/IKAzD9DGEE+rvH8ZCHHvLIWVrnJBBAwd2RPVIbzqixq2w/tpWWtckN2uYTOa6GO9uHWMzvR7V+46oTsausL5I9T1qu1y3T2PdrIHjV1j/JIvR6/RlRxSVLWacwbqwN1eI3SkG9NwhNiPvXnmxafmvnVc9KKMwfRiyCG8J4vEm9bXtbWToi4U2ZHC2o5kM+1q0NdegtboWzRXlKC/Ox/lL2Ug6k43jaZkIjTkN37BEuO08jikbDuCF5UF4an4g/nemLx593wsPjduGB8b44J5xgRgxKQTDJ+/H8PdD4fj+Hjh+sB+Dp4ZhsNgMXOzRRBpG58Pp2ogPQ3Hf1GB8Y1oQHp7uD6eZPvjjp1swav56vL5kNSa7r8YMz9VYsGYdFq9Zi8WrVmMJ6bO167Bk4xbM27AdH6/zw5TVO/CSIQh/XxKMJ+fuxM8/DsR339+Fr07ag3uoLEOn7IfjlH0YPImO4w6RwuXxEAbTeYcOk47AcWw4hr0TjGHv7caQd0lvklH/mi8eeF089rYVugnb8IcPt8N1dgDeWRyMqW67sMAzAIbVvti40Q87fAOxO2g39obsQ+SBA0iKPIJ0sR/SxUvIzy9CSSm1b1Ul6hpqYWppQqulBW2tYvPtTqdLV0eUkPgs3h5nRm5lPQKOpuP1T33xC5cl+No/F+CBp5fj/ueMuPc5N3xTWYIn3l6K9xatw3qfXQgLDceJ43G4dDIdJbmZqCjLQ1MT5dlKKV/FEWVVnUDUR9qlg4Lio7kBluZmNNLphfJmbD6ehReX7MePX1yJ4f90w9BnVuIe/Urc77ICDzy3CN9zccOfxq3HO/O9sHC1P7YHBCM0lNrk+BGcPHUSObl5KC8rR21NjbrSSuxbpW6ereYv8qYyqAVQL6FVOIlaLNRXO1pIrBZrpsC8eguCoi5jLPXHnyuf4Tv/WoivPb0YX3nuM3zVeTG+77oQv39vKcYv88LaoCMIiUhAVOIpZJy7iNL8PDRWFMFSXw5rS6Pq4BLtXU35xmaXYL5vDP538nY8qF+Dwc+thoMzHZV1GEoS+zFpXHyhGe0PjWsgNC8EQfPiLmhe2gW7F4Ng/3yAujrMYfROVR0OK9tycA3qUaqzy8Z3v9BODB7tjaGjhUNyM77y7Dp8Z5QHfv/WGkxfGYrdkWlIzDiLc9npyCtKR3F5NirrK9FA7W6mZqYhgdqdKi/+84VXauA4ovSGhO5zpE4xJMpghmH6IJ2OqE71hkPqinGCJIMGDuyI6pHedEQJbKV1TXKzfiiTuC7GueE9m+n1qDvniOqE/iT8/lh362QqS6TtMt6cxrpZm0l7xhqsr1Ne98ts7xi97ohys1pITaQaaodyyv80tfUh0jb6PJ+Or40xWP8wfi7ukUUcEAzYucNplLuTrcrrFGOvLmdmbhyyCG8JVquJbMxmsurJyBRbD5Fh39LWAIu1FlZLPdDQCEttBSprcpBVmIuzWYU4fa4QickXERl7GnsiU7DpYDyW+odj9rpATDb64eWF2/B/M7fiN9O24dGpPvjJB374/pQd+M5kP3yTzr/xgT++/sFOfO2DYHz9wxB8a+oefG9qCH740W785KNd+OUMP/xhti/+b74vRi/xwdvLt+JD93WY77EKxtUrsW6dJzavN2DbBgO2bzRgx2YjdnitxHafDdji54M1foHw8AvGAu8QfLhpD95bHQLXFXvwt0Wh+NXcg/jZzAN46KM9eHBKEO6fGID7xwvtVHXfuEDSTtw7tkP3jAnCve8F4sG3ffC1d3zx9Xd34KGxO/A/4/3wqynb8c+PvfHip954e743Ji/3x6yVQVi+PgBrNvlg8+Yt8PPeij27/HHo0H4cOXYYqbFROJuchMyzZ1CQm4ey8irU1DWgoakRTSaxL1QdLBYzWrs6ooQTiP6J1VDCKSIk3iXX2NaEvOo6hCZcwDTPEPxz3Go88aoR2tc88Qjpp68YoHvDDU9Ndsc0t43w2hGMiNDDSDkej0unM1BckIPKquLPHVFXQ/gihA+orXOljKUN1oYGtIqNziksr64NYadKMHvzMfxzykY89poB//O6O37y+jL87JUFeOT5uXjy5RVwnboVU913wn1jMHYG7UFEeBji42KRfuYscvOKUVlRi4a6RphMpv9yjnU6oTocUR3OOfXtedRvO2K0oZX6crPVjNJGC46mFGLhmsN4euwa/O41d2hfWYGfv+KGR153w6/eXY6nP3SncnhjbcBB7I6IRVRiKs6eO4uy/Cw0l+ejvb4MMNdDvKVQrBKst5iQlp2Hlbti4TpnFx4fux0/escb33trCx56YwMeenUtHvrPWnzrpfX41sub8Y1XtuHBV71Vff01L3z79W347hub8P03NuO7r29X9dBrPl+qzjhXk63v/be2U76b8c1X1+HbL6/HD19aB90rq/H0xPWYs2o3Qg5HISE1AWcvJFDbp6GoJBMVteWobzHDRM0s1j+JW00N/vmZQA5BdzUj9e4v25ojtc5GvYzCMEwfpLsjqjccUrbGChnEMEw/Y+5cOI53w/+OX2H9YKybdXuHc8p6mdRi08nSRcLhRPEuqqus3OBF5+PfM1h/JZNmmP9iwM4dOsXoY6PylU88s2G4jML0caRNePMIJ5RQGxmarVa0i9UQlnpYrHVk9DeSMU5GaWMFyuuzUFhViLySKmTlVCLjdDZST5xFXOJpHE48iZDIeOzYtRcb/EPw2ZYgfLRmJ94y7IR+6U78fV4Anpzpi19O98bjM/2g+8QfTtP98djH/tB9HIBfkX4/IwB/memP/5vtjxcX++KNZX4Y7+6Hj1f6Yv4ab7it3YQ169Zh24ZV8Nu0Cv6bDAjaYsAeb08c2LEaBwPXY3/gVgQH70BgSDD89obCa98hbNhzCMagw5jndxQfbD2ON9dHYZThMP64IAS6GX74+VRv/OwjH/z0Qy/85ANv/Ph9L/xoshd+OGkbHp60FT+YuBUPj9+CR8ZtxmN0/sv3t+OPVPan5+zEK4uDMGlFIGYad2CBhx8WrNwOt43+2OzjD19fHwTu2II9u7YhIiwIMdHhSDwRhYtnUpF7IQOFOZdRXlaK2voGNLdY0NpGajXBYmnoWBElVqh97ohqQ5u1lW5PhyNKOEaEI8oEM6osrUil+7Ht0EnM3nAYEwyheGfFPry6ZDdc5+2A6+wtGLNkC5Zv3oHgPQcQdVjsEXUCmWfOo6gwD+VVJde0Ikr4IjqdUR2OqHa0NTTBUt9Ip1aUNLQjvbAZAZHnqBwH8fbyQLy0ZDtGz98M11lr8PzUlXjjo834YEkQFq/fjw0+odi7JwwxkVSe5BT1EcXC4jLU1FB7NJrUxxM7H01Us6djZ3uIgoir6uow8WY38dlqgaW1AabWJlSbWnE6sxp++05j0YZIfEht8taSYLy4IBDPL9xB980HE1b44LPNwfAOicC+ozGISUrGhfNnUVFwGebyPEB1RDVQJtTulId4m1xeeQX2x13EEt8kTFgdizc8Y/CiIQLK0n14dv4uPDfLD/oZW+E8wwvPztiOf033xVPU5//9sRdGzdgGl5lbMHoWhc/a8blG0e/htukTPzw9Pwj/nB+Mf80JxqjZu/Hyp7swcWkQPLxDERpxHAknonHubCzyc1JRXHwJlTWlqDeZYKI6W8T9Fm2v/lf0ug7kEHRXo9UbTnafI7WKIVIGMwzTR/kyR1SnbodDqvtYISSDGIa5ixCrmSYss35nzDLr/4xfjpGq3K0/eddg/fYkT+t9MhrDXBMDcu4YqXj82lbFdYqx95fGMjeMtAlvHvH8jUU4ocjQFM6I9la0tZvV1SUtQmhGY1s9qkxVqGisQnl1FcrKKlCcX4K8izm4dPoMziYlITk6CmGHw7Ev7DB27g/Hlt2H4BF4CPN9DmLqpv0YuzoEb3qE4CX3MDy/fA9eWhKI15dsx7tLtmD8orV4f4EHpi1yx6zPDFi4ygtL1vpg+XofeGzywdotPti8zQc+Pj7Y6e+L3YE7ELJ7J/bsC8b+A3sQFh6KiKOHcPRYuKojdH7kyEGERh7DrshY7Dx8DP77D8M3+AC2BITA08sfi9duxix3TzLKV+PVJT74z8KteGHOBrjOXgfXWevw/Oy19FloHV6m47hPPTFhvgemLl6JT5avwTzDeiz23IwVa7zgsc4XqzYGwnvzdvh7+1H5AnBgTxAiDu5G9NF9SI49irNpicg8k4as/AvIK8tGaXURahur0WwWG5Ob0NrS8QY41dPU4Xu5KsI50EL/qi1NyKmpQWpeCY6kZyMoOh1b98djlf8xuHvtx/Kt3vD02YEtgbsRvD8Mx6g90lJP49KlTBQUFKC0vPzzx+C6On6uRDgjSKojqONUPMppMYkn9Kww1bcjp8KMpJxKhKVdgs/heKwMOgS37fuwYsterFgXTO21A2vWByPQ7yCCKexQ2DHExSXgzJl05ORmUr8qRnV1JZqaGlSn0xeOuCvLpF6n5rK2tVPXpf7a3kxFslB3tqLB1IbC0nqcv1SGsPgcBEWcxbZ9J7B253F47giHp28o1u0IhXdwOPXVSGqT4zidegL5ly+gpiQXTRX5sNSVAi3CEUVpm5tQQ2nm17UhI78GsadyERaTjt3hSfDdcxwb/A7AuHEnFq/ZgTmkT1f5YqaHNz4xeqnH2Z4+6rU5q/0wlzR/za3RvLU9a9Eabyym39MCz+1YtDIQK9bvxVqvA9i+8zD2hx3H8ZgEXDh1ApWXT6KqKBN1NaVoaKpHk8UCM7VlKzW9cIq2UTt33gs5BN21aF2Mb9maI0fq3f8tozAM00fpyRHVqVvpkLI1XsgghmEYhrHJgJw7tHpjUPdKaxVjoWbuXHsZhekHSHv85hELHYTzgyxOYdQL419sgt1iNaPzXzNMaLA2ob6tCXUmUn0TqirrUFpYjoLMXOScPYfzJ08jOSEZsbFJiDgWi5BDUdi+Lwrrg4/B4H8ES7ZHYIHPYcz1OYpPt4Th0417MG/DTixa74fP1nlh+ZpNMK7biNUbt2DtZi+s3+qDTV5+2OobAJ+AXfDftQdBe0Kx90A4Dhw+isPHjuNYVDSOx8YhNjEJCckpSEpNVZWYQqLPsUknKDwex45HI+LIMRwKO4LQ/YcQvHsffHbsxPptPjBs8cWirSGYvzEIc9b6Y6ZwInj6YNZK0ipvkg9mr/TCfI9NWLxyE5at2QjDuk1YuWEL1m3ahi1bt8Nrmx98vQMRsnMPDuzZh4iwA4g+dhgJsceQeiIGZ0+nIPviORTmZKOgvABFZOxXNtagwdwIk3B0iA25xYo04W+50udiE7E2yoQm1LY2orC+ARfKq5GSU4roM3k4lHgRe4+nY+eheHjv3Qvf/aEIPhiOw0eOIz4+CenpGcjOzkVxSSkqqirVx+AswhEmljt9Kd0cUeJA/YaKD1NjO5rr21He0IbMykakZBcj4uR5hESnIOBwHPxCqS8EH8G2gHD4+YcjJCgCB/ZHIvJYHJKTU3HhwjkUFOSisrIMdXU1VJ6ma3JEtba2q86ztnbxdkETdWUz2q1taDa3obSySV25d+piFeJOFeFQwgXsOpqKHQfjqD2Owz/0KELCoxEWmYjYuDicOZWKwuxLqC3NR1Nlxx5RsDTS74PSbjHB3NqGenM7SqrqcSmnGGkZmYg7cQYRkUkICY3Ejp0Hsc1vNzb6BGK9lz/WbvXDGupba7b6Yt22HVjv7Y8N3gEkf2zy3nFLtMGnZ23a3nFc5xVA5QrGVr9Q+Acdwr59EYik/pASH4es9BOoyEpHTXE26mvL0NjcoDqiWqiNxfAguoVwRg0UR5ROMVzoPkfq9IYb2ryVYZje5VodUZ26FQ6pK8cLdkQxDMMwV2fAzR1OeuOfbFVaqxgnyyhMP6HDHL8FCN9CKx3I4lQNTpKFjHnx2vqOV9e3opnUBAua2klkoDY0W1DfYEZ1VQNKiytQmFuIvEs5yCTj/OzJ80hOPImoqCQcjojHvkOx2BUajYB9UdhB8t0TBu+gfdjmv5sM953wIkPZy2c7vH28sN3XG4H+2xHk540gsfJpZwD2hOzGvtADCA0/ikORcTgSl4LIpHQkpJ5B8qkMpJ45h9PnLuHMxcs4eylbVcbFLGSI8zMZOJtyAmeSEnE6NhZpUdFIPhaJ2MOHcYTSPBCyB7t374H/7gPw3blX3UNps08gNnn5Y6MXGfDb/LBhq5AvNm31xhZvHyqvF3x9t8HfbxuV0QshgduxPygAYcHBOBoegWhKPyE2BsknEnHqlNh36AwuZ2Uiv6gIJWUVKKmvR7mpETUtJjS2tZKx366+lExFOniuBeGIoruB5rZmVJmaUFRTh6ziSmRkFSPlTBbiU87jeHwqDkYdQfjxozgadQwx1AYpJ5JxNuMccnLyUFJShqrqGvXtdOLtc1d1RKnLj4T3SZxL0aW2FqClmdQEVDWaUFhdi8ziMpy6nI349LM4diINh2MScTAiGqEHI3HwQBQOh8Uh8mgikhLTkKGWJQelpcWora1CY2M9WqhtujqibNFOjWZuFW97FI8tSkeUVbxlj9q0pR11tRaUljSisKgRmdmVSDuTg+gTGVSWFBw4Ho+Dx6gvRSchmsqQnJKCi3SfSvJzUF9ZAnNtOdqaaoBW8diq2DheyIxWqmRTQy2qKspQlJ+LzAsXcSo1DXHRsTgi+uf+/TgYEojQ4ADs3emHPYG+6nFf0A7s3+WP/XRdPQaJPuN709pH2nsV7aN89uzegWAqU1DwTuwK3o09e6mMBw7h+KEInIiKxNnEWORnpKIy9zxqS/NQX1eJBuqfTVRn4YgSPULcAtE1BoIjSqcYJtiaI3V697/KKAzD9GGu1xHVqZtxSNkaM2QQwzAMw9hkwM0dOr1hf/cKaxVjpgxm+hEd5vjN02lkCgeUeAxH7AsjNp8Wr6w3kcQDT0JNQtZ2NLaSyNBvaG5DXb0Z1dUNKC+vQUlRBYpyS5BzKR/nMy7ipHAUJaQhMTYJcTHxiImKRVRkNI6F78Ph0N04QMbx/t0B2EfGudjMO2QXGe+7A3FwbzDC9wXj8IEQHD0Uisgj4YiKOo7Y+EQkppxC6ulzOHnuMs5dzMLFzGxkZuUhWzjCCopRUFSqKr+wBHmkArEC6eJZ5J49g6zTJ3ExLQXnhIMoPg5J0VGIO3YUkREROExGeRgZ5/v2HsDu4L3YFRSCoJ27ERi4GwGBwQgI2EWfyZAPCkBIsD/2h/ghbO8OROwPQOTBYMSE70XikTCcSIhHavIJnD6VhrPnMqh8mbicl4/c4lIUVdaitK4ZFS1tqKLGrm23opEa30Rt3UrnqsNFeKTEUfXyXB3xtsM2NKClvQmN5kbU1NWhpKxSbYvz5zJxOu2M6nSKT4pGAikxMRYpyYlIp3a4dOkiCgoKUVFRjdq6RvWxPLFH1NUcUdZOp1CXoom9otos1GfMVBozqAxUx4piFJYUIisvm+7ROaSdTkPCiQTExEbj+PFjiImOR0L8KSpbOjLOXEBWVg6KiopQVVWFhoZ6mEzNqlOs0+lhC3FdOKKahSOKCiHea9dGPVY4o1rbWuj7bTA1Uv+ssaCypBaF1C8vnb+MU6fSkUhtEpuQgOj4BMQnpiA5NR1nz2YgJzsTFaVFaKypgLmhBm1ifyjhZbO2UT3b6LQRluYamBur0FhbhqqyQupfmbiYcRonqX6JMaI/hSPu8F5EHwrB8QPBiAzdhUg6ivPj1E+OH9ytHiNDd/aaIg4FIYx0kPI9dGgfjh4NR/TxI0ii8p5JikfWyRQUX8xAdUE26itK0NBYo/anRqq7GANEj1Bvu+yjQnIIuivRKoa8K+ZIvXG3DGYYpo9zo46oTt2IQ6r7mCEkgxiGYRjGJgNq7qA/pv9pq8I6veE9GYXpR3SY5DePMDQ7n84Tb8kSUh1RJDOdC0eJOHacdzhOxKvdzW103tKOxuZW1DVaUF1nQnllA4pLq5BXUILLWTm4eOECLmSk41x6GjJOncCZ1Hikx4UjJeogEo/uR9zRUEQfPYjII2E4diQcxyOPISYmGrFxCUhITMSJ5GSkpaWqzpPzlE7WxXPIz7qEorwslBbmo6K4GJWlJagpL0NdZQXqq6qkKulzJaorylFeVoLi4kLk5+chKysLFy9dQsa58zh1JgMpp04hKTkN8fEpiIk9gcjjiYg4GofwiFgcIoUdjsWBwzEIPRyFsPDDCD8cjiNU1sjIMMREH0JC7GGkJEQiPSUW504m4cL5DFy6dA7Z2ZeRm5+PgpIy1QFVUteEiqZWVFHD1VDb1VEb1pMaSerbyagt1dU/whsolqYJy78HrGih+1aH1vYGmM1ig+961FXXoKKoFEXU9jnnLuBS+mlkpCfi7JkTOHcmFRfPpyOb2q+wsACV1D719U1obrZ87oj6MsePoNMJ0RXxsY2K29pqRSt1nOaGWtTXlKK2qgQVZfkozL+MrEsZdO/ScIbu/+m0BKRTm2dkXMSFC5nUTnkoKiqhstA9E5u2Nzerq7N6foMftRep881u4r124rG8tvZm+q6JytKKFgpsbmhHXVk1KvKLUHA5E5fPn6F2SKMypODkKepX6ek4f/4icrKzUFJcgOqqCjQ21MHc3IQ2i3BCUQbiF0LHVguVTbzVkNTYWENxy6kd83A58xK17xmcPnkSaSnJSE5KQFJCHBLiYhAfG019RChGKpquRSE+JrKXdJx+S0cQHRuOKOqrsYnHkZSagLRTydQvTuHy2fMovJSNirx81JUWo7GmCs0m8VheMxrbhSOqXR0fVOfjAHBEaRXDR7bmSCfF80kZhWGYPs7NOqI6dT0OKVvjhgxiGIZhGJsMqLlDpxiO2Khwugxm+hnCPrwVCENTmP3CGfW5Q4oMz05nlJBYKdUZ1hlP/SzC6cREAY0UsYpOKhtMKK+pR0lFOYpKClBQkI38XDL2s84g69IpZGecwIVTCTgrnFJpiTh1MgWpaalISTuJ1PSzOHnuItIu5uL0pTycvZyHi1m5qqOgKDcTlQWXUV+chebSLJgqi2GuKUdLbQVa66vQ1lCN9saaL9QgHvNqQEVTM8oaGlFUW4ecqhpkllfiQkk5zhWU4ExeEdKzCpB+Lg9pGdlIPnUZiacyEX8yE3EnLyMmLQvRqZcRlXIRcSdOIj7lJJJEWU+nIO1MCtLPpuH8xXRczjqnbrZdWJyL4tJ8lJaXopzyqqxrQnVTC2rNVtRROzVQezVRuzVLdayGonvQaeQLR5Tw7NB5T4gVUa2oR1t7A1rNjWgVG44Lx1JVLeqofpX5hSjOyUJeVjrys8+hIO8SiopyUFZejOqaajQ0NsJstsBC9004fsReS1dDlEgtY8dH+Vn1T1AZrKraLc1oN9WjtakWptpK1JUXoaIwh+7dRSrDeeTnnEduTia1Va66UXpJSSkqK6tRV9eIpiYzlafl803Tr0anI0o4oUSfFGui2sRDpO1NaG0TzihRr3aYm9qpHI2op3teVVSA0rzLKKQy5FF7ZF+me5adqTooS0uKUFVZTuWoQ1OzCWZLK6WlumAIUVOxb1orzG2t1NctaDSZUF1Xj+KycuTkF+Fydh4yqZ+ez6R+S3331IVspJ29jLRz/63Us5mkS3Teezp1NgMnM05ReU7hFPXVs1T3C3QPLufkIj+vBKVFNagtrUVzZQ1M9Dsxt5jQ1EaymsUaM6o51V/87y53RP3kKc8hNB+WdZsfxYphPxmFYZh+wK1yRHXqWhxS3ccNIRnEMAzDMDYZMHPHSGfDKFuV1eoNr8ooTD+jw0i+eYRrQax76PzXRp+FG0A4mTol/CNicYhwmLTTifhG13hk86OZPjTQh/qWNtQ2mVFdX4+qmmpUVJWhrLwQJSW5KCy8rD7OlHP5PLIuncflzIvIvJyFi5dzcO5yLs5l5+NifgkuFlXhcnENckqqUVBS0eGwKC1CPaVjrixEa00RWhsq0NZYjfamGlhNtYC5rptqYTI3o9rchiqzBWUmC4qazchraEZuXRNyqhuQXdmAnLJa5OSVIzO3FBcuF1M5ipFBOnO5FKcyy5B2iXSxBGcyc+k6lTEnBxdyL+NSHhnzBZeRU5SD/NJ8FJYXo6KmFFW15aiqq0ZNYxPqKU/xGGNTK9BEbdREbdaqtpt4GxkdVcNevQ0diM/U2MLY7wmRknhg0mo1wdpqpjawoL3RAkudGU1VDagpq6E2K0VFaS4qygroPpRQ2SpQW1+DhqZGNJvMaDG3oq2FytHWZvOxvK7lEGe2JHpDm3g8TvQL8Ro9sTTKbEJbQwPM1VVoqChDdVmhukKqvLyA+oJQkboxeU0NlaWhCc1NFpipLBbhAOrhEUFBp0NE9D8RU5y1WZthaW+EeHteWzu1Q2s73f92WEx0rG9GQ00V6iuLUVeRj6qyXJSX5KCslNqFylcrwurr0NjYjOYW4XDqWGn1RSnEL4OqRmpps6KJItQ2mKhNG1BC7VxUUqUqr7gamdR3MwsrcbGgQtWlgkr1szhezKdr+eW4VNR7yiooRXZeES7n5yOrOBc55fnIo99RfmkZSkqpj1Sa0FDdghbqNxZTK9WvFY3t1IdgAl3pqLlwQsl+KSSHoLsKmg9nd58fVY0yjpRRGIbpB9xqR1SnruaQsjV2yCCGYRiGscmAmTu0ijG2e0W1esMJGcz0Q1T7+BYgjHixtuRziT1xpMHZ4XyiOMICt5AharGomza3tZvIPBWOEOGQ6nBEkf0O8USV2Ci6mQzaxkYycBsa1Ueu6mrrUFNTjaqqSpSpj8oVoZBUVFKMotJS9RG2vOJSVflllSitrEFZVS3Kq+tQSaquqUVNbW3HHkJN9WgxNVE+JEsTLJaOx7Ha2q6U2GvIbKbyUNkbW9tQZ2lDtakFlY0tqKgzoZJUXVOP2vISVJeWoIzKVFxE5SosRgEZ8HnCiM8vISO+FDlUxnxSYVkpiiuLUVxVhBJSeXUJKsSeQfUVqGmsQk1TNeqaGtBA+Yh8RbvQgWSFuV08/mbpaFDhtGkX59SCXTw77VROsfqkJ4Qjqk1dV0X3TKRrsqK92YqWBqprbQuqq0zU3tT2dVWoqxeOMWrDpjrUNTei0SRWH1nQam5Dewt9TzwWSPe7O12vyeJdIeGI6liRRGUQy7tEes2taK03o6W2EeaaOjTW1KgbkVfWVqCK2qquvozuZTWaqJ06V2W1ieZQ+1tH37saXfun+pnyFquhhCNKrIwSfVPsHdXUQi1ETdzY3K46vJqoHUz15dQ+JairLkZtTTldr0MzlcPU3IRmcwua6GZ98chfJyIjKhP9T7w9rqXFQvHNaGowo6G+GfW1zairaUJ1dT3Kq6pRVkmqqOoQnYvVcULq9Uq6Jn4Ht0KVlSi/ikR4ZUUdKsrqUFZegbLqMur3QqX0u6qk+jegsZ7aqoFasLHjHojVkE3WFjSqjijxcB7dV/lWx852l0PQXYNulPErNCfWd58jdYphi4zCMEw/4XY5ojplyyF1xdhBkkEMwzAMY5MBMXdoFfcXbVV0pGIYLaMw/ZAOA/lWIEzuFnkUjhEh4Rwhda6EEEuiWumzhcLE6pt2sWOUcFwJJxb9l4xX4YNQLXeK0m4mw7a5TZXF1IYWkrm5VZVYjVNbX6eqvrFBlTivrq1RJc6bhcOgoUZ1OgkHQZPJjMaWNjSSoSxcLyL3LiVWRUFXSDg11CVbnX4EMqLbqC4tJgvMjS0w11vQWt8I1JcAdcVorS6CuaoQzVXFaKwoQZ1wUJUVo5JUVlWtrvCqra+iMlehobkSjaYKNJmrYGqpgbm1Ho1tdVTGBjRTG5kpH5E1/U9KuO1E45ioTE0kqgnFU3f7Fh4VWb5Waki13D0gnD/inYZtdL9U55XY0kgkR8m3kJpIDWKfJLMJjaR6czPqLCY0WFpgovht6lI3NSGbjqhOp0Mn4syWRDk6pTrQRMOLsogb1UR1MbVSNVupncxqGepNtWiitjOZ6mCmcqn1Fd1NNAF9vXu+tuiMI/x5opu2tbdQ92yitmigUjSTxNblVjS1Un+jOPWiLZqE86hjw3FLcxXMTdS/muuoS5thoQYTjwU2i3JaqM0oe9HHRPN0lEQUTG0oEl1VPa4dsprpdyBWllHftjQ2wUT9o7nuC4mNzztlon7dLMIbKm+JTPU9qQKmGvr9VNN9r6lFI32nyVRO9axAM9W/tZl+y/RbtVL7iG6ptiXVtpn6qXBECVeU6GX0oxGN/Hm7yyHoroHmw8Xd50dbBiiLxWJ1qqtDqvv4IaQOLgzDMAzzJQyIuYMqldq9kjrFECWDmX6Kah/3YVSjtb1jtY1w/ojHv9pa29Bi6dgcW5VFqvPz5xKPjZHoXKxq6nxcS+wLdHUXxTUiEpEJtVO5LCYTSTyaJI6d55S/lJmuNTWJjb2bVZnos9hUW5TTQuUXexIJiccWO9RhsNumM/Muhbhhrvx+p7NAlEE4tNpE+6tt11GuTn15+W6czrxViXtP9129b1Ktog+I1TWynW5tGTraU/0nyyDq2Vl/0QfbKe/PpT6OKETlEJLx1e92JPildKbfqc76tVE/tYg+24ckfkOde2919tW2to49wcT9+Xzvp86jkKij+s82cgi6K3jEdfW3tHpja/c50pbhyWKxWJ/rg9jIv02J+YsYR7qPH0LqAMMwDMMwX8JdP3dQhd7oXkEhrbPHMzIK00+RNmGf5XOjlvS5oS4cEdcg4Xjq3EBbSHUWUDq3A5Fum4XyslBeXaWuGqK8xVG8hU0a9Z3Osc79jLqXsVN3iq5lEOps++7XhW413dPvzLuruse5HXRN31YZuqtrfPqPTOXL6RpfqDMd4fBSnW19SK1tHf20s69eUefOf13q0xNyCLor0OrdDbbmyCdcPb4vozAM04+43Y/mdXVAdWJrDJFBDMMwDGOTu37u0OoN566opGI4JIOZfoy0Cfs0wqjtNHyvR12N4k7dNoTvQawG+RJBHm2Vs6t6rbw90L0cX1Y+oVuNrTy6tpGtctwOuudxveqJ7vG717EvqXtZO9Wdq4V1Rw5B/R7t6BU/vGJ+7NAKGYVhmH7GbXNE2XBAdWJjDGFHFMMwDHNV7uq5Q6s3jrNVQScXj7/JKEw/RtqEfZpOw7arUXw301nfO1nPrmUQuppD4nbQPY/O/L+sHLeD7nlcr3qie/yudeuvdK1PT8ghqN+jUwxrr5wjDWatsuIbMgrDMP2MW+6IuooDqpMrxxF2RDEMwzBX566eO3SKMbt75bR64x4ZzPRzpE3Y5+lq4F6Lkduf6Qv17FoGoS9zAAndLrrn01kGW2W5HXRN/0bUE93jd61Xf6J7PTrVE3II6teMfG7FI93nR3WOVAwLZRSGYfoht8wRdQ0OqE5sjSUyiGEYhmFsctfOHVq98UNbldPpDX+QUZh+jrQJ+xXXYuT2J7ob8F11p+heDlvOn07dbrrnZ6sct4PueVyveqJ7/P7miOpe7u73pSfkENSv0SqGbd3nR63eUPOz55bdK6MwDNMPuWlH1HU4oDrpPpYIySCGYRiGscldOXc88d6GwTrFUGKjcv4yCnMXIG3CfkdXg/fL9GVcS5wbQaTWk7rStRw3aszfLrqWQchW2TrVG9jKt6tuB9ebftf41/Kd7vG/rA/0BXWn8/rVytwTcgjqtzgphl/amB9B12fKKAzD9FNu2BF1Aw6oTmyNJzKIYRiGYWxyV84dIxWPmbYqJv74llGYuwBpEzI3iTC7yRTvUd2N9U59mUF/p+haBqEvczYI9Ra28u7U7eB60+8a/1q+0z1+1zbuy3Qv95epJ+QQ1G/RKYaAK+ZIxVDy5z/PHSSjMAzTT7luR9RNOKA6uWI8IckghmEYhrHJXTd3/OYpz/vE4wXdKyUeQ5BRmLsEaRMytwBhevcoGwb71XSn6F4OdkT1TNf41/Kd7vH7iyPqy+hen56QQ1C/RDye3n1+VKV4fCCjMAzTj7lmR9QtcEB1YmtMkUEMwzAMY5O7bu4QG63aqtTjzsZfyCjMXYK0CRmGYXoVOQT1S2g+3NN9fhQv9pDBDMP0c3p0RN1CB1QnV4wpJBnEMAzDMDa5q+YOrbL2G+LV01dUSjGslVGYuwhpEzIMw/Qqcgjqdzi5ePztivmRpNUbx8koDMP0c77UEXUbHFCd2BpXZBDDMAzD2OSumjt0isHNVoW0o1f8UEZh7iKkTcgwDNOryCGo36FVjOFXzI96wzkZzDDMXcAVjqjb6IDqpPu4IiSDGIZhGMYmd83c8bh+xQ9sVUanGNxlFOYuQ9qEDMMwvYocgvoVWmePZ2zOkXrjGzIKwzB3AZ87onrBAdWJjXGFHVEMwzDMVblr5g6t3ri6e0W0isHyiOvqb8kozF2GtAkZhmF6FTkE9St0ijG6+xxJSpXBDMPcJQjnU285oDqxMbawI4phGIa5KnfF3PGY3u3ntiqi1bsvllGYuxBpEzIMw/QqcgjqN4xUPFxtz5HGF2QUhmGYG8bW+CKDGIZhGMYmd8XcoVMMW7pXQqs31OlGGb8iozB3IdImZBiG6VXkENRvoPnwxBVzpGKMlcEMwzA3RffxRUgGMQzDMIxN+v3coXM1jrRVCdJsGYW5S5E2IcMwTK8ih6B+gVZveNXG/IiRzoZRMgrDMMxNYWuMkUEMwzAMY5N+P3doFaPflZUwlP3kKc8hMgpzlyJtQoZhmF5FDkH9ApoPz1wxRyqGIzKYYRjmprlijCHJIIZhGIaxSb+eOx5zNv7OVgW0eo+pMgpzFyNtQoZhmF5FDkF9Hp3e8J6tOVLnYvg/GYVhGOamsTXOyCCGYRiGsUm/nju0euPu7oXXKsZcGczc5UibkGEYpleRQ1CfR6s3XO4+R+r0hv0ymGEY5pZw5TjDjiiGYRjm6vTbuUOn9/yrrcLrFMMEGYW5y5E2IcMwTK8ih6A+jZPeMMXWHOnkYvijjMIwDHNLsDXWyCCGYRiGsUm/nTt0ekPYFYVXjOdlMDMAkDYhwzBMryKHoL7L3Ln2WsVY2H2O1OoNO2UMhmGYW0b3sUZIBjEMwzCMTfrl3DFS7/FvWwXXuhjfklGYAYC0CRmGYXoVOQT1WXSKcbqtOXKk4vFrGYVhGOaWYWu8kUEMwzAMY5N+OXdoFUNk90LTtZMymBkgSJuQYRimV5FDUJ9E+48VI3SKsar7HEnXfGQUhmGYW8oV4w1JBjEMwzCMTfrd3KHVu7vYKvRIvfvLMgozQJA2IcMwTK8ih6A+iU4xzrM1R2oVj8dkFIZhmFuKrTFHBjEMwzCMTfrd3KFTDIlXFtoQL4OZAYS0CRmGYXoVOQT1OX7tvOpBrWJs7j5H0rUNMgrDMMwtp/uYIySDGIZhGMYm/Wru0CmG/9gqsE5xV2QUZgAhbUKGYZheRQ5BfQ6tYlxma478pbPnj2UUhmGYW46tcUcGMQzDMIxN+tXcodUbT3UvrFYxHJPBzABD2oQMwzC9ihyC+hROiud3aU60dp8jdYrRQ0ZhGIa5LVwx7pBkEMMwDMPYpN/MHU6K4R1bhdUqnk/JKMwAQ9qEDMMwvYocgvoUOr3B84o5UjG260a7PySjMAzD3BauGHtIMohhGIa5C/jBn+cOfWS0+1fF//Hp9JzxZ1oXt8dHunj+3klv/JNO7/nXkXrD37WK+1M6xfC0k2J8Tuts1I9UPFy1iseLOhf3V0a6GF7X6t3fpr9X39PqjeO0imFSv5k7qGAXuxeUKnBABjMDEGkTMgzD9CpyCOozPD7a/Sfd50d1jtQblsooDMMwtw1b448MYhiGYe4QTi+vfeBRZ88fP+5i+JXOxfB/WsX9ReEE0jkbZ9E4vYL+TlyjVQzb6LiTrodqFeMxOibp9IYzOsWYRcdSildP521dx/fbKVn0vsOXecx0Lsa/yCjMAETahAzDML2KHIL6DPQHxMbu8yNdaxL/z5WMwjAMc9voPv4IySCGYRjmFqAbZfzK487GX2gVw/8T+2Zr9cYPtYrHQjqu0ekN/nTtEP3td4I+Z+oUYxWNw1du19APJKvbd6BC5XcvJDXwLhnMDFCkTcgwDNOryCGoT+A0yt3pivmRRH+MzJVRGIZhbiu2xiAZxDAMw1yFkaM9v/6Yi4dWqzf+k8bON+j4CR1X0jFIqxhjxcokW29Evlslm6VvQAWa1r2AQloX429lFGaAIm1ChmGYXkUOQX0CrWLYfsX8qDdUPjnafZiMwjAMc1vpPgYJySCGYZgBjdirU6c3/EHn7P4KjY2zdYpxMx2PdjiYDJau4yarD80d4g9pukHl3Quo1Rt9ZRRmACNtQoZhmF5FDkF3HPqj5jfd58cOGT6WURiGYW47tsYhGcQwDHNX88Qzbl9T/x5zMTwv/v7SKe7raAwM0ynG8/TZ3H1s7L8SdTFUaxVjIX2+qNUbTmoVQxzVM1rdW0oxRnQ8HmgMpXh7ScEUZycd/enadgr3ovAtdNxAx7X03VUUbqRzN1KiVu+xVEg2651H62ycc2UjGDFScdfJKMwARtqEDMMwvYocgu44NB8GdZ8facIvoCC7jhgMwzC3nyvHIXZEMQxzd+GkN/xopN793zrF4wPpTImiv7nEZt5XjH99RVrFUKfVG3KorGmkI1q9x86Oshs/o7J/rHMxTNAp7m9q9cYXtC4ez1D8/+ekuD/pNNrdSWxy/kvF8O3f/Mfzvj//ee4g2QwDA7HLOzVYg41G3SSjMAMcaRMyDMP0KnIIuqN0vC73ivmR/ugwTpZRGIZhegVbY5EMYhiG6Tf8+fVtQ3WjjCNVx4zeMJfGMn+dYkyjv636wh5NjVSuTJ3eECNXGnmKMmrFS92c3V8RTjInxfNJp+eMPxP7Tg0459GtRKcYlti4AdA6u/1URmEGONImZBiG6VXkEHRH6Vj63G1+VIyZMphhGKbX6D4WCckghmGYPonYu0k4b+jvKbE5uL9WbzjXfRzrDWkVQ61OMZyno3i8zU+nGN20eo+pI/UeL+v0nn991Nn4C/HGPFls5nbz+HOrvkM3o83GzVopozAMO6IYhrkjyCHojkF/NIk3q3SfH6FzNr4rozAMw/QatsYjGcQwDHPH0bkYHhWOHa1iXKYT+xgphhJb49ZtkWKopmOqTm8IpnN3nd5jotZZPAbn8Zj2lRUjZBGZvoJWbFxl40Y+OsrtezIKw7AjimGYO4Icgu4YNB8e7T4/ktJlMMMwTK9iYzxiRxTDMHeEx1w8tFq9x9vajn2cEkkmW2PUrZJWffOd4Qzls58+r9TqjR9qnY16rYvn405Pr31AFovpD4iNwLrfYCG6yctlFIZRkTYhwzBMryKHoDsCzYfO3edHVS4er8goDMMwvYqtMUkGMQzD3DbE43U03jjrxJY+6mbchrruY9Gtk6FSqxhjKZ8t9Hka5fUsbxl0l0E3dX33G083vVlsuiWjMIyKtAkZhmF6FTkE3RFoPoy7Yo7UG5NkMMMwTK/TfUwSkkEMwzC3hB+8Pneok4vhj2L/JPpbKJDGmezu486tkFa8ZU5vDFOf0FKMY3Quxr884rr6W7IYzN2KeH6ze2dQ5WKYL6MwzOdIm5BhGKZXkUNQr6NVPF60NUc6KYbRMgrDMEyvY2tckkEMwzA3hHiDvrrqSDEu0yqGK/5PuJuVeKSO0k7WKcbNdD5ppLP7n3lT8AEMdQqv7p1EpxiqH3FdfY+MwjCfI21ChmGYXkUOQb0OzYdpNubIKBnMMAxzR7hiXCLJIIZhmGtCvKxM52J4nsaPlaTUruPJzUqrGMq1ijGC/mZy0+oNr4p9pGS2DEOdz8XwK5sdR2/8REZhmP9C2oQMwzC9ihyCehWd4v6mrTmS/qh6WkZhGIa5I9gam2QQwzCMTXSjjA9rFeNrWr1hI+mcrXHkhiTeUtfxZryFYkUVv+yM6RH5rOd/dSSt3ljk6rrTQUZhmP9C2oQMwzC9ihyCehX6o+p89zlS/KElgxmGYe4YV4xNJBnEMAyjIh57U98mpxhXaRXDWVvjxo1IPF6n1RvX0PkbI5/zfERmxzDXhtbZ43+7dypVivF9GYVhrkDahAzDML2KHIJ6DSfFfbytOZL+kPt/MgrDMMwdw9b4JIMYhhmwwM5plNvf6G+VRVobL1q5ISmGbFKAVm/80GmU4Y8/ecpziMyMYW4Mnd5j75UdzZglgxnGJtImZBiG6VXkENRraDve4PJfcyT9YRcigxmGYe4o3ccnIRnEMMwAQuvi9riT3n2aTm84SOOAqfu4cL3S6o1ntYpxA+k1J73hRzIbhrk1jFQ8/mGr44nXJcooDGMTaRMyDMP0KnII6hXE/+tna44c6eL2exmFYRjmjmJrjJJBDMPcxfzmKc/7xJt7tYphIynX1lhwnUrV6Q2eIxUP118qhm/LbBjm9qDVGw5374RaxZghgxnmS5E2IcMwTK8ih6DbzhPvbRhMf5CVdp8j6Zq/jMIwDHPHuXKMYkcUw9ytiFVPOsV9Ov3Oj3b/3V+vtHpjEtn9y8Sm4k4vr31AZsEwtx8nxe05W52SxWKxWCyWbWldPB+X0yjDMMwdx9Y4JYMYhunnPPHMhuFfrHoy3uSqJ8MFneK+Tqx4euIZt6/JLBim96HOGGO7k7JYLBaLxeourd64VU6hDMMwfQJbY5UMYhimH6IdveKHOsUwgf7mCKXfs7X77/uapRhKSTtGKoZ3HnX2/LFMnmHuLDoXw/M2OyyLxWKxWCybeky/8udyGmUYhukT2BqrZBDDMP0EJ8X9SfrtLtAqxuTuv+frkdh2R6sYPnJSDL+USTNM30KnN6TY6rwsFovFYrFsao2cQhmGYfoMNsYqdkQxTF/H1dVhpLNhlFYxbqDfbH733/A1SzFmicft6NxZPMYnU2eYvomTi+H1Kzoxi8VisVisL9co48NyGmUYhukz2BqvZBDDMH0I+jviKzoXj1e0ijGQ1Gzrt3st6lz19JiLh1YmzTAMM3CQL7BiGIbpVeQQxDAMwxC2DFUZxDDMHebRUW7fc1Lcx+v0hoO2fqvXqHx15ZTirmj/sWKETJphGGZgIm1ChmGYXkUOQQzDMAxhw2jlcZJh7iAjR3s+olOM07WKMdbW7/NaRN9N1rl4zBd7R8lkGYZhGIG0CRmGYXoVOQQxDMMwhC0jVgYxDNNLaF2Mv9UqhkWk07Z+kz3LYBVvyRupeIzXPrvihzJZhmEYpjvSJmQYhulV5BDEMAzDELaMWhnEMMxtZKTe8Hed3uCpUwzZtn6HPUmrN1aQtmr1Hi5PjnYfJpNlGIZhroa0CRmGYXoVOQQxDMMwhC0DVwYxDHMLecR1rqPW2ajvcB4ZK2z99nqU6rQyeAonlkyWYRiGuR6kTcgwDNOryCGIYRiGIWwZuzKIYZibZORoz6/rFPc3dXpDsE4xttj6vfUkrd54Sn1sz8X4W5kswzAMc6NIm5BhGKZXkUMQwzAMQ9gyfGUQwzA3wEi9x//oFMMH9Fs60v23de0yxOgU9+kjn1vxiEyWYRiGuRVIm5BhGKZXkUMQwzAMQ9gygmUQwzDXyOMuhl/pFOM8nd6QYus3dW0yHNTqjeMeHeX2PZkswzAMc6uRNiHDMEyvIocghmEYhrBlEMsghmGugpPe8HetYvTQ6Q2Xbf2OehJ9t5kUqHPxeOUJ1w33y2QZhmGY24m0CRmGYXoVOQQxDMMwhC0DWQYxDNOFnzzlOUS8oU6rGLbdxGbjpXTcNNLZMEozd669TJphGIbpLaRNyDAM06vIIYhhGIYhrjCUSTKIYQY8Tornd7V6j7e1iiFEqze22vq99CjFcIHkpnMx/kUmyzAMw9wppE3IMAzTq8ghiGEYhiFsG85GD63i/qJulPFhGY1hBgw6vedf6TfwGf0Wbny/J8WQSMfZOlfjSJkswzAM0xeQNiHDMEyvIocghmEYhrjCgO4mrWLIJaM6gAzz9/n18czdiJPe8CPq32OonwdTn6/v/hu4VmkVYzj9XiZpn13xQ5k0wzAM09eQNiHDMEyvIocghmEYhrBlUF9dBrNWbziuczF+Jva5eexZj2/KpBimfzB3rr1Wb/ynTjG46xRjuu1+3rMojSax2Tj9Hl51enrtAzJ1hmEYpi8jbUKGYZheRQ5BDMMwDGHLwL5uKcbzYgNnsapkpOKuk0kzTJ/hMb3bz8VqJeqj+0gmm/34GqTVG4spnY1OittzZM3YyeQZhmGY/oK0CRmGYXoVOQQxDMMwxEjFfbxWMfpp9YYcW4b3DapepxiiyOD3cHI2vO402t1JZscwvcIPXp87lPr0s9QXVwpHabf+eX1SDGn0G1nmpDf+SSbPMAzD9FekTcgwDNOryCGIYRiG6cYjrh7f17kYntfqjQad3pBg0yi/QZEh30yKJa3SOhvf4k2cmVuJeLvdSMXD9Zb0XcVQTQrQ6t3ffnTUmu/JLBiGYZi7AWkTMgzD9CpyCGIYhmF64BHXuY5iFYhOcZ+uVQwhZJyX2DTcb1SKsYXSTCSt1Tkb33Vy9XxC7N8js2eYL8VJMfxypOIxnvrldp3ecNlm/7oeUT+ktBY6uRj+KLNgGIZh7kakTcgwDNOryCGIYRiGuQG0zm4/FY/b6RTjOq3ecNKmUX8T0iqGNq1iTNYphi1avftUJ2fjvx7Xr/iBzJ4ZgPzmKc/7OjYXN86jfnGI+l2drb5zfTKUUno+YqPxR1yXf0tmxTAMw9ztSJuQYRimV5FDEMMwDHML+M1/OpwEZNDPJQM/jIz7qiuN/puXVjHW6vSGeEp/s3BQaRXPp55w9fi+LAZzF/Gos+ePdS4er1C/WqNTDGm2+sMNSTFGaxXDp1oX429lVgzDMMxAQ9qEDMMwvYocghiGYZjbxOOj3X8i9ushw/8zdQWLYii36Ri4BfpvB5XxQ63izg6qfoTqdNIbnUmztXqPnXQvC7re35uRVmzA39EvXnhktPtXZZYMwzDMQEbahAzDML2KHIIYhmGYXkQ7esUPtc5GvVYxLNIqxgNavbHYlvPgFqqRlK7TG/Zq9QYj5TtJpxieftzZ+Isf/HnuUFksppf4tfOqB3WjjH/R6T0m0v3fQIqj+1Pf5X7dtKhPJekUo4dwPPHjnAzDMIxNpE3IMAzTq8ghiGEYhrnDiLf0jXQ2jNKpe/8Y993K1TDXoHyt3nhcqxi2ice1dIrhP487G3/32Ise35TFY66TJ1yX3i83EXfV6g0zqI03UdseE23dpd1vjRRjFd2/UDqfRXn8vydHuw+TxWAYhmGYL0fahAzDML2KHIIYhmGYPsjjz636zki9+7+1iuEjnd6wRac3JmhvyebU1y7K26RTDNlaxRhLn4NIK7V64yd0fIOO/3zMxUM7crTn12WRBwyizo9T3UUbdLSFYa5ObPitGOLoXpWKtrttUoznKZ9tlM97TqPcnWSRGIZhGOb6kDYhwzBMryKHIIZhGKYfoRtlfLjTQaXVG7bqFEOi7hY/2nXdUowtWsWYq9MbhLNsN2k9fV4mnFakcU4uxpdEmUe6uP1+5GjPR4STTfuPFSNkle4oYgXRY896fFO8BXGksuLXTi4efxOPTjophneojcUKsbV0DBHtTMc8ksVmG9wGUdu1UttGi7bUKe4Kv9WOYRiGuWVIm5BhGKZXkUMQwzAMcxfQ4aDykA4qo+qg6u0VVNctxdhCxzLSRa1iTKayx5Ei6TxcpzfsJwVTmL9YbUT12SycQnTuQXGWa13EHlskvWEpXXPTORs86XwNfXcDfW+L/M4OuraT2mM3ne+n+OLxuBSKk0nn5RTPrJajD4jKWUPliRF1dFLcx2ud3f7X1XWng7y9DMMwDHNrkTYhwzBMryKHIIZhGOYuRqus+IaT4v7kSL37yzq9+2yt3rCVFKlTDHm2HCKsXlF6h5NMrBgzPCuciPJ2MQzDMEzvIG1ChmGYXkUOQQzDMMwA5RHXuY6P6d1+LlZS6fTuE7V6d4O24zG006QGGw4U1rVIMbbT8aJObzioVYyr6PP7wuEkHkv885/nDpLNzzAMwzB3DmkTMgzD9CpyCGIYhmEYm/zmP573CUeVTu/+V7GiSqt3n6pTDG5axeCnVYzHdOrG2cbaKxwxd7nUOisGsWn4MdEWapvojeN0zob/e9TZ88ey+RiGYRim7yJtQoZhmF5FDkEMwzAMc1M84rr6npF6j/9x0hv/pNUbXxBOGfnY2VLSep1iCNDpjWGkBOG8IpVoxRv5bDh5el2KoYXKUi72jaLPqcLBRp9DdHqDtyi/k94wRedieN7JxfDHx591/8kTz2wYLqvNMAzDMP0XaRMyDMP0KnIIYhiGYZg7wg9enztUvAnOabTxZ+KNdSNdPH+vczH+Redi+D+ts8cz4u11WsX9RdJrWr3H28LBpTqG9MZppFmqFON0sVJLqxgnj1Tcx+v0hvd0isebWr3hVfVtfYq7K8VzFumJN+KNVDx+Ld6Q99iLHt8Ub8yTRWEYhuknaDT/HyObkDzwlMepAAAAAElFTkSuQmCC"


# Construct main window
root = Tk()
root.title("SBML2HYB v1.0.1")
root.geometry("1000x800")

first_level = None
second_level = None

# Vertical (y) Scroll Bar
top_frame = Frame(root, pady=10)
mid_frame = Frame(root, pady=10)
bot_frame = Frame(root, pady=10)

canvas = Canvas(top_frame, width=350, height=100)

save_label = Label(top_frame, text="File Saved!")

my_text = Text(mid_frame, wrap=NONE, height=50, width=150)

scroll_y = Scrollbar(mid_frame, orient="vertical", command=my_text.yview)
scroll_x = Scrollbar(mid_frame, orient="horizontal", command=my_text.xview)

# Root variables
smbl_file_selected = hmod_file_selected = files_l_hyb = b_load_file = added = res = None
default_file_name = ""
default_file_selected = False
default_file_selected_type = ""

is_hyb = None
error_text = ""
hmod_file_string = ""

# First window variables
curr_file_name = hyb_file = file_selected_for_conversion_l = _error_previous_state = ""
species = []
parameters = []
add_ml = None

# Second window variables
warning_text_species_selected = ""
warning_text_parameters = ""
file_selected = ""
species_checkboxes = []
parameters_checkboxes = []
h5_file = ""
hmod_file = ""


top_frame.pack()
bot_frame.pack()

mid_frame.pack()


canvas.pack()
img = ImageTk.PhotoImage(
    Image.open(BytesIO(base64.b64decode(logo))).resize((330, 80), Image.ANTIALIAS)
)
canvas.create_image(20, 20, anchor=NW, image=img)

# top_title_label = Label(top_frame, pady=20, text="SBML <-> HMOD converter")
# top_title_label.config(font=(50))
# top_title_label.pack()

# top_label = Label(top_frame, pady=10, text="Choose an SBML file to export to hmod\n"
#                                            "or\n"
#                                            "Choose an hmod file to export to SBML")
# top_label.config(font=(10))
#
# top_label.pack()

pos1 = Label(
    bot_frame, pady=10, text="Choose an SBML file to HMOD           OR", borderwidth=1
)
pos1.config(font=(50))
pos1.grid(row=0, column=0)

pos2 = Label(
    bot_frame, pady=10, text="          Choose an HMOD file to SBML", borderwidth=1
)
pos2.config(font=(50))
pos2.grid(row=0, column=1)


def open_hmod():
    open_file("hmod")


def open_xml():
    open_file("sbml")


def open_file(type):
    global first_level, file_selected_for_conversion_l, is_hyb, files_l_hyb, b_load_file, added, error_text, add_ml, parameters, species
    _error_previous_state = error_text
    # Open new window and set it up
    first_level = Toplevel(root)
    first_level.grab_set()
    first_level.title("Load HMOD file" if type == "hmod" else "Load SBML file")
    width = 600
    height = 400
    first_level.geometry("{}x{}".format(width, height))
    files_f = Frame(first_level, width=width, padx=3, pady=3)
    files_f.grid_rowconfigure(0, weight=1)
    files_f.grid_columnconfigure(0, weight=1)
    files_f.grid(row=0, column=0, columnspan=3)

    def clean_global_vars():
        global curr_file_name, hyb_file, file_selected_for_conversion_l, hmod_file_selected, hmod_file_string, files_l_hyb, b_load_file, added, res, default_file_selected_type

        curr_file_name = hyb_file = ""
        file_selected_for_conversion_l = (
            hmod_file_selected
        ) = files_l_hyb = b_load_file = added = res = None

    def confirm_button():
        global hyb_file, res, curr_file_name, default_file_selected, default_file_name, default_file_selected_type, error_text, file_selected_for_conversion_l, add_ml, _error_previous_state
        if error_text != "":  # and _error_previous_state == "":
            my_text.delete("1.0", END)
            my_text.insert(INSERT, error_text)
            scroll_y.pack(side="right", expand=True, fill="y")
            scroll_x.pack(side="bottom", expand=True, fill="x")

            my_text.configure(yscrollcommand=scroll_y.set)
            my_text.configure(xscrollcommand=scroll_x.set)
            my_btn_export.grid(row=1, column=3)

            my_text.pack(side="left")
            default_file_selected = True
            clean_global_vars()
            first_level.grab_release()
            first_level.destroy()

        elif error_text == "" and (
            curr_file_name != ""
            or (
                default_file_selected
                and default_file_name != ""
                and default_file_selected_type == type
            )
        ):
            previous_text = my_text.get("1.0", END)
            my_text.delete("1.0", END)
            save_label.config(text="")
            if type == "sbml":
                if hyb_file != "":
                    t = hyb_file
                elif (
                    default_file_selected
                    and default_file_name != ""
                    and default_file_selected_type == type
                ):
                    t = xmlparser.main(default_file_name, previous_text)[0]
                else:
                    t = res[0]
                my_text.insert(INSERT, t)
                default_file_selected_type = "hmod"
            elif type == "hmod":
                if hyb_file != "":
                    t = hmodparser.main(
                        curr_file_name if curr_file_name != "" else default_file_name,
                        hyb_file,
                    )[0]
                elif (
                    default_file_selected
                    and default_file_name != ""
                    and default_file_selected_type == type
                ):
                    t = hmodparser.main(default_file_name, previous_text)[0]
                else:
                    t = res[0]
                my_text.insert(INSERT, t)
                default_file_selected_type = "sbml"

            scroll_y.pack(side="right", expand=True, fill="y")
            scroll_x.pack(side="bottom", expand=True, fill="x")

            my_text.configure(yscrollcommand=scroll_y.set)
            my_text.configure(xscrollcommand=scroll_x.set)
            my_btn_export.grid(row=1, column=3)

            my_text.pack(side="left")
            default_file_selected = True
            clean_global_vars()
            first_level.grab_release()
            first_level.destroy()
        else:
            file_selected_for_conversion_l.config(text="Please select a file", fg="red")

    def cancel_button():
        global error_text
        clean_global_vars()
        error_text = _error_previous_state
        first_level.grab_release()
        first_level.destroy()

    def load_file():
        top_frame.filename = filedialog.askopenfilename(
            title="Select A File",
            filetypes=(("xml files", "*.xml"), ("all files", "*.*"))
            if type == "sbml"
            else (("hmod files", "*.hmod"), ("all files", "*.*")),
        )
        if top_frame.filename is None or top_frame.filename == "":
            return
        try:
            file = top_frame.filename
            global species, parameters, is_hyb, curr_file_name, files_l_hyb, b_load_file, added, res, default_file_name, error_text, hmod_file_string, add_ml, _error_previous_state

            if type == "hmod":
                hmod_file_string = open(file, "r").read()
                res = hmodparser.main(file, hmod_file_string)
            else:
                xml_file_string = open(file, "r").read()
                res = xmlparser.main(file, xml_file_string)
                hmod_file_string = res[0]

            species = res[1]
            parameters = res[2]
            global default_file_selected
            # Check if text is hybrid
            if parameters is None:
                error_text = res[0]
            elif "w1" in parameters:
                default_file_selected = False
                error_text = ""
                is_hyb = True
            else:
                error_text = ""
                default_file_selected = False
                is_hyb = False

            # Save filename
            curr_file_name = file.split("/")[-1]
            default_file_name = curr_file_name

            # Change name in the text components and add ML component if valid file
            file_selected_for_conversion_l.config(text=curr_file_name, fg="black")

            # Create ML Button if not exist
            if files_l_hyb is None:
                files_l_hyb = Label(
                    files_f, text="ML Component (optional):", borderwidth=1
                )

            files_l_hyb.config(font=(50))
            files_l_hyb.config(text="ML Component (optional):", font=(50))

            # Create add button and label below if not exist
            if add_ml is None:
                add_ml = Button(
                    files_f, padx=10, text="Add ML", command=open_keras_file
                )

            if added is None:
                added = Label(files_f, pady=10, borderwidth=1, fg="red")
            added.config(font=(50), text="NOT ADDED")

            # If the text to be converted is already hyb or has errors don't display the buttons
            if not is_hyb and error_text == "":
                if len(parameters) != 0:
                    parameters = sorted(parameters)
                if len(species) != 0:
                    species = sorted(species)
                _empty_space = Label(files_f, pady=10, text="", borderwidth=1, fg="red")
                _empty_space.grid(row=2, column=0, columnspan=3)
                files_l_hyb.grid(row=3, column=0, columnspan=2, pady=1)
                add_ml.grid(row=3, column=2, columnspan=1, pady=1)
                added.grid(row=4, column=1, columnspan=1)
            else:
                files_l_hyb.config(text="")
                files_l_hyb.grid_forget()
                add_ml.grid_forget()
                added.config(text="")
                added.grid_forget()
        except Exception as e:
            print(e)

    # Load file component
    files_l_hmod = Label(
        files_f,
        text="Choose an SBML file to load:"
        if type == "sbml"
        else "Choose an HMOD file to load:",
        borderwidth=1,
    )
    files_l_hmod.config(font=(50))
    files_l_hmod.grid(row=0, column=0, columnspan=2, pady=1)

    b_load_file = Button(
        files_f,
        padx=10,
        text="SBML File" if type == "sbml" else "HMOD File",
        command=load_file,
    )
    b_load_file.grid(row=0, column=2, columnspan=1, pady=1)

    file_selected_text = Label(files_f, text="File selected: ", borderwidth=1)
    file_selected_text.config(font=(50))
    file_selected_text.grid(row=1, column=0, columnspan=2, pady=1)

    # Name of the file selected
    global file_selected_for_conversion_l, default_file_selected_type
    if error_text != "":
        file_selected_for_conversion_l = Label(
            files_f, text="(No file selected)", borderwidth=1
        )
    elif default_file_selected_type == "":
        file_selected_for_conversion_l = Label(
            files_f,
            text="(No file selected)"
            if len(my_text.get("1.0", END)) == 1
            else "Current File",
            borderwidth=1,
        )
    elif default_file_selected_type != type:
        file_selected_for_conversion_l = Label(
            files_f, text="(No file selected)", borderwidth=1
        )
    else:
        file_selected_for_conversion_l = Label(
            files_f, text="Current File", borderwidth=1
        )

    file_selected_for_conversion_l.config(font=(50))
    file_selected_for_conversion_l.grid(row=1, column=2, columnspan=1, pady=1)

    # Confirm and Cancel buttons
    _empty_space = Label(files_f, pady=10, text="", borderwidth=1, fg="red")
    _empty_space.grid(row=5, column=0, columnspan=3)
    confirm_button = Button(files_f, padx=10, text="Confirm", command=confirm_button)
    confirm_button.grid(row=6, column=1, columnspan=1)
    cancel_button = Button(files_f, padx=10, text="Cancel", command=cancel_button)
    cancel_button.grid(row=7, column=1, columnspan=1)

    # Check if there is any previous translation being displayed
    if len(my_text.get("1.0", END)) > 1:
        global default_file_selected
        default_file_selected = True

    # Create ML Button
    files_l_hyb = Label(files_f, text="ML Component (optional):", borderwidth=1)
    files_l_hyb.config(font=(50))

    # Create add button and label below
    add_ml = Button(files_f, padx=10, text="Add ML", command=open_keras_file)
    added = Label(files_f, pady=10, text="NOT ADDED", borderwidth=1, fg="red")
    added.config(font=(50))

    # If the text to be converted is already hyb don't display the buttons
    if not is_hyb and is_hyb is not None and default_file_selected_type == type:
        if len(parameters) != 0:
            parameters = sorted(parameters)
        if len(species) != 0:
            species = sorted(species)
        _empty_space = Label(files_f, pady=10, text="", borderwidth=1, fg="red")
        _empty_space.grid(row=2, column=0, columnspan=3)
        files_l_hyb.grid(row=3, column=0, columnspan=2, pady=1)
        add_ml.grid(row=3, column=2, columnspan=1, pady=1)
        added.grid(row=4, column=1, columnspan=1)
    else:
        files_l_hyb.config(text="")
        files_l_hyb.grid_forget()
        add_ml.grid_forget()
        added.config(text="")
        added.grid_forget()


def open_keras_file():
    global parameters, species, species_checkboxes, parameters_checkboxes, first_level, second_level, file_selected

    first_level.grab_release()
    # Create new window
    second_level = Toplevel(first_level)
    second_level.grab_set()

    # sets the title of the
    # Toplevel widget
    second_level.title("Neural network")

    # sets the geometry of toplevel
    width = 500
    height = 800
    second_level.geometry("{}x{}".format(width, height))

    # Reset global variables
    def clean_global_variables():
        global warning_text_species_selected, warning_text_parameters, file_selected, species_checkboxes, parameters_checkboxes, h5_file
        warning_text_species_selected = (
            warning_text_parameters
        ) = file_selected = h5_file = ""
        species_checkboxes = parameters_checkboxes = []

    # Set X button behavior
    def on_closing():
        pass

    second_level.protocol("WM_DELETE_WINDOW", on_closing)

    # Frame container for File selection
    h5 = Frame(second_level, width=width, padx=3, pady=3)
    h5.grid_rowconfigure(0, weight=1)
    h5.grid_columnconfigure(0, weight=1)

    # Frame container for species text and checkboxes
    species_f = Frame(second_level, width=width, padx=3, pady=3)
    species_f.grid_rowconfigure(0, weight=1)
    species_f.grid_columnconfigure(0, weight=1)
    species_checkbox_holder_f = Frame(species_f, width=width - 100)
    species_checkbox_holder_f.grid(row=1, column=0, columnspan=4)
    species_checkbox_holder = scrolledtext.ScrolledText(
        species_checkbox_holder_f
    )  # , bg="gray")
    species_checkbox_holder.pack()

    # Frame container for parameters text and checkboxes
    parameters_f = Frame(second_level, width=width, padx=3, pady=3)
    parameters_f.grid_rowconfigure(0, weight=1)
    parameters_f.grid_columnconfigure(0, weight=1)
    parameter_checkbox_holder_f = Frame(parameters_f, width=width - 100)
    parameter_checkbox_holder_f.grid(row=1, column=0, columnspan=4)
    parameter_checkbox_holder = scrolledtext.ScrolledText(
        parameter_checkbox_holder_f
    )  # , bg="gray")
    parameter_checkbox_holder.pack()

    # Frame for confirm and cancel buttons
    confirm_f = Frame(second_level, width=width, padx=3, pady=3)
    confirm_f.grid_columnconfigure(0, weight=1)
    confirm_f.grid_rowconfigure(0, weight=1)

    # Set grid for frames
    h5.grid(row=0, column=0, columnspan=4)
    species_f.grid(row=3, column=0, columnspan=4)
    parameters_f.grid(row=11, column=0, columnspan=4)
    confirm_f.grid(row=20, column=0, columnspan=4)

    # Text for file selection
    h5_l = Label(h5, text="Choose a Keras H5 file to load:", borderwidth=1)
    h5_l.config(font=(50))
    h5_l.grid(row=0, columnspan=2, pady=1)

    file_selected_text = Label(h5, text="File selected: ", borderwidth=1)
    file_selected_text.config(font=(50))
    file_selected_text.grid(row=1, column=0, columnspan=2, pady=1)

    # Default text before user inputs H5 file
    file_selected = Label(h5, text="(No file selected)", borderwidth=1)
    file_selected.config(font=(50))
    file_selected.grid(row=1, column=2, columnspan=1, pady=1)

    # Button to load H5 file
    def load_h5_file():
        filename = filedialog.askopenfilename(
            title="Select A File",
            filetypes=(("h5 files", "*.h5"), ("all files", "*.*")),
        )
        if filename is None or filename == "":
            return
        try:
            global h5_file, file_selected
            h5_file = filename
            file_selected.config(text=h5_file.split("/")[-1], fg="black")
            second_level.grab_set()
        except Exception as e:
            print(e)
            h5_file = "An unexpected error as occurred"

    b = Button(h5, padx=10, text="H5 File", command=load_h5_file)
    b.grid(row=0, column=2, columnspan=1, pady=1)

    # Text for species
    species_l = Label(species_f, pady=10, text="Select model inputs:", borderwidth=1)
    species_l.config(font=(50))
    species_l.grid(row=0, columnspan=2, pady=1)

    # Text for parameters
    parameters_l = Label(
        parameters_f, pady=10, text="Select model outputs:", borderwidth=1
    )
    parameters_l.config(font=(50))
    parameters_l.grid(row=0, columnspan=2, pady=1)

    # Set of auxiliary methods to check if all properties have been inserted by the user
    def check_parameters():
        global warning_text_parameters
        for i in range(len(parameters_checkboxes)):
            if parameters_checkboxes[i][1].get() == 1:
                if warning_text_parameters != "":
                    warning_text_parameters.config(text="")
                    warning_text_parameters.grid(row=0, column=2, columnspan=1)
                return True
        warning_text_parameters = Label(
            parameters_f, pady=10, text="(Select at least one)", borderwidth=1, fg="red"
        )
        warning_text_parameters.config(font=(50))
        warning_text_parameters.grid(row=0, column=2, columnspan=1)
        return False

    def check_species():
        global warning_text_species_selected
        for i in range(len(species_checkboxes)):
            if species_checkboxes[i][1].get() == 1:
                if warning_text_species_selected != "":
                    warning_text_species_selected.config(text="")
                    warning_text_species_selected.grid(row=0, column=2, columnspan=1)
                return True
        warning_text_species_selected = Label(
            species_f, pady=10, text="(Select at least one)", borderwidth=1, fg="red"
        )
        warning_text_species_selected.config(font=(50))
        warning_text_species_selected.grid(row=0, column=2, columnspan=1)
        return False

    def h5_file_selected():
        if h5_file != "":
            return True
        file_selected.config(text="Please select a file", fg="red")
        return False

    # Create Confirm button and action associated with it
    def closing_confirm():
        global first_level, hyb_file, hmod_file_string, warning_text_parameters, is_hyb, default_file_name
        c1 = h5_file_selected()
        c2 = check_species()
        c3 = check_parameters()
        if c1 and c2 and c3:
            global added
            added.config(text="ADDED", fg="green")
            hyb_file = neural_network_parser.main(
                parameters,
                species,
                species_checkboxes,
                parameters_checkboxes,
                h5_file,
                curr_file_name if curr_file_name != "" else default_file_name,
                hmod_file_string,
            )
            if hyb_file[0] is None:
                warning_text_parameters = Label(
                    parameters_f,
                    pady=10,
                    text="(Select at most " + str(hyb_file[1]) + ")",
                    borderwidth=1,
                    fg="red",
                )
                warning_text_parameters.config(font=(50))
                warning_text_parameters.grid(row=0, column=2, columnspan=1)
                hyb_file = ""
            else:
                hyb_file = hyb_file[0]
                hmod_file_string = hyb_file[0]
                is_hyb = True
                clean_global_variables()
                second_level.destroy()
                second_level.grab_release()
                first_level.grab_set()

    _empty_space = Label(confirm_f, pady=10, text="", borderwidth=1)
    _empty_space.grid(row=0, column=1, columnspan=1)
    confirm_button = Button(confirm_f, padx=10, text="Confirm", command=closing_confirm)
    confirm_button.grid(row=1, column=1, columnspan=1)

    # Create cancel button and action associated with it
    def closing_cancel():
        global first_level
        clean_global_variables()
        second_level.grab_release()
        second_level.destroy()
        first_level.grab_set()

    cancel_button = Button(confirm_f, padx=10, text="Cancel", command=closing_cancel)
    cancel_button.grid(row=2, column=1, columnspan=1)

    # Create species Checkboxes
    species_checkboxes = []
    for sp in range(len(species)):
        check_box_var = tkinter.IntVar()
        checkbox = ttk.Checkbutton(
            species_checkbox_holder,
            text=species[sp],
            variable=check_box_var,
            onvalue=1,
            offvalue=0,
            width=width,
        )
        species_checkbox_holder.window_create("end", window=checkbox)
        species_checkbox_holder.insert("end", "\n")
        species_checkboxes.append([checkbox, check_box_var])

    # Create parameters checkboxes
    parameters_checkboxes = []
    for pm in range(len(parameters)):
        check_box_var = tkinter.IntVar()
        checkbox = ttk.Checkbutton(
            parameter_checkbox_holder,
            text=parameters[pm],
            variable=check_box_var,
            onvalue=1,
            offvalue=0,
            width=width,
        )
        parameter_checkbox_holder.window_create("end", window=checkbox)
        parameter_checkbox_holder.insert("end", "\n")
        parameters_checkboxes.append([checkbox, check_box_var])

    # Set scrollbox dimensions for each set of checkboxes and disable accidental deletion
    parameter_checkbox_holder.config(height=12, width=45)
    species_checkbox_holder.config(height=12, width=45)
    parameter_checkbox_holder["state"] = "disabled"
    species_checkbox_holder["state"] = "disabled"


def save_file():
    text2save = my_text.get("1.0", END)
    if '<?xml version="1.0" encoding="UTF-8"?>' in text2save:
        f = filedialog.asksaveasfile(mode="w", defaultextension=".xml")
    else:
        f = filedialog.asksaveasfile(mode="w", defaultextension=".hmod")
    if f is None:  # asksaveasfile return `None` if dialog closed with "cancel".
        return

    f.write(text2save)
    f.close()
    save_label.config(text="File Saved!")
    save_label.pack(side="bottom")


my_btn_export = Button(bot_frame, text="Save file", command=save_file)
my_btn_xml = Button(bot_frame, padx=10, text="Translate SBML File", command=open_xml)
my_btn_hmod = Button(bot_frame, padx=10, text="Translate HMOD File", command=open_hmod)

my_btn_xml.grid(row=1, column=0)

my_btn_hmod.grid(row=1, column=1)

root.mainloop()
