# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class MlAssetsCreateModelInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self,
                 tags=None,
                 framework=None,
                 name=None,
                 description=None,
                 training_definition_url=None,
                 author=None,
                 transformed_label=None,
                 label_column=None,
                 training_data_reference=None,
                 training_data_schema=None,
                 input_data_schema=None,
                 evaluation=None,
                 content_location=None,
                 hyper_parameters=None,
                 output_data_schema=None,
                 runtime_url=None):
        """
        MlAssetsCreateModelInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'tags': 'list[TagRepository]',
            'framework': 'FrameworkOutputRepository',
            'name': 'str',
            'description': 'str',
            'training_definition_url': 'str',
            'author': 'AuthorRepository',
            'transformed_label': 'str',
            'label_column': 'str',
            'training_data_reference': 'ArrayDataInputRepository',
            'training_data_schema': 'TrainingDataSchema',
            'input_data_schema': 'InputDataSchema',
            'evaluation': 'EvaluationDefinitionRepository',
            'content_location': 'ContentLocation',
            'hyper_parameters':'list[HyperParameters]',
            'output_data_schema':'OutputDataSchema',
            'runtime_url':'str'
        }

        self.attribute_map = {
            'tags': 'tags',
            'framework': 'framework',
            'name': 'name',
            'description': 'description',
            'training_definition_url': 'training_definition_url',
            'author': 'author',
            'transformed_label': 'transformed_label',
            'label_column': 'label_column',
            'training_data_reference': 'training_data_reference',
            'training_data_schema': 'training_data_schema',
            'input_data_schema': 'input_data_schema',
            'evaluation': 'evaluation',
            'content_location': 'content_location',
            'hyper_parameters': 'hyper_parameters',
            'output_data_schema': 'output_data_schema',
            'runtime_url':'runtime_url'
        }

        self._tags = tags
        self._framework = framework
        self._name = name
        self._description = description
        self._training_definition_url = training_definition_url
        self._author = author
        self._transformed_label = transformed_label
        self._label_column = label_column
        self._training_data_reference = training_data_reference
        self._training_data_schema = training_data_schema
        self._input_data_schema = input_data_schema
        self._evaluation = evaluation
        self._content_location = content_location
        self._hyper_parameters = hyper_parameters
        self._output_data_schema = output_data_schema
        self._runtime_url = runtime_url

    @property
    def tags(self):
        """
        Gets the tags of this ExperimentInputExperiments.


        :return: The tags of this ExperimentInputExperiments.
        :rtype: list[TagRepository]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this ExperimentInputExperiments.


        :param tags: The tags of this ExperimentInputExperiments.
        :type: list[TagRepository]
        """

        self._tags = tags

    @property
    def framework(self):
        """
        Gets the framework of this MlAssetsCreateModelInput.


        :return: The framework of this MlAssetsCreateModelInput.
        :rtype: FrameworkOutputRepository
        """
        return self._framework

    @framework.setter
    def framework(self, framework):
        """
        Sets the framework of this MlAssetsCreateModelInput.


        :param framework: The framework of this MlAssetsCreateModelInput.
        :type: FrameworkOutputRepository
        """
        self._framework = framework

    @property
    def hyper_parameters(self):
        """
        Gets the hyper_parameters of this MlAssetsCreateModelInput.


        :return: The hyper_parameters of this MlAssetsCreateModelInput.
        :rtype: HyperParameters
        """
        return self._hyper_parameters

    @hyper_parameters.setter
    def hyper_parameters(self, hyper_parameters):
        """
        Sets the framework of this MlAssetsCreateModelInput.


        :param framework: The framework of this MlAssetsCreateModelInput.
        :type: HyperParameters
        """
        self._hyper_parameters = hyper_parameters

    @property
    def content_location(self):
        """
        Gets the content_location of this MlAssetsCreateModelInput.
        :return: The content_location of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._content_location


    @content_location.setter
    def content_location(self, content_location):
        """
        Sets the content_location of this MlAssetsCreateModelInput.
        :param content_location: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._content_location = content_location



    @property
    def name(self):
        """
        Gets the name of this MlAssetsCreateModelInput.


        :return: The name of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MlAssetsCreateModelInput.


        :param name: The name of this MlAssetsCreateModelInput.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this MlAssetsCreateModelInput.


        :return: The description of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MlAssetsCreateModelInput.


        :param description: The description of this MlAssetsCreateModelInput.
        :type: str
        """
        self._description = description

    @property
    def training_definition_url(self):
        """
        Gets the training_definition_url of this MlAssetsCreateModelInput.
        The URL to the training_definitions which was used to create this model

        :return: The training_definition_url of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._training_definition_url

    @training_definition_url.setter
    def training_definition_url(self, training_definition_url):
        """
        Sets the training_definition_url of this MlAssetsCreateModelInput.
        The URL to the training_definitions which was used to create this model

        :param training_definition_url: The training_definition_url of this MlAssetsCreateModelInput.
        :type: str
        """
        self._training_definition_url = training_definition_url

    @property
    def author(self):
        """
        Gets the author of this MlAssetsCreateModelInput.


        :return: The author of this MlAssetsCreateModelInput.
        :rtype: AuthorRepository
        """
        return self._author

    @author.setter
    def author(self, author):
        """
        Sets the author of this MlAssetsCreateModelInput.


        :param author: The author of this MlAssetsCreateModelInput.
        :type: AuthorRepository
        """
        self._author = author

    @property
    def transformed_label(self):
        """
        Gets the transformed_label of this MlAssetsCreateModelInput.


        :return: The transformed_label of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._transformed_label

    @transformed_label.setter
    def transformed_label(self, transformed_label):
        """
        Sets the transformed_label of this MlAssetsCreateModelInput.


        :param transformed_label: The transformed_label of this MlAssetsCreateModelInput.
        :type: str
        """
        self._transformed_label = transformed_label



    @property
    def label_column(self):
        """
        Gets the label_column of this MlAssetsCreateModelInput.
        Name of the label column

        :return: The label_column of this MlAssetsCreateModelInput.
        :rtype: str
        """
        return self._label_column

    @label_column.setter
    def label_column(self, label_column):
        """
        Sets the label_column of this MlAssetsCreateModelInput.
        Name of the label column

        :param label_column: The label_column of this MlAssetsCreateModelInput.
        :type: str
        """
        self._label_column = label_column


    @property
    def training_data_reference(self):
        """
        Gets the training_data of this MlAssetsCreateModelInput.
        :return: The training_data of this MlAssetsCreateModelInput.
        :rtype: ArrayDataInputRepository
        """
        return self._training_data_reference


    @training_data_reference.setter
    def training_data_reference(self, training_data_reference):
        """
        Sets the training_data of this MlAssetsCreateModelInput.
        :param training_data: The training_data of this MlAssetsCreateModelInput.
        :type: ArrayDataInputRepository
        """
        self._training_data_reference = training_data_reference

    @property
    def training_data_schema(self):
        """
        Gets the training_data_schema of this MlAssetsCreateModelInput.


        :return: The training_data_schema of this MlAssetsCreateModelInput.
        :rtype: TrainingDataSchema
        """
        return self._training_data_schema

    @training_data_schema.setter
    def training_data_schema(self, training_data_schema):
        """
        Sets the training_data_schema of this MlAssetsCreateModelInput.


        :param training_data_schema: The training_data_schema of this MlAssetsCreateModelInput.
        :type: TrainingDataSchema
        """
        self._training_data_schema = training_data_schema


    @property
    def input_data_schema(self):
        """
        Gets the input_data_schema of this MlAssetsCreateModelInput.


        :return: The input_data_schema of this MlAssetsCreateModelInput.
        :rtype: InputDataSchema
        """
        return self._input_data_schema

    @input_data_schema.setter
    def input_data_schema(self, input_data_schema):
        """
        Sets the input_data_schema of this MlAssetsCreateModelInput.


        :param input_data_schema: The input_data_schema of this MlAssetsCreateModelInput.
        :type: InputDataSchema
        """
        self._input_data_schema = input_data_schema

    @property
    def evaluation(self):
        """
        Gets the evaluation of this MlAssetsCreateModelInput.
        Definition of the evaluation method used for pipeline models

        :return: The evaluation of this MlAssetsCreateModelInput.
        :rtype: EvaluationDefinitionRepository
        """
        return self._evaluation

    @evaluation.setter
    def evaluation(self, evaluation):
        """
        Sets the evaluation of this MlAssetsCreateModelInput.
        Definition of the evaluation method used for pipeline models

        :param evaluation: The evaluation of this MlAssetsCreateModelInput.
        :type: EvaluationDefinitionRepository
        """
        self._evaluation = evaluation

    @property
    def output_data_schema(self):
        """
        Gets the output_data_schema of this MlAssetsCreateModelInput.


        :return: The output_data_schema of this MlAssetsCreateModelInput.
        :rtype: OutputDataSchema
        """
        return self._output_data_schema

    @output_data_schema.setter
    def output_data_schema(self, output_data_schema):
        """
        Sets the output_data_schema of this MlAssetsCreateModelInput.


        :param output_data_schema: The input_data_schema of this MlAssetsCreateModelInput.
        :type: OutputDataSchema
        """
        self._output_data_schema = output_data_schema

    @property
    def runtime_url(self):
        """
        Gets the runtime_url of this MlAssetsCreateModelInput.


        :return: The runtime_url of this MlAssetsCreateModelInput.
        :rtype: runtime_url
        """
        return self._runtime_url

    @runtime_url.setter
    def runtime_url(self, runtime_url):
        """
        Sets the runtime_url of this MlAssetsCreateModelInput.

        :param runtime_url: The runtime_url of this MlAssetsCreateModelInput.
        :type: runtime_url
        """
        self._runtime_url = runtime_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

