# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class MlAssetsCreateFunctionInput(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MlAssetsCreateFunctionInput - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'tags': 'list[TagRepository]',
            'name': 'str',
            'type': 'str',
            'description': 'str',
            'runtime_url': 'str',
            #'sample_scoring_input': 'SampleScoringInput',
            'input_data_schema': 'InputDataSchema',
            'output_data_schema': 'OutputDataSchema'
        }

        self.attribute_map = {
            'tags': 'tags',
            'name': 'name',
            'type': 'type',
            'description': 'description',
            'runtime_url': 'runtime_url',
            #'sample_scoring_input': 'sample_scoring_input',
            'input_data_schema': 'input_data_schema',
            'output_data_schema': 'output_data_schema'
        }

        self._tags = None
        self._name = None
        self._type = None
        self._description = None
        self._runtime_url = None
        #self._sample_scoring_input = None
        self._input_data_schema = None
        self._output_data_schema = None

    @property
    def tags(self):
        """
        Gets the tags of this MlAssetsCreateFunctionInput.


        :return: The tags of this MlAssetsCreateFunctionInput.
        :rtype: list[TagRepository]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this MlAssetsCreateFunctionInput.


        :param tags: The tags of this MlAssetsCreateFunctionInput.
        :type: list[TagRepository]
        """
        self._tags = tags

    @property
    def name(self):
        """
        Gets the name of this MlAssetsCreateFunctionInput.


        :return: The name of this MlAssetsCreateFunctionInput.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MlAssetsCreateFunctionInput.


        :param name: The name of this MlAssetsCreateFunctionInput.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this MlAssetsCreateFunctionInput.
        Type of the function to be created. Only \"python\" type is supported as of now. If not specified, \"python\" is the default

        :return: The type of this MlAssetsCreateFunctionInput.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MlAssetsCreateFunctionInput.
        Type of the function to be created. Only \"python\" type is supported as of now. If not specified, \"python\" is the default

        :param type: The type of this MlAssetsCreateFunctionInput.
        :type: str
        """
        self._type = type

    @property
    def description(self):
        """
        Gets the description of this MlAssetsCreateFunctionInput.


        :return: The description of this MlAssetsCreateFunctionInput.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MlAssetsCreateFunctionInput.


        :param description: The description of this MlAssetsCreateFunctionInput.
        :type: str
        """
        self._description = description

    @property
    def runtime_url(self):
        """
        Gets the runtime_url of this MlAssetsCreateFunctionInput.


        :return: The runtime_url of this MlAssetsCreateFunctionInput.
        :rtype: str
        """
        return self._runtime_url

    @runtime_url.setter
    def runtime_url(self, runtime_url):
        """
        Sets the runtime_url of this MlAssetsCreateFunctionInput.


        :param runtime_url: The runtime_url of this MlAssetsCreateFunctionInput.
        :type: str
        """
        self._runtime_url = runtime_url

    @property
    def sample_scoring_input(self):
        """
        Gets the sample_scoring_input of this MlAssetsCreateFunctionInput.


        :return: The sample_scoring_input of this MlAssetsCreateFunctionInput.
        :rtype: SampleScoringInput
        """
        return self._sample_scoring_input

    @sample_scoring_input.setter
    def sample_scoring_input(self, sample_scoring_input):
        """
        Sets the sample_scoring_input of this MlAssetsCreateFunctionInput.


        :param sample_scoring_input: The sample_scoring_input of this MlAssetsCreateFunctionInput.
        :type: SampleScoringInput
        """
        self._sample_scoring_input = sample_scoring_input

    @property
    def input_data_schema(self):
        """
        Gets the input_data_schema of this MlAssetsCreateFunctionInput.


        :return: The input_data_schema of this MlAssetsCreateFunctionInput.
        :rtype: InputDataSchema
        """
        return self._input_data_schema

    @input_data_schema.setter
    def input_data_schema(self, input_data_schema):
        """
        Sets the input_data_schema of this MlAssetsCreateFunctionInput.


        :param input_data_schema: The input_data_schema of this MlAssetsCreateFunctionInput.
        :type: InputDataSchema
        """
        self._input_data_schema = input_data_schema

    @property
    def output_data_schema(self):
        """
        Gets the output_data_schema of this MlAssetsCreateFunctionInput.


        :return: The output_data_schema of this MlAssetsCreateFunctionInput.
        :rtype: OutputDataSchema
        """
        return self._output_data_schema

    @output_data_schema.setter
    def output_data_schema(self, output_data_schema):
        """
        Sets the output_data_schema of this MlAssetsCreateFunctionInput.


        :param output_data_schema: The output_data_schema of this MlAssetsCreateFunctionInput.
        :type: OutputDataSchema
        """
        self._output_data_schema = output_data_schema

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

