digraphs = {
    "<(":	"[",	#LEFT SQUARE BRACKET
    "//":	"\\",	#REVERSE SOLIDUS
    ")>":	"]",	#RIGHT SQUARE BRACKET
    "'>":	"^",	#CIRCUMFLEX ACCENT
    "'!":	"`",	#GRAVE ACCENT
    "'?":	"~",	#TILDE
    "NS":	"|",	#NO-BREAK SPACE
    "!I":	"¡",	#INVERTED EXCLAMATION MARK
    "Ct":	"¢",	#CENT SIGN
    "Pd":	"£",	#POUND SIGN
    "Cu":	"¤",	#CURRENCY SIGN
    "Ye":	"¥",	#YEN SIGN
    "BB":	"¦",	#BROKEN BAR
    "SE":	"§",	#SECTION SIGN
    "':":	"¨",	#DIAERESIS
    "Co":	"©",	#COPYRIGHT SIGN
    "-a":	"ª",	#FEMININE ORDINAL INDICATOR
    "<<":	"«",	#LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    "NO":	"¬",	#NOT SIGN
    "--":	"­",	#SOFT HYPHEN
    "Rg":	"®",	#REGISTERED SIGN
    "'m":	"¯",	#MACRON
    "DG":	"°",	#DEGREE SIGN
    "+-":	"±",	#PLUS-MINUS SIGN
    "2S":	"²",	#SUPERSCRIPT TWO
    "3S":	"³",	#SUPERSCRIPT THREE
    "''":	"´",	#ACUTE ACCENT
    "My":	"µ",	#MICRO SIGN
    "PI":	"¶",	#PILCROW SIGN
    ".M":	"·",	#MIDDLE DOT
    "',":	"¸",	#CEDILLA
    "1S":	"¹",	#SUPERSCRIPT ONE
    "-o":	"º",	#MASCULINE ORDINAL INDICATOR
    ">>":	"»",	#RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    "14":	"¼",	#VULGAR FRACTION ONE QUARTER
    "12":	"½",	#VULGAR FRACTION ONE HALF
    "34":	"¾",	#VULGAR FRACTION THREE QUARTERS
    "?I":	"¿",	#INVERTED QUESTION MARK
    "A!":	"À",	#LATIN CAPITAL LETTER A WITH GRAVE
    "A'":	"Á",	#LATIN CAPITAL LETTER A WITH ACUTE
    "A>":	"Â",	#LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    "A?":	"Ã",	#LATIN CAPITAL LETTER A WITH TILDE
    "A:":	"Ä",	#LATIN CAPITAL LETTER A WITH DIAERESIS
    "AA":	"Å",	#LATIN CAPITAL LETTER A WITH RING ABOVE
    "AE":	"Æ",	#LATIN CAPITAL LETTER AE
    "C,":	"Ç",	#LATIN CAPITAL LETTER C WITH CEDILLA
    "E!":	"È",	#LATIN CAPITAL LETTER E WITH GRAVE
    "E'":	"É",	#LATIN CAPITAL LETTER E WITH ACUTE
    "E>":	"Ê",	#LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    "E:":	"Ë",	#LATIN CAPITAL LETTER E WITH DIAERESIS
    "I!":	"Ì",	#LATIN CAPITAL LETTER I WITH GRAVE
    "I'":	"Í",	#LATIN CAPITAL LETTER I WITH ACUTE
    "I>":	"Î",	#LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    "I:":	"Ï",	#LATIN CAPITAL LETTER I WITH DIAERESIS
    "D-":	"Ð",	#LATIN CAPITAL LETTER ETH (Icelandic)
    "N?":	"Ñ",	#LATIN CAPITAL LETTER N WITH TILDE
    "O!":	"Ò",	#LATIN CAPITAL LETTER O WITH GRAVE
    "O'":	"Ó",	#LATIN CAPITAL LETTER O WITH ACUTE
    "O>":	"Ô",	#LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    "O?":	"Õ",	#LATIN CAPITAL LETTER O WITH TILDE
    "O:":	"Ö",	#LATIN CAPITAL LETTER O WITH DIAERESIS
    "*X":	"×",	#MULTIPLICATION SIGN
    "O/":	"Ø",	#LATIN CAPITAL LETTER O WITH STROKE
    "U!":	"Ù",	#LATIN CAPITAL LETTER U WITH GRAVE
    "U'":	"Ú",	#LATIN CAPITAL LETTER U WITH ACUTE
    "U>":	"Û",	#LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    "U:":	"Ü",	#LATIN CAPITAL LETTER U WITH DIAERESIS
    "Y'":	"Ý",	#LATIN CAPITAL LETTER Y WITH ACUTE
    "TH":	"Þ",	#LATIN CAPITAL LETTER THORN (Icelandic)
    "ss":	"ß",	#LATIN SMALL LETTER SHARP S (German)
    "a!":	"à",	#LATIN SMALL LETTER A WITH GRAVE
    "a'":	"á",	#LATIN SMALL LETTER A WITH ACUTE
    "a>":	"â",	#LATIN SMALL LETTER A WITH CIRCUMFLEX
    "a?":	"ã",	#LATIN SMALL LETTER A WITH TILDE
    "a:":	"ä",	#LATIN SMALL LETTER A WITH DIAERESIS
    "aa":	"å",	#LATIN SMALL LETTER A WITH RING ABOVE
    "ae":	"æ",	#LATIN SMALL LETTER AE
    "c,":	"ç",	#LATIN SMALL LETTER C WITH CEDILLA
    "e!":	"è",	#LATIN SMALL LETTER E WITH GRAVE
    "e'":	"é",	#LATIN SMALL LETTER E WITH ACUTE
    "e>":	"ê",	#LATIN SMALL LETTER E WITH CIRCUMFLEX
    "e:":	"ë",	#LATIN SMALL LETTER E WITH DIAERESIS
    "i!":	"ì",	#LATIN SMALL LETTER I WITH GRAVE
    "i'":	"í",	#LATIN SMALL LETTER I WITH ACUTE
    "i>":	"î",	#LATIN SMALL LETTER I WITH CIRCUMFLEX
    "i:":	"ï",	#LATIN SMALL LETTER I WITH DIAERESIS
    "d-":	"ð",	#LATIN SMALL LETTER ETH (Icelandic)
    "n?":	"ñ",	#LATIN SMALL LETTER N WITH TILDE
    "o!":	"ò",	#LATIN SMALL LETTER O WITH GRAVE
    "o'":	"ó",	#LATIN SMALL LETTER O WITH ACUTE
    "o>":	"ô",	#LATIN SMALL LETTER O WITH CIRCUMFLEX
    "o?":	"õ",	#LATIN SMALL LETTER O WITH TILDE
    "o:":	"ö",	#LATIN SMALL LETTER O WITH DIAERESIS
    "-:":	"÷",	#DIVISION SIGN
    "o/":	"ø",	#LATIN SMALL LETTER O WITH STROKE
    "u!":	"ù",	#LATIN SMALL LETTER U WITH GRAVE
    "u'":	"ú",	#LATIN SMALL LETTER U WITH ACUTE
    "u>":	"û",	#LATIN SMALL LETTER U WITH CIRCUMFLEX
    "u:":	"ü",	#LATIN SMALL LETTER U WITH DIAERESIS
    "y'":	"ý",	#LATIN SMALL LETTER Y WITH ACUTE
    "th":	"þ",	#LATIN SMALL LETTER THORN (Icelandic)
    "y:":	"ÿ",	#LATIN SMALL LETTER Y WITH DIAERESIS
    "A-":	"Ā",	#LATIN CAPITAL LETTER A WITH MACRON
    "a-":	"ā",	#LATIN SMALL LETTER A WITH MACRON
    "A(":	"Ă",	#LATIN CAPITAL LETTER A WITH BREVE
    "a(":	"ă",	#LATIN SMALL LETTER A WITH BREVE
    "A;":	"Ą",	#LATIN CAPITAL LETTER A WITH OGONEK
    "a;":	"ą",	#LATIN SMALL LETTER A WITH OGONEK
    "C'":	"Ć",	#LATIN CAPITAL LETTER C WITH ACUTE
    "c'":	"ć",	#LATIN SMALL LETTER C WITH ACUTE
    "C>":	"Ĉ",	#LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    "c>":	"ĉ",	#LATIN SMALL LETTER C WITH CIRCUMFLEX
    "C.":	"Ċ",	#LATIN CAPITAL LETTER C WITH DOT ABOVE
    "c.":	"ċ",	#LATIN SMALL LETTER C WITH DOT ABOVE
    "C<":	"Č",	#LATIN CAPITAL LETTER C WITH CARON
    "c<":	"č",	#LATIN SMALL LETTER C WITH CARON
    "D<":	"Ď",	#LATIN CAPITAL LETTER D WITH CARON
    "d<":	"ď",	#LATIN SMALL LETTER D WITH CARON
    "D/":	"Đ",	#LATIN CAPITAL LETTER D WITH STROKE
    "d/":	"đ",	#LATIN SMALL LETTER D WITH STROKE
    "E-":	"Ē",	#LATIN CAPITAL LETTER E WITH MACRON
    "e-":	"ē",	#LATIN SMALL LETTER E WITH MACRON
    "E(":	"Ĕ",	#LATIN CAPITAL LETTER E WITH BREVE
    "e(":	"ĕ",	#LATIN SMALL LETTER E WITH BREVE
    "E.":	"Ė",	#LATIN CAPITAL LETTER E WITH DOT ABOVE
    "e.":	"ė",	#LATIN SMALL LETTER E WITH DOT ABOVE
    "E;":	"Ę",	#LATIN CAPITAL LETTER E WITH OGONEK
    "e;":	"ę",	#LATIN SMALL LETTER E WITH OGONEK
    "E<":	"Ě",	#LATIN CAPITAL LETTER E WITH CARON
    "e<":	"ě",	#LATIN SMALL LETTER E WITH CARON
    "G>":	"Ĝ",	#LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    "g>":	"ĝ",	#LATIN SMALL LETTER G WITH CIRCUMFLEX
    "G(":	"Ğ",	#LATIN CAPITAL LETTER G WITH BREVE
    "g(":	"ğ",	#LATIN SMALL LETTER G WITH BREVE
    "G.":	"Ġ",	#LATIN CAPITAL LETTER G WITH DOT ABOVE
    "g.":	"ġ",	#LATIN SMALL LETTER G WITH DOT ABOVE
    "G,":	"Ģ",	#LATIN CAPITAL LETTER G WITH CEDILLA
    "g,":	"ģ",	#LATIN SMALL LETTER G WITH CEDILLA
    "H>":	"Ĥ",	#LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    "h>":	"ĥ",	#LATIN SMALL LETTER H WITH CIRCUMFLEX
    "H/":	"Ħ",	#LATIN CAPITAL LETTER H WITH STROKE
    "h/":	"ħ",	#LATIN SMALL LETTER H WITH STROKE
    "I?":	"Ĩ",	#LATIN CAPITAL LETTER I WITH TILDE
    "i?":	"ĩ",	#LATIN SMALL LETTER I WITH TILDE
    "I-":	"Ī",	#LATIN CAPITAL LETTER I WITH MACRON
    "i-":	"ī",	#LATIN SMALL LETTER I WITH MACRON
    "I(":	"Ĭ",	#LATIN CAPITAL LETTER I WITH BREVE
    "i(":	"ĭ",	#LATIN SMALL LETTER I WITH BREVE
    "I;":	"Į",	#LATIN CAPITAL LETTER I WITH OGONEK
    "i;":	"į",	#LATIN SMALL LETTER I WITH OGONEK
    "I.":	"İ",	#LATIN CAPITAL LETTER I WITH DOT ABOVE
    "i.":	"ı",	#LATIN SMALL LETTER DOTLESS I
    "IJ":	"Ĳ",	#LATIN CAPITAL LIGATURE IJ
    "ij":	"ĳ",	#LATIN SMALL LIGATURE IJ
    "J>":	"Ĵ",	#LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    "j>":	"ĵ",	#LATIN SMALL LETTER J WITH CIRCUMFLEX
    "K,":	"Ķ",	#LATIN CAPITAL LETTER K WITH CEDILLA
    "k,":	"ķ",	#LATIN SMALL LETTER K WITH CEDILLA
    "kk":	"ĸ",	#LATIN SMALL LETTER KRA
    "L'":	"Ĺ",	#LATIN CAPITAL LETTER L WITH ACUTE
    "l'":	"ĺ",	#LATIN SMALL LETTER L WITH ACUTE
    "L,":	"Ļ",	#LATIN CAPITAL LETTER L WITH CEDILLA
    "l,":	"ļ",	#LATIN SMALL LETTER L WITH CEDILLA
    "L<":	"Ľ",	#LATIN CAPITAL LETTER L WITH CARON
    "l<":	"ľ",	#LATIN SMALL LETTER L WITH CARON
    "L.":	"Ŀ",	#LATIN CAPITAL LETTER L WITH MIDDLE DOT
    "l.":	"ŀ",	#LATIN SMALL LETTER L WITH MIDDLE DOT
    "L/":	"Ł",	#LATIN CAPITAL LETTER L WITH STROKE
    "l/":	"ł",	#LATIN SMALL LETTER L WITH STROKE
    "N'":	"Ń",	#LATIN CAPITAL LETTER N WITH ACUTE `
    "n'":	"ń",	#LATIN SMALL LETTER N WITH ACUTE `
    "N,":	"Ņ",	#LATIN CAPITAL LETTER N WITH CEDILLA `
    "n,":	"ņ",	#LATIN SMALL LETTER N WITH CEDILLA `
    "N<":	"Ň",	#LATIN CAPITAL LETTER N WITH CARON `
    "n<":	"ň",	#LATIN SMALL LETTER N WITH CARON `
    "'n":	"ŉ",	#LATIN SMALL LETTER N PRECEDED BY APOSTROPHE `
    "NG":	"Ŋ",	#LATIN CAPITAL LETTER ENG
    "ng":	"ŋ",	#LATIN SMALL LETTER ENG
    "O-":	"Ō",	#LATIN CAPITAL LETTER O WITH MACRON
    "o-":	"ō",	#LATIN SMALL LETTER O WITH MACRON
    "O(":	"Ŏ",	#LATIN CAPITAL LETTER O WITH BREVE
    "o(":	"ŏ",	#LATIN SMALL LETTER O WITH BREVE
    "O\"":	"Ő",	#LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    "o\"":	"ő",	#LATIN SMALL LETTER O WITH DOUBLE ACUTE
    "OE":	"Œ",	#LATIN CAPITAL LIGATURE OE
    "oe":	"œ",	#LATIN SMALL LIGATURE OE
    "R'":	"Ŕ",	#LATIN CAPITAL LETTER R WITH ACUTE
    "r'":	"ŕ",	#LATIN SMALL LETTER R WITH ACUTE
    "R,":	"Ŗ",	#LATIN CAPITAL LETTER R WITH CEDILLA
    "r,":	"ŗ",	#LATIN SMALL LETTER R WITH CEDILLA
    "R<":	"Ř",	#LATIN CAPITAL LETTER R WITH CARON
    "r<":	"ř",	#LATIN SMALL LETTER R WITH CARON
    "S'":	"Ś",	#LATIN CAPITAL LETTER S WITH ACUTE
    "s'":	"ś",	#LATIN SMALL LETTER S WITH ACUTE
    "S>":	"Ŝ",	#LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    "s>":	"ŝ",	#LATIN SMALL LETTER S WITH CIRCUMFLEX
    "S,":	"Ş",	#LATIN CAPITAL LETTER S WITH CEDILLA
    "s,":	"ş",	#LATIN SMALL LETTER S WITH CEDILLA
    "S<":	"Š",	#LATIN CAPITAL LETTER S WITH CARON
    "s<":	"š",	#LATIN SMALL LETTER S WITH CARON
    "T,":	"Ţ",	#LATIN CAPITAL LETTER T WITH CEDILLA
    "t,":	"ţ",	#LATIN SMALL LETTER T WITH CEDILLA
    "T<":	"Ť",	#LATIN CAPITAL LETTER T WITH CARON
    "t<":	"ť",	#LATIN SMALL LETTER T WITH CARON
    "T/":	"Ŧ",	#LATIN CAPITAL LETTER T WITH STROKE
    "t/":	"ŧ",	#LATIN SMALL LETTER T WITH STROKE
    "U?":	"Ũ",	#LATIN CAPITAL LETTER U WITH TILDE
    "u?":	"ũ",	#LATIN SMALL LETTER U WITH TILDE
    "U-":	"Ū",	#LATIN CAPITAL LETTER U WITH MACRON
    "u-":	"ū",	#LATIN SMALL LETTER U WITH MACRON
    "U(":	"Ŭ",	#LATIN CAPITAL LETTER U WITH BREVE
    "u(":	"ŭ",	#LATIN SMALL LETTER U WITH BREVE
    "U0":	"Ů",	#LATIN CAPITAL LETTER U WITH RING ABOVE
    "u0":	"ů",	#LATIN SMALL LETTER U WITH RING ABOVE
    "U\"":	"Ű",	#LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    "u\"":	"ű",	#LATIN SMALL LETTER U WITH DOUBLE ACUTE
    "U;":	"Ų",	#LATIN CAPITAL LETTER U WITH OGONEK
    "u;":	"ų",	#LATIN SMALL LETTER U WITH OGONEK
    "W>":	"Ŵ",	#LATIN CAPITAL LETTER W WITH CIRCUMFLEX
    "w>":	"ŵ",	#LATIN SMALL LETTER W WITH CIRCUMFLEX
    "Y>":	"Ŷ",	#LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
    "y>":	"ŷ",	#LATIN SMALL LETTER Y WITH CIRCUMFLEX
    "Y:":	"Ÿ",	#LATIN CAPITAL LETTER Y WITH DIAERESIS
    "Z'":	"Ź",	#LATIN CAPITAL LETTER Z WITH ACUTE
    "z'":	"ź",	#LATIN SMALL LETTER Z WITH ACUTE
    "Z.":	"Ż",	#LATIN CAPITAL LETTER Z WITH DOT ABOVE
    "z.":	"ż",	#LATIN SMALL LETTER Z WITH DOT ABOVE
    "Z<":	"Ž",	#LATIN CAPITAL LETTER Z WITH CARON
    "z<":	"ž",	#LATIN SMALL LETTER Z WITH CARON
    "O9":	"Ơ",	#LATIN CAPITAL LETTER O WITH HORN
    "o9":	"ơ",	#LATIN SMALL LETTER O WITH HORN
    "OI":	"Ƣ",	#LATIN CAPITAL LETTER OI
    "oi":	"ƣ",	#LATIN SMALL LETTER OI
    "yr":	"Ʀ",	#LATIN LETTER YR
    "U9":	"Ư",	#LATIN CAPITAL LETTER U WITH HORN
    "u9":	"ư",	#LATIN SMALL LETTER U WITH HORN
    "Z/":	"Ƶ",	#LATIN CAPITAL LETTER Z WITH STROKE
    "z/":	"ƶ",	#LATIN SMALL LETTER Z WITH STROKE
    "ED":	"Ʒ",	#LATIN CAPITAL LETTER EZH
    "A<":	"Ǎ",	#LATIN CAPITAL LETTER A WITH CARON
    "a<":	"ǎ",	#LATIN SMALL LETTER A WITH CARON
    "I<":	"Ǐ",	#LATIN CAPITAL LETTER I WITH CARON
    "i<":	"ǐ",	#LATIN SMALL LETTER I WITH CARON
    "O<":	"Ǒ",	#LATIN CAPITAL LETTER O WITH CARON
    "o<":	"ǒ",	#LATIN SMALL LETTER O WITH CARON
    "U<":	"Ǔ",	#LATIN CAPITAL LETTER U WITH CARON
    "u<":	"ǔ",	#LATIN SMALL LETTER U WITH CARON
    "A1":	"Ǟ",	#LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
    "a1":	"ǟ",	#LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
    "A7":	"Ǡ",	#LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
    "a7":	"ǡ",	#LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
    "A3":	"Ǣ",	#LATIN CAPITAL LETTER AE WITH MACRON
    "a3":	"ǣ",	#LATIN SMALL LETTER AE WITH MACRON
    "G/":	"Ǥ",	#LATIN CAPITAL LETTER G WITH STROKE
    "g/":	"ǥ",	#LATIN SMALL LETTER G WITH STROKE
    "G<":	"Ǧ",	#LATIN CAPITAL LETTER G WITH CARON
    "g<":	"ǧ",	#LATIN SMALL LETTER G WITH CARON
    "K<":	"Ǩ",	#LATIN CAPITAL LETTER K WITH CARON
    "k<":	"ǩ",	#LATIN SMALL LETTER K WITH CARON
    "O;":	"Ǫ",	#LATIN CAPITAL LETTER O WITH OGONEK
    "o;":	"ǫ",	#LATIN SMALL LETTER O WITH OGONEK
    "O1":	"Ǭ",	#LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
    "o1":	"ǭ",	#LATIN SMALL LETTER O WITH OGONEK AND MACRON
    "EZ":	"Ǯ",	#LATIN CAPITAL LETTER EZH WITH CARON
    "ez":	"ǯ",	#LATIN SMALL LETTER EZH WITH CARON
    "j<":	"ǰ",	#LATIN SMALL LETTER J WITH CARON
    "G'":	"Ǵ",	#LATIN CAPITAL LETTER G WITH ACUTE
    "g'":	"ǵ",	#LATIN SMALL LETTER G WITH ACUTE
    ";S":	"ʿ",	#MODIFIER LETTER LEFT HALF RING
    "'<":	"ˇ",	#CARON
    "'(":	"˘",	#BREVE
    "'.":	"˙",	#DOT ABOVE
    "'0":	"˚",	#RING ABOVE
    "';":	"˛",	#OGONEK
    "'\"":	"˝",	#DOUBLE ACUTE ACCENT
    "A%":	"Ά",	#GREEK CAPITAL LETTER ALPHA WITH TONOS
    "E%":	"Έ",	#GREEK CAPITAL LETTER EPSILON WITH TONOS
    "Y%":	"Ή",	#GREEK CAPITAL LETTER ETA WITH TONOS
    "I%":	"Ί",	#GREEK CAPITAL LETTER IOTA WITH TONOS
    "O%":	"Ό",	#GREEK CAPITAL LETTER OMICRON WITH TONOS
    "U%":	"Ύ",	#GREEK CAPITAL LETTER UPSILON WITH TONOS
    "W%":	"Ώ",	#GREEK CAPITAL LETTER OMEGA WITH TONOS
    "i3":	"ΐ",	#GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    "A*":	"Α",	#GREEK CAPITAL LETTER ALPHA
    "B*":	"Β",	#GREEK CAPITAL LETTER BETA
    "G*":	"Γ",	#GREEK CAPITAL LETTER GAMMA
    "D*":	"Δ",	#GREEK CAPITAL LETTER DELTA
    "E*":	"Ε",	#GREEK CAPITAL LETTER EPSILON
    "Z*":	"Ζ",	#GREEK CAPITAL LETTER ZETA
    "Y*":	"Η",	#GREEK CAPITAL LETTER ETA
    "H*":	"Θ",	#GREEK CAPITAL LETTER THETA
    "I*":	"Ι",	#GREEK CAPITAL LETTER IOTA
    "K*":	"Κ",	#GREEK CAPITAL LETTER KAPPA
    "L*":	"Λ",	#GREEK CAPITAL LETTER LAMDA
    "M*":	"Μ",	#GREEK CAPITAL LETTER MU
    "N*":	"Ν",	#GREEK CAPITAL LETTER NU
    "C*":	"Ξ",	#GREEK CAPITAL LETTER XI
    "O*":	"Ο",	#GREEK CAPITAL LETTER OMICRON
    "P*":	"Π",	#GREEK CAPITAL LETTER PI
    "R*":	"Ρ",	#GREEK CAPITAL LETTER RHO
    "S*":	"Σ",	#GREEK CAPITAL LETTER SIGMA
    "T*":	"Τ",	#GREEK CAPITAL LETTER TAU
    "U*":	"Υ",	#GREEK CAPITAL LETTER UPSILON
    "F*":	"Φ",	#GREEK CAPITAL LETTER PHI
    "X*":	"Χ",	#GREEK CAPITAL LETTER CHI
    "Q*":	"Ψ",	#GREEK CAPITAL LETTER PSI
    "W*":	"Ω",	#GREEK CAPITAL LETTER OMEGA
    "J*":	"Ϊ",	#GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    "V*":	"Ϋ",	#GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    "a%":	"ά",	#GREEK SMALL LETTER ALPHA WITH TONOS
    "e%":	"έ",	#GREEK SMALL LETTER EPSILON WITH TONOS
    "y%":	"ή",	#GREEK SMALL LETTER ETA WITH TONOS
    "i%":	"ί",	#GREEK SMALL LETTER IOTA WITH TONOS
    "u3":	"ΰ",	#GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    "a*":	"α",	#GREEK SMALL LETTER ALPHA
    "b*":	"β",	#GREEK SMALL LETTER BETA
    "g*":	"γ",	#GREEK SMALL LETTER GAMMA
    "d*":	"δ",	#GREEK SMALL LETTER DELTA
    "e*":	"ε",	#GREEK SMALL LETTER EPSILON
    "z*":	"ζ",	#GREEK SMALL LETTER ZETA
    "y*":	"η",	#GREEK SMALL LETTER ETA
    "h*":	"θ",	#GREEK SMALL LETTER THETA
    "i*":	"ι",	#GREEK SMALL LETTER IOTA
    "k*":	"κ",	#GREEK SMALL LETTER KAPPA
    "l*":	"λ",	#GREEK SMALL LETTER LAMDA
    "m*":	"μ",	#GREEK SMALL LETTER MU
    "n*":	"ν",	#GREEK SMALL LETTER NU
    "c*":	"ξ",	#GREEK SMALL LETTER XI
    "o*":	"ο",	#GREEK SMALL LETTER OMICRON
    "p*":	"π",	#GREEK SMALL LETTER PI
    "r*":	"ρ",	#GREEK SMALL LETTER RHO
    "*s":	"ς",	#GREEK SMALL LETTER FINAL SIGMA
    "s*":	"σ",	#GREEK SMALL LETTER SIGMA
    "t*":	"τ",	#GREEK SMALL LETTER TAU
    "u*":	"υ",	#GREEK SMALL LETTER UPSILON
    "f*":	"φ",	#GREEK SMALL LETTER PHI
    "x*":	"χ",	#GREEK SMALL LETTER CHI
    "q*":	"ψ",	#GREEK SMALL LETTER PSI
    "w*":	"ω",	#GREEK SMALL LETTER OMEGA
    "j*":	"ϊ",	#GREEK SMALL LETTER IOTA WITH DIALYTIKA
    "v*":	"ϋ",	#GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    "o%":	"ό",	#GREEK SMALL LETTER OMICRON WITH TONOS
    "u%":	"ύ",	#GREEK SMALL LETTER UPSILON WITH TONOS
    "w%":	"ώ",	#GREEK SMALL LETTER OMEGA WITH TONOS
    "'G":	"Ϙ",	#GREEK LETTER ARCHAIC KOPPA
    ",G":	"ϙ",	#GREEK SMALL LETTER ARCHAIC KOPPA
    "T3":	"Ϛ",	#GREEK LETTER STIGMA
    "t3":	"ϛ",	#GREEK SMALL LETTER STIGMA
    "M3":	"Ϝ",	#GREEK LETTER DIGAMMA
    "m3":	"ϝ",	#GREEK SMALL LETTER DIGAMMA
    "K3":	"Ϟ",	#GREEK LETTER KOPPA
    "k3":	"ϟ",	#GREEK SMALL LETTER KOPPA
    "P3":	"Ϡ",	#GREEK LETTER SAMPI
    "p3":	"ϡ",	#GREEK SMALL LETTER SAMPI
    "'%":	"ϴ",	#GREEK CAPITAL THETA SYMBOL
    "j3":	"ϵ",	#GREEK LUNATE EPSILON SYMBOL
    "IO":	"Ё",	#CYRILLIC CAPITAL LETTER IO
    "D%":	"Ђ",	#CYRILLIC CAPITAL LETTER DJE
    "G%":	"Ѓ",	#CYRILLIC CAPITAL LETTER GJE
    "IE":	"Є",	#CYRILLIC CAPITAL LETTER UKRAINIAN IE
    "DS":	"Ѕ",	#CYRILLIC CAPITAL LETTER DZE
    "II":	"І",	#CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    "YI":	"Ї",	#CYRILLIC CAPITAL LETTER YI
    "J%":	"Ј",	#CYRILLIC CAPITAL LETTER JE
    "LJ":	"Љ",	#CYRILLIC CAPITAL LETTER LJE
    "NJ":	"Њ",	#CYRILLIC CAPITAL LETTER NJE
    "Ts":	"Ћ",	#CYRILLIC CAPITAL LETTER TSHE
    "KJ":	"Ќ",	#CYRILLIC CAPITAL LETTER KJE
    "V%":	"Ў",	#CYRILLIC CAPITAL LETTER SHORT U
    "DZ":	"Џ",	#CYRILLIC CAPITAL LETTER DZHE
    "A=":	"А",	#CYRILLIC CAPITAL LETTER A
    "B=":	"Б",	#CYRILLIC CAPITAL LETTER BE
    "V=":	"В",	#CYRILLIC CAPITAL LETTER VE
    "G=":	"Г",	#CYRILLIC CAPITAL LETTER GHE
    "D=":	"Д",	#CYRILLIC CAPITAL LETTER DE
    "E=":	"Е",	#CYRILLIC CAPITAL LETTER IE
    "Z%":	"Ж",	#CYRILLIC CAPITAL LETTER ZHE
    "Z=":	"З",	#CYRILLIC CAPITAL LETTER ZE
    "I=":	"И",	#CYRILLIC CAPITAL LETTER I
    "J=":	"Й",	#CYRILLIC CAPITAL LETTER SHORT I
    "K=":	"К",	#CYRILLIC CAPITAL LETTER KA
    "L=":	"Л",	#CYRILLIC CAPITAL LETTER EL
    "M=":	"М",	#CYRILLIC CAPITAL LETTER EM
    "N=":	"Н",	#CYRILLIC CAPITAL LETTER EN
    "O=":	"О",	#CYRILLIC CAPITAL LETTER O
    "P=":	"П",	#CYRILLIC CAPITAL LETTER PE
    "R=":	"Р",	#CYRILLIC CAPITAL LETTER ER
    "S=":	"С",	#CYRILLIC CAPITAL LETTER ES
    "T=":	"Т",	#CYRILLIC CAPITAL LETTER TE
    "U=":	"У",	#CYRILLIC CAPITAL LETTER U
    "F=":	"Ф",	#CYRILLIC CAPITAL LETTER EF
    "H=":	"Х",	#CYRILLIC CAPITAL LETTER HA
    "C=":	"Ц",	#CYRILLIC CAPITAL LETTER TSE
    "C%":	"Ч",	#CYRILLIC CAPITAL LETTER CHE
    "S%":	"Ш",	#CYRILLIC CAPITAL LETTER SHA
    "Sc":	"Щ",	#CYRILLIC CAPITAL LETTER SHCHA
    "=\"":	"Ъ",	#CYRILLIC CAPITAL LETTER HARD SIGN
    "Y=":	"Ы",	#CYRILLIC CAPITAL LETTER YERU
    "%\"":	"Ь",	#CYRILLIC CAPITAL LETTER SOFT SIGN
    "JE":	"Э",	#CYRILLIC CAPITAL LETTER E
    "JU":	"Ю",	#CYRILLIC CAPITAL LETTER YU
    "JA":	"Я",	#CYRILLIC CAPITAL LETTER YA
    "a=":	"а",	#CYRILLIC SMALL LETTER A
    "b=":	"б",	#CYRILLIC SMALL LETTER BE
    "v=":	"в",	#CYRILLIC SMALL LETTER VE
    "g=":	"г",	#CYRILLIC SMALL LETTER GHE
    "d=":	"д",	#CYRILLIC SMALL LETTER DE
    "e=":	"е",	#CYRILLIC SMALL LETTER IE
    "z%":	"ж",	#CYRILLIC SMALL LETTER ZHE
    "z=":	"з",	#CYRILLIC SMALL LETTER ZE
    "i=":	"и",	#CYRILLIC SMALL LETTER I
    "j=":	"й",	#CYRILLIC SMALL LETTER SHORT I
    "k=":	"к",	#CYRILLIC SMALL LETTER KA
    "l=":	"л",	#CYRILLIC SMALL LETTER EL
    "m=":	"м",	#CYRILLIC SMALL LETTER EM
    "n=":	"н",	#CYRILLIC SMALL LETTER EN
    "o=":	"о",	#CYRILLIC SMALL LETTER O
    "p=":	"п",	#CYRILLIC SMALL LETTER PE
    "r=":	"р",	#CYRILLIC SMALL LETTER ER
    "s=":	"с",	#CYRILLIC SMALL LETTER ES
    "t=":	"т",	#CYRILLIC SMALL LETTER TE
    "u=":	"у",	#CYRILLIC SMALL LETTER U
    "f=":	"ф",	#CYRILLIC SMALL LETTER EF
    "h=":	"х",	#CYRILLIC SMALL LETTER HA
    "c=":	"ц",	#CYRILLIC SMALL LETTER TSE
    "c%":	"ч",	#CYRILLIC SMALL LETTER CHE
    "s%":	"ш",	#CYRILLIC SMALL LETTER SHA
    "sc":	"щ",	#CYRILLIC SMALL LETTER SHCHA
    "='":	"ъ",	#CYRILLIC SMALL LETTER HARD SIGN
    "y=":	"ы",	#CYRILLIC SMALL LETTER YERU
    "%'":	"ь",	#CYRILLIC SMALL LETTER SOFT SIGN
    "je":	"э",	#CYRILLIC SMALL LETTER E
    "ju":	"ю",	#CYRILLIC SMALL LETTER YU
    "ja":	"я",	#CYRILLIC SMALL LETTER YA
    "io":	"ё",	#CYRILLIC SMALL LETTER IO
    "d%":	"ђ",	#CYRILLIC SMALL LETTER DJE
    "g%":	"ѓ",	#CYRILLIC SMALL LETTER GJE
    "ie":	"є",	#CYRILLIC SMALL LETTER UKRAINIAN IE
    "ds":	"ѕ",	#CYRILLIC SMALL LETTER DZE
    "ii":	"і",	#CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    "yi":	"ї",	#CYRILLIC SMALL LETTER YI
    "j%":	"ј",	#CYRILLIC SMALL LETTER JE
    "lj":	"љ",	#CYRILLIC SMALL LETTER LJE
    "nj":	"њ",	#CYRILLIC SMALL LETTER NJE
    "ts":	"ћ",	#CYRILLIC SMALL LETTER TSHE
    "kj":	"ќ",	#CYRILLIC SMALL LETTER KJE
    "v%":	"ў",	#CYRILLIC SMALL LETTER SHORT U
    "dz":	"џ",	#CYRILLIC SMALL LETTER DZHE
    "Y3":	"Ѣ",	#CYRILLIC CAPITAL LETTER YAT
    "y3":	"ѣ",	#CYRILLIC SMALL LETTER YAT
    "O3":	"Ѫ",	#CYRILLIC CAPITAL LETTER BIG YUS
    "o3":	"ѫ",	#CYRILLIC SMALL LETTER BIG YUS
    "F3":	"Ѳ",	#CYRILLIC CAPITAL LETTER FITA
    "f3":	"ѳ",	#CYRILLIC SMALL LETTER FITA
    "V3":	"Ѵ",	#CYRILLIC CAPITAL LETTER IZHITSA
    "v3":	"ѵ",	#CYRILLIC SMALL LETTER IZHITSA
    "C3":	"Ҁ",	#CYRILLIC CAPITAL LETTER KOPPA
    "c3":	"ҁ",	#CYRILLIC SMALL LETTER KOPPA
    "G3":	"Ґ",	#CYRILLIC CAPITAL LETTER GHE WITH UPTURN
    "g3":	"ґ",	#CYRILLIC SMALL LETTER GHE WITH UPTURN
    "A+":	"א",	#HEBREW LETTER ALEF
    "B+":	"ב",	#HEBREW LETTER BET
    "G+":	"ג",	#HEBREW LETTER GIMEL
    "D+":	"ד",	#HEBREW LETTER DALET
    "H+":	"ה",	#HEBREW LETTER HE
    "W+":	"ו",	#HEBREW LETTER VAV
    "Z+":	"ז",	#HEBREW LETTER ZAYIN
    "X+":	"ח",	#HEBREW LETTER HET
    "Tj":	"ט",	#HEBREW LETTER TET
    "J+":	"י",	#HEBREW LETTER YOD
    "K%":	"ך",	#HEBREW LETTER FINAL KAF
    "K+":	"כ",	#HEBREW LETTER KAF
    "L+":	"ל",	#HEBREW LETTER LAMED
    "M%":	"ם",	#HEBREW LETTER FINAL MEM
    "M+":	"מ",	#HEBREW LETTER MEM
    "N%":	"ן",	#HEBREW LETTER FINAL NUN `
    "N+":	"נ",	#HEBREW LETTER NUN `
    "S+":	"ס",	#HEBREW LETTER SAMEKH
    "E+":	"ע",	#HEBREW LETTER AYIN
    "P%":	"ף",	#HEBREW LETTER FINAL PE
    "P+":	"פ",	#HEBREW LETTER PE
    "Zj":	"ץ",	#HEBREW LETTER FINAL TSADI
    "ZJ":	"צ",	#HEBREW LETTER TSADI
    "Q+":	"ק",	#HEBREW LETTER QOF
    "R+":	"ר",	#HEBREW LETTER RESH
    "Sh":	"ש",	#HEBREW LETTER SHIN
    "T+":	"ת",	#HEBREW LETTER TAV
    "B.":	"Ḃ",	#LATIN CAPITAL LETTER B WITH DOT ABOVE
    "b.":	"ḃ",	#LATIN SMALL LETTER B WITH DOT ABOVE
    "B_":	"Ḇ",	#LATIN CAPITAL LETTER B WITH LINE BELOW
    "b_":	"ḇ",	#LATIN SMALL LETTER B WITH LINE BELOW
    "D.":	"Ḋ",	#LATIN CAPITAL LETTER D WITH DOT ABOVE
    "d.":	"ḋ",	#LATIN SMALL LETTER D WITH DOT ABOVE
    "D_":	"Ḏ",	#LATIN CAPITAL LETTER D WITH LINE BELOW
    "d_":	"ḏ",	#LATIN SMALL LETTER D WITH LINE BELOW
    "D,":	"Ḑ",	#LATIN CAPITAL LETTER D WITH CEDILLA
    "d,":	"ḑ",	#LATIN SMALL LETTER D WITH CEDILLA
    "F.":	"Ḟ",	#LATIN CAPITAL LETTER F WITH DOT ABOVE
    "f.":	"ḟ",	#LATIN SMALL LETTER F WITH DOT ABOVE
    "G-":	"Ḡ",	#LATIN CAPITAL LETTER G WITH MACRON
    "g-":	"ḡ",	#LATIN SMALL LETTER G WITH MACRON
    "H.":	"Ḣ",	#LATIN CAPITAL LETTER H WITH DOT ABOVE
    "h.":	"ḣ",	#LATIN SMALL LETTER H WITH DOT ABOVE
    "H:":	"Ḧ",	#LATIN CAPITAL LETTER H WITH DIAERESIS
    "h:":	"ḧ",	#LATIN SMALL LETTER H WITH DIAERESIS
    "H,":	"Ḩ",	#LATIN CAPITAL LETTER H WITH CEDILLA
    "h,":	"ḩ",	#LATIN SMALL LETTER H WITH CEDILLA
    "K'":	"Ḱ",	#LATIN CAPITAL LETTER K WITH ACUTE
    "k'":	"ḱ",	#LATIN SMALL LETTER K WITH ACUTE
    "K_":	"Ḵ",	#LATIN CAPITAL LETTER K WITH LINE BELOW
    "k_":	"ḵ",	#LATIN SMALL LETTER K WITH LINE BELOW
    "L_":	"Ḻ",	#LATIN CAPITAL LETTER L WITH LINE BELOW
    "l_":	"ḻ",	#LATIN SMALL LETTER L WITH LINE BELOW
    "M'":	"Ḿ",	#LATIN CAPITAL LETTER M WITH ACUTE
    "m'":	"ḿ",	#LATIN SMALL LETTER M WITH ACUTE
    "M.":	"Ṁ",	#LATIN CAPITAL LETTER M WITH DOT ABOVE
    "m.":	"ṁ",	#LATIN SMALL LETTER M WITH DOT ABOVE
    "N.":	"Ṅ",	#LATIN CAPITAL LETTER N WITH DOT ABOVE `
    "n.":	"ṅ",	#LATIN SMALL LETTER N WITH DOT ABOVE `
    "N_":	"Ṉ",	#LATIN CAPITAL LETTER N WITH LINE BELOW `
    "n_":	"ṉ",	#LATIN SMALL LETTER N WITH LINE BELOW `
    "P'":	"Ṕ",	#LATIN CAPITAL LETTER P WITH ACUTE
    "p'":	"ṕ",	#LATIN SMALL LETTER P WITH ACUTE
    "P.":	"Ṗ",	#LATIN CAPITAL LETTER P WITH DOT ABOVE
    "p.":	"ṗ",	#LATIN SMALL LETTER P WITH DOT ABOVE
    "R.":	"Ṙ",	#LATIN CAPITAL LETTER R WITH DOT ABOVE
    "r.":	"ṙ",	#LATIN SMALL LETTER R WITH DOT ABOVE
    "R_":	"Ṟ",	#LATIN CAPITAL LETTER R WITH LINE BELOW
    "r_":	"ṟ",	#LATIN SMALL LETTER R WITH LINE BELOW
    "S.":	"Ṡ",	#LATIN CAPITAL LETTER S WITH DOT ABOVE
    "s.":	"ṡ",	#LATIN SMALL LETTER S WITH DOT ABOVE
    "T.":	"Ṫ",	#LATIN CAPITAL LETTER T WITH DOT ABOVE
    "t.":	"ṫ",	#LATIN SMALL LETTER T WITH DOT ABOVE
    "T_":	"Ṯ",	#LATIN CAPITAL LETTER T WITH LINE BELOW
    "t_":	"ṯ",	#LATIN SMALL LETTER T WITH LINE BELOW
    "V?":	"Ṽ",	#LATIN CAPITAL LETTER V WITH TILDE
    "v?":	"ṽ",	#LATIN SMALL LETTER V WITH TILDE
    "W!":	"Ẁ",	#LATIN CAPITAL LETTER W WITH GRAVE
    "w!":	"ẁ",	#LATIN SMALL LETTER W WITH GRAVE
    "W'":	"Ẃ",	#LATIN CAPITAL LETTER W WITH ACUTE
    "w'":	"ẃ",	#LATIN SMALL LETTER W WITH ACUTE
    "W:":	"Ẅ",	#LATIN CAPITAL LETTER W WITH DIAERESIS
    "w:":	"ẅ",	#LATIN SMALL LETTER W WITH DIAERESIS
    "W.":	"Ẇ",	#LATIN CAPITAL LETTER W WITH DOT ABOVE
    "w.":	"ẇ",	#LATIN SMALL LETTER W WITH DOT ABOVE
    "X.":	"Ẋ",	#LATIN CAPITAL LETTER X WITH DOT ABOVE
    "x.":	"ẋ",	#LATIN SMALL LETTER X WITH DOT ABOVE
    "X:":	"Ẍ",	#LATIN CAPITAL LETTER X WITH DIAERESIS
    "x:":	"ẍ",	#LATIN SMALL LETTER X WITH DIAERESIS
    "Y.":	"Ẏ",	#LATIN CAPITAL LETTER Y WITH DOT ABOVE
    "y.":	"ẏ",	#LATIN SMALL LETTER Y WITH DOT ABOVE
    "Z>":	"Ẑ",	#LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
    "z>":	"ẑ",	#LATIN SMALL LETTER Z WITH CIRCUMFLEX
    "Z_":	"Ẕ",	#LATIN CAPITAL LETTER Z WITH LINE BELOW
    "z_":	"ẕ",	#LATIN SMALL LETTER Z WITH LINE BELOW
    "h_":	"ẖ",	#LATIN SMALL LETTER H WITH LINE BELOW
    "t:":	"ẗ",	#LATIN SMALL LETTER T WITH DIAERESIS
    "w0":	"ẘ",	#LATIN SMALL LETTER W WITH RING ABOVE
    "y0":	"ẙ",	#LATIN SMALL LETTER Y WITH RING ABOVE
    "A2":	"Ả",	#LATIN CAPITAL LETTER A WITH HOOK ABOVE
    "a2":	"ả",	#LATIN SMALL LETTER A WITH HOOK ABOVE
    "E2":	"Ẻ",	#LATIN CAPITAL LETTER E WITH HOOK ABOVE
    "e2":	"ẻ",	#LATIN SMALL LETTER E WITH HOOK ABOVE
    "E?":	"Ẽ",	#LATIN CAPITAL LETTER E WITH TILDE
    "e?":	"ẽ",	#LATIN SMALL LETTER E WITH TILDE
    "I2":	"Ỉ",	#LATIN CAPITAL LETTER I WITH HOOK ABOVE
    "i2":	"ỉ",	#LATIN SMALL LETTER I WITH HOOK ABOVE
    "O2":	"Ỏ",	#LATIN CAPITAL LETTER O WITH HOOK ABOVE
    "o2":	"ỏ",	#LATIN SMALL LETTER O WITH HOOK ABOVE
    "U2":	"Ủ",	#LATIN CAPITAL LETTER U WITH HOOK ABOVE
    "u2":	"ủ",	#LATIN SMALL LETTER U WITH HOOK ABOVE
    "Y!":	"Ỳ",	#LATIN CAPITAL LETTER Y WITH GRAVE
    "y!":	"ỳ",	#LATIN SMALL LETTER Y WITH GRAVE
    "Y2":	"Ỷ",	#LATIN CAPITAL LETTER Y WITH HOOK ABOVE
    "y2":	"ỷ",	#LATIN SMALL LETTER Y WITH HOOK ABOVE
    "Y?":	"Ỹ",	#LATIN CAPITAL LETTER Y WITH TILDE
    "y?":	"ỹ",	#LATIN SMALL LETTER Y WITH TILDE
    ";'":	"ἀ",	#GREEK SMALL LETTER ALPHA WITH PSILI
    ",'":	"ἁ",	#GREEK SMALL LETTER ALPHA WITH DASIA
    ";!":	"ἂ",	#GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
    ",!":	"ἃ",	#GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
    "?;":	"ἄ",	#GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
    "?,":	"ἅ",	#GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
    "!:":	"ἆ",	#GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
    "?:":	"ἇ",	#GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
    "1N":	" ",	#EN SPACE
    "1M":	" ",	#EM SPACE
    "3M":	" ",	#THREE-PER-EM SPACE
    "4M":	" ",	#FOUR-PER-EM SPACE
    "6M":	" ",	#SIX-PER-EM SPACE
    "1T":	" ",	#THIN SPACE
    "1H":	" ",	#HAIR SPACE
    "-1":	"‐",	#HYPHEN
    "-N":	"–",	#EN DASH `
    "-M":	"—",	#EM DASH
    "-3":	"―",	#HORIZONTAL BAR
    "!2":	"‖",	#DOUBLE VERTICAL LINE
    "=2":	"‗",	#DOUBLE LOW LINE
    "'6":	"‘",	#LEFT SINGLE QUOTATION MARK
    "'9":	"’",	#RIGHT SINGLE QUOTATION MARK
    ".9":	"‚",	#SINGLE LOW-9 QUOTATION MARK
    "9'":	"‛",	#SINGLE HIGH-REVERSED-9 QUOTATION MARK
    "%0":	"‰",	#PER MILLE SIGN
    "1'":	"′",	#PRIME
    "2'":	"″",	#DOUBLE PRIME
    "3'":	"‴",	#TRIPLE PRIME
    "1\"":	"‵",	#REVERSED PRIME
    "2\"":	"‶",	#REVERSED DOUBLE PRIME
    "3\"":	"‷",	#REVERSED TRIPLE PRIME
    "Ca":	"‸",	#CARET
    "<1":	"‹",	#SINGLE LEFT-POINTING ANGLE QUOTATION MARK
    ">1":	"›",	#SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
    ":X":	"※",	#REFERENCE MARK
    "'-":	"‾",	#OVERLINE
    "/f":	"⁄",	#FRACTION SLASH
    "0S":	"⁰",	#SUPERSCRIPT ZERO
    "4S":	"⁴",	#SUPERSCRIPT FOUR
    "5S":	"⁵",	#SUPERSCRIPT FIVE
    "6S":	"⁶",	#SUPERSCRIPT SIX
    "7S":	"⁷",	#SUPERSCRIPT SEVEN
    "8S":	"⁸",	#SUPERSCRIPT EIGHT
    "9S":	"⁹",	#SUPERSCRIPT NINE
    "+S":	"⁺",	#SUPERSCRIPT PLUS SIGN
    "-S":	"⁻",	#SUPERSCRIPT MINUS
    "=S":	"⁼",	#SUPERSCRIPT EQUALS SIGN
    "(S":	"⁽",	#SUPERSCRIPT LEFT PARENTHESIS
    ")S":	"⁾",	#SUPERSCRIPT RIGHT PARENTHESIS
    "nS":	"ⁿ",	#SUPERSCRIPT LATIN SMALL LETTER N `
    "0s":	"₀",	#SUBSCRIPT ZERO
    "1s":	"₁",	#SUBSCRIPT ONE
    "2s":	"₂",	#SUBSCRIPT TWO
    "3s":	"₃",	#SUBSCRIPT THREE
    "4s":	"₄",	#SUBSCRIPT FOUR
    "5s":	"₅",	#SUBSCRIPT FIVE
    "6s":	"₆",	#SUBSCRIPT SIX
    "7s":	"₇",	#SUBSCRIPT SEVEN
    "8s":	"₈",	#SUBSCRIPT EIGHT
    "9s":	"₉",	#SUBSCRIPT NINE
    "+s":	"₊",	#SUBSCRIPT PLUS SIGN
    "-s":	"₋",	#SUBSCRIPT MINUS
    "=s":	"₌",	#SUBSCRIPT EQUALS SIGN
    "(s":	"₍",	#SUBSCRIPT LEFT PARENTHESIS
    ")s":	"₎",	#SUBSCRIPT RIGHT PARENTHESIS
    "Li":	"₤",	#LIRA SIGN
    "Pt":	"₧",	#PESETA SIGN
    "W=":	"₩",	#WON SIGN
    "Eu":	"€",	#EURO SIGN
    "=R":	"₽",	#ROUBLE SIGN
    "=P":	"₽",	#ROUBLE SIGN
    "oC":	"℃",	#DEGREE CELSIUS
    "co":	"℅",	#CARE OF
    "oF":	"℉",	#DEGREE FAHRENHEIT
    "N0":	"№",	#NUMERO SIGN
    "PO":	"℗",	#SOUND RECORDING COPYRIGHT
    "Rx":	"℞",	#PRESCRIPTION TAKE
    "SM":	"℠",	#SERVICE MARK
    "TM":	"™",	#TRADE MARK SIGN
    "Om":	"Ω",	#OHM SIGN
    "AO":	"Å",	#ANGSTROM SIGN
    "13":	"⅓",	#VULGAR FRACTION ONE THIRD
    "23":	"⅔",	#VULGAR FRACTION TWO THIRDS
    "15":	"⅕",	#VULGAR FRACTION ONE FIFTH
    "25":	"⅖",	#VULGAR FRACTION TWO FIFTHS
    "35":	"⅗",	#VULGAR FRACTION THREE FIFTHS
    "45":	"⅘",	#VULGAR FRACTION FOUR FIFTHS
    "16":	"⅙",	#VULGAR FRACTION ONE SIXTH
    "56":	"⅚",	#VULGAR FRACTION FIVE SIXTHS
    "18":	"⅛",	#VULGAR FRACTION ONE EIGHTH
    "38":	"⅜",	#VULGAR FRACTION THREE EIGHTHS
    "58":	"⅝",	#VULGAR FRACTION FIVE EIGHTHS
    "78":	"⅞",	#VULGAR FRACTION SEVEN EIGHTHS
    "<-":	"←",	#LEFTWARDS ARROW
    "-!":	"↑",	#UPWARDS ARROW
    "->":	"→",	#RIGHTWARDS ARROW
    "-v":	"↓",	#DOWNWARDS ARROW
    "<>":	"↔",	#LEFT RIGHT ARROW
    "UD":	"↕",	#UP DOWN ARROW
    "<=":	"⇐",	#LEFTWARDS DOUBLE ARROW
    "=>":	"⇒",	#RIGHTWARDS DOUBLE ARROW
    "==":	"⇔",	#LEFT RIGHT DOUBLE ARROW
    "FA":	"∀",	#FOR ALL
    "dP":	"∂",	#PARTIAL DIFFERENTIAL
    "TE":	"∃",	#THERE EXISTS
    "/0":	"∅",	#EMPTY SET
    "DE":	"∆",	#INCREMENT
    "NB":	"∇",	#NABLA
    "(-":	"∈",	#ELEMENT OF
    "-)":	"∋",	#CONTAINS AS MEMBER
    "*P":	"∏",	#N-ARY PRODUCT `
    "+Z":	"∑",	#N-ARY SUMMATION `
    "-2":	"−",	#MINUS SIGN
    "-+":	"∓",	#MINUS-OR-PLUS SIGN
    "*-":	"∗",	#ASTERISK OPERATOR
    "Ob":	"∘",	#RING OPERATOR
    "Sb":	"∙",	#BULLET OPERATOR
    "RT":	"√",	#SQUARE ROOT
    "0(":	"∝",	#PROPORTIONAL TO
    "00":	"∞",	#INFINITY
    "-L":	"∟",	#RIGHT ANGLE
    "-V":	"∠",	#ANGLE
    "PP":	"∥",	#PARALLEL TO
    "AN":	"∧",	#LOGICAL AND
    "OR":	"∨",	#LOGICAL OR
    "(U":	"∩",	#INTERSECTION
    ")U":	"∪",	#UNION
    "In":	"∫",	#INTEGRAL
    "DI":	"∬",	#DOUBLE INTEGRAL
    "Io":	"∮",	#CONTOUR INTEGRAL
    ".:":	"∴",	#THEREFORE
    ":.":	"∵",	#BECAUSE
    ":R":	"∶",	#RATIO
    "::":	"∷",	#PROPORTION
    "?1":	"∼",	#TILDE OPERATOR
    "CG":	"∾",	#INVERTED LAZY S
    "?-":	"≃",	#ASYMPTOTICALLY EQUAL TO
    "?=":	"≅",	#APPROXIMATELY EQUAL TO
    "?2":	"≈",	#ALMOST EQUAL TO
    "=?":	"≌",	#ALL EQUAL TO
    "HI":	"≓",	#IMAGE OF OR APPROXIMATELY EQUAL TO
    "!=":	"≠",	#NOT EQUAL TO
    "=3":	"≡",	#IDENTICAL TO
    "=<":	"≤",	#LESS-THAN OR EQUAL TO
    ">=":	"≥",	#GREATER-THAN OR EQUAL TO
    "<*":	"≪",	#MUCH LESS-THAN
    "*>":	"≫",	#MUCH GREATER-THAN
    "!<":	"≮",	#NOT LESS-THAN
    "!>":	"≯",	#NOT GREATER-THAN
    "(C":	"⊂",	#SUBSET OF
    ")C":	"⊃",	#SUPERSET OF
    "(_":	"⊆",	#SUBSET OF OR EQUAL TO
    ")_":	"⊇",	#SUPERSET OF OR EQUAL TO
    "0.":	"⊙",	#CIRCLED DOT OPERATOR
    "02":	"⊚",	#CIRCLED RING OPERATOR
    "-T":	"⊥",	#UP TACK
    ".P":	"⋅",	#DOT OPERATOR
    ":3":	"⋮",	#VERTICAL ELLIPSIS
    ".3":	"⋯",	#MIDLINE HORIZONTAL ELLIPSIS
    "Eh":	"⌂",	#HOUSE
    "<7":	"⌈",	#LEFT CEILING
    ">7":	"⌉",	#RIGHT CEILING
    "7<":	"⌊",	#LEFT FLOOR
    "7>":	"⌋",	#RIGHT FLOOR
    "NI":	"⌐",	#REVERSED NOT SIGN
    "(A":	"⌒",	#ARC
    "TR":	"⌕",	#TELEPHONE RECORDER
    "Iu":	"⌠",	#TOP HALF INTEGRAL
    "Il":	"⌡",	#BOTTOM HALF INTEGRAL
    "</":	"〈",	#LEFT-POINTING ANGLE BRACKET
    "/>":	"〉",	#RIGHT-POINTING ANGLE BRACKET
    "Vs":	"␣",	#OPEN BOX
    "4j":	"⑉",	#OCR CUSTOMER ACCOUNT NUMBER
    "hh":	"─",	#BOX DRAWINGS LIGHT HORIZONTAL
    "HH":	"━",	#BOX DRAWINGS HEAVY HORIZONTAL
    "vv":	"│",	#BOX DRAWINGS LIGHT VERTICAL
    "VV":	"┃",	#BOX DRAWINGS HEAVY VERTICAL
    "3-":	"┄",	#BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
    "3_":	"┅",	#BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
    "3!":	"┆",	#BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
    "3/":	"┇",	#BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
    "4-":	"┈",	#BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
    "4_":	"┉",	#BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
    "4!":	"┊",	#BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
    "4/":	"┋",	#BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
    "dr":	"┌",	#BOX DRAWINGS LIGHT DOWN AND RIGHT
    "dR":	"┍",	#BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
    "Dr":	"┎",	#BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
    "DR":	"┏",	#BOX DRAWINGS HEAVY DOWN AND RIGHT
    "dl":	"┐",	#BOX DRAWINGS LIGHT DOWN AND LEFT
    "dL":	"┑",	#BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
    "Dl":	"┒",	#BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
    "LD":	"┓",	#BOX DRAWINGS HEAVY DOWN AND LEFT
    "ur":	"└",	#BOX DRAWINGS LIGHT UP AND RIGHT
    "uR":	"┕",	#BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
    "Ur":	"┖",	#BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
    "UR":	"┗",	#BOX DRAWINGS HEAVY UP AND RIGHT
    "ul":	"┘",	#BOX DRAWINGS LIGHT UP AND LEFT
    "uL":	"┙",	#BOX DRAWINGS UP LIGHT AND LEFT HEAVY
    "Ul":	"┚",	#BOX DRAWINGS UP HEAVY AND LEFT LIGHT
    "UL":	"┛",	#BOX DRAWINGS HEAVY UP AND LEFT
    "vr":	"├",	#BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    "vR":	"┝",	#BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
    "Vr":	"┠",	#BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
    "VR":	"┣",	#BOX DRAWINGS HEAVY VERTICAL AND RIGHT
    "vl":	"┤",	#BOX DRAWINGS LIGHT VERTICAL AND LEFT
    "vL":	"┥",	#BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
    "Vl":	"┨",	#BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
    "VL":	"┫",	#BOX DRAWINGS HEAVY VERTICAL AND LEFT
    "dh":	"┬",	#BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    "dH":	"┯",	#BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
    "Dh":	"┰",	#BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
    "DH":	"┳",	#BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
    "uh":	"┴",	#BOX DRAWINGS LIGHT UP AND HORIZONTAL
    "uH":	"┷",	#BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
    "Uh":	"┸",	#BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
    "UH":	"┻",	#BOX DRAWINGS HEAVY UP AND HORIZONTAL
    "vh":	"┼",	#BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    "vH":	"┿",	#BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
    "Vh":	"╂",	#BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
    "VH":	"╋",	#BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
    "FD":	"╱",	#BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
    "BD":	"╲",	#BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
    "cS":	"♠",	#BLACK SPADE SUIT
    "cH":	"♡",	#WHITE HEART SUIT
    "cD":	"♢",	#WHITE DIAMOND SUIT
    "cC":	"♣",	#BLACK CLUB SUIT
    "Md":	"♩",	#QUARTER NOTE `
    "M8":	"♪",	#EIGHTH NOTE `
    "M2":	"♫",	#BEAMED EIGHTH NOTES
    "Mb":	"♭",	#MUSIC FLAT SIGN
    "Mx":	"♮",	#MUSIC NATURAL SIGN
    "MX":	"♯",	#MUSIC SHARP SIGN
    "OK":	"✓",	#CHECK MARK
    "XX":	"✗",	#BALLOT X
    "-X":	"✠",	#MALTESE CROSS
    "IS":	"　",	#IDEOGRAPHIC SPACE
    ",_":	"、",	#IDEOGRAPHIC COMMA
    "._":	"。",	#IDEOGRAPHIC FULL STOP
    "+\"":	"〃",	#DITTO MARK
    "+_":	"〄",	#JAPANESE INDUSTRIAL STANDARD SYMBOL
    "*_":	"々",	#IDEOGRAPHIC ITERATION MARK
    ";_":	"〆",	#IDEOGRAPHIC CLOSING MARK
    "0_":	"〇",	#IDEOGRAPHIC NUMBER ZERO
    "<+":	"《",	#LEFT DOUBLE ANGLE BRACKET
    ">+":	"》",	#RIGHT DOUBLE ANGLE BRACKET
    "<'":	"「",	#LEFT CORNER BRACKET
    ">'":	"」",	#RIGHT CORNER BRACKET
    "<\"":	"『",	#LEFT WHITE CORNER BRACKET
    ">\"":	"』",	#RIGHT WHITE CORNER BRACKET
    "(\"":	"【",	#LEFT BLACK LENTICULAR BRACKET
    ")\"":	"】",	#RIGHT BLACK LENTICULAR BRACKET
    "=T":	"〒",	#POSTAL MARK
    "=_":	"〓",	#GETA MARK
    "('":	"〔",	#LEFT TORTOISE SHELL BRACKET
    ")'":	"〕",	#RIGHT TORTOISE SHELL BRACKET
    "(I":	"〖",	#LEFT WHITE LENTICULAR BRACKET
    ")I":	"〗",	#RIGHT WHITE LENTICULAR BRACKET
    "-?":	"〜",	#WAVE DASH
}
