## :sparkles: Contributing to Athena :sparkles:

We welcome all contributions to Athena's development! This guide will help you get started with submitting bug reports, requesting features, and contributing code.

### :beetle: Reporting Bugs

1. **:mag: Search existing issues**: Before reporting a new bug, search the existing issues to see if someone else has reported the same problem.
2. **:bulb: Create a new issue**: If the problem has not been reported yet, create a new issue in the GitHub repository. Provide a clear and descriptive title, and include as much information as possible to help reproduce the issue:
   - :footprints: Steps to reproduce
   - :white_check_mark: Expected behavior
   - :x: Actual behavior
   - :camera: Screenshots (if applicable)
   - :computer: System information (OS, Python version, etc.)

### :rocket: Requesting Features

1. **:mag: Search existing issues**: Before requesting a new feature, search the existing issues to see if someone else has already suggested it.
2. **:bulb: Create a new issue**: If the feature has not been requested yet, create a new issue in the GitHub repository. Provide a clear and descriptive title, and include as much information as possible about the proposed feature:
   - :balance_scale: Rationale and use cases
   - :wrench: Proposed implementation (if applicable)
   - :thinking: Potential drawbacks and alternatives

### :hammer_and_wrench: Code Contributions

1. **:fork_and_knife: Fork the repository**: Fork the Athena repository to your GitHub account.
2. **:twisted_rightwards_arrows: Create a new branch**: Create a new branch in your forked repository, using a descriptive name that reflects the purpose of your changes (e.g., `fix-bug-123` or `add-feature-xyz`).
3. **:pencil2: Make your changes**: Modify the codebase to implement your bug fix or feature. Be sure to follow the project's code formatting guidelines (e.g., using an auto-formatter like Black or adhering to PEP 8 for Python code).
4. **:test_tube: Write tests**: Write tests to verify that your changes work as expected and do not introduce new bugs. Use the project's existing testing framework (e.g., pytest or unittest) and follow any testing guidelines provided.
5. **:white_check_mark: Commit your changes**: Commit your changes with a clear and descriptive commit message. Include the issue number in your commit message (e.g., `Fix bug #123: Description of the fix`).
6. **:arrow_up: Push your changes**: Push your changes to your forked repository on GitHub.
7. **:inbox_tray: Create a pull request**: Submit a pull request to the original Athena repository, providing a clear and concise description of your changes. Be prepared to address any feedback or requested changes from the project maintainers.

Thank you for helping Athena grow and improve! :tada:

### Current Flow

![Flow](https://raw.githubusercontent.com/BillSchumacher/Athena/main/execution_flow.png)