# coding: utf-8

"""
    Kiln API Specifications

    This API provides reporting staking data on various protocols as well as network wide data, staking transaction crafting features and so on. In order to use it, you should first get an API token from your Kiln dashboard (applications section). If you don't have access to our dashboard, please get in touch at hello@kiln.fi. Once you have your API token, you can set it as a bearer token in your request headers.  ### Backward Compatibility  This is an experimental specification used for development and testing, do not rely on what is here unless you know the implications.  The official Kiln API specification following backward compatible changes can be found [here](/).  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: contact@kiln.fi
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, confloat
from kiln_connect.openapi_client.models.account_portfolio_protocols_inner_total_balance import AccountPortfolioProtocolsInnerTotalBalance
from kiln_connect.openapi_client.models.account_portfolio_protocols_inner_total_rewards import AccountPortfolioProtocolsInnerTotalRewards

class AccountPortfolioProtocolsInner(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    token: Optional[StrictStr] = Field(None, description="Token name")
    name: Optional[StrictStr] = Field(None, description="Protocol name")
    total_stakes: Optional[StrictInt] = Field(None, description="Total number of stakes for this protocol")
    total_active_stakes: Optional[StrictInt] = Field(None, description="Total number of stakes actively collecting rewards for this protocol")
    total_balance: Optional[AccountPortfolioProtocolsInnerTotalBalance] = None
    total_rewards: Optional[AccountPortfolioProtocolsInnerTotalRewards] = None
    balance_share_percent: Optional[confloat(le=100, ge=0)] = Field(None, description="Protocol share of the total balance")
    rewards_share_percent: Optional[confloat(le=100, ge=0)] = Field(None, description="Protocol share of the total rewards earned")
    __properties = ["token", "name", "total_stakes", "total_active_stakes", "total_balance", "total_rewards", "balance_share_percent", "rewards_share_percent"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountPortfolioProtocolsInner:
        """Create an instance of AccountPortfolioProtocolsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of total_balance
        if self.total_balance:
            _dict['total_balance'] = self.total_balance.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_rewards
        if self.total_rewards:
            _dict['total_rewards'] = self.total_rewards.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountPortfolioProtocolsInner:
        """Create an instance of AccountPortfolioProtocolsInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountPortfolioProtocolsInner.parse_obj(obj)

        _obj = AccountPortfolioProtocolsInner.parse_obj({
            "token": obj.get("token"),
            "name": obj.get("name"),
            "total_stakes": obj.get("total_stakes"),
            "total_active_stakes": obj.get("total_active_stakes"),
            "total_balance": AccountPortfolioProtocolsInnerTotalBalance.from_dict(obj.get("total_balance")) if obj.get("total_balance") is not None else None,
            "total_rewards": AccountPortfolioProtocolsInnerTotalRewards.from_dict(obj.get("total_rewards")) if obj.get("total_rewards") is not None else None,
            "balance_share_percent": obj.get("balance_share_percent"),
            "rewards_share_percent": obj.get("rewards_share_percent")
        })
        return _obj

