# mypy-boto3-emr-containers

[![PyPI - mypy-boto3-emr-containers](https://img.shields.io/pypi/v/mypy-boto3-emr-containers.svg?color=blue)](https://pypi.org/project/mypy-boto3-emr-containers)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-emr-containers.svg?color=blue)](https://pypi.org/project/mypy-boto3-emr-containers)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-emr-containers?color=blue)](https://pypistats.org/packages/mypy-boto3-emr-containers)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.EMRContainers 1.17.63](https://boto3.amazonaws.com/v1/documentation/api/1.17.63/reference/services/emr-containers.html#EMRContainers) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.8.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[auto-generated docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_emr_containers/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-emr-containers](#mypy-boto3-emr-containers)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `EMRContainers` service.

```bash
python -m pip install boto3-stubs[emr-containers]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[emr-containers]` in your environment: `python -m pip install 'boto3-stubs[emr-containers]'`

Both type checking and auto-complete should work for `EMRContainers` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[emr-containers]` in your environment: `python -m pip install 'boto3-stubs[emr-containers]'`

Both type checking and auto-complete should work for `EMRContainers` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[emr-containers]` in your environment: `python -m pip install 'boto3-stubs[emr-containers]'`
- Run `mypy` as usual

Type checking should work for `EMRContainers` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[emr-containers]` in your environment: `python -m pip install 'boto3-stubs[emr-containers]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `EMRContainers` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`EMRContainersClient` provides annotations for `boto3.client("emr-containers")`.

```python
import boto3

from mypy_boto3_emr_containers import EMRContainersClient

client: EMRContainersClient = boto3.client("emr-containers")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EMRContainersClient = session.client("emr-containers")
```

### Paginators annotations

`mypy_boto3_emr_containers.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_emr_containers import EMRContainersClient
from mypy_boto3_emr_containers.paginator import (
    ListJobRunsPaginator,
    ListManagedEndpointsPaginator,
    ListVirtualClustersPaginator,
)

client: EMRContainersClient = boto3.client("emr-containers")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_job_runs_paginator: ListJobRunsPaginator = client.get_paginator("list_job_runs")
list_managed_endpoints_paginator: ListManagedEndpointsPaginator = client.get_paginator("list_managed_endpoints")
list_virtual_clusters_paginator: ListVirtualClustersPaginator = client.get_paginator("list_virtual_clusters")
```







### Literals

`mypy_boto3_emr_containers.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_emr_containers.literals import (
    ContainerProviderType,
    EndpointState,
    FailureReason,
    JobRunState,
    ListJobRunsPaginatorName,
    ListManagedEndpointsPaginatorName,
    ListVirtualClustersPaginatorName,
    PersistentAppUI,
    VirtualClusterState,
)

def check_value(value: ContainerProviderType) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_emr_containers.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_emr_containers.type_defs import (
    CancelJobRunResponseTypeDef,
    CloudWatchMonitoringConfigurationTypeDef,
    ConfigurationOverridesTypeDef,
    ConfigurationTypeDef,
    ContainerInfoTypeDef,
    ContainerProviderTypeDef,
    CreateManagedEndpointResponseTypeDef,
    CreateVirtualClusterResponseTypeDef,
    DeleteManagedEndpointResponseTypeDef,
    DeleteVirtualClusterResponseTypeDef,
    DescribeJobRunResponseTypeDef,
    DescribeManagedEndpointResponseTypeDef,
    DescribeVirtualClusterResponseTypeDef,
    EksInfoTypeDef,
    EndpointTypeDef,
    JobDriverTypeDef,
    JobRunTypeDef,
    ListJobRunsResponseTypeDef,
    ListManagedEndpointsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListVirtualClustersResponseTypeDef,
    MonitoringConfigurationTypeDef,
    PaginatorConfigTypeDef,
    S3MonitoringConfigurationTypeDef,
    SparkSubmitJobDriverTypeDef,
    StartJobRunResponseTypeDef,
    VirtualClusterTypeDef,
)

def get_structure() -> CancelJobRunResponseTypeDef:
    return {
      ...
    }
```
