# alvin-api-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.0.3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import alvin_api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import alvin_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import alvin_api_client
from pprint import pprint
from alvin_api_client.api import default_api
from alvin_api_client.model.admin_config import AdminConfig
from alvin_api_client.model.auth_provider import AuthProvider
from alvin_api_client.model.client_config import ClientConfig
from alvin_api_client.model.data_entity_get import DataEntityGet
from alvin_api_client.model.data_entity_lineage_response import DataEntityLineageResponse
from alvin_api_client.model.data_entity_lineage_v2_request import DataEntityLineageV2Request
from alvin_api_client.model.data_entity_lineage_v2_response import DataEntityLineageV2Response
from alvin_api_client.model.data_entity_numerical_stat import DataEntityNumericalStat
from alvin_api_client.model.data_entity_numerical_stat_response import DataEntityNumericalStatResponse
from alvin_api_client.model.data_entity_type import DataEntityType
from alvin_api_client.model.data_entity_usage_stats_report import DataEntityUsageStatsReport
from alvin_api_client.model.data_entity_usage_stats_request import DataEntityUsageStatsRequest
from alvin_api_client.model.data_platform_big_query_create import DataPlatformBigQueryCreate
from alvin_api_client.model.data_platform_get import DataPlatformGet
from alvin_api_client.model.data_platform_job_step import DataPlatformJobStep
from alvin_api_client.model.data_platform_job_step_aggregated_report import DataPlatformJobStepAggregatedReport
from alvin_api_client.model.data_platform_job_step_report_type import DataPlatformJobStepReportType
from alvin_api_client.model.data_platform_job_step_request import DataPlatformJobStepRequest
from alvin_api_client.model.data_platform_job_step_user import DataPlatformJobStepUser
from alvin_api_client.model.data_platform_looker_create import DataPlatformLookerCreate
from alvin_api_client.model.data_platform_redshift_create import DataPlatformRedshiftCreate
from alvin_api_client.model.data_platform_snowflake_create import DataPlatformSnowflakeCreate
from alvin_api_client.model.data_platform_tableau_create import DataPlatformTableauCreate
from alvin_api_client.model.data_platform_type import DataPlatformType
from alvin_api_client.model.email_login_request import EmailLoginRequest
from alvin_api_client.model.exhange_token_request import ExhangeTokenRequest
from alvin_api_client.model.filters_response import FiltersResponse
from alvin_api_client.model.http_validation_error import HTTPValidationError
from alvin_api_client.model.impact_analysis_query_get import ImpactAnalysisQueryGet
from alvin_api_client.model.impact_analysis_query_response import ImpactAnalysisQueryResponse
from alvin_api_client.model.impact_analysis_query_validation import ImpactAnalysisQueryValidation
from alvin_api_client.model.impact_analysis_request import ImpactAnalysisRequest
from alvin_api_client.model.impact_analysis_v2_response import ImpactAnalysisV2Response
from alvin_api_client.model.impact_analysis_validation_payload import ImpactAnalysisValidationPayload
from alvin_api_client.model.job_query_v1_response import JobQueryV1Response
from alvin_api_client.model.limit_offset_page_data_entity_usage_stats_report import LimitOffsetPageDataEntityUsageStatsReport
from alvin_api_client.model.limit_offset_page_data_platform_job import LimitOffsetPageDataPlatformJob
from alvin_api_client.model.limit_offset_page_data_platform_job_step_aggregated_report import LimitOffsetPageDataPlatformJobStepAggregatedReport
from alvin_api_client.model.notification import Notification
from alvin_api_client.model.tiny_url_response import TinyURLResponse
from alvin_api_client.model.token import Token
from alvin_api_client.model.user_get import UserGet
from alvin_api_client.model.user_organization_api_key_request import UserOrganizationAPIKeyRequest
from alvin_api_client.model.user_organization_api_key_response import UserOrganizationAPIKeyResponse
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = alvin_api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: HTTPBearer
configuration = alvin_api_client.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with alvin_api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    user_organization_api_key_request = UserOrganizationAPIKeyRequest(
        api_key_display_name="api_key_display_name_example",
        api_key_exp_seconds=1,
        status=APIKeyStatus("ACTIVE"),
        scopes=[
            APIKeyScope("USER_INHERITED"),
        ],
        allowed_domains=[
            "allowed_domains_example",
        ],
    ) # UserOrganizationAPIKeyRequest | 

    try:
        # Create Api Key
        api_response = api_instance.create_api_key_api_v1_admin_api_key_post(user_organization_api_key_request)
        pprint(api_response)
    except alvin_api_client.ApiException as e:
        print("Exception when calling DefaultApi->create_api_key_api_v1_admin_api_key_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_api_key_api_v1_admin_api_key_post**](docs/DefaultApi.md#create_api_key_api_v1_admin_api_key_post) | **POST** /api/v1/admin/api-key | Create Api Key
*DefaultApi* | [**create_bigquery_platform_api_v1_platforms_bigquery_post**](docs/DefaultApi.md#create_bigquery_platform_api_v1_platforms_bigquery_post) | **POST** /api/v1/platforms/bigquery | Create Bigquery Platform
*DefaultApi* | [**create_looker_platform_api_v1_platforms_looker_post**](docs/DefaultApi.md#create_looker_platform_api_v1_platforms_looker_post) | **POST** /api/v1/platforms/looker | Create Looker Platform
*DefaultApi* | [**create_redshift_platform_api_v1_platforms_redshift_post**](docs/DefaultApi.md#create_redshift_platform_api_v1_platforms_redshift_post) | **POST** /api/v1/platforms/redshift | Create Redshift Platform
*DefaultApi* | [**create_snowflake_platform_api_v1_platforms_snowflake_post**](docs/DefaultApi.md#create_snowflake_platform_api_v1_platforms_snowflake_post) | **POST** /api/v1/platforms/snowflake | Create Snowflake Platform
*DefaultApi* | [**create_tableau_platform_api_v1_platforms_tableau_post**](docs/DefaultApi.md#create_tableau_platform_api_v1_platforms_tableau_post) | **POST** /api/v1/platforms/tableau | Create Tableau Platform
*DefaultApi* | [**email_login_api_v1_auth_email_login_post**](docs/DefaultApi.md#email_login_api_v1_auth_email_login_post) | **POST** /api/v1/auth/email-login | Email Login
*DefaultApi* | [**exchange_token_api_v1_auth_exhange_token_post**](docs/DefaultApi.md#exchange_token_api_v1_auth_exhange_token_post) | **POST** /api/v1/auth/exhange-token | Exchange Token
*DefaultApi* | [**get_admin_config_api_v1_admin_config_get**](docs/DefaultApi.md#get_admin_config_api_v1_admin_config_get) | **GET** /api/v1/admin-config | Get Admin Config
*DefaultApi* | [**get_client_config_api_v1_client_config_get**](docs/DefaultApi.md#get_client_config_api_v1_client_config_get) | **GET** /api/v1/client-config | Get Client Config
*DefaultApi* | [**get_entities_usage_stats_post_api_v1_entities_usage_stats_post**](docs/DefaultApi.md#get_entities_usage_stats_post_api_v1_entities_usage_stats_post) | **POST** /api/v1/entities/usage-stats | Get Entities Usage Stats Post
*DefaultApi* | [**get_entity_api_v1_entity_get**](docs/DefaultApi.md#get_entity_api_v1_entity_get) | **GET** /api/v1/entity | Get Entity
*DefaultApi* | [**get_entity_children_api_v1_entity_children_get**](docs/DefaultApi.md#get_entity_children_api_v1_entity_children_get) | **GET** /api/v1/entity-children | Get Entity Children
*DefaultApi* | [**get_entity_children_api_v1_most_recent_entity_numerical_stats_get**](docs/DefaultApi.md#get_entity_children_api_v1_most_recent_entity_numerical_stats_get) | **GET** /api/v1/most-recent-entity-numerical-stats | Get Entity Children
*DefaultApi* | [**get_entity_jobs_api_v1_entity_jobs_get**](docs/DefaultApi.md#get_entity_jobs_api_v1_entity_jobs_get) | **GET** /api/v1/entity-jobs | Get Entity Jobs
*DefaultApi* | [**get_entity_lineage_api_v1_lineage_get**](docs/DefaultApi.md#get_entity_lineage_api_v1_lineage_get) | **GET** /api/v1/lineage | Get Entity Lineage
*DefaultApi* | [**get_entity_lineage_api_v2_lineage_post**](docs/DefaultApi.md#get_entity_lineage_api_v2_lineage_post) | **POST** /api/v2/lineage | Get Entity Lineage
*DefaultApi* | [**get_entity_numerical_stats_api_v1_get_entity_numerical_stats_get**](docs/DefaultApi.md#get_entity_numerical_stats_api_v1_get_entity_numerical_stats_get) | **GET** /api/v1/get-entity-numerical-stats | Get Entity Numerical Stats
*DefaultApi* | [**get_entity_parents_api_v1_entity_parents_get**](docs/DefaultApi.md#get_entity_parents_api_v1_entity_parents_get) | **GET** /api/v1/entity-parents | Get Entity Parents
*DefaultApi* | [**get_entity_schema_api_v1_entity_entity_schema_get**](docs/DefaultApi.md#get_entity_schema_api_v1_entity_entity_schema_get) | **GET** /api/v1/entity/entity-schema | Get Entity Schema
*DefaultApi* | [**get_entity_siblings_api_v1_entity_siblings_get**](docs/DefaultApi.md#get_entity_siblings_api_v1_entity_siblings_get) | **GET** /api/v1/entity-siblings | Get Entity Siblings
*DefaultApi* | [**get_entity_usage_stats_api_v1_entity_usage_stats_get**](docs/DefaultApi.md#get_entity_usage_stats_api_v1_entity_usage_stats_get) | **GET** /api/v1/entity/usage-stats | Get Entity Usage Stats
*DefaultApi* | [**get_filters_config_api_v1_filters_config_get**](docs/DefaultApi.md#get_filters_config_api_v1_filters_config_get) | **GET** /api/v1/filters/config | Get Filters Config
*DefaultApi* | [**get_impact_by_query_api_v2_impact_analysis_query_post**](docs/DefaultApi.md#get_impact_by_query_api_v2_impact_analysis_query_post) | **POST** /api/v2/impact-analysis/query | Get Impact By Query
*DefaultApi* | [**get_impact_from_validation_payload_api_v2_impact_analysis_query_entities_post**](docs/DefaultApi.md#get_impact_from_validation_payload_api_v2_impact_analysis_query_entities_post) | **POST** /api/v2/impact-analysis/query-entities | Get Impact From Validation Payload
*DefaultApi* | [**get_job_steps_aggregated_stats_api_v1_job_steps_aggregated_stats_get**](docs/DefaultApi.md#get_job_steps_aggregated_stats_api_v1_job_steps_aggregated_stats_get) | **GET** /api/v1/job/steps/aggregated-stats | Get Job Steps Aggregated Stats
*DefaultApi* | [**get_job_steps_api_v1_jobs_steps_post**](docs/DefaultApi.md#get_job_steps_api_v1_jobs_steps_post) | **POST** /api/v1/jobs/steps | Get Job Steps
*DefaultApi* | [**get_jobs_steps_aggregated_stats_api_v1_jobs_steps_aggregated_stats_get**](docs/DefaultApi.md#get_jobs_steps_aggregated_stats_api_v1_jobs_steps_aggregated_stats_get) | **GET** /api/v1/jobs/steps/aggregated-stats | Get Jobs Steps Aggregated Stats
*DefaultApi* | [**get_jobs_users_api_v1_jobs_users_post**](docs/DefaultApi.md#get_jobs_users_api_v1_jobs_users_post) | **POST** /api/v1/jobs/users | Get Jobs Users
*DefaultApi* | [**get_last_job_query_api_v1_job_query_get**](docs/DefaultApi.md#get_last_job_query_api_v1_job_query_get) | **GET** /api/v1/job/query | Get Last Job Query
*DefaultApi* | [**get_lineage_job_steps_api_v1_lineage_jobs_steps_get**](docs/DefaultApi.md#get_lineage_job_steps_api_v1_lineage_jobs_steps_get) | **GET** /api/v1/lineage/jobs/steps | Get Lineage Job Steps
*DefaultApi* | [**get_notifications_api_v1_notifications_get**](docs/DefaultApi.md#get_notifications_api_v1_notifications_get) | **GET** /api/v1/notifications | Get Notifications
*DefaultApi* | [**get_platform_api_v1_platforms_platform_id_get**](docs/DefaultApi.md#get_platform_api_v1_platforms_platform_id_get) | **GET** /api/v1/platforms/{platform_id} | Get Platform
*DefaultApi* | [**get_platforms_api_v1_platforms_get**](docs/DefaultApi.md#get_platforms_api_v1_platforms_get) | **GET** /api/v1/platforms | Get Platforms
*DefaultApi* | [**get_query_impact_analysis_api_v1_impact_analysis_query_post**](docs/DefaultApi.md#get_query_impact_analysis_api_v1_impact_analysis_query_post) | **POST** /api/v1/impact-analysis/query | Get Query Impact Analysis
*DefaultApi* | [**get_top_level_entities_api_v1_top_entities_get**](docs/DefaultApi.md#get_top_level_entities_api_v1_top_entities_get) | **GET** /api/v1/top-entities | Get Top Level Entities
*DefaultApi* | [**get_user_info_api_v1_me_get**](docs/DefaultApi.md#get_user_info_api_v1_me_get) | **GET** /api/v1/me | Get User Info
*DefaultApi* | [**get_users_by_id_api_v1_users_get**](docs/DefaultApi.md#get_users_by_id_api_v1_users_get) | **GET** /api/v1/users | Get Users By Id
*DefaultApi* | [**get_users_in_org_api_v1_org_users_get**](docs/DefaultApi.md#get_users_in_org_api_v1_org_users_get) | **GET** /api/v1/org-users | Get Users In Org
*DefaultApi* | [**search_entities_stats_post_api_v1_search_entities_usage_stats_post**](docs/DefaultApi.md#search_entities_stats_post_api_v1_search_entities_usage_stats_post) | **POST** /api/v1/search/entities/usage-stats | Search Entities Stats Post
*DefaultApi* | [**sync_platform_rpc_api_v1_platforms_platform_id_rpc_sync_get**](docs/DefaultApi.md#sync_platform_rpc_api_v1_platforms_platform_id_rpc_sync_get) | **GET** /api/v1/platforms/{platform_id}/rpc-sync | Sync Platform Rpc
*DefaultApi* | [**sync_sheet_api_v1_sync_sheet_get**](docs/DefaultApi.md#sync_sheet_api_v1_sync_sheet_get) | **GET** /api/v1/sync-sheet | Sync Sheet
*DefaultApi* | [**tinyurl_api_v1_tinyurl_get**](docs/DefaultApi.md#tinyurl_api_v1_tinyurl_get) | **GET** /api/v1/tinyurl | Tinyurl
*DefaultApi* | [**validate_impact_analysis_query_api_v2_impact_analysis_validate_query_post**](docs/DefaultApi.md#validate_impact_analysis_query_api_v2_impact_analysis_validate_query_post) | **POST** /api/v2/impact-analysis/validate-query | Validate Impact Analysis Query


## Documentation For Models

 - [APIKeyScope](docs/APIKeyScope.md)
 - [APIKeyStatus](docs/APIKeyStatus.md)
 - [AdminConfig](docs/AdminConfig.md)
 - [AlterParseResult](docs/AlterParseResult.md)
 - [AlterType](docs/AlterType.md)
 - [AnalyticsEnvironmentConfig](docs/AnalyticsEnvironmentConfig.md)
 - [AuthProvider](docs/AuthProvider.md)
 - [BiPlatform](docs/BiPlatform.md)
 - [BigQueryAccountDetails](docs/BigQueryAccountDetails.md)
 - [BigQueryAdditionalConfig](docs/BigQueryAdditionalConfig.md)
 - [ClassificationType](docs/ClassificationType.md)
 - [ClientAuthConfig](docs/ClientAuthConfig.md)
 - [ClientConfig](docs/ClientConfig.md)
 - [ColumnAlter](docs/ColumnAlter.md)
 - [ColumnTarget](docs/ColumnTarget.md)
 - [ComparisonOperator](docs/ComparisonOperator.md)
 - [ConfigType](docs/ConfigType.md)
 - [DataEntityConnection](docs/DataEntityConnection.md)
 - [DataEntityConnectionGet](docs/DataEntityConnectionGet.md)
 - [DataEntityConnectionType](docs/DataEntityConnectionType.md)
 - [DataEntityDetail](docs/DataEntityDetail.md)
 - [DataEntityGet](docs/DataEntityGet.md)
 - [DataEntityID](docs/DataEntityID.md)
 - [DataEntityJobStep](docs/DataEntityJobStep.md)
 - [DataEntityLineage](docs/DataEntityLineage.md)
 - [DataEntityLineageData](docs/DataEntityLineageData.md)
 - [DataEntityLineageGet](docs/DataEntityLineageGet.md)
 - [DataEntityLineageGraphEdge](docs/DataEntityLineageGraphEdge.md)
 - [DataEntityLineageGraphNode](docs/DataEntityLineageGraphNode.md)
 - [DataEntityLineageJobStepPath](docs/DataEntityLineageJobStepPath.md)
 - [DataEntityLineageLookup](docs/DataEntityLineageLookup.md)
 - [DataEntityLineagePath](docs/DataEntityLineagePath.md)
 - [DataEntityLineageResponse](docs/DataEntityLineageResponse.md)
 - [DataEntityLineageResult](docs/DataEntityLineageResult.md)
 - [DataEntityLineageState](docs/DataEntityLineageState.md)
 - [DataEntityLineageV2Request](docs/DataEntityLineageV2Request.md)
 - [DataEntityLineageV2Response](docs/DataEntityLineageV2Response.md)
 - [DataEntityNumericalStat](docs/DataEntityNumericalStat.md)
 - [DataEntityNumericalStatResponse](docs/DataEntityNumericalStatResponse.md)
 - [DataEntityNumericalStatType](docs/DataEntityNumericalStatType.md)
 - [DataEntitySubType](docs/DataEntitySubType.md)
 - [DataEntityType](docs/DataEntityType.md)
 - [DataEntityUsageStat](docs/DataEntityUsageStat.md)
 - [DataEntityUsageStatsReport](docs/DataEntityUsageStatsReport.md)
 - [DataEntityUsageStatsRequest](docs/DataEntityUsageStatsRequest.md)
 - [DataEntityUsageType](docs/DataEntityUsageType.md)
 - [DataPlatformAggregatedJobStat](docs/DataPlatformAggregatedJobStat.md)
 - [DataPlatformBigQueryCreate](docs/DataPlatformBigQueryCreate.md)
 - [DataPlatformGet](docs/DataPlatformGet.md)
 - [DataPlatformJob](docs/DataPlatformJob.md)
 - [DataPlatformJobExecutionStatus](docs/DataPlatformJobExecutionStatus.md)
 - [DataPlatformJobStat](docs/DataPlatformJobStat.md)
 - [DataPlatformJobStep](docs/DataPlatformJobStep.md)
 - [DataPlatformJobStepAggregatedReport](docs/DataPlatformJobStepAggregatedReport.md)
 - [DataPlatformJobStepExecutionStatus](docs/DataPlatformJobStepExecutionStatus.md)
 - [DataPlatformJobStepId](docs/DataPlatformJobStepId.md)
 - [DataPlatformJobStepReportType](docs/DataPlatformJobStepReportType.md)
 - [DataPlatformJobStepRequest](docs/DataPlatformJobStepRequest.md)
 - [DataPlatformJobStepSubType](docs/DataPlatformJobStepSubType.md)
 - [DataPlatformJobStepUser](docs/DataPlatformJobStepUser.md)
 - [DataPlatformJobType](docs/DataPlatformJobType.md)
 - [DataPlatformLookerCreate](docs/DataPlatformLookerCreate.md)
 - [DataPlatformRedshiftCreate](docs/DataPlatformRedshiftCreate.md)
 - [DataPlatformSnowflakeCreate](docs/DataPlatformSnowflakeCreate.md)
 - [DataPlatformStatus](docs/DataPlatformStatus.md)
 - [DataPlatformTableauCreate](docs/DataPlatformTableauCreate.md)
 - [DataPlatformType](docs/DataPlatformType.md)
 - [DropParseResult](docs/DropParseResult.md)
 - [DropType](docs/DropType.md)
 - [ElementPosition](docs/ElementPosition.md)
 - [EmailLoginRequest](docs/EmailLoginRequest.md)
 - [EventType](docs/EventType.md)
 - [ExhangeTokenRequest](docs/ExhangeTokenRequest.md)
 - [ExtractedSimpleColumn](docs/ExtractedSimpleColumn.md)
 - [ExtractedSimpleTable](docs/ExtractedSimpleTable.md)
 - [FiltersResponse](docs/FiltersResponse.md)
 - [FirebaseAuthProvider](docs/FirebaseAuthProvider.md)
 - [FirebaseAuthUIConfig](docs/FirebaseAuthUIConfig.md)
 - [GroupType](docs/GroupType.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [ImpactAnalysisAffectedEntitiesSummary](docs/ImpactAnalysisAffectedEntitiesSummary.md)
 - [ImpactAnalysisAffectedEntityResult](docs/ImpactAnalysisAffectedEntityResult.md)
 - [ImpactAnalysisAffectedEntityUsageData](docs/ImpactAnalysisAffectedEntityUsageData.md)
 - [ImpactAnalysisCreateTableDiff](docs/ImpactAnalysisCreateTableDiff.md)
 - [ImpactAnalysisEntityImpactResult](docs/ImpactAnalysisEntityImpactResult.md)
 - [ImpactAnalysisPlatformRequest](docs/ImpactAnalysisPlatformRequest.md)
 - [ImpactAnalysisQueryDiff](docs/ImpactAnalysisQueryDiff.md)
 - [ImpactAnalysisQueryGet](docs/ImpactAnalysisQueryGet.md)
 - [ImpactAnalysisQueryReport](docs/ImpactAnalysisQueryReport.md)
 - [ImpactAnalysisQueryRequest](docs/ImpactAnalysisQueryRequest.md)
 - [ImpactAnalysisQueryResponse](docs/ImpactAnalysisQueryResponse.md)
 - [ImpactAnalysisQueryResult](docs/ImpactAnalysisQueryResult.md)
 - [ImpactAnalysisQueryValidation](docs/ImpactAnalysisQueryValidation.md)
 - [ImpactAnalysisRequest](docs/ImpactAnalysisRequest.md)
 - [ImpactAnalysisSidebarDataNode](docs/ImpactAnalysisSidebarDataNode.md)
 - [ImpactAnalysisSummary](docs/ImpactAnalysisSummary.md)
 - [ImpactAnalysisV2EntityRow](docs/ImpactAnalysisV2EntityRow.md)
 - [ImpactAnalysisV2JobRow](docs/ImpactAnalysisV2JobRow.md)
 - [ImpactAnalysisV2Response](docs/ImpactAnalysisV2Response.md)
 - [ImpactAnalysisV2ResponseStatus](docs/ImpactAnalysisV2ResponseStatus.md)
 - [ImpactAnalysisValidationPayload](docs/ImpactAnalysisValidationPayload.md)
 - [ImpactStatus](docs/ImpactStatus.md)
 - [ImpactType](docs/ImpactType.md)
 - [JobEntityID](docs/JobEntityID.md)
 - [JobEntityUsageStatsReport](docs/JobEntityUsageStatsReport.md)
 - [JobQueryV1Response](docs/JobQueryV1Response.md)
 - [KnownColumn](docs/KnownColumn.md)
 - [KnownTable](docs/KnownTable.md)
 - [KnownTableType](docs/KnownTableType.md)
 - [LimitOffsetPageDataEntityUsageStatsReport](docs/LimitOffsetPageDataEntityUsageStatsReport.md)
 - [LimitOffsetPageDataPlatformJob](docs/LimitOffsetPageDataPlatformJob.md)
 - [LimitOffsetPageDataPlatformJobStepAggregatedReport](docs/LimitOffsetPageDataPlatformJobStepAggregatedReport.md)
 - [LineageConnectionType](docs/LineageConnectionType.md)
 - [LookerAdditionalConfig](docs/LookerAdditionalConfig.md)
 - [LookerCredentials](docs/LookerCredentials.md)
 - [LookerQueryComment](docs/LookerQueryComment.md)
 - [Notification](docs/Notification.md)
 - [NotificationConfig](docs/NotificationConfig.md)
 - [NotificationProvider](docs/NotificationProvider.md)
 - [NotificationType](docs/NotificationType.md)
 - [OperatorType](docs/OperatorType.md)
 - [PlatformBuildData](docs/PlatformBuildData.md)
 - [PlatformBuildType](docs/PlatformBuildType.md)
 - [Position](docs/Position.md)
 - [PredefinedFilter](docs/PredefinedFilter.md)
 - [ProductAnalyticsConfig](docs/ProductAnalyticsConfig.md)
 - [QueryBuilder](docs/QueryBuilder.md)
 - [QueryComment](docs/QueryComment.md)
 - [QueryCreateMode](docs/QueryCreateMode.md)
 - [QueryFingerprint](docs/QueryFingerprint.md)
 - [QueryLineageParseResult](docs/QueryLineageParseResult.md)
 - [QueryParseResult](docs/QueryParseResult.md)
 - [QueryType](docs/QueryType.md)
 - [RedshiftAccountDetails](docs/RedshiftAccountDetails.md)
 - [RedshiftAdditionalConfig](docs/RedshiftAdditionalConfig.md)
 - [RuleElement](docs/RuleElement.md)
 - [RuleElementValueType](docs/RuleElementValueType.md)
 - [RuleType](docs/RuleType.md)
 - [RuleValue](docs/RuleValue.md)
 - [SeenTableAtLevel](docs/SeenTableAtLevel.md)
 - [SheetSettings](docs/SheetSettings.md)
 - [SnowflakeAccountDetails](docs/SnowflakeAccountDetails.md)
 - [SnowflakeAdditionalConfig](docs/SnowflakeAdditionalConfig.md)
 - [SqlTable](docs/SqlTable.md)
 - [TableAlter](docs/TableAlter.md)
 - [TableExistence](docs/TableExistence.md)
 - [TableInsert](docs/TableInsert.md)
 - [TableMerge](docs/TableMerge.md)
 - [TableMergeAction](docs/TableMergeAction.md)
 - [TableMergeMatchActionType](docs/TableMergeMatchActionType.md)
 - [TableMergeMatchType](docs/TableMergeMatchType.md)
 - [TableUpdate](docs/TableUpdate.md)
 - [TableauAdditionalConfig](docs/TableauAdditionalConfig.md)
 - [TableauCredentials](docs/TableauCredentials.md)
 - [TinyURLResponse](docs/TinyURLResponse.md)
 - [Token](docs/Token.md)
 - [TreeResultClassification](docs/TreeResultClassification.md)
 - [TruncateResult](docs/TruncateResult.md)
 - [UsagePeriod](docs/UsagePeriod.md)
 - [UserGet](docs/UserGet.md)
 - [UserNameUsageStat](docs/UserNameUsageStat.md)
 - [UserOrganizationAPIKeyRequest](docs/UserOrganizationAPIKeyRequest.md)
 - [UserOrganizationAPIKeyResponse](docs/UserOrganizationAPIKeyResponse.md)
 - [UserRole](docs/UserRole.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization


## HTTPBearer

- **Type**: Bearer authentication


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in alvin_api_client.apis and alvin_api_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from alvin_api_client.api.default_api import DefaultApi`
- `from alvin_api_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import alvin_api_client
from alvin_api_client.apis import *
from alvin_api_client.models import *
```

