# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from restapisdk.api_helper import APIHelper
from restapisdk.controllers.metadata_controller import MetadataController


class MetadataControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(MetadataControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = MetadataController(cls.config, cls.response_catcher)

    # To get details of a specific tag, use this endpoint. At least one of id or name of tag is required. When both are given, then id will be considered.
    def test_get_tag(self):
        # Parameters for the API call
        name = None
        id = None

        # Perform the API call through the SDK function
        result = self.controller.get_tag(name, id)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


    # To programmatically delete tags, use this endpoint. At least one of id or name of tag is required. When both are given, then id will be considered.
    def test_delete_tag(self):
        # Parameters for the API call
        name = None
        id = None

        # Perform the API call through the SDK function
        result = self.controller.delete_tag(name, id)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


    # To get the name and id of liveboard that is set as a home liveboard for a user, use this endpoint. At least one of user id or username is required. When both are given, then id will be considered.
    def test_get_homeliveboard(self):
        # Parameters for the API call
        user_name = None
        user_id = None

        # Perform the API call through the SDK function
        result = self.controller.get_homeliveboard(user_name, user_id)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


    # To get a list of objects with incomplete metadata, use this endpoint
    def test_get_incomplete_objects(self):

        # Perform the API call through the SDK function
        result = self.controller.get_incomplete_objects()

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


