# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from restapisdk.decorators import lazy_property
from restapisdk.configuration import Configuration
from restapisdk.configuration import Environment
from restapisdk.controllers.session_controller import SessionController
from restapisdk.controllers.user_controller import UserController
from restapisdk.controllers.group_controller import GroupController
from restapisdk.controllers.metadata_controller import MetadataController
from restapisdk.controllers.database_controller import DatabaseController


class RestapisdkClient(object):

    @lazy_property
    def session(self):
        return SessionController(self.config)

    @lazy_property
    def user(self):
        return UserController(self.config)

    @lazy_property
    def group(self):
        return GroupController(self.config)

    @lazy_property
    def metadata(self):
        return MetadataController(self.config)

    @lazy_property
    def database(self):
        return DatabaseController(self.config)

    def __init__(self, http_client_instance=None,
                 override_http_client_configuration=False, timeout=60,
                 max_retries=0, backoff_factor=2,
                 retry_statuses=[408, 413, 429, 500, 502, 503, 504, 521, 522, 524, 408, 413, 429, 500, 502, 503, 504, 521, 522, 524],
                 retry_methods=['GET', 'PUT', 'GET', 'PUT'],
                 environment=Environment.PRODUCTION,
                 base_url='https://localhost:443',
                 content_type='application/json',
                 accept_language='application/json', access_token='',
                 config=None):
        if config is None:
            self.config = Configuration(
                                         http_client_instance=http_client_instance,
                                         override_http_client_configuration=override_http_client_configuration,
                                         timeout=timeout,
                                         max_retries=max_retries,
                                         backoff_factor=backoff_factor,
                                         retry_statuses=retry_statuses,
                                         retry_methods=retry_methods,
                                         environment=environment,
                                         base_url=base_url,
                                         content_type=content_type,
                                         accept_language=accept_language,
                                         access_token=access_token)
        else:
            self.config = config
