# -*- coding: utf-8 -*-

"""
restapisdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from restapisdk.models.group_name_and_id import GroupNameAndID
from restapisdk.models.liveboard_name_and_id import LiveboardNameAndID
from restapisdk.models.user_name_and_id import UserNameAndID


class GroupResponse(object):

    """Implementation of the 'GroupResponse' model.

    TODO: type model description here.

    Attributes:
        name (string): Name of the group
        display_name (string): A unique display name string for the user
            group
        id (string): GUID of the group
        visibility (string): Visibility of the group
        description (string): Description of the group
        privileges (list of string): Privileges assigned to the group
        groups (list of GroupNameAndID): Name of the group to which is added
        users (list of UserNameAndID): User Group Information by Id or Name.
        assigned_liveboards (list of LiveboardNameAndID): Liveboards assigned
            to the group
        user_group_content (object): TODO: type description here.
        tags (list of string): Tags assigned to the group
        is_deleted (bool): Indicates if the group is deleted
        is_hidden (bool): Indicates if the group is hidden
        is_external (bool): Indicates if the group is from external system
        is_deprecated (bool): TODO: type description here.
        complete (bool): Indicates if the all the properties of group is
            provided
        is_system_principal (bool): Indicates if the group is system
            principal
        mtype (string): Indicates the type of group
        parenttype (string): Indicates the type of parent object
        group_idx (int): TODO: type description here.
        metadata_version (int): TODO: type description here.
        tenant_id (string): Tenant id associated with the group
        index_version (int): TODO: type description here.
        generation_num (int): TODO: type description here.
        created (float): Date and time when group was created
        modified (float): Date and time of last modification of the group
        modified_by (UserNameAndID): TODO: type description here.
        author (UserNameAndID): TODO: type description here.
        owner (UserNameAndID): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "display_name": 'displayName',
        "id": 'id',
        "visibility": 'visibility',
        "description": 'description',
        "privileges": 'privileges',
        "groups": 'groups',
        "users": 'users',
        "assigned_liveboards": 'assignedLiveboards',
        "user_group_content": 'userGroupContent',
        "tags": 'tags',
        "is_deleted": 'isDeleted',
        "is_hidden": 'isHidden',
        "is_external": 'isExternal',
        "is_deprecated": 'isDeprecated',
        "complete": 'complete',
        "is_system_principal": 'isSystemPrincipal',
        "mtype": 'type',
        "parenttype": 'parenttype',
        "group_idx": 'groupIdx',
        "metadata_version": 'metadataVersion',
        "tenant_id": 'tenantId',
        "index_version": 'indexVersion',
        "generation_num": 'generationNum',
        "created": 'created',
        "modified": 'modified',
        "modified_by": 'modifiedBy',
        "author": 'author',
        "owner": 'owner'
    }

    def __init__(self,
                 name=None,
                 display_name=None,
                 id=None,
                 visibility=None,
                 description=None,
                 privileges=None,
                 groups=None,
                 users=None,
                 assigned_liveboards=None,
                 user_group_content=None,
                 tags=None,
                 is_deleted=None,
                 is_hidden=None,
                 is_external=None,
                 is_deprecated=None,
                 complete=None,
                 is_system_principal=None,
                 mtype=None,
                 parenttype=None,
                 group_idx=None,
                 metadata_version=None,
                 tenant_id=None,
                 index_version=None,
                 generation_num=None,
                 created=None,
                 modified=None,
                 modified_by=None,
                 author=None,
                 owner=None):
        """Constructor for the GroupResponse class"""

        # Initialize members of the class
        self.name = name
        self.display_name = display_name
        self.id = id
        self.visibility = visibility
        self.description = description
        self.privileges = privileges
        self.groups = groups
        self.users = users
        self.assigned_liveboards = assigned_liveboards
        self.user_group_content = user_group_content
        self.tags = tags
        self.is_deleted = is_deleted
        self.is_hidden = is_hidden
        self.is_external = is_external
        self.is_deprecated = is_deprecated
        self.complete = complete
        self.is_system_principal = is_system_principal
        self.mtype = mtype
        self.parenttype = parenttype
        self.group_idx = group_idx
        self.metadata_version = metadata_version
        self.tenant_id = tenant_id
        self.index_version = index_version
        self.generation_num = generation_num
        self.created = created
        self.modified = modified
        self.modified_by = modified_by
        self.author = author
        self.owner = owner

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get('name')
        display_name = dictionary.get('displayName')
        id = dictionary.get('id')
        visibility = dictionary.get('visibility')
        description = dictionary.get('description')
        privileges = dictionary.get('privileges')
        groups = None
        if dictionary.get('groups') is not None:
            groups = [GroupNameAndID.from_dictionary(x) for x in dictionary.get('groups')]
        users = None
        if dictionary.get('users') is not None:
            users = [UserNameAndID.from_dictionary(x) for x in dictionary.get('users')]
        assigned_liveboards = None
        if dictionary.get('assignedLiveboards') is not None:
            assigned_liveboards = [LiveboardNameAndID.from_dictionary(x) for x in dictionary.get('assignedLiveboards')]
        user_group_content = dictionary.get('userGroupContent')
        tags = dictionary.get('tags')
        is_deleted = dictionary.get('isDeleted')
        is_hidden = dictionary.get('isHidden')
        is_external = dictionary.get('isExternal')
        is_deprecated = dictionary.get('isDeprecated')
        complete = dictionary.get('complete')
        is_system_principal = dictionary.get('isSystemPrincipal')
        mtype = dictionary.get('type')
        parenttype = dictionary.get('parenttype')
        group_idx = dictionary.get('groupIdx')
        metadata_version = dictionary.get('metadataVersion')
        tenant_id = dictionary.get('tenantId')
        index_version = dictionary.get('indexVersion')
        generation_num = dictionary.get('generationNum')
        created = dictionary.get('created')
        modified = dictionary.get('modified')
        modified_by = UserNameAndID.from_dictionary(dictionary.get('modifiedBy')) if dictionary.get('modifiedBy') else None
        author = UserNameAndID.from_dictionary(dictionary.get('author')) if dictionary.get('author') else None
        owner = UserNameAndID.from_dictionary(dictionary.get('owner')) if dictionary.get('owner') else None

        # Return an object of this model
        return cls(name,
                   display_name,
                   id,
                   visibility,
                   description,
                   privileges,
                   groups,
                   users,
                   assigned_liveboards,
                   user_group_content,
                   tags,
                   is_deleted,
                   is_hidden,
                   is_external,
                   is_deprecated,
                   complete,
                   is_system_principal,
                   mtype,
                   parenttype,
                   group_idx,
                   metadata_version,
                   tenant_id,
                   index_version,
                   generation_num,
                   created,
                   modified,
                   modified_by,
                   author,
                   owner)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
