"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlbBinding = exports.SlbBindingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const sae_generated_1 = require("./sae.generated");
Object.defineProperty(exports, "SlbBindingProperty", { enumerable: true, get: function () { return sae_generated_1.RosSlbBinding; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::SAE::SlbBinding`, which is used to bind an SLB instance to an application.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosSlbBinding`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sae-slbbinding
 */
class SlbBinding extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSlbBinding = new sae_generated_1.RosSlbBinding(this, id, {
            internetSlbId: props.internetSlbId,
            appId: props.appId,
            intranet: props.intranet,
            intranetSlbId: props.intranetSlbId,
            internet: props.internet,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSlbBinding;
        this.attrAppId = rosSlbBinding.attrAppId;
        this.attrChangeOrderId = rosSlbBinding.attrChangeOrderId;
    }
}
exports.SlbBinding = SlbBinding;
//# sourceMappingURL=data:application/json;base64,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