"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosSlbBinding = exports.RosNamespace = exports.RosApplication = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosApplicationProps`
 *
 * @param properties - the TypeScript properties of a `RosApplicationProps`
 *
 * @returns the result of the validation.
 */
function RosApplicationPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('timezone', ros.validateString)(properties.timezone));
    if (properties.appDescription && (Array.isArray(properties.appDescription) || (typeof properties.appDescription) === 'string')) {
        errors.collect(ros.propertyValidator('appDescription', ros.validateLength)({
            data: properties.appDescription.length,
            min: undefined,
            max: 1024,
        }));
    }
    errors.collect(ros.propertyValidator('appDescription', ros.validateString)(properties.appDescription));
    errors.collect(ros.propertyValidator('mountDesc', ros.validateString)(properties.mountDesc));
    errors.collect(ros.propertyValidator('nasId', ros.validateString)(properties.nasId));
    errors.collect(ros.propertyValidator('warStartOptions', ros.validateString)(properties.warStartOptions));
    errors.collect(ros.propertyValidator('liveness', ros.validateString)(properties.liveness));
    errors.collect(ros.propertyValidator('memory', ros.requiredValidator)(properties.memory));
    if (properties.memory && (typeof properties.memory) !== 'object') {
        errors.collect(ros.propertyValidator('memory', ros.validateRange)({
            data: properties.memory,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('memory', ros.validateNumber)(properties.memory));
    errors.collect(ros.propertyValidator('webContainer', ros.validateString)(properties.webContainer));
    errors.collect(ros.propertyValidator('slsConfigs', ros.validateString)(properties.slsConfigs));
    errors.collect(ros.propertyValidator('cpu', ros.requiredValidator)(properties.cpu));
    if (properties.cpu && (typeof properties.cpu) !== 'object') {
        errors.collect(ros.propertyValidator('cpu', ros.validateRange)({
            data: properties.cpu,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('cpu', ros.validateNumber)(properties.cpu));
    errors.collect(ros.propertyValidator('deploy', ros.validateBoolean)(properties.deploy));
    errors.collect(ros.propertyValidator('packageVersion', ros.validateString)(properties.packageVersion));
    errors.collect(ros.propertyValidator('appName', ros.requiredValidator)(properties.appName));
    errors.collect(ros.propertyValidator('appName', ros.validateString)(properties.appName));
    errors.collect(ros.propertyValidator('jdk', ros.validateString)(properties.jdk));
    errors.collect(ros.propertyValidator('jarStartArgs', ros.validateString)(properties.jarStartArgs));
    errors.collect(ros.propertyValidator('preStop', ros.validateString)(properties.preStop));
    errors.collect(ros.propertyValidator('readiness', ros.validateString)(properties.readiness));
    errors.collect(ros.propertyValidator('packageType', ros.requiredValidator)(properties.packageType));
    errors.collect(ros.propertyValidator('packageType', ros.validateString)(properties.packageType));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosApplication_TagsPropertyValidator))(properties.tags));
    errors.collect(ros.propertyValidator('commandArgs', ros.validateString)(properties.commandArgs));
    errors.collect(ros.propertyValidator('securityGroupId', ros.validateString)(properties.securityGroupId));
    errors.collect(ros.propertyValidator('envs', ros.validateString)(properties.envs));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('imageUrl', ros.validateString)(properties.imageUrl));
    errors.collect(ros.propertyValidator('postStart', ros.validateString)(properties.postStart));
    errors.collect(ros.propertyValidator('jarStartOptions', ros.validateString)(properties.jarStartOptions));
    errors.collect(ros.propertyValidator('mountHost', ros.validateString)(properties.mountHost));
    errors.collect(ros.propertyValidator('replicas', ros.requiredValidator)(properties.replicas));
    errors.collect(ros.propertyValidator('replicas', ros.validateNumber)(properties.replicas));
    errors.collect(ros.propertyValidator('customHostAlias', ros.validateString)(properties.customHostAlias));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('command', ros.validateString)(properties.command));
    errors.collect(ros.propertyValidator('edasContainerVersion', ros.validateString)(properties.edasContainerVersion));
    errors.collect(ros.propertyValidator('packageUrl', ros.validateString)(properties.packageUrl));
    errors.collect(ros.propertyValidator('namespaceId', ros.requiredValidator)(properties.namespaceId));
    errors.collect(ros.propertyValidator('namespaceId', ros.validateString)(properties.namespaceId));
    return errors.wrap('supplied properties not correct for "RosApplicationProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::Application` resource
 *
 * @param properties - the TypeScript properties of a `RosApplicationProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::Application` resource.
 */
// @ts-ignore TS6133
function rosApplicationPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosApplicationPropsValidator(properties).assertSuccess();
    }
    return {
        AppName: ros.stringToRosTemplate(properties.appName),
        Cpu: ros.numberToRosTemplate(properties.cpu),
        Memory: ros.numberToRosTemplate(properties.memory),
        NamespaceId: ros.stringToRosTemplate(properties.namespaceId),
        PackageType: ros.stringToRosTemplate(properties.packageType),
        Replicas: ros.numberToRosTemplate(properties.replicas),
        AppDescription: ros.stringToRosTemplate(properties.appDescription),
        Command: ros.stringToRosTemplate(properties.command),
        CommandArgs: ros.stringToRosTemplate(properties.commandArgs),
        CustomHostAlias: ros.stringToRosTemplate(properties.customHostAlias),
        Deploy: ros.booleanToRosTemplate(properties.deploy),
        EdasContainerVersion: ros.stringToRosTemplate(properties.edasContainerVersion),
        Envs: ros.stringToRosTemplate(properties.envs),
        ImageUrl: ros.stringToRosTemplate(properties.imageUrl),
        JarStartArgs: ros.stringToRosTemplate(properties.jarStartArgs),
        JarStartOptions: ros.stringToRosTemplate(properties.jarStartOptions),
        Jdk: ros.stringToRosTemplate(properties.jdk),
        Liveness: ros.stringToRosTemplate(properties.liveness),
        MountDesc: ros.stringToRosTemplate(properties.mountDesc),
        MountHost: ros.stringToRosTemplate(properties.mountHost),
        NasId: ros.stringToRosTemplate(properties.nasId),
        PackageUrl: ros.stringToRosTemplate(properties.packageUrl),
        PackageVersion: ros.stringToRosTemplate(properties.packageVersion),
        PostStart: ros.stringToRosTemplate(properties.postStart),
        PreStop: ros.stringToRosTemplate(properties.preStop),
        Readiness: ros.stringToRosTemplate(properties.readiness),
        SecurityGroupId: ros.stringToRosTemplate(properties.securityGroupId),
        SlsConfigs: ros.stringToRosTemplate(properties.slsConfigs),
        Tags: ros.listMapper(rosApplicationTagsPropertyToRosTemplate)(properties.tags),
        Timezone: ros.stringToRosTemplate(properties.timezone),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        WarStartOptions: ros.stringToRosTemplate(properties.warStartOptions),
        WebContainer: ros.stringToRosTemplate(properties.webContainer),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::SAE::Application`, which is used to create an application in Serverless App Engine (SAE).
 * @Note This class does not contain additional functions, so it is recommended to use the `Application` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sae-application
 */
class RosApplication extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosApplication.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAppId = this.getAtt('AppId');
        this.attrChangeOrderId = this.getAtt('ChangeOrderId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.appName = props.appName;
        this.cpu = props.cpu;
        this.memory = props.memory;
        this.namespaceId = props.namespaceId;
        this.packageType = props.packageType;
        this.replicas = props.replicas;
        this.appDescription = props.appDescription;
        this.command = props.command;
        this.commandArgs = props.commandArgs;
        this.customHostAlias = props.customHostAlias;
        this.deploy = props.deploy;
        this.edasContainerVersion = props.edasContainerVersion;
        this.envs = props.envs;
        this.imageUrl = props.imageUrl;
        this.jarStartArgs = props.jarStartArgs;
        this.jarStartOptions = props.jarStartOptions;
        this.jdk = props.jdk;
        this.liveness = props.liveness;
        this.mountDesc = props.mountDesc;
        this.mountHost = props.mountHost;
        this.nasId = props.nasId;
        this.packageUrl = props.packageUrl;
        this.packageVersion = props.packageVersion;
        this.postStart = props.postStart;
        this.preStop = props.preStop;
        this.readiness = props.readiness;
        this.securityGroupId = props.securityGroupId;
        this.slsConfigs = props.slsConfigs;
        this.tags = props.tags;
        this.timezone = props.timezone;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.warStartOptions = props.warStartOptions;
        this.webContainer = props.webContainer;
    }
    get rosProperties() {
        return {
            appName: this.appName,
            cpu: this.cpu,
            memory: this.memory,
            namespaceId: this.namespaceId,
            packageType: this.packageType,
            replicas: this.replicas,
            appDescription: this.appDescription,
            command: this.command,
            commandArgs: this.commandArgs,
            customHostAlias: this.customHostAlias,
            deploy: this.deploy,
            edasContainerVersion: this.edasContainerVersion,
            envs: this.envs,
            imageUrl: this.imageUrl,
            jarStartArgs: this.jarStartArgs,
            jarStartOptions: this.jarStartOptions,
            jdk: this.jdk,
            liveness: this.liveness,
            mountDesc: this.mountDesc,
            mountHost: this.mountHost,
            nasId: this.nasId,
            packageUrl: this.packageUrl,
            packageVersion: this.packageVersion,
            postStart: this.postStart,
            preStop: this.preStop,
            readiness: this.readiness,
            securityGroupId: this.securityGroupId,
            slsConfigs: this.slsConfigs,
            tags: this.tags,
            timezone: this.timezone,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            warStartOptions: this.warStartOptions,
            webContainer: this.webContainer,
        };
    }
    renderProperties(props) {
        return rosApplicationPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosApplication = RosApplication;
/**
 * The resource type name for this resource class.
 */
RosApplication.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAE::Application";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosApplication_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::Application.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::Application.Tags` resource.
 */
// @ts-ignore TS6133
function rosApplicationTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosApplication_TagsPropertyValidator(properties).assertSuccess();
    return {
        Value: ros.stringToRosTemplate(properties.value),
        Key: ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosNamespaceProps`
 *
 * @param properties - the TypeScript properties of a `RosNamespaceProps`
 *
 * @returns the result of the validation.
 */
function RosNamespacePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('namespaceName', ros.requiredValidator)(properties.namespaceName));
    errors.collect(ros.propertyValidator('namespaceName', ros.validateString)(properties.namespaceName));
    errors.collect(ros.propertyValidator('namespaceId', ros.requiredValidator)(properties.namespaceId));
    errors.collect(ros.propertyValidator('namespaceId', ros.validateString)(properties.namespaceId));
    errors.collect(ros.propertyValidator('namespaceDescription', ros.validateString)(properties.namespaceDescription));
    return errors.wrap('supplied properties not correct for "RosNamespaceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::Namespace` resource
 *
 * @param properties - the TypeScript properties of a `RosNamespaceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::Namespace` resource.
 */
// @ts-ignore TS6133
function rosNamespacePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosNamespacePropsValidator(properties).assertSuccess();
    }
    return {
        NamespaceId: ros.stringToRosTemplate(properties.namespaceId),
        NamespaceName: ros.stringToRosTemplate(properties.namespaceName),
        NamespaceDescription: ros.stringToRosTemplate(properties.namespaceDescription),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::SAE::Namespace`, which is used to create a Namespace.
 * @Note This class does not contain additional functions, so it is recommended to use the `Namespace` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sae-namespace
 */
class RosNamespace extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosNamespace.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrNamespaceId = this.getAtt('NamespaceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.namespaceId = props.namespaceId;
        this.namespaceName = props.namespaceName;
        this.namespaceDescription = props.namespaceDescription;
    }
    get rosProperties() {
        return {
            namespaceId: this.namespaceId,
            namespaceName: this.namespaceName,
            namespaceDescription: this.namespaceDescription,
        };
    }
    renderProperties(props) {
        return rosNamespacePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosNamespace = RosNamespace;
/**
 * The resource type name for this resource class.
 */
RosNamespace.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAE::Namespace";
/**
 * Determine whether the given properties match those of a `RosSlbBindingProps`
 *
 * @param properties - the TypeScript properties of a `RosSlbBindingProps`
 *
 * @returns the result of the validation.
 */
function RosSlbBindingPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('internetSlbId', ros.validateString)(properties.internetSlbId));
    errors.collect(ros.propertyValidator('appId', ros.requiredValidator)(properties.appId));
    errors.collect(ros.propertyValidator('appId', ros.validateString)(properties.appId));
    errors.collect(ros.propertyValidator('intranet', ros.validateString)(properties.intranet));
    errors.collect(ros.propertyValidator('intranetSlbId', ros.validateString)(properties.intranetSlbId));
    errors.collect(ros.propertyValidator('internet', ros.validateString)(properties.internet));
    return errors.wrap('supplied properties not correct for "RosSlbBindingProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::SAE::SlbBinding` resource
 *
 * @param properties - the TypeScript properties of a `RosSlbBindingProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::SAE::SlbBinding` resource.
 */
// @ts-ignore TS6133
function rosSlbBindingPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSlbBindingPropsValidator(properties).assertSuccess();
    }
    return {
        AppId: ros.stringToRosTemplate(properties.appId),
        Internet: ros.stringToRosTemplate(properties.internet),
        InternetSlbId: ros.stringToRosTemplate(properties.internetSlbId),
        Intranet: ros.stringToRosTemplate(properties.intranet),
        IntranetSlbId: ros.stringToRosTemplate(properties.intranetSlbId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::SAE::SlbBinding`, which is used to bind an SLB instance to an application.
 * @Note This class does not contain additional functions, so it is recommended to use the `SlbBinding` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sae-slbbinding
 */
class RosSlbBinding extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSlbBinding.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAppId = this.getAtt('AppId');
        this.attrChangeOrderId = this.getAtt('ChangeOrderId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.appId = props.appId;
        this.internet = props.internet;
        this.internetSlbId = props.internetSlbId;
        this.intranet = props.intranet;
        this.intranetSlbId = props.intranetSlbId;
    }
    get rosProperties() {
        return {
            appId: this.appId,
            internet: this.internet,
            internetSlbId: this.internetSlbId,
            intranet: this.intranet,
            intranetSlbId: this.intranetSlbId,
        };
    }
    renderProperties(props) {
        return rosSlbBindingPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSlbBinding = RosSlbBinding;
/**
 * The resource type name for this resource class.
 */
RosSlbBinding.ROS_RESOURCE_TYPE_NAME = "ALIYUN::SAE::SlbBinding";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FlLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNhZS5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHlEQUF5RDs7O0FBRXpELDhDQUE4QztBQXNMOUM7Ozs7OztHQU1HO0FBQ0gsU0FBUyw0QkFBNEIsQ0FBQyxVQUFlO0lBQ2pELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsSUFBRyxVQUFVLENBQUMsY0FBYyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxjQUFjLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUMzSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUM7WUFDdkUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxjQUFjLENBQUMsTUFBTTtZQUN0QyxHQUFHLEVBQUUsU0FBUztZQUNkLEdBQUcsRUFBRSxJQUFJO1NBQ1YsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQztJQUN2RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDckYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQ3pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQzFGLElBQUcsVUFBVSxDQUFDLE1BQU0sSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLE1BQU0sQ0FBQyxLQUFLLFFBQVEsRUFBRTtRQUM3RCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxDQUFDO1lBQzlELElBQUksRUFBRSxVQUFVLENBQUMsTUFBTTtZQUN2QixHQUFHLEVBQUUsQ0FBQztZQUNOLEdBQUcsRUFBRSxTQUFTO1NBQ2YsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDdkYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNwRixJQUFHLFVBQVUsQ0FBQyxHQUFHLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxHQUFHLENBQUMsS0FBSyxRQUFRLEVBQUU7UUFDdkQsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUMzRCxJQUFJLEVBQUUsVUFBVSxDQUFDLEdBQUc7WUFDcEIsR0FBRyxFQUFFLENBQUM7WUFDTixHQUFHLEVBQUUsU0FBUztTQUNmLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztJQUM1RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsSUFBRyxVQUFVLENBQUMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxRQUFRLENBQUMsRUFBRTtRQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQzdELElBQUksRUFBRSxVQUFVLENBQUMsSUFBSSxDQUFDLE1BQU07WUFDNUIsR0FBRyxFQUFFLFNBQVM7WUFDZCxHQUFHLEVBQUUsRUFBRTtTQUNSLENBQUMsQ0FBQyxDQUFDO0tBQ1Q7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDeEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztJQUNuRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQzdGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM3RixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3pGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ25ILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdDQUFnQyxDQUFDLFVBQWUsRUFBRSxnQ0FBeUM7SUFDaEcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELElBQUcsZ0NBQWdDLEVBQUU7UUFDakMsNEJBQTRCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7S0FDNUQ7SUFDRCxPQUFPO1FBQ0wsT0FBTyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3BELEdBQUcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUM1QyxNQUFNLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDbEQsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzVELFdBQVcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUM1RCxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsY0FBYyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ2xFLE9BQU8sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUNwRCxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDNUQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLE1BQU0sRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQztRQUNuRCxvQkFBb0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQzlFLElBQUksRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztRQUM5QyxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzlELGVBQWUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUNwRSxHQUFHLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7UUFDNUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELFNBQVMsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUN4RCxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDeEQsS0FBSyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ2hELFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDbEUsU0FBUyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1FBQ3hELE9BQU8sRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUNwRCxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDeEQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7UUFDOUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELEtBQUssRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQztRQUNoRCxTQUFTLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDeEQsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLFlBQVksRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztLQUMvRCxDQUFDO0FBQ04sQ0FBQztBQUVEOzs7O0dBSUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsV0FBVztJQWdNL0M7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBMEIsRUFBRSxnQ0FBeUM7UUFDL0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsY0FBYyxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN0QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUV0RCxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFDekUsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQztRQUNyQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFDM0IsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBQzNDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztRQUN2QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUM3QyxJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQyxHQUFHLENBQUM7UUFDckIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztRQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFDakMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztJQUMzQyxDQUFDO0lBR0QsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsR0FBRyxFQUFFLElBQUksQ0FBQyxHQUFHO1lBQ2IsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU87WUFDckIsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07WUFDbkIsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDZixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUc7WUFDYixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDakIsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNuQyxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7WUFDekIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztZQUN6QixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDakIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDbEMsQ0FBQztJQUNOLENBQUM7SUFDUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLGdDQUFnQyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUMxRixDQUFDOztBQXhSTCx3Q0F5UkM7QUF4Ukc7O0dBRUc7QUFDb0IscUNBQXNCLEdBQUcsMEJBQTBCLENBQUM7QUFzUy9FOzs7Ozs7R0FNRztBQUNILFNBQVMsb0NBQW9DLENBQUMsVUFBZTtJQUN6RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO0lBQ3JGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNwRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ2pGLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO0FBQzdFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyx1Q0FBdUMsQ0FBQyxVQUFlO0lBQzVELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxvQ0FBb0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRSxPQUFPO1FBQ0wsS0FBSyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDO1FBQ2hELEdBQUcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztLQUM3QyxDQUFDO0FBQ04sQ0FBQztBQXdCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLDBCQUEwQixDQUFDLFVBQWU7SUFDL0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDbkgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHlEQUF5RCxDQUFDLENBQUM7QUFDbEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDhCQUE4QixDQUFDLFVBQWUsRUFBRSxnQ0FBeUM7SUFDOUYsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELElBQUcsZ0NBQWdDLEVBQUU7UUFDakMsMEJBQTBCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7S0FDMUQ7SUFDRCxPQUFPO1FBQ0wsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzVELGFBQWEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNoRSxvQkFBb0IsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO0tBQy9FLENBQUM7QUFDTixDQUFDO0FBRUQ7Ozs7R0FJRztBQUNILE1BQWEsWUFBYSxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBNkI3Qzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF3QixFQUFFLGdDQUF5QztRQUM3RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxZQUFZLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDbkYsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRWxELElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUN6RSxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7SUFDM0QsQ0FBQztJQUdELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1NBQ2xELENBQUM7SUFDTixDQUFDO0lBQ1MsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTyw4QkFBOEIsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDeEYsQ0FBQzs7QUF0REwsb0NBdURDO0FBdERHOztHQUVHO0FBQ29CLG1DQUFzQixHQUFHLHdCQUF3QixDQUFDO0FBcUY3RTs7Ozs7O0dBTUc7QUFDSCxTQUFTLDJCQUEyQixDQUFDLFVBQWU7SUFDaEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQztJQUNyRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGVBQWUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUM7SUFDckcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsMERBQTBELENBQUMsQ0FBQztBQUNuRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsK0JBQStCLENBQUMsVUFBZSxFQUFFLGdDQUF5QztJQUMvRixJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsSUFBRyxnQ0FBZ0MsRUFBRTtRQUNqQywyQkFBMkIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztLQUMzRDtJQUNELE9BQU87UUFDTCxLQUFLLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7UUFDaEQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELGFBQWEsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQztRQUNoRSxRQUFRLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDdEQsYUFBYSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO0tBQ2pFLENBQUM7QUFDTixDQUFDO0FBRUQ7Ozs7R0FJRztBQUNILE1BQWEsYUFBYyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBNEM5Qzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF5QixFQUFFLGdDQUF5QztRQUM5RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxhQUFhLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBRXRELElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUN6RSxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUM7UUFDekIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQztRQUN6QyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO0lBQzdDLENBQUM7SUFHRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7U0FDcEMsQ0FBQztJQUNOLENBQUM7SUFDUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLCtCQUErQixDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUN6RixDQUFDOztBQTFFTCxzQ0EyRUM7QUExRUc7O0dBRUc7QUFDb0Isb0NBQXNCLEdBQUcseUJBQXlCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cblxuaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYFJvc0FwcGxpY2F0aW9uYC5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLXNhZS1hcHBsaWNhdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJvc0FwcGxpY2F0aW9uUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGFwcE5hbWU6IEFwcGxpY2F0aW9uIE5hbWUuIEFsbG93ZWQgbnVtYmVycywgbGV0dGVycyBhbmQgdW5kZXJsaW5lZCBjb21iaW5hdGlvbnMgdGhlcmVvZi4gV2UgbXVzdCBiZWdpbiB3aXRoIHRoZSBsZXR0ZXJzLCB0aGUgbWF4aW11bSBsZW5ndGggb2YgMzYgY2hhcmFjdGVycy5cbiAgICAgKi9cbiAgICByZWFkb25seSBhcHBOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY3B1OiBFYWNoIGluc3RhbmNlIG9mIHRoZSBDUFUgcmVxdWlyZWQsIGluIHVuaXRzIG9mIG1pbGxpIGNvcmUsIGNhbiBub3QgYmUgemVyby4gQ3VycmVudGx5IG9ubHkgc3VwcG9ydHMgZml4ZWQgc3BlY2lmaWNhdGlvbnMgaW5zdGFuY2UgdHlwZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBjcHU6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBtZW1vcnk6IEVhY2ggaW5zdGFuY2Ugb2YgdGhlIHJlcXVpcmVkIG1lbW9yeSwgaW4gdW5pdHMgb2YgTUIsIGNhbiBub3QgYmUgemVyby4gQ3VycmVudGx5IG9ubHkgc3VwcG9ydHMgZml4ZWQgc3BlY2lmaWNhdGlvbnMgaW5zdGFuY2UgdHlwZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBtZW1vcnk6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogRURBUyBuYW1lc3BhY2UgY29ycmVzcG9uZGluZyB0byBJRC4gQ2FuYWRhIHN1cHBvcnRzIG9ubHkgdGhlIG5hbWUgb2YgdGhlIHNjcmliZSBsb3dlcmNhc2UgbmFtZXNwYWNlIG11c3QgYmVnaW4gd2l0aCBhIGxldHRlci5cbiAgICAgKiBOYW1lc3BhY2UgY2FuIGludGVyZmFjZSB0byBvYnRhaW4gZnJvbSBEZXNjcmliZU5hbWVzcGFjZUxpc3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZXNwYWNlSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBwYWNrYWdlVHlwZTogQXBwbGljYXRpb24gcGFja2FnZSB0eXBlLiBTdXBwb3J0IEZhdEphciwgV2FyLCBJbWFnZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBwYWNrYWdlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlcGxpY2FzOiBUaGUgaW5pdGlhbCBudW1iZXIgb2YgaW5zdGFuY2VzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcGxpY2FzOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYXBwRGVzY3JpcHRpb246IEFwcGxpY2F0aW9uIGRlc2NyaXB0aW9uLiBObyBtb3JlIHRoYW4gMTAyNCBjaGFyYWN0ZXJzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGFwcERlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNvbW1hbmQ6IE1pcnJvcmluZyB0aGUgc3RhcnQgY29tbWFuZC4gVGhlIGNvbW1hbmQgb2JqZWN0IGluIG1lbW9yeSBleGVjdXRhYmxlIGNvbnRhaW5lciBtdXN0IGJlLiBGb3IgZXhhbXBsZTogc2xlZXAuIFRoaXMgY29tbWFuZCB3aWxsIGNhdXNlIHRoZSBpbWFnZSB0byBzZXQgdGhlIG9yaWdpbmFsIHN0YXJ0dXAgY29tbWFuZCBmYWlsdXJlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbW1hbmQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY29tbWFuZEFyZ3M6IE1pcnJvcmluZyB0aGUgc3RhcnQgY29tbWFuZCBwYXJhbWV0ZXJzLiBQYXJhbWV0ZXJzIHJlcXVpcmVkIGZvciB0aGUgc3RhcnQtY29tbWFuZC4gRm9yIGV4YW1wbGU6IFsgXCIxZFwiXVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGNvbW1hbmRBcmdzPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGN1c3RvbUhvc3RBbGlhczogQ3VzdG9tIG1hcHBpbmcgaG9zdCB2ZXNzZWwuIEZvciBleGFtcGxlOiBbeyBcImhvc3ROYW1lXCI6IFwic2FtcGxlaG9zdFwiLCBcImlwXCI6IFwiMTI3LjAuMC4xXCJ9XVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGN1c3RvbUhvc3RBbGlhcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXBsb3k6IFdoZXRoZXIgZGVwbG95ZWQgaW1tZWRpYXRlbHkgdGFrZSBlZmZlY3QsIHRoZSBkZWZhdWx0IGlzIGZhbHNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlcGxveT86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWRhc0NvbnRhaW5lclZlcnNpb246IEVEQVMgcGFuZG9yYSBydW50aW1lIGVudmlyb25tZW50IHVzZWQgYnkgdGhlIGFwcGxpY2F0aW9uLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVkYXNDb250YWluZXJWZXJzaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVudnM6IENvbnRhaW5lciBlbnZpcm9ubWVudCB2YXJpYWJsZSBwYXJhbWV0ZXJzLiBGb3IgZXhhbXBsZTogW3sgXCJuYW1lXCI6IFwiZW52dG1wXCIsIFwidmFsdWVcIjogXCIwXCJ9XVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGVudnM/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaW1hZ2VVcmw6IE1pcnJvcmluZyBhZGRyZXNzLiBJbWFnZSBvbmx5IHR5cGUgb2YgYXBwbGljYXRpb24gY2FuIGJlIGNvbmZpZ3VyZWQgdG8gbWlycm9yIGFkZHJlc3MuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW1hZ2VVcmw/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgamFyU3RhcnRBcmdzOiBKYXIgcGFja2FnZSBzdGFydHVwIGFwcGxpY2F0aW9uIHBhcmFtZXRlcnMuIEFwcGx5IHRoZSBkZWZhdWx0IHN0YXJ0dXAgY29tbWFuZDogJCBKQVZBX0hPTUUgXFwvIGJpbiBcXC8gamF2YSAkIEphclN0YXJ0T3B0aW9ucyAtamFyICQgQ0FUQUxJTkFfT1BUUyBcIiQgcGFja2FnZV9wYXRoXCJcbiAgICAgKiAkIEphclN0YXJ0QXJnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGphclN0YXJ0QXJncz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBqYXJTdGFydE9wdGlvbnM6IEphciBzdGFydCB0aGUgYXBwbGljYXRpb24gcGFja2FnZSBvcHRpb24uIEFwcGx5IHRoZSBkZWZhdWx0IHN0YXJ0dXAgY29tbWFuZDogJCBKQVZBX0hPTUUgXFwvIGJpbiBcXC8gamF2YSAkIEphclN0YXJ0T3B0aW9ucyAtamFyICQgQ0FUQUxJTkFfT1BUUyBcIiQgcGFja2FnZV9wYXRoXCJcbiAgICAgKiAkIEphclN0YXJ0QXJnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGphclN0YXJ0T3B0aW9ucz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBqZGs6IERlcGxveW1lbnQgb2YgSkRLIHZlcnNpb24gb2YgdGhlIHBhY2thZ2UgZGVwZW5kcyBvbi4gTWlycm9yaW5nIG5vdCBzdXBwb3J0ZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgamRrPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGxpdmVuZXNzOiBDb250YWluZXIgaGVhbHRoIGNoZWNrLCBoZWFsdGggY2hlY2sgZmFpbHMgY29udGFpbmVyIHdpbGwgYmUga2lsbGVkIGFuZCByZWNvdmVyeS4gQ3VycmVudGx5IG9ubHkgc3VwcG9ydHMgbW9kZSBjb21tYW5kIGlzc3VlZCBpbiB0aGUgY29udGFpbmVyLiBUaGUgY29sdW1uczogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogWyBcInNsZWVwXCIsIFwiNXNcIl19LCBcImluaXRpYWxEZWxheVNlY29uZHNcIjogMTAsIFwidGltZW91dFNlY29uZHNcIjogMTF9XG4gICAgICovXG4gICAgcmVhZG9ubHkgbGl2ZW5lc3M/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbW91bnREZXNjOiBNb3VudCBEZXNjcmlwdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1vdW50RGVzYz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBtb3VudEhvc3Q6IG5hcyBtb3VudCBwb2ludCBpbiB0aGUgYXBwbGljYXRpb24gb2YgdnBjLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1vdW50SG9zdD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuYXNJZDogTW91bnQgdGhlIE5BUyBJRCwgeW91IG11c3QgYmUgaW4gdGhlIHNhbWUgcmVnaW9uIGFuZCBjbHVzdGVyLiBJdCBtdXN0IGJlIGF2YWlsYWJsZSB0byBjcmVhdGUgYSBtb3VudCBwb2ludCBsaW1pdCwgb3Igc3dpdGNoIG9uIGl0cyBtb3VudCBwb2ludCBhbHJlYWR5IGluIHRoZSBWUEMuIElmIHlvdSBkbyBub3QgZmlsbCwgYW5kIHRoZXJlIG1vdW50RGVzY3MgZmllbGQsIHRoZSBkZWZhdWx0IHdpbGwgYXV0b21hdGljYWxseSBwdXJjaGFzZSBhIE5BUyBhbmQgbW91bnQgaXQgb250byB0aGUgc3dpdGNoIHdpdGhpbiB0aGUgVlBDLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hc0lkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBhY2thZ2VVcmw6IERlcGxveW1lbnQgcGFja2FnZXMgYWRkcmVzcy4gT25seSBGYXRKYXIgV2FyIG9yIHRoZSB0eXBlIG9mIGFwcGxpY2F0aW9uIGNhbiBiZSBjb25maWd1cmVkIHRvIGRlcGxveSBwYWNrZXQgYWRkcmVzcy5cbiAgICAgKi9cbiAgICByZWFkb25seSBwYWNrYWdlVXJsPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBhY2thZ2VWZXJzaW9uOiBUaGUgdmVyc2lvbiBudW1iZXIgb2YgdGhlIGRlcGxveWVkIHBhY2thZ2UsIFdhciBGYXRKYXIgdHlwZSByZXF1aXJlZC4gUGxlYXNlIGN1c3RvbWl6ZSBpdCBtZWFuaW5nLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHBhY2thZ2VWZXJzaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBvc3RTdGFydDogRXhlY3V0aW5nIHRoZSBzY3JpcHQsIHN1Y2ggYXMgYWZ0ZXIgc3RhcnRpbmcgdGhlIGZvcm1hdDogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogXCJjYXRcIiwgXCJcXC8gZXRjIFxcLyBncm91cFwifX1cbiAgICAgKi9cbiAgICByZWFkb25seSBwb3N0U3RhcnQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcHJlU3RvcDogU2NyaXB0IGlzIGV4ZWN1dGVkIGJlZm9yZSBzdG9wcGluZyB0aGUgZm9ybWF0IGFzOiB7IFwiZXhlY1wiOiB7IFwiY29tbWFuZFwiOiBcImNhdFwiLCBcIlxcLyBldGMgXFwvIGdyb3VwXCJ9fVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByZVN0b3A/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVhZGluZXNzOiBBcHBsaWNhdGlvbiBsYXVuY2ggc3RhdHVzIGNoZWNrLCBoZWFsdGggY2hlY2sgZmFpbHMgcmVwZWF0ZWRseSBjb250YWluZXIgd2lsbCBiZSBraWxsZWQgYW5kIHJlc3RhcnRlZC4gRG8gbm90IHBhc3MgaGVhbHRoIGNoZWNrIG9mIHRoZSB2ZXNzZWwgd2lsbCBub3QgaGF2ZSB0byBlbnRlciBTTEIgdHJhZmZpYy4gRm9yIGV4YW1wbGU6IHsgXCJleGVjXCI6IHsgXCJjb21tYW5kXCI6IFsgXCJzbGVlcFwiLCBcIjZzXCJdfSwgXCJpbml0aWFsRGVsYXlTZWNvbmRzXCI6IDE1LCBcInRpbWVvdXRTZWNvbmRzXCI6IDEyfVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlYWRpbmVzcz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUdyb3VwSWQ6IFNlY3VyaXR5IGdyb3VwIElELlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXBJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzbHNDb25maWdzOiBMb2cgY29sbGVjdGlvbiBjb25maWd1cmF0aW9uIGZpbGVcbiAgICAgKi9cbiAgICByZWFkb25seSBzbHNDb25maWdzPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRhZ3M6IFRhZ3MgdG8gYXR0YWNoIHRvIGFwcGxpY2F0aW9uLiBNYXggc3VwcG9ydCAyMCB0YWdzIHRvIGFkZCBkdXJpbmcgY3JlYXRlIGFwcGxpY2F0aW9uLiBFYWNoIHRhZyB3aXRoIHR3byBwcm9wZXJ0aWVzIEtleSBhbmQgVmFsdWUsIGFuZCBLZXkgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFncz86IFJvc0FwcGxpY2F0aW9uLlRhZ3NQcm9wZXJ0eVtdO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRpbWV6b25lOiBBcHBsaWNhdGlvbiB0aW1lIHpvbmUuIERlZmF1bHQgQXNpYVxcL1NoYW5naGFpLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRpbWV6b25lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZwY0lkOiBFREFTIG5hbWVzcGFjZSBjb3JyZXNwb25kaW5nIFZQQy4gSW4gU2VydmVybGVzcyBpbiBhIGNvcnJlc3BvbmRpbmcgb25lIG9mIHRoZSBWUEMgbmFtZXNwYWNlIG9ubHksIGFuZCBjYW4gbm90IGJlIG1vZGlmaWVkLiBTZXJ2ZXJsZXNzIGZpcnN0IGNyZWF0ZWQgaW4gdGhlIGFwcGxpY2F0aW9uIG5hbWUgc3BhY2Ugd2lsbCBmb3JtIGEgYmluZGluZyByZWxhdGlvbnNoaXAuIFlvdSBtYXkgY29ycmVzcG9uZCB0byBhIHBsdXJhbGl0eSBvZiBuYW1lc3BhY2VzIFZQQy4gRG8gbm90IGZpbGwgd2FzIFZwY0lkIG5hbWVzcGFjZSBiaW5kaW5nLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZwY0lkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogQXBwbGljYXRpb24gZXhhbXBsZXMgd2hlcmUgdGhlIGVsYXN0aWMgY2FyZCB2aXJ0dWFsIHN3aXRjaC4gVGhlIHN3aXRjaCBtdXN0IGJlIGxvY2F0ZWQgYWJvdmUgdGhlIFZQQy4gVGhlIHNhbWUgc3dpdGNoIHdpdGggRURBUyBuYW1lc3BhY2UgYmluZGluZyByZWxhdGlvbnNoaXAuIERvIG5vdCBmaWxsIHdhcyBWU3dpdGNoSWQgbmFtZXNwYWNlIGJpbmRpbmcuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdlN3aXRjaElkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHdhclN0YXJ0T3B0aW9uczogV2FyIFN0YXJ0IHRoZSBhcHBsaWNhdGlvbiBwYWNrYWdlIG9wdGlvbi4gQXBwbHkgdGhlIGRlZmF1bHQgc3RhcnR1cCBjb21tYW5kOiBqYXZhICQgSkFWQV9PUFRTICQgQ0FUQUxJTkFfT1BUUyAtT3B0aW9ucyBvcmcuYXBhY2hlLmNhdGFsaW5hLnN0YXJ0dXAuQm9vdHN0cmFwIFwiJCBAXCIgc3RhcnRcbiAgICAgKi9cbiAgICByZWFkb25seSB3YXJTdGFydE9wdGlvbnM/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgd2ViQ29udGFpbmVyOiBUb21jYXQgZGVwbG95bWVudCBvZiB0aGUgcGFja2FnZSBkZXBlbmRzIG9uIHRoZSB2ZXJzaW9uLiBNaXJyb3Jpbmcgbm90IHN1cHBvcnRlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSB3ZWJDb250YWluZXI/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zQXBwbGljYXRpb25Qcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zQXBwbGljYXRpb25Qcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBSb3NBcHBsaWNhdGlvblByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGltZXpvbmUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudGltZXpvbmUpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmFwcERlc2NyaXB0aW9uICYmIChBcnJheS5pc0FycmF5KHByb3BlcnRpZXMuYXBwRGVzY3JpcHRpb24pIHx8ICh0eXBlb2YgcHJvcGVydGllcy5hcHBEZXNjcmlwdGlvbikgPT09ICdzdHJpbmcnKSkge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FwcERlc2NyaXB0aW9uJywgcm9zLnZhbGlkYXRlTGVuZ3RoKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmFwcERlc2NyaXB0aW9uLmxlbmd0aCxcbiAgICAgICAgICAgIG1pbjogdW5kZWZpbmVkLFxuICAgICAgICAgICAgbWF4OiAxMDI0LFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhcHBEZXNjcmlwdGlvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hcHBEZXNjcmlwdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbW91bnREZXNjJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm1vdW50RGVzYykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFzSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFzSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3dhclN0YXJ0T3B0aW9ucycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy53YXJTdGFydE9wdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2xpdmVuZXNzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmxpdmVuZXNzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdtZW1vcnknLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubWVtb3J5KSk7XG4gICAgaWYocHJvcGVydGllcy5tZW1vcnkgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLm1lbW9yeSkgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbWVtb3J5Jywgcm9zLnZhbGlkYXRlUmFuZ2UpKHtcbiAgICAgICAgICAgIGRhdGE6IHByb3BlcnRpZXMubWVtb3J5LFxuICAgICAgICAgICAgbWluOiAxLFxuICAgICAgICAgICAgbWF4OiB1bmRlZmluZWQsXG4gICAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ21lbW9yeScsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5tZW1vcnkpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3dlYkNvbnRhaW5lcicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy53ZWJDb250YWluZXIpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Nsc0NvbmZpZ3MnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc2xzQ29uZmlncykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY3B1Jywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmNwdSkpO1xuICAgIGlmKHByb3BlcnRpZXMuY3B1ICYmICh0eXBlb2YgcHJvcGVydGllcy5jcHUpICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NwdScsIHJvcy52YWxpZGF0ZVJhbmdlKSh7XG4gICAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmNwdSxcbiAgICAgICAgICAgIG1pbjogMSxcbiAgICAgICAgICAgIG1heDogdW5kZWZpbmVkLFxuICAgICAgICAgIH0pKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdjcHUnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuY3B1KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXBsb3knLCByb3MudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmRlcGxveSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigncGFja2FnZVZlcnNpb24nLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGFja2FnZVZlcnNpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2FwcE5hbWUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYXBwTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwTmFtZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5hcHBOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdqZGsnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuamRrKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdqYXJTdGFydEFyZ3MnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuamFyU3RhcnRBcmdzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwcmVTdG9wJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnByZVN0b3ApKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JlYWRpbmVzcycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yZWFkaW5lc3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BhY2thZ2VUeXBlJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnBhY2thZ2VUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdwYWNrYWdlVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wYWNrYWdlVHlwZSkpO1xuICAgIGlmKHByb3BlcnRpZXMudGFncyAmJiAoQXJyYXkuaXNBcnJheShwcm9wZXJ0aWVzLnRhZ3MpIHx8ICh0eXBlb2YgcHJvcGVydGllcy50YWdzKSA9PT0gJ3N0cmluZycpKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIHJvcy52YWxpZGF0ZUxlbmd0aCkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy50YWdzLmxlbmd0aCxcbiAgICAgICAgICAgIG1pbjogdW5kZWZpbmVkLFxuICAgICAgICAgICAgbWF4OiAyMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIHJvcy5saXN0VmFsaWRhdG9yKFJvc0FwcGxpY2F0aW9uX1RhZ3NQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMudGFncykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY29tbWFuZEFyZ3MnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuY29tbWFuZEFyZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3NlY3VyaXR5R3JvdXBJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zZWN1cml0eUdyb3VwSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2VudnMnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZW52cykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndlN3aXRjaElkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZTd2l0Y2hJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW1hZ2VVcmwnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW1hZ2VVcmwpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Bvc3RTdGFydCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5wb3N0U3RhcnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2phclN0YXJ0T3B0aW9ucycsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5qYXJTdGFydE9wdGlvbnMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ21vdW50SG9zdCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5tb3VudEhvc3QpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3JlcGxpY2FzJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnJlcGxpY2FzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZXBsaWNhcycsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5yZXBsaWNhcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignY3VzdG9tSG9zdEFsaWFzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmN1c3RvbUhvc3RBbGlhcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndnBjSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudnBjSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2NvbW1hbmQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuY29tbWFuZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZWRhc0NvbnRhaW5lclZlcnNpb24nLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZWRhc0NvbnRhaW5lclZlcnNpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3BhY2thZ2VVcmwnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucGFja2FnZVVybCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZXNwYWNlSWQnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZXNwYWNlSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZUlkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5hbWVzcGFjZUlkKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc0FwcGxpY2F0aW9uUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6QXBwbGljYXRpb25gIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJvc0FwcGxpY2F0aW9uUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6QXBwbGljYXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gcm9zQXBwbGljYXRpb25Qcm9wc1RvUm9zVGVtcGxhdGUocHJvcGVydGllczogYW55LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbik6IGFueSB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIGlmKGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KSB7XG4gICAgICAgIFJvc0FwcGxpY2F0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgQXBwTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hcHBOYW1lKSxcbiAgICAgIENwdTogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5jcHUpLFxuICAgICAgTWVtb3J5OiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm1lbW9yeSksXG4gICAgICBOYW1lc3BhY2VJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5uYW1lc3BhY2VJZCksXG4gICAgICBQYWNrYWdlVHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5wYWNrYWdlVHlwZSksXG4gICAgICBSZXBsaWNhczogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5yZXBsaWNhcyksXG4gICAgICBBcHBEZXNjcmlwdGlvbjogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5hcHBEZXNjcmlwdGlvbiksXG4gICAgICBDb21tYW5kOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmNvbW1hbmQpLFxuICAgICAgQ29tbWFuZEFyZ3M6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuY29tbWFuZEFyZ3MpLFxuICAgICAgQ3VzdG9tSG9zdEFsaWFzOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmN1c3RvbUhvc3RBbGlhcyksXG4gICAgICBEZXBsb3k6IHJvcy5ib29sZWFuVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlcGxveSksXG4gICAgICBFZGFzQ29udGFpbmVyVmVyc2lvbjogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5lZGFzQ29udGFpbmVyVmVyc2lvbiksXG4gICAgICBFbnZzOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmVudnMpLFxuICAgICAgSW1hZ2VVcmw6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaW1hZ2VVcmwpLFxuICAgICAgSmFyU3RhcnRBcmdzOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmphclN0YXJ0QXJncyksXG4gICAgICBKYXJTdGFydE9wdGlvbnM6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuamFyU3RhcnRPcHRpb25zKSxcbiAgICAgIEpkazogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5qZGspLFxuICAgICAgTGl2ZW5lc3M6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubGl2ZW5lc3MpLFxuICAgICAgTW91bnREZXNjOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm1vdW50RGVzYyksXG4gICAgICBNb3VudEhvc3Q6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubW91bnRIb3N0KSxcbiAgICAgIE5hc0lkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm5hc0lkKSxcbiAgICAgIFBhY2thZ2VVcmw6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucGFja2FnZVVybCksXG4gICAgICBQYWNrYWdlVmVyc2lvbjogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5wYWNrYWdlVmVyc2lvbiksXG4gICAgICBQb3N0U3RhcnQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucG9zdFN0YXJ0KSxcbiAgICAgIFByZVN0b3A6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucHJlU3RvcCksXG4gICAgICBSZWFkaW5lc3M6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVhZGluZXNzKSxcbiAgICAgIFNlY3VyaXR5R3JvdXBJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zZWN1cml0eUdyb3VwSWQpLFxuICAgICAgU2xzQ29uZmlnczogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zbHNDb25maWdzKSxcbiAgICAgIFRhZ3M6IHJvcy5saXN0TWFwcGVyKHJvc0FwcGxpY2F0aW9uVGFnc1Byb3BlcnR5VG9Sb3NUZW1wbGF0ZSkocHJvcGVydGllcy50YWdzKSxcbiAgICAgIFRpbWV6b25lOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnRpbWV6b25lKSxcbiAgICAgIFZwY0lkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnZwY0lkKSxcbiAgICAgIFZTd2l0Y2hJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy52U3dpdGNoSWQpLFxuICAgICAgV2FyU3RhcnRPcHRpb25zOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLndhclN0YXJ0T3B0aW9ucyksXG4gICAgICBXZWJDb250YWluZXI6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMud2ViQ29udGFpbmVyKSxcbiAgICB9O1xufVxuXG4vKipcbiAqIFRoaXMgY2xhc3MgaXMgYSBiYXNlIGVuY2Fwc3VsYXRpb24gYXJvdW5kIHRoZSBST1MgcmVzb3VyY2UgdHlwZSBgQUxJWVVOOjpTQUU6OkFwcGxpY2F0aW9uYCwgd2hpY2ggaXMgdXNlZCB0byBjcmVhdGUgYW4gYXBwbGljYXRpb24gaW4gU2VydmVybGVzcyBBcHAgRW5naW5lIChTQUUpLlxuICogQE5vdGUgVGhpcyBjbGFzcyBkb2VzIG5vdCBjb250YWluIGFkZGl0aW9uYWwgZnVuY3Rpb25zLCBzbyBpdCBpcyByZWNvbW1lbmRlZCB0byB1c2UgdGhlIGBBcHBsaWNhdGlvbmAgY2xhc3MgaW5zdGVhZCBvZiB0aGlzIGNsYXNzIGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tc2FlLWFwcGxpY2F0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBSb3NBcHBsaWNhdGlvbiBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6U0FFOjpBcHBsaWNhdGlvblwiO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBBcHBJZDogQ3JlYXRpbmcgc3VjY2Vzc2Z1bCBhcHBsaWNhdGlvbiBJRC5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckFwcElkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAQXR0cmlidXRlIENoYW5nZU9yZGVySWQ6IFJldHVybiB0byByZWxlYXNlIGEgc2luZ2xlIElELCB1c2VkIHRvIHF1ZXJ5IHRhc2sgZXhlY3V0aW9uIHN0YXR1cy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckNoYW5nZU9yZGVySWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIHB1YmxpYyBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbjtcblxuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGFwcE5hbWU6IEFwcGxpY2F0aW9uIE5hbWUuIEFsbG93ZWQgbnVtYmVycywgbGV0dGVycyBhbmQgdW5kZXJsaW5lZCBjb21iaW5hdGlvbnMgdGhlcmVvZi4gV2UgbXVzdCBiZWdpbiB3aXRoIHRoZSBsZXR0ZXJzLCB0aGUgbWF4aW11bSBsZW5ndGggb2YgMzYgY2hhcmFjdGVycy5cbiAgICAgKi9cbiAgICBwdWJsaWMgYXBwTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNwdTogRWFjaCBpbnN0YW5jZSBvZiB0aGUgQ1BVIHJlcXVpcmVkLCBpbiB1bml0cyBvZiBtaWxsaSBjb3JlLCBjYW4gbm90IGJlIHplcm8uIEN1cnJlbnRseSBvbmx5IHN1cHBvcnRzIGZpeGVkIHNwZWNpZmljYXRpb25zIGluc3RhbmNlIHR5cGUuXG4gICAgICovXG4gICAgcHVibGljIGNwdTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IG1lbW9yeTogRWFjaCBpbnN0YW5jZSBvZiB0aGUgcmVxdWlyZWQgbWVtb3J5LCBpbiB1bml0cyBvZiBNQiwgY2FuIG5vdCBiZSB6ZXJvLiBDdXJyZW50bHkgb25seSBzdXBwb3J0cyBmaXhlZCBzcGVjaWZpY2F0aW9ucyBpbnN0YW5jZSB0eXBlLlxuICAgICAqL1xuICAgIHB1YmxpYyBtZW1vcnk6IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogRURBUyBuYW1lc3BhY2UgY29ycmVzcG9uZGluZyB0byBJRC4gQ2FuYWRhIHN1cHBvcnRzIG9ubHkgdGhlIG5hbWUgb2YgdGhlIHNjcmliZSBsb3dlcmNhc2UgbmFtZXNwYWNlIG11c3QgYmVnaW4gd2l0aCBhIGxldHRlci5cbiAgICAgKiBOYW1lc3BhY2UgY2FuIGludGVyZmFjZSB0byBvYnRhaW4gZnJvbSBEZXNjcmliZU5hbWVzcGFjZUxpc3QuXG4gICAgICovXG4gICAgcHVibGljIG5hbWVzcGFjZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcGFja2FnZVR5cGU6IEFwcGxpY2F0aW9uIHBhY2thZ2UgdHlwZS4gU3VwcG9ydCBGYXRKYXIsIFdhciwgSW1hZ2UuXG4gICAgICovXG4gICAgcHVibGljIHBhY2thZ2VUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVwbGljYXM6IFRoZSBpbml0aWFsIG51bWJlciBvZiBpbnN0YW5jZXMuXG4gICAgICovXG4gICAgcHVibGljIHJlcGxpY2FzOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYXBwRGVzY3JpcHRpb246IEFwcGxpY2F0aW9uIGRlc2NyaXB0aW9uLiBObyBtb3JlIHRoYW4gMTAyNCBjaGFyYWN0ZXJzLlxuICAgICAqL1xuICAgIHB1YmxpYyBhcHBEZXNjcmlwdGlvbjogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGNvbW1hbmQ6IE1pcnJvcmluZyB0aGUgc3RhcnQgY29tbWFuZC4gVGhlIGNvbW1hbmQgb2JqZWN0IGluIG1lbW9yeSBleGVjdXRhYmxlIGNvbnRhaW5lciBtdXN0IGJlLiBGb3IgZXhhbXBsZTogc2xlZXAuIFRoaXMgY29tbWFuZCB3aWxsIGNhdXNlIHRoZSBpbWFnZSB0byBzZXQgdGhlIG9yaWdpbmFsIHN0YXJ0dXAgY29tbWFuZCBmYWlsdXJlLlxuICAgICAqL1xuICAgIHB1YmxpYyBjb21tYW5kOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgY29tbWFuZEFyZ3M6IE1pcnJvcmluZyB0aGUgc3RhcnQgY29tbWFuZCBwYXJhbWV0ZXJzLiBQYXJhbWV0ZXJzIHJlcXVpcmVkIGZvciB0aGUgc3RhcnQtY29tbWFuZC4gRm9yIGV4YW1wbGU6IFsgXCIxZFwiXVxuICAgICAqL1xuICAgIHB1YmxpYyBjb21tYW5kQXJnczogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGN1c3RvbUhvc3RBbGlhczogQ3VzdG9tIG1hcHBpbmcgaG9zdCB2ZXNzZWwuIEZvciBleGFtcGxlOiBbeyBcImhvc3ROYW1lXCI6IFwic2FtcGxlaG9zdFwiLCBcImlwXCI6IFwiMTI3LjAuMC4xXCJ9XVxuICAgICAqL1xuICAgIHB1YmxpYyBjdXN0b21Ib3N0QWxpYXM6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXBsb3k6IFdoZXRoZXIgZGVwbG95ZWQgaW1tZWRpYXRlbHkgdGFrZSBlZmZlY3QsIHRoZSBkZWZhdWx0IGlzIGZhbHNlLlxuICAgICAqL1xuICAgIHB1YmxpYyBkZXBsb3k6IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZWRhc0NvbnRhaW5lclZlcnNpb246IEVEQVMgcGFuZG9yYSBydW50aW1lIGVudmlyb25tZW50IHVzZWQgYnkgdGhlIGFwcGxpY2F0aW9uLlxuICAgICAqL1xuICAgIHB1YmxpYyBlZGFzQ29udGFpbmVyVmVyc2lvbjogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGVudnM6IENvbnRhaW5lciBlbnZpcm9ubWVudCB2YXJpYWJsZSBwYXJhbWV0ZXJzLiBGb3IgZXhhbXBsZTogW3sgXCJuYW1lXCI6IFwiZW52dG1wXCIsIFwidmFsdWVcIjogXCIwXCJ9XVxuICAgICAqL1xuICAgIHB1YmxpYyBlbnZzOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaW1hZ2VVcmw6IE1pcnJvcmluZyBhZGRyZXNzLiBJbWFnZSBvbmx5IHR5cGUgb2YgYXBwbGljYXRpb24gY2FuIGJlIGNvbmZpZ3VyZWQgdG8gbWlycm9yIGFkZHJlc3MuXG4gICAgICovXG4gICAgcHVibGljIGltYWdlVXJsOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgamFyU3RhcnRBcmdzOiBKYXIgcGFja2FnZSBzdGFydHVwIGFwcGxpY2F0aW9uIHBhcmFtZXRlcnMuIEFwcGx5IHRoZSBkZWZhdWx0IHN0YXJ0dXAgY29tbWFuZDogJCBKQVZBX0hPTUUgXFwvIGJpbiBcXC8gamF2YSAkIEphclN0YXJ0T3B0aW9ucyAtamFyICQgQ0FUQUxJTkFfT1BUUyBcIiQgcGFja2FnZV9wYXRoXCJcbiAgICAgKiAkIEphclN0YXJ0QXJnc1xuICAgICAqL1xuICAgIHB1YmxpYyBqYXJTdGFydEFyZ3M6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBqYXJTdGFydE9wdGlvbnM6IEphciBzdGFydCB0aGUgYXBwbGljYXRpb24gcGFja2FnZSBvcHRpb24uIEFwcGx5IHRoZSBkZWZhdWx0IHN0YXJ0dXAgY29tbWFuZDogJCBKQVZBX0hPTUUgXFwvIGJpbiBcXC8gamF2YSAkIEphclN0YXJ0T3B0aW9ucyAtamFyICQgQ0FUQUxJTkFfT1BUUyBcIiQgcGFja2FnZV9wYXRoXCJcbiAgICAgKiAkIEphclN0YXJ0QXJnc1xuICAgICAqL1xuICAgIHB1YmxpYyBqYXJTdGFydE9wdGlvbnM6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBqZGs6IERlcGxveW1lbnQgb2YgSkRLIHZlcnNpb24gb2YgdGhlIHBhY2thZ2UgZGVwZW5kcyBvbi4gTWlycm9yaW5nIG5vdCBzdXBwb3J0ZWQuXG4gICAgICovXG4gICAgcHVibGljIGpkazogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGxpdmVuZXNzOiBDb250YWluZXIgaGVhbHRoIGNoZWNrLCBoZWFsdGggY2hlY2sgZmFpbHMgY29udGFpbmVyIHdpbGwgYmUga2lsbGVkIGFuZCByZWNvdmVyeS4gQ3VycmVudGx5IG9ubHkgc3VwcG9ydHMgbW9kZSBjb21tYW5kIGlzc3VlZCBpbiB0aGUgY29udGFpbmVyLiBUaGUgY29sdW1uczogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogWyBcInNsZWVwXCIsIFwiNXNcIl19LCBcImluaXRpYWxEZWxheVNlY29uZHNcIjogMTAsIFwidGltZW91dFNlY29uZHNcIjogMTF9XG4gICAgICovXG4gICAgcHVibGljIGxpdmVuZXNzOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbW91bnREZXNjOiBNb3VudCBEZXNjcmlwdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBtb3VudERlc2M6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBtb3VudEhvc3Q6IG5hcyBtb3VudCBwb2ludCBpbiB0aGUgYXBwbGljYXRpb24gb2YgdnBjLlxuICAgICAqL1xuICAgIHB1YmxpYyBtb3VudEhvc3Q6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuYXNJZDogTW91bnQgdGhlIE5BUyBJRCwgeW91IG11c3QgYmUgaW4gdGhlIHNhbWUgcmVnaW9uIGFuZCBjbHVzdGVyLiBJdCBtdXN0IGJlIGF2YWlsYWJsZSB0byBjcmVhdGUgYSBtb3VudCBwb2ludCBsaW1pdCwgb3Igc3dpdGNoIG9uIGl0cyBtb3VudCBwb2ludCBhbHJlYWR5IGluIHRoZSBWUEMuIElmIHlvdSBkbyBub3QgZmlsbCwgYW5kIHRoZXJlIG1vdW50RGVzY3MgZmllbGQsIHRoZSBkZWZhdWx0IHdpbGwgYXV0b21hdGljYWxseSBwdXJjaGFzZSBhIE5BUyBhbmQgbW91bnQgaXQgb250byB0aGUgc3dpdGNoIHdpdGhpbiB0aGUgVlBDLlxuICAgICAqL1xuICAgIHB1YmxpYyBuYXNJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBhY2thZ2VVcmw6IERlcGxveW1lbnQgcGFja2FnZXMgYWRkcmVzcy4gT25seSBGYXRKYXIgV2FyIG9yIHRoZSB0eXBlIG9mIGFwcGxpY2F0aW9uIGNhbiBiZSBjb25maWd1cmVkIHRvIGRlcGxveSBwYWNrZXQgYWRkcmVzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcGFja2FnZVVybDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBhY2thZ2VWZXJzaW9uOiBUaGUgdmVyc2lvbiBudW1iZXIgb2YgdGhlIGRlcGxveWVkIHBhY2thZ2UsIFdhciBGYXRKYXIgdHlwZSByZXF1aXJlZC4gUGxlYXNlIGN1c3RvbWl6ZSBpdCBtZWFuaW5nLlxuICAgICAqL1xuICAgIHB1YmxpYyBwYWNrYWdlVmVyc2lvbjogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHBvc3RTdGFydDogRXhlY3V0aW5nIHRoZSBzY3JpcHQsIHN1Y2ggYXMgYWZ0ZXIgc3RhcnRpbmcgdGhlIGZvcm1hdDogeyBcImV4ZWNcIjogeyBcImNvbW1hbmRcIjogXCJjYXRcIiwgXCJcXC8gZXRjIFxcLyBncm91cFwifX1cbiAgICAgKi9cbiAgICBwdWJsaWMgcG9zdFN0YXJ0OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcHJlU3RvcDogU2NyaXB0IGlzIGV4ZWN1dGVkIGJlZm9yZSBzdG9wcGluZyB0aGUgZm9ybWF0IGFzOiB7IFwiZXhlY1wiOiB7IFwiY29tbWFuZFwiOiBcImNhdFwiLCBcIlxcLyBldGMgXFwvIGdyb3VwXCJ9fVxuICAgICAqL1xuICAgIHB1YmxpYyBwcmVTdG9wOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVhZGluZXNzOiBBcHBsaWNhdGlvbiBsYXVuY2ggc3RhdHVzIGNoZWNrLCBoZWFsdGggY2hlY2sgZmFpbHMgcmVwZWF0ZWRseSBjb250YWluZXIgd2lsbCBiZSBraWxsZWQgYW5kIHJlc3RhcnRlZC4gRG8gbm90IHBhc3MgaGVhbHRoIGNoZWNrIG9mIHRoZSB2ZXNzZWwgd2lsbCBub3QgaGF2ZSB0byBlbnRlciBTTEIgdHJhZmZpYy4gRm9yIGV4YW1wbGU6IHsgXCJleGVjXCI6IHsgXCJjb21tYW5kXCI6IFsgXCJzbGVlcFwiLCBcIjZzXCJdfSwgXCJpbml0aWFsRGVsYXlTZWNvbmRzXCI6IDE1LCBcInRpbWVvdXRTZWNvbmRzXCI6IDEyfVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkaW5lc3M6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzZWN1cml0eUdyb3VwSWQ6IFNlY3VyaXR5IGdyb3VwIElELlxuICAgICAqL1xuICAgIHB1YmxpYyBzZWN1cml0eUdyb3VwSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBzbHNDb25maWdzOiBMb2cgY29sbGVjdGlvbiBjb25maWd1cmF0aW9uIGZpbGVcbiAgICAgKi9cbiAgICBwdWJsaWMgc2xzQ29uZmlnczogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRhZ3M6IFRhZ3MgdG8gYXR0YWNoIHRvIGFwcGxpY2F0aW9uLiBNYXggc3VwcG9ydCAyMCB0YWdzIHRvIGFkZCBkdXJpbmcgY3JlYXRlIGFwcGxpY2F0aW9uLiBFYWNoIHRhZyB3aXRoIHR3byBwcm9wZXJ0aWVzIEtleSBhbmQgVmFsdWUsIGFuZCBLZXkgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcHVibGljIHRhZ3M6IFJvc0FwcGxpY2F0aW9uLlRhZ3NQcm9wZXJ0eVtdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRpbWV6b25lOiBBcHBsaWNhdGlvbiB0aW1lIHpvbmUuIERlZmF1bHQgQXNpYVxcL1NoYW5naGFpLlxuICAgICAqL1xuICAgIHB1YmxpYyB0aW1lem9uZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZwY0lkOiBFREFTIG5hbWVzcGFjZSBjb3JyZXNwb25kaW5nIFZQQy4gSW4gU2VydmVybGVzcyBpbiBhIGNvcnJlc3BvbmRpbmcgb25lIG9mIHRoZSBWUEMgbmFtZXNwYWNlIG9ubHksIGFuZCBjYW4gbm90IGJlIG1vZGlmaWVkLiBTZXJ2ZXJsZXNzIGZpcnN0IGNyZWF0ZWQgaW4gdGhlIGFwcGxpY2F0aW9uIG5hbWUgc3BhY2Ugd2lsbCBmb3JtIGEgYmluZGluZyByZWxhdGlvbnNoaXAuIFlvdSBtYXkgY29ycmVzcG9uZCB0byBhIHBsdXJhbGl0eSBvZiBuYW1lc3BhY2VzIFZQQy4gRG8gbm90IGZpbGwgd2FzIFZwY0lkIG5hbWVzcGFjZSBiaW5kaW5nLlxuICAgICAqL1xuICAgIHB1YmxpYyB2cGNJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHZTd2l0Y2hJZDogQXBwbGljYXRpb24gZXhhbXBsZXMgd2hlcmUgdGhlIGVsYXN0aWMgY2FyZCB2aXJ0dWFsIHN3aXRjaC4gVGhlIHN3aXRjaCBtdXN0IGJlIGxvY2F0ZWQgYWJvdmUgdGhlIFZQQy4gVGhlIHNhbWUgc3dpdGNoIHdpdGggRURBUyBuYW1lc3BhY2UgYmluZGluZyByZWxhdGlvbnNoaXAuIERvIG5vdCBmaWxsIHdhcyBWU3dpdGNoSWQgbmFtZXNwYWNlIGJpbmRpbmcuXG4gICAgICovXG4gICAgcHVibGljIHZTd2l0Y2hJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHdhclN0YXJ0T3B0aW9uczogV2FyIFN0YXJ0IHRoZSBhcHBsaWNhdGlvbiBwYWNrYWdlIG9wdGlvbi4gQXBwbHkgdGhlIGRlZmF1bHQgc3RhcnR1cCBjb21tYW5kOiBqYXZhICQgSkFWQV9PUFRTICQgQ0FUQUxJTkFfT1BUUyAtT3B0aW9ucyBvcmcuYXBhY2hlLmNhdGFsaW5hLnN0YXJ0dXAuQm9vdHN0cmFwIFwiJCBAXCIgc3RhcnRcbiAgICAgKi9cbiAgICBwdWJsaWMgd2FyU3RhcnRPcHRpb25zOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgd2ViQ29udGFpbmVyOiBUb21jYXQgZGVwbG95bWVudCBvZiB0aGUgcGFja2FnZSBkZXBlbmRzIG9uIHRoZSB2ZXJzaW9uLiBNaXJyb3Jpbmcgbm90IHN1cHBvcnRlZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgd2ViQ29udGFpbmVyOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9zQXBwbGljYXRpb25Qcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc0FwcGxpY2F0aW9uLlJPU19SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICB0aGlzLmF0dHJBcHBJZCA9IHRoaXMuZ2V0QXR0KCdBcHBJZCcpO1xuICAgICAgICB0aGlzLmF0dHJDaGFuZ2VPcmRlcklkID0gdGhpcy5nZXRBdHQoJ0NoYW5nZU9yZGVySWQnKTtcblxuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XG4gICAgICAgIHRoaXMuYXBwTmFtZSA9IHByb3BzLmFwcE5hbWU7XG4gICAgICAgIHRoaXMuY3B1ID0gcHJvcHMuY3B1O1xuICAgICAgICB0aGlzLm1lbW9yeSA9IHByb3BzLm1lbW9yeTtcbiAgICAgICAgdGhpcy5uYW1lc3BhY2VJZCA9IHByb3BzLm5hbWVzcGFjZUlkO1xuICAgICAgICB0aGlzLnBhY2thZ2VUeXBlID0gcHJvcHMucGFja2FnZVR5cGU7XG4gICAgICAgIHRoaXMucmVwbGljYXMgPSBwcm9wcy5yZXBsaWNhcztcbiAgICAgICAgdGhpcy5hcHBEZXNjcmlwdGlvbiA9IHByb3BzLmFwcERlc2NyaXB0aW9uO1xuICAgICAgICB0aGlzLmNvbW1hbmQgPSBwcm9wcy5jb21tYW5kO1xuICAgICAgICB0aGlzLmNvbW1hbmRBcmdzID0gcHJvcHMuY29tbWFuZEFyZ3M7XG4gICAgICAgIHRoaXMuY3VzdG9tSG9zdEFsaWFzID0gcHJvcHMuY3VzdG9tSG9zdEFsaWFzO1xuICAgICAgICB0aGlzLmRlcGxveSA9IHByb3BzLmRlcGxveTtcbiAgICAgICAgdGhpcy5lZGFzQ29udGFpbmVyVmVyc2lvbiA9IHByb3BzLmVkYXNDb250YWluZXJWZXJzaW9uO1xuICAgICAgICB0aGlzLmVudnMgPSBwcm9wcy5lbnZzO1xuICAgICAgICB0aGlzLmltYWdlVXJsID0gcHJvcHMuaW1hZ2VVcmw7XG4gICAgICAgIHRoaXMuamFyU3RhcnRBcmdzID0gcHJvcHMuamFyU3RhcnRBcmdzO1xuICAgICAgICB0aGlzLmphclN0YXJ0T3B0aW9ucyA9IHByb3BzLmphclN0YXJ0T3B0aW9ucztcbiAgICAgICAgdGhpcy5qZGsgPSBwcm9wcy5qZGs7XG4gICAgICAgIHRoaXMubGl2ZW5lc3MgPSBwcm9wcy5saXZlbmVzcztcbiAgICAgICAgdGhpcy5tb3VudERlc2MgPSBwcm9wcy5tb3VudERlc2M7XG4gICAgICAgIHRoaXMubW91bnRIb3N0ID0gcHJvcHMubW91bnRIb3N0O1xuICAgICAgICB0aGlzLm5hc0lkID0gcHJvcHMubmFzSWQ7XG4gICAgICAgIHRoaXMucGFja2FnZVVybCA9IHByb3BzLnBhY2thZ2VVcmw7XG4gICAgICAgIHRoaXMucGFja2FnZVZlcnNpb24gPSBwcm9wcy5wYWNrYWdlVmVyc2lvbjtcbiAgICAgICAgdGhpcy5wb3N0U3RhcnQgPSBwcm9wcy5wb3N0U3RhcnQ7XG4gICAgICAgIHRoaXMucHJlU3RvcCA9IHByb3BzLnByZVN0b3A7XG4gICAgICAgIHRoaXMucmVhZGluZXNzID0gcHJvcHMucmVhZGluZXNzO1xuICAgICAgICB0aGlzLnNlY3VyaXR5R3JvdXBJZCA9IHByb3BzLnNlY3VyaXR5R3JvdXBJZDtcbiAgICAgICAgdGhpcy5zbHNDb25maWdzID0gcHJvcHMuc2xzQ29uZmlncztcbiAgICAgICAgdGhpcy50YWdzID0gcHJvcHMudGFncztcbiAgICAgICAgdGhpcy50aW1lem9uZSA9IHByb3BzLnRpbWV6b25lO1xuICAgICAgICB0aGlzLnZwY0lkID0gcHJvcHMudnBjSWQ7XG4gICAgICAgIHRoaXMudlN3aXRjaElkID0gcHJvcHMudlN3aXRjaElkO1xuICAgICAgICB0aGlzLndhclN0YXJ0T3B0aW9ucyA9IHByb3BzLndhclN0YXJ0T3B0aW9ucztcbiAgICAgICAgdGhpcy53ZWJDb250YWluZXIgPSBwcm9wcy53ZWJDb250YWluZXI7XG4gICAgfVxuXG5cbiAgICBwcm90ZWN0ZWQgZ2V0IHJvc1Byb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgYXBwTmFtZTogdGhpcy5hcHBOYW1lLFxuICAgICAgICAgICAgY3B1OiB0aGlzLmNwdSxcbiAgICAgICAgICAgIG1lbW9yeTogdGhpcy5tZW1vcnksXG4gICAgICAgICAgICBuYW1lc3BhY2VJZDogdGhpcy5uYW1lc3BhY2VJZCxcbiAgICAgICAgICAgIHBhY2thZ2VUeXBlOiB0aGlzLnBhY2thZ2VUeXBlLFxuICAgICAgICAgICAgcmVwbGljYXM6IHRoaXMucmVwbGljYXMsXG4gICAgICAgICAgICBhcHBEZXNjcmlwdGlvbjogdGhpcy5hcHBEZXNjcmlwdGlvbixcbiAgICAgICAgICAgIGNvbW1hbmQ6IHRoaXMuY29tbWFuZCxcbiAgICAgICAgICAgIGNvbW1hbmRBcmdzOiB0aGlzLmNvbW1hbmRBcmdzLFxuICAgICAgICAgICAgY3VzdG9tSG9zdEFsaWFzOiB0aGlzLmN1c3RvbUhvc3RBbGlhcyxcbiAgICAgICAgICAgIGRlcGxveTogdGhpcy5kZXBsb3ksXG4gICAgICAgICAgICBlZGFzQ29udGFpbmVyVmVyc2lvbjogdGhpcy5lZGFzQ29udGFpbmVyVmVyc2lvbixcbiAgICAgICAgICAgIGVudnM6IHRoaXMuZW52cyxcbiAgICAgICAgICAgIGltYWdlVXJsOiB0aGlzLmltYWdlVXJsLFxuICAgICAgICAgICAgamFyU3RhcnRBcmdzOiB0aGlzLmphclN0YXJ0QXJncyxcbiAgICAgICAgICAgIGphclN0YXJ0T3B0aW9uczogdGhpcy5qYXJTdGFydE9wdGlvbnMsXG4gICAgICAgICAgICBqZGs6IHRoaXMuamRrLFxuICAgICAgICAgICAgbGl2ZW5lc3M6IHRoaXMubGl2ZW5lc3MsXG4gICAgICAgICAgICBtb3VudERlc2M6IHRoaXMubW91bnREZXNjLFxuICAgICAgICAgICAgbW91bnRIb3N0OiB0aGlzLm1vdW50SG9zdCxcbiAgICAgICAgICAgIG5hc0lkOiB0aGlzLm5hc0lkLFxuICAgICAgICAgICAgcGFja2FnZVVybDogdGhpcy5wYWNrYWdlVXJsLFxuICAgICAgICAgICAgcGFja2FnZVZlcnNpb246IHRoaXMucGFja2FnZVZlcnNpb24sXG4gICAgICAgICAgICBwb3N0U3RhcnQ6IHRoaXMucG9zdFN0YXJ0LFxuICAgICAgICAgICAgcHJlU3RvcDogdGhpcy5wcmVTdG9wLFxuICAgICAgICAgICAgcmVhZGluZXNzOiB0aGlzLnJlYWRpbmVzcyxcbiAgICAgICAgICAgIHNlY3VyaXR5R3JvdXBJZDogdGhpcy5zZWN1cml0eUdyb3VwSWQsXG4gICAgICAgICAgICBzbHNDb25maWdzOiB0aGlzLnNsc0NvbmZpZ3MsXG4gICAgICAgICAgICB0YWdzOiB0aGlzLnRhZ3MsXG4gICAgICAgICAgICB0aW1lem9uZTogdGhpcy50aW1lem9uZSxcbiAgICAgICAgICAgIHZwY0lkOiB0aGlzLnZwY0lkLFxuICAgICAgICAgICAgdlN3aXRjaElkOiB0aGlzLnZTd2l0Y2hJZCxcbiAgICAgICAgICAgIHdhclN0YXJ0T3B0aW9uczogdGhpcy53YXJTdGFydE9wdGlvbnMsXG4gICAgICAgICAgICB3ZWJDb250YWluZXI6IHRoaXMud2ViQ29udGFpbmVyLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiByb3NBcHBsaWNhdGlvblByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wcywgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgfVxufVxuXG5leHBvcnQgbmFtZXNwYWNlIFJvc0FwcGxpY2F0aW9uIHtcbiAgICAvKipcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBUYWdzUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IHZhbHVlOiB1bmRlZmluZWRcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZhbHVlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogQFByb3BlcnR5IGtleTogdW5kZWZpbmVkXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBrZXk6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbiAgICB9XG59XG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFRhZ3NQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVGFnc1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0FwcGxpY2F0aW9uX1RhZ3NQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3ZhbHVlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZhbHVlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdrZXknLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMua2V5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdrZXknLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMua2V5KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlRhZ3NQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6U0FFOjpBcHBsaWNhdGlvbi5UYWdzYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBUYWdzUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6QXBwbGljYXRpb24uVGFnc2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiByb3NBcHBsaWNhdGlvblRhZ3NQcm9wZXJ0eVRvUm9zVGVtcGxhdGUocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgUm9zQXBwbGljYXRpb25fVGFnc1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgVmFsdWU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudmFsdWUpLFxuICAgICAgS2V5OiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmtleSksXG4gICAgfTtcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBSb3NOYW1lc3BhY2VgLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tc2FlLW5hbWVzcGFjZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJvc05hbWVzcGFjZVByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBuYW1lc3BhY2VJZDogTmFtZXNwYWNlIElELiBGb3JtYXQ6IFwicmVnaW9uSWQ6bG9naWNhbElkXCIgb3IgXCJsb2dpY2FsSWRcIlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWVzcGFjZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbmFtZXNwYWNlTmFtZTogTmFtZXNwYWNlIG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBuYW1lc3BhY2VOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbmFtZXNwYWNlRGVzY3JpcHRpb246IE5hbWVzcGFjZSBkZXNjcmlwdGlvblxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hbWVzcGFjZURlc2NyaXB0aW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFJvc05hbWVzcGFjZVByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NOYW1lc3BhY2VQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBSb3NOYW1lc3BhY2VQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiByb3MuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFyb3MuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcm9zLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyByb3MuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZU5hbWUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMubmFtZXNwYWNlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZXNwYWNlTmFtZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5uYW1lc3BhY2VOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCduYW1lc3BhY2VJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5uYW1lc3BhY2VJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignbmFtZXNwYWNlSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubmFtZXNwYWNlSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ25hbWVzcGFjZURlc2NyaXB0aW9uJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm5hbWVzcGFjZURlc2NyaXB0aW9uKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc05hbWVzcGFjZVByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpTQUU6Ok5hbWVzcGFjZWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zTmFtZXNwYWNlUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6TmFtZXNwYWNlYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIHJvc05hbWVzcGFjZVByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnksIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcbiAgICAgICAgUm9zTmFtZXNwYWNlUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgTmFtZXNwYWNlSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMubmFtZXNwYWNlSWQpLFxuICAgICAgTmFtZXNwYWNlTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5uYW1lc3BhY2VOYW1lKSxcbiAgICAgIE5hbWVzcGFjZURlc2NyaXB0aW9uOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLm5hbWVzcGFjZURlc2NyaXB0aW9uKSxcbiAgICB9O1xufVxuXG4vKipcbiAqIFRoaXMgY2xhc3MgaXMgYSBiYXNlIGVuY2Fwc3VsYXRpb24gYXJvdW5kIHRoZSBST1MgcmVzb3VyY2UgdHlwZSBgQUxJWVVOOjpTQUU6Ok5hbWVzcGFjZWAsIHdoaWNoIGlzIHVzZWQgdG8gY3JlYXRlIGEgTmFtZXNwYWNlLlxuICogQE5vdGUgVGhpcyBjbGFzcyBkb2VzIG5vdCBjb250YWluIGFkZGl0aW9uYWwgZnVuY3Rpb25zLCBzbyBpdCBpcyByZWNvbW1lbmRlZCB0byB1c2UgdGhlIGBOYW1lc3BhY2VgIGNsYXNzIGluc3RlYWQgb2YgdGhpcyBjbGFzcyBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLXNhZS1uYW1lc3BhY2VcbiAqL1xuZXhwb3J0IGNsYXNzIFJvc05hbWVzcGFjZSBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6U0FFOjpOYW1lc3BhY2VcIjtcblxuICAgIC8qKlxuICAgICAqIEBBdHRyaWJ1dGUgTmFtZXNwYWNlSWQ6IE5hbWVzcGFjZSBJRFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyTmFtZXNwYWNlSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIHB1YmxpYyBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbjtcblxuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IG5hbWVzcGFjZUlkOiBOYW1lc3BhY2UgSUQuIEZvcm1hdDogXCJyZWdpb25JZDpsb2dpY2FsSWRcIiBvciBcImxvZ2ljYWxJZFwiXG4gICAgICovXG4gICAgcHVibGljIG5hbWVzcGFjZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgbmFtZXNwYWNlTmFtZTogTmFtZXNwYWNlIG5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZXNwYWNlTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IG5hbWVzcGFjZURlc2NyaXB0aW9uOiBOYW1lc3BhY2UgZGVzY3JpcHRpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgbmFtZXNwYWNlRGVzY3JpcHRpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSb3NOYW1lc3BhY2VQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc05hbWVzcGFjZS5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgdGhpcy5hdHRyTmFtZXNwYWNlSWQgPSB0aGlzLmdldEF0dCgnTmFtZXNwYWNlSWQnKTtcblxuICAgICAgICB0aGlzLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50ID0gZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ7XG4gICAgICAgIHRoaXMubmFtZXNwYWNlSWQgPSBwcm9wcy5uYW1lc3BhY2VJZDtcbiAgICAgICAgdGhpcy5uYW1lc3BhY2VOYW1lID0gcHJvcHMubmFtZXNwYWNlTmFtZTtcbiAgICAgICAgdGhpcy5uYW1lc3BhY2VEZXNjcmlwdGlvbiA9IHByb3BzLm5hbWVzcGFjZURlc2NyaXB0aW9uO1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZUlkOiB0aGlzLm5hbWVzcGFjZUlkLFxuICAgICAgICAgICAgbmFtZXNwYWNlTmFtZTogdGhpcy5uYW1lc3BhY2VOYW1lLFxuICAgICAgICAgICAgbmFtZXNwYWNlRGVzY3JpcHRpb246IHRoaXMubmFtZXNwYWNlRGVzY3JpcHRpb24sXG4gICAgICAgIH07XG4gICAgfVxuICAgIHByb3RlY3RlZCByZW5kZXJQcm9wZXJ0aWVzKHByb3BzOiB7W2tleTogc3RyaW5nXTogYW55fSk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHJvc05hbWVzcGFjZVByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wcywgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgfVxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYFJvc1NsYkJpbmRpbmdgLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tc2FlLXNsYmJpbmRpbmdcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSb3NTbGJCaW5kaW5nUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGFwcElkOiBTdWNjZXNzZnVsIGFwcGxpY2F0aW9uIGRlcGxveW1lbnQgdGFyZ2V0IElEXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXBwSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpbnRlcm5ldDogQmluZGluZyBwdWJsaWMgU0xCLiBGb3IgZXhhbXBsZTogW3sgXCJwb3J0XCI6IDgwLCBcInRhcmdldFBvcnRcIjogODA4MCwgXCJwcm90b2NvbFwiOiBcIlRDUFwifV0sIHNob3dzIGEgY29udGFpbmVyIHBvcnQgODA4MCB0aHJvdWdoIHBvcnQgODAgc2xiIGV4cG9zZWQgc2VydmljZSwgdGhlIHByb3RvY29sIGlzIFRDUCwgdGhlIGJsYW5rIGlzIGlnbm9yZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW50ZXJuZXQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaW50ZXJuZXRTbGJJZDogVXNlIFNMQiBwdXJjaGFzZWQgc3BlY2lmaWVkLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBub24tc2hhcmVkIGV4YW1wbGVzXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW50ZXJuZXRTbGJJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpbnRyYW5ldDogQmluZCBwcml2YXRlIFNMQi4gRm9yIGV4YW1wbGU6IFt7IFwicG9ydFwiOiA4MCwgXCJ0YXJnZXRQb3J0XCI6IDgwODAsIFwicHJvdG9jb2xcIjogXCJUQ1BcIn1dLCBzaG93cyBhIGNvbnRhaW5lciBwb3J0IDgwODAgdGhyb3VnaCBwb3J0IDgwIHNsYiBleHBvc2VkIHNlcnZpY2UsIHRoZSBwcm90b2NvbCBpcyBUQ1AsIHRoZSBibGFuayBpcyBpZ25vcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGludHJhbmV0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGludHJhbmV0U2xiSWQ6IFVzZSBTTEIgcHVyY2hhc2VkIHNwZWNpZmllZCwgY3VycmVudGx5IG9ubHkgc3VwcG9ydHMgbm9uLXNoYXJlZCBleGFtcGxlc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGludHJhbmV0U2xiSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zU2xiQmluZGluZ1Byb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NTbGJCaW5kaW5nUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gUm9zU2xiQmluZGluZ1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW50ZXJuZXRTbGJJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5pbnRlcm5ldFNsYklkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdhcHBJZCcsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5hcHBJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYXBwSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYXBwSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ludHJhbmV0Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmludHJhbmV0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdpbnRyYW5ldFNsYklkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmludHJhbmV0U2xiSWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2ludGVybmV0Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmludGVybmV0KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlJvc1NsYkJpbmRpbmdQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6U0FFOjpTbGJCaW5kaW5nYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NTbGJCaW5kaW5nUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBwcm9wZXJ0aWVzIG9mIGFuIGBBTElZVU46OlNBRTo6U2xiQmluZGluZ2AgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiByb3NTbGJCaW5kaW5nUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBpZihlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCkge1xuICAgICAgICBSb3NTbGJCaW5kaW5nUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgQXBwSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuYXBwSWQpLFxuICAgICAgSW50ZXJuZXQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaW50ZXJuZXQpLFxuICAgICAgSW50ZXJuZXRTbGJJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5pbnRlcm5ldFNsYklkKSxcbiAgICAgIEludHJhbmV0OiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmludHJhbmV0KSxcbiAgICAgIEludHJhbmV0U2xiSWQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuaW50cmFuZXRTbGJJZCksXG4gICAgfTtcbn1cblxuLyoqXG4gKiBUaGlzIGNsYXNzIGlzIGEgYmFzZSBlbmNhcHN1bGF0aW9uIGFyb3VuZCB0aGUgUk9TIHJlc291cmNlIHR5cGUgYEFMSVlVTjo6U0FFOjpTbGJCaW5kaW5nYCwgd2hpY2ggaXMgdXNlZCB0byBiaW5kIGFuIFNMQiBpbnN0YW5jZSB0byBhbiBhcHBsaWNhdGlvbi5cbiAqIEBOb3RlIFRoaXMgY2xhc3MgZG9lcyBub3QgY29udGFpbiBhZGRpdGlvbmFsIGZ1bmN0aW9ucywgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoZSBgU2xiQmluZGluZ2AgY2xhc3MgaW5zdGVhZCBvZiB0aGlzIGNsYXNzIGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tc2FlLXNsYmJpbmRpbmdcbiAqL1xuZXhwb3J0IGNsYXNzIFJvc1NsYkJpbmRpbmcgZXh0ZW5kcyByb3MuUm9zUmVzb3VyY2Uge1xuICAgIC8qKlxuICAgICAqIFRoZSByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBST1NfUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBTElZVU46OlNBRTo6U2xiQmluZGluZ1wiO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBBcHBJZDogU3VjY2Vzc2Z1bCBhcHBsaWNhdGlvbiBkZXBsb3ltZW50IHRhcmdldCBJRFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQXBwSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBBdHRyaWJ1dGUgQ2hhbmdlT3JkZXJJZDogUmV0dXJuIHRvIHJlbGVhc2UgYSBzaW5nbGUgSUQsIHVzZWQgdG8gcXVlcnkgdGFzayBleGVjdXRpb24gc3RhdHVzLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQ2hhbmdlT3JkZXJJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgcHVibGljIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYXBwSWQ6IFN1Y2Nlc3NmdWwgYXBwbGljYXRpb24gZGVwbG95bWVudCB0YXJnZXQgSURcbiAgICAgKi9cbiAgICBwdWJsaWMgYXBwSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpbnRlcm5ldDogQmluZGluZyBwdWJsaWMgU0xCLiBGb3IgZXhhbXBsZTogW3sgXCJwb3J0XCI6IDgwLCBcInRhcmdldFBvcnRcIjogODA4MCwgXCJwcm90b2NvbFwiOiBcIlRDUFwifV0sIHNob3dzIGEgY29udGFpbmVyIHBvcnQgODA4MCB0aHJvdWdoIHBvcnQgODAgc2xiIGV4cG9zZWQgc2VydmljZSwgdGhlIHByb3RvY29sIGlzIFRDUCwgdGhlIGJsYW5rIGlzIGlnbm9yZWQuXG4gICAgICovXG4gICAgcHVibGljIGludGVybmV0OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgaW50ZXJuZXRTbGJJZDogVXNlIFNMQiBwdXJjaGFzZWQgc3BlY2lmaWVkLCBjdXJyZW50bHkgb25seSBzdXBwb3J0cyBub24tc2hhcmVkIGV4YW1wbGVzXG4gICAgICovXG4gICAgcHVibGljIGludGVybmV0U2xiSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBpbnRyYW5ldDogQmluZCBwcml2YXRlIFNMQi4gRm9yIGV4YW1wbGU6IFt7IFwicG9ydFwiOiA4MCwgXCJ0YXJnZXRQb3J0XCI6IDgwODAsIFwicHJvdG9jb2xcIjogXCJUQ1BcIn1dLCBzaG93cyBhIGNvbnRhaW5lciBwb3J0IDgwODAgdGhyb3VnaCBwb3J0IDgwIHNsYiBleHBvc2VkIHNlcnZpY2UsIHRoZSBwcm90b2NvbCBpcyBUQ1AsIHRoZSBibGFuayBpcyBpZ25vcmVkLlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnRyYW5ldDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGludHJhbmV0U2xiSWQ6IFVzZSBTTEIgcHVyY2hhc2VkIHNwZWNpZmllZCwgY3VycmVudGx5IG9ubHkgc3VwcG9ydHMgbm9uLXNoYXJlZCBleGFtcGxlc1xuICAgICAqL1xuICAgIHB1YmxpYyBpbnRyYW5ldFNsYklkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9zU2xiQmluZGluZ1Byb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDogYm9vbGVhbikge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogUm9zU2xiQmluZGluZy5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgdGhpcy5hdHRyQXBwSWQgPSB0aGlzLmdldEF0dCgnQXBwSWQnKTtcbiAgICAgICAgdGhpcy5hdHRyQ2hhbmdlT3JkZXJJZCA9IHRoaXMuZ2V0QXR0KCdDaGFuZ2VPcmRlcklkJyk7XG5cbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuICAgICAgICB0aGlzLmFwcElkID0gcHJvcHMuYXBwSWQ7XG4gICAgICAgIHRoaXMuaW50ZXJuZXQgPSBwcm9wcy5pbnRlcm5ldDtcbiAgICAgICAgdGhpcy5pbnRlcm5ldFNsYklkID0gcHJvcHMuaW50ZXJuZXRTbGJJZDtcbiAgICAgICAgdGhpcy5pbnRyYW5ldCA9IHByb3BzLmludHJhbmV0O1xuICAgICAgICB0aGlzLmludHJhbmV0U2xiSWQgPSBwcm9wcy5pbnRyYW5ldFNsYklkO1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFwcElkOiB0aGlzLmFwcElkLFxuICAgICAgICAgICAgaW50ZXJuZXQ6IHRoaXMuaW50ZXJuZXQsXG4gICAgICAgICAgICBpbnRlcm5ldFNsYklkOiB0aGlzLmludGVybmV0U2xiSWQsXG4gICAgICAgICAgICBpbnRyYW5ldDogdGhpcy5pbnRyYW5ldCxcbiAgICAgICAgICAgIGludHJhbmV0U2xiSWQ6IHRoaXMuaW50cmFuZXRTbGJJZCxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gcm9zU2xiQmluZGluZ1Byb3BzVG9Sb3NUZW1wbGF0ZShwcm9wcywgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgfVxufVxuIl19