"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Application = exports.ApplicationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const sae_generated_1 = require("./sae.generated");
Object.defineProperty(exports, "ApplicationProperty", { enumerable: true, get: function () { return sae_generated_1.RosApplication; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::SAE::Application`, which is used to create an application in Serverless App Engine (SAE).
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosApplication`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-sae-application
 */
class Application extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosApplication = new sae_generated_1.RosApplication(this, id, {
            timezone: props.timezone,
            appDescription: props.appDescription,
            mountDesc: props.mountDesc,
            nasId: props.nasId,
            warStartOptions: props.warStartOptions,
            liveness: props.liveness,
            memory: props.memory,
            webContainer: props.webContainer,
            slsConfigs: props.slsConfigs,
            cpu: props.cpu,
            deploy: props.deploy,
            packageVersion: props.packageVersion,
            appName: props.appName,
            jdk: props.jdk,
            jarStartArgs: props.jarStartArgs,
            preStop: props.preStop,
            readiness: props.readiness,
            packageType: props.packageType,
            tags: props.tags,
            commandArgs: props.commandArgs,
            securityGroupId: props.securityGroupId,
            envs: props.envs,
            vSwitchId: props.vSwitchId,
            imageUrl: props.imageUrl,
            postStart: props.postStart,
            jarStartOptions: props.jarStartOptions,
            mountHost: props.mountHost,
            replicas: props.replicas,
            customHostAlias: props.customHostAlias,
            vpcId: props.vpcId,
            command: props.command,
            edasContainerVersion: props.edasContainerVersion,
            packageUrl: props.packageUrl,
            namespaceId: props.namespaceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApplication;
        this.attrAppId = rosApplication.attrAppId;
        this.attrChangeOrderId = rosApplication.attrChangeOrderId;
    }
}
exports.Application = Application;
//# sourceMappingURL=data:application/json;base64,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