# -*- coding: utf-8 -*-
# code generated by Prisma. DO NOT EDIT.
# pylint: disable=all
# pyright: reportUnusedImport=false
# fmt: off

# global imports for type checking
import sys
import datetime
from typing import (
    TYPE_CHECKING,
    Optional,
    Iterable,
    Iterator,
    Mapping,
    Tuple,
    Union,
    List,
    Dict,
    Type,
    Any,
    Set,
    overload,
    cast,
)

if sys.version_info >= (3, 8):
    from typing import TypedDict, Literal
else:
    from typing_extensions import TypedDict, Literal

# -- template models.py.jinja --
import os
from pydantic import BaseConfig, BaseModel, Field

from . import types, enums, errors
from .generator import partial_models_ctx, PartialModelField


class Config(BaseConfig):
    use_enum_values: bool = True
    allow_population_by_field_name: bool = True


_created_partial_types: Set[str] = set()


class Post(BaseModel):
    id: str
    created_at: datetime.datetime
    updated_at: datetime.datetime
    title: str
    published: bool
    views: int
    desc: Optional[str]
    author: Optional['models.User']
    author_id: Optional[str]
    categories: Optional[List['models.Category']]

    Config = Config

    @staticmethod
    def create_partial(
        name: str,
        include: Optional[Iterable['types.PostKeys']] = None,
        exclude: Optional[Iterable['types.PostKeys']] = None,
        required: Optional[Iterable['types.PostKeys']] = None,
        optional: Optional[Iterable['types.PostKeys']] = None,
        relations: Optional[Mapping['types.PostRelationalFieldKeys', str]] = None,
    ) -> None:
        if not os.environ.get('PRISMA_GENERATOR_INVOCATION'):
            raise RuntimeError(
                'Attempted to create a partial type outside of client generation.'
            )

        if name in _created_partial_types:
            raise ValueError(f'Partial type "{name}" has already been created.')

        if include is not None and exclude is not None:
            raise TypeError(f'Exclude and include are mutually exclusive.')

        if required and optional:
            shared = set(required) & set(optional)
            if shared:
                raise ValueError(f'Cannot make the same field(s) required and optional {shared}')

        fields: Dict['types.PostKeys', PartialModelField] = {}

        try:
            if include:
                for field in include:
                    fields[field] = _Post_fields[field]
            elif exclude:
                for field in exclude:
                    if field not in _Post_fields:
                        raise KeyError(field)

                fields = {
                    key: data
                    for key, data in _Post_fields.items()
                    if key not in exclude
                }
            else:
                fields = _Post_fields.copy()

            if required:
                for field in required:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = False

            if optional:
                for field in optional:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = True

            if relations:
                for field, type_ in relations.items():
                    if field not in _Post_relational_fields:
                        raise errors.UnknownRelationalFieldError('Post', field)

                    # TODO: this method of validating types is not ideal
                    # as it means we cannot two create partial types that
                    # reference each other
                    if type_ not in _created_partial_types:
                        raise ValueError(
                            f'Unknown partial type: "{type_}". '
                            f'Did you remember to generate the {type_} type before this one?'
                        )

                    # TODO: support non prisma.partials models
                    info = fields[field]
                    if info['is_list']:
                        info['type'] = f'List[\'partials.{type_}\']'
                    else:
                        info['type'] = f'\'partials.{type_}\''
        except KeyError as exc:
            raise ValueError(
                f'{exc.args[0]} is not a valid Post / {name} field.'
            ) from None

        models = partial_models_ctx.get()

        # mypy does not like this as we are assigning a
        # Dict[Literal[str]] to a Dict[str] but this is fine
        models[name] = fields  # type: ignore[assignment]
        partial_models_ctx.set(models)
        _created_partial_types.add(name)


class User(BaseModel):
    id: str
    name: str
    posts: Optional[List['models.Post']]
    profile: Optional['models.Profile']

    Config = Config

    @staticmethod
    def create_partial(
        name: str,
        include: Optional[Iterable['types.UserKeys']] = None,
        exclude: Optional[Iterable['types.UserKeys']] = None,
        required: Optional[Iterable['types.UserKeys']] = None,
        optional: Optional[Iterable['types.UserKeys']] = None,
        relations: Optional[Mapping['types.UserRelationalFieldKeys', str]] = None,
    ) -> None:
        if not os.environ.get('PRISMA_GENERATOR_INVOCATION'):
            raise RuntimeError(
                'Attempted to create a partial type outside of client generation.'
            )

        if name in _created_partial_types:
            raise ValueError(f'Partial type "{name}" has already been created.')

        if include is not None and exclude is not None:
            raise TypeError(f'Exclude and include are mutually exclusive.')

        if required and optional:
            shared = set(required) & set(optional)
            if shared:
                raise ValueError(f'Cannot make the same field(s) required and optional {shared}')

        fields: Dict['types.UserKeys', PartialModelField] = {}

        try:
            if include:
                for field in include:
                    fields[field] = _User_fields[field]
            elif exclude:
                for field in exclude:
                    if field not in _User_fields:
                        raise KeyError(field)

                fields = {
                    key: data
                    for key, data in _User_fields.items()
                    if key not in exclude
                }
            else:
                fields = _User_fields.copy()

            if required:
                for field in required:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = False

            if optional:
                for field in optional:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = True

            if relations:
                for field, type_ in relations.items():
                    if field not in _User_relational_fields:
                        raise errors.UnknownRelationalFieldError('User', field)

                    # TODO: this method of validating types is not ideal
                    # as it means we cannot two create partial types that
                    # reference each other
                    if type_ not in _created_partial_types:
                        raise ValueError(
                            f'Unknown partial type: "{type_}". '
                            f'Did you remember to generate the {type_} type before this one?'
                        )

                    # TODO: support non prisma.partials models
                    info = fields[field]
                    if info['is_list']:
                        info['type'] = f'List[\'partials.{type_}\']'
                    else:
                        info['type'] = f'\'partials.{type_}\''
        except KeyError as exc:
            raise ValueError(
                f'{exc.args[0]} is not a valid User / {name} field.'
            ) from None

        models = partial_models_ctx.get()

        # mypy does not like this as we are assigning a
        # Dict[Literal[str]] to a Dict[str] but this is fine
        models[name] = fields  # type: ignore[assignment]
        partial_models_ctx.set(models)
        _created_partial_types.add(name)


class Category(BaseModel):
    id: int
    posts: Optional[List['models.Post']]
    name: str

    Config = Config

    @staticmethod
    def create_partial(
        name: str,
        include: Optional[Iterable['types.CategoryKeys']] = None,
        exclude: Optional[Iterable['types.CategoryKeys']] = None,
        required: Optional[Iterable['types.CategoryKeys']] = None,
        optional: Optional[Iterable['types.CategoryKeys']] = None,
        relations: Optional[Mapping['types.CategoryRelationalFieldKeys', str]] = None,
    ) -> None:
        if not os.environ.get('PRISMA_GENERATOR_INVOCATION'):
            raise RuntimeError(
                'Attempted to create a partial type outside of client generation.'
            )

        if name in _created_partial_types:
            raise ValueError(f'Partial type "{name}" has already been created.')

        if include is not None and exclude is not None:
            raise TypeError(f'Exclude and include are mutually exclusive.')

        if required and optional:
            shared = set(required) & set(optional)
            if shared:
                raise ValueError(f'Cannot make the same field(s) required and optional {shared}')

        fields: Dict['types.CategoryKeys', PartialModelField] = {}

        try:
            if include:
                for field in include:
                    fields[field] = _Category_fields[field]
            elif exclude:
                for field in exclude:
                    if field not in _Category_fields:
                        raise KeyError(field)

                fields = {
                    key: data
                    for key, data in _Category_fields.items()
                    if key not in exclude
                }
            else:
                fields = _Category_fields.copy()

            if required:
                for field in required:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = False

            if optional:
                for field in optional:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = True

            if relations:
                for field, type_ in relations.items():
                    if field not in _Category_relational_fields:
                        raise errors.UnknownRelationalFieldError('Category', field)

                    # TODO: this method of validating types is not ideal
                    # as it means we cannot two create partial types that
                    # reference each other
                    if type_ not in _created_partial_types:
                        raise ValueError(
                            f'Unknown partial type: "{type_}". '
                            f'Did you remember to generate the {type_} type before this one?'
                        )

                    # TODO: support non prisma.partials models
                    info = fields[field]
                    if info['is_list']:
                        info['type'] = f'List[\'partials.{type_}\']'
                    else:
                        info['type'] = f'\'partials.{type_}\''
        except KeyError as exc:
            raise ValueError(
                f'{exc.args[0]} is not a valid Category / {name} field.'
            ) from None

        models = partial_models_ctx.get()

        # mypy does not like this as we are assigning a
        # Dict[Literal[str]] to a Dict[str] but this is fine
        models[name] = fields  # type: ignore[assignment]
        partial_models_ctx.set(models)
        _created_partial_types.add(name)


class Profile(BaseModel):
    id: int
    user: Optional['models.User']
    user_id: str
    bio: str

    Config = Config

    @staticmethod
    def create_partial(
        name: str,
        include: Optional[Iterable['types.ProfileKeys']] = None,
        exclude: Optional[Iterable['types.ProfileKeys']] = None,
        required: Optional[Iterable['types.ProfileKeys']] = None,
        optional: Optional[Iterable['types.ProfileKeys']] = None,
        relations: Optional[Mapping['types.ProfileRelationalFieldKeys', str]] = None,
    ) -> None:
        if not os.environ.get('PRISMA_GENERATOR_INVOCATION'):
            raise RuntimeError(
                'Attempted to create a partial type outside of client generation.'
            )

        if name in _created_partial_types:
            raise ValueError(f'Partial type "{name}" has already been created.')

        if include is not None and exclude is not None:
            raise TypeError(f'Exclude and include are mutually exclusive.')

        if required and optional:
            shared = set(required) & set(optional)
            if shared:
                raise ValueError(f'Cannot make the same field(s) required and optional {shared}')

        fields: Dict['types.ProfileKeys', PartialModelField] = {}

        try:
            if include:
                for field in include:
                    fields[field] = _Profile_fields[field]
            elif exclude:
                for field in exclude:
                    if field not in _Profile_fields:
                        raise KeyError(field)

                fields = {
                    key: data
                    for key, data in _Profile_fields.items()
                    if key not in exclude
                }
            else:
                fields = _Profile_fields.copy()

            if required:
                for field in required:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = False

            if optional:
                for field in optional:
                    fields[field] = fields[field].copy()
                    fields[field]['optional'] = True

            if relations:
                for field, type_ in relations.items():
                    if field not in _Profile_relational_fields:
                        raise errors.UnknownRelationalFieldError('Profile', field)

                    # TODO: this method of validating types is not ideal
                    # as it means we cannot two create partial types that
                    # reference each other
                    if type_ not in _created_partial_types:
                        raise ValueError(
                            f'Unknown partial type: "{type_}". '
                            f'Did you remember to generate the {type_} type before this one?'
                        )

                    # TODO: support non prisma.partials models
                    info = fields[field]
                    if info['is_list']:
                        info['type'] = f'List[\'partials.{type_}\']'
                    else:
                        info['type'] = f'\'partials.{type_}\''
        except KeyError as exc:
            raise ValueError(
                f'{exc.args[0]} is not a valid Profile / {name} field.'
            ) from None

        models = partial_models_ctx.get()

        # mypy does not like this as we are assigning a
        # Dict[Literal[str]] to a Dict[str] but this is fine
        models[name] = fields  # type: ignore[assignment]
        partial_models_ctx.set(models)
        _created_partial_types.add(name)



_Post_relational_fields: Set[str] = {
        'author',
        'categories',
    }
_Post_fields: Dict['types.PostKeys', PartialModelField] = {
    'id': {
        'name': 'id',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
    'created_at': {
        'name': 'created_at',
        'is_list': False,
        'optional': False,
        'type': 'datetime.datetime',
    },
    'updated_at': {
        'name': 'updated_at',
        'is_list': False,
        'optional': False,
        'type': 'datetime.datetime',
    },
    'title': {
        'name': 'title',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
    'published': {
        'name': 'published',
        'is_list': False,
        'optional': False,
        'type': 'bool',
    },
    'views': {
        'name': 'views',
        'is_list': False,
        'optional': False,
        'type': 'int',
    },
    'desc': {
        'name': 'desc',
        'is_list': False,
        'optional': True,
        'type': 'str',
    },
    'author': {
        'name': 'author',
        'is_list': False,
        'optional': True,
        'type': 'models.User',
    },
    'author_id': {
        'name': 'author_id',
        'is_list': False,
        'optional': True,
        'type': 'str',
    },
    'categories': {
        'name': 'categories',
        'is_list': True,
        'optional': True,
        'type': 'List[\'models.Category\']',
    },
}

_User_relational_fields: Set[str] = {
        'posts',
        'profile',
    }
_User_fields: Dict['types.UserKeys', PartialModelField] = {
    'id': {
        'name': 'id',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
    'name': {
        'name': 'name',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
    'posts': {
        'name': 'posts',
        'is_list': True,
        'optional': True,
        'type': 'List[\'models.Post\']',
    },
    'profile': {
        'name': 'profile',
        'is_list': False,
        'optional': True,
        'type': 'models.Profile',
    },
}

_Category_relational_fields: Set[str] = {
        'posts',
    }
_Category_fields: Dict['types.CategoryKeys', PartialModelField] = {
    'id': {
        'name': 'id',
        'is_list': False,
        'optional': False,
        'type': 'int',
    },
    'posts': {
        'name': 'posts',
        'is_list': True,
        'optional': True,
        'type': 'List[\'models.Post\']',
    },
    'name': {
        'name': 'name',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
}

_Profile_relational_fields: Set[str] = {
        'user',
    }
_Profile_fields: Dict['types.ProfileKeys', PartialModelField] = {
    'id': {
        'name': 'id',
        'is_list': False,
        'optional': False,
        'type': 'int',
    },
    'user': {
        'name': 'user',
        'is_list': False,
        'optional': True,
        'type': 'models.User',
    },
    'user_id': {
        'name': 'user_id',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
    'bio': {
        'name': 'bio',
        'is_list': False,
        'optional': False,
        'type': 'str',
    },
}



# we have to import ourselves as relation types are namespaced to models
# e.g. models.Post
from . import models

# required to support relationships between models
Post.update_forward_refs()
User.update_forward_refs()
Category.update_forward_refs()
Profile.update_forward_refs()
