# -*- coding: utf-8 -*-
# code generated by Prisma. DO NOT EDIT.
# pylint: disable=all
# pyright: reportUnusedImport=false
# fmt: off

# global imports for type checking
import sys
import datetime
from typing import (
    TYPE_CHECKING,
    Optional,
    Iterable,
    Iterator,
    Mapping,
    Tuple,
    Union,
    List,
    Dict,
    Type,
    Any,
    Set,
    overload,
    cast,
)

if sys.version_info >= (3, 8):
    from typing import TypedDict, Literal
else:
    from typing_extensions import TypedDict, Literal

# -- template client.py.jinja --
from types import TracebackType
from collections import defaultdict
from pydantic import BaseModel, validate_arguments

from . import types, models, errors
from ._types import BaseModelT
from .engine import QueryEngine
from .builder import QueryBuilder


__all__ = (
    'Client',
    'load_env',
)

SCHEMA = '''
datasource db {
  provider = "sqlite"
  url      = "file:dev.db"
}

generator db {
  provider               = "python3 -m prisma"
  recursive_type_depth   = 5
  http                   = "aiohttp"
  partial_type_generator = "tests/scripts/partial_type_generator.py"
}

model Post {
  id         String     @id @default(cuid())
  created_at DateTime   @default(now())
  updated_at DateTime   @updatedAt
  title      String
  published  Boolean
  views      Int        @default(0)
  desc       String?
  author     User?      @relation(fields: [author_id], references: [id])
  author_id  String?
  categories Category[] @relation(references: [id])
}

model User {
  id      String   @id @default(cuid())
  name    String
  posts   Post[]
  profile Profile?
}

model Category {
  id    Int    @id @default(autoincrement())
  posts Post[] @relation(references: [id])
  name  String
}

model Profile {
  id      Int    @id @default(autoincrement())
  user    User   @relation(fields: [user_id], references: [id])
  user_id String
  bio     String
}

'''


def load_env(*, override: bool = True, **kwargs: Any) -> None:
    """Load environemntal variables from dotenv files

    Loads from the following files relative to the current
    working directory:

    - .env
    - prisma/.env
    """
    from dotenv import load_dotenv

    load_dotenv('.env', override=override, **kwargs)
    load_dotenv('prisma/.env', override=override, **kwargs)


class Client:
    post: 'PostActions'
    user: 'UserActions'
    category: 'CategoryActions'
    profile: 'ProfileActions'

    def __init__(self, *, use_dotenv: bool = True, log_queries: bool = False) -> None:
        self.post = PostActions(self)
        self.user = UserActions(self)
        self.category = CategoryActions(self)
        self.profile = ProfileActions(self)
        self.__engine: Optional[QueryEngine] = None
        self._active_provider = 'sqlite'
        self._log_queries = log_queries

        if use_dotenv:
            load_env()

    def __del__(self) -> None:
        if self.__engine is not None:
            self.__engine.stop()
            self.__engine = None

    def is_connected(self) -> bool:
        """Returns True if the client is connected to the query engine, False otherwise."""
        return self.__engine is not None

    async def connect(self, timeout: int = 10) -> None:
        """Connect to the Prisma query engine.

        It is required to call this before accessing data.
        """
        if self.__engine is None:
            self.__engine = QueryEngine(dml=SCHEMA, log_queries=self._log_queries)

        await self.__engine.connect(timeout=timeout)

    async def disconnect(self) -> None:
        """Disconnect the Prisma query engine."""
        if self.__engine is not None:
            self.__engine.disconnect()
            await self.__engine.close_session()
            self.__engine = None

    async def execute_raw(self, query: str, *args: Any) -> int:
        resp = await self._execute(
            operation='mutation',
            method='executeRaw',
            arguments={
                'query': query,
                'parameters': args,
            }
        )
        return int(resp['data']['result'])

    @overload
    async def query_first(self, query: str, *args: Any) -> Any:
        ...

    @overload
    async def query_first(self, query: str, *args: Any, model: Type[BaseModelT]) -> Optional[BaseModelT]:
        ...

    async def query_first(
        self, query: str, *args: Any, model: Optional[Type[BaseModelT]] = None
    ) -> Union[Optional[BaseModelT], Any]:
        if model is not None:
            results = await self.query_raw(query, *args, model=model)
        else:
            results = await self.query_raw(query, *args)

        if not results:
            return None

        return results[0]

    @overload
    async def query_raw(self, query: str, *args: Any) -> Any:
        ...

    @overload
    async def query_raw(self, query: str, *args: Any, model: Type[BaseModelT]) -> List[BaseModelT]:
        ...

    async def query_raw(
        self, query: str, *args: Any, model: Optional[Type[BaseModelT]] = None
    ) -> Union[List[BaseModelT], Any]:
        resp = await self._execute(
            operation='mutation',
            method='queryRaw',
            arguments={
                'query': query,
                'parameters': args,
            }
        )
        result = resp['data']['result']
        if model is not None:
            return [model.parse_obj(r) for r in result]
        return result

    def batch_(self) -> 'Batch':
        """Returns a context manager for grouping write queries into a single transaction."""
        return Batch(client=self)

    # TODO: don't return Any
    async def _execute(
        self,
        method: str,
        operation: str,
        arguments: Dict[str, Any],
        model: Optional[str] = None,
        root_selection: Optional[List[str]] = None
    ) -> Any:
        builder = QueryBuilder(
            operation=operation,
            method=method,
            model=model,
            arguments=arguments,
            root_selection=root_selection,
        )
        return await self._engine.request('POST', '/', data=builder.build())

    @property
    def _engine(self) -> QueryEngine:
        engine = self.__engine
        if engine is None:
            raise errors.ClientNotConnectedError()
        return engine


# TODO: this should return the results as well
# TODO: don't require copy-pasting arguments between actions and batch actions
class Batch:
    post: 'PostBatchActions'
    user: 'UserBatchActions'
    category: 'CategoryBatchActions'
    profile: 'ProfileBatchActions'

    def __init__(self, client: Client) -> None:
        self.__client = client
        self.__queries: List[str] = []
        self._active_provider = client._active_provider
        self.post = PostBatchActions(self)
        self.user = UserBatchActions(self)
        self.category = CategoryBatchActions(self)
        self.profile = ProfileBatchActions(self)

    def _add(self, **kwargs: Any) -> None:
        builder = QueryBuilder(**kwargs)
        self.__queries.append(builder.build_query())

    async def commit(self) -> None:
        """Execute the queries"""
        # TODO: normalise this, we should still call client._execute
        from .builder import dumps

        queries = self.__queries
        self.__queries = []

        payload = {
            'batch': [
                {
                    'query': query,
                    'variables': {},
                }
                for query in queries
            ],
            'transaction': True,
        }
        await self.__client._engine.request('POST', '/', data=dumps(payload))

    async def __aenter__(self) -> 'Batch':
        return self

    async def __aexit__(
        self,
        exc_type: Optional[Type[BaseException]],
        exc: Optional[BaseException],
        exc_tb: Optional[TracebackType],
    ) -> None:
        if exc is None:
            await self.commit()


class PostActions:
    def __init__(self, client: Client):
        self._client = client

    async def create(
        self,
        data: types.PostCreateInput,
        include: Optional[types.PostInclude] = None
    ) -> models.Post:
        resp = await self._client._execute(
            operation='mutation',
            method='createOne',
            model='Post',
            arguments={
                'data': data,
                'include': include,
            },
        )
        return models.Post.parse_obj(resp['data']['result'])

    async def create_many(
        self,
        data: List[types.PostCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> int:
        if self._client._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        resp = await self._client._execute(
            operation='mutation',
            method='createMany',
            model='Post',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def delete(
        self,
        where: types.PostWhereUniqueInput,
        include: Optional[types.PostInclude] = None
    ) -> Optional[models.Post]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='deleteOne',
                model='Post',
                arguments={
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.Post.parse_obj(resp['data']['result'])

    async def find_unique(
        self,
        where: types.PostWhereUniqueInput,
        include: Optional[types.PostInclude] = None
    ) -> Optional[models.Post]:
        resp = await self._client._execute(
            operation='query',
            method='findUnique',
            model='Post',
            arguments={
                'where': where,
                'include': include,
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.Post.parse_obj(result)

    async def find_many(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.PostWhereInput] = None,
        cursor: Optional[types.PostWhereUniqueInput] = None,
        include: Optional[types.PostInclude] = None,
        order: Optional[Union[types.PostOrderByInput, List[types.PostOrderByInput]]] = None,
    ) -> List[models.Post]:
        resp = await self._client._execute(
            operation='query',
            method='findMany',
            model='Post',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include,
            },
        )
        return [models.Post.parse_obj(r) for r in resp['data']['result']]

    async def find_first(
        self,
        skip: Optional[int] = None,
        where: Optional[types.PostWhereInput] = None,
        cursor: Optional[types.PostWhereUniqueInput] = None,
        include: Optional[types.PostInclude] = None,
        order: Optional[Union[types.PostOrderByInput, List[types.PostOrderByInput]]] = None,
    ) -> Optional[models.Post]:
        resp = await self._client._execute(
            operation='query',
            method='findFirst',
            model='Post',
            arguments={
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.Post.parse_obj(result)

    async def update(
        self,
        data: types.PostUpdateInput,
        where: types.PostWhereUniqueInput,
        include: Optional[types.PostInclude] = None
    ) -> Optional[models.Post]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='updateOne',
                model='Post',
                arguments={
                    'data': data,
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.Post.parse_obj(resp['data']['result'])

    async def upsert(
        self,
        where: types.PostWhereUniqueInput,
        data: types.PostUpsertInput,
        include: Optional[types.PostInclude] = None,
    ) -> models.Post:
        resp = await self._client._execute(
            operation='mutation',
            method='upsertOne',
            model='Post',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )
        return models.Post.parse_obj(resp['data']['result'])

    async def update_many(
        self,
        data: types.PostUpdateManyMutationInput,
        where: types.PostWhereInput,
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='updateMany',
            model='Post',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def count(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.PostWhereInput] = None,
        cursor: Optional[types.PostWhereUniqueInput] = None,
        order: Optional[Union[types.PostOrderByInput, List[types.PostOrderByInput]]] = None,
    ) -> int:
        # TODO: support select
        resp = await self._client._execute(
            operation='query',
            method='aggregate',
            model='Post',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
            },
            root_selection=['count { _all }'],
        )
        return cast(int, resp['data']['result']['count']['_all'])

    async def delete_many(
        self,
        where: Optional[types.PostWhereInput] = None
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='deleteMany',
            model='Post',
            arguments={'where': where},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])


# NOTE: some arguments are meaningless in this context but are included
# for completeness sake
class PostBatchActions:
    def __init__(self, batcher: Batch) -> None:
        self._batcher = batcher

    def create(
        self,
        data: types.PostCreateInput,
        include: Optional[types.PostInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='createOne',
            model='Post',
            arguments={
                'data': data,
                'include': include,
            },
        )

    def create_many(
        self,
        data: List[types.PostCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> None:
        if self._batcher._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        self._batcher._add(
            operation='mutation',
            method='createMany',
            model='Post',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )

    def delete(
        self,
        where: types.PostWhereUniqueInput,
        include: Optional[types.PostInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteOne',
            model='Post',
            arguments={
                'where': where,
                'include': include,
            },
        )

    def update(
        self,
        data: types.PostUpdateInput,
        where: types.PostWhereUniqueInput,
        include: Optional[types.PostInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateOne',
            model='Post',
            arguments={
                'data': data,
                'where': where,
                'include': include,
            },
        )

    def upsert(
        self,
        where: types.PostWhereUniqueInput,
        data: types.PostUpsertInput,
        include: Optional[types.PostInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='upsertOne',
            model='Post',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )

    def update_many(
        self,
        data: types.PostUpdateManyMutationInput,
        where: types.PostWhereInput,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateMany',
            model='Post',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )

    def delete_many(
        self,
        where: Optional[types.PostWhereInput] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteMany',
            model='Post',
            arguments={'where': where},
            root_selection=['count'],
        )



class UserActions:
    def __init__(self, client: Client):
        self._client = client

    async def create(
        self,
        data: types.UserCreateInput,
        include: Optional[types.UserInclude] = None
    ) -> models.User:
        resp = await self._client._execute(
            operation='mutation',
            method='createOne',
            model='User',
            arguments={
                'data': data,
                'include': include,
            },
        )
        return models.User.parse_obj(resp['data']['result'])

    async def create_many(
        self,
        data: List[types.UserCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> int:
        if self._client._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        resp = await self._client._execute(
            operation='mutation',
            method='createMany',
            model='User',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def delete(
        self,
        where: types.UserWhereUniqueInput,
        include: Optional[types.UserInclude] = None
    ) -> Optional[models.User]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='deleteOne',
                model='User',
                arguments={
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.User.parse_obj(resp['data']['result'])

    async def find_unique(
        self,
        where: types.UserWhereUniqueInput,
        include: Optional[types.UserInclude] = None
    ) -> Optional[models.User]:
        resp = await self._client._execute(
            operation='query',
            method='findUnique',
            model='User',
            arguments={
                'where': where,
                'include': include,
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.User.parse_obj(result)

    async def find_many(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.UserWhereInput] = None,
        cursor: Optional[types.UserWhereUniqueInput] = None,
        include: Optional[types.UserInclude] = None,
        order: Optional[Union[types.UserOrderByInput, List[types.UserOrderByInput]]] = None,
    ) -> List[models.User]:
        resp = await self._client._execute(
            operation='query',
            method='findMany',
            model='User',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include,
            },
        )
        return [models.User.parse_obj(r) for r in resp['data']['result']]

    async def find_first(
        self,
        skip: Optional[int] = None,
        where: Optional[types.UserWhereInput] = None,
        cursor: Optional[types.UserWhereUniqueInput] = None,
        include: Optional[types.UserInclude] = None,
        order: Optional[Union[types.UserOrderByInput, List[types.UserOrderByInput]]] = None,
    ) -> Optional[models.User]:
        resp = await self._client._execute(
            operation='query',
            method='findFirst',
            model='User',
            arguments={
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.User.parse_obj(result)

    async def update(
        self,
        data: types.UserUpdateInput,
        where: types.UserWhereUniqueInput,
        include: Optional[types.UserInclude] = None
    ) -> Optional[models.User]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='updateOne',
                model='User',
                arguments={
                    'data': data,
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.User.parse_obj(resp['data']['result'])

    async def upsert(
        self,
        where: types.UserWhereUniqueInput,
        data: types.UserUpsertInput,
        include: Optional[types.UserInclude] = None,
    ) -> models.User:
        resp = await self._client._execute(
            operation='mutation',
            method='upsertOne',
            model='User',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )
        return models.User.parse_obj(resp['data']['result'])

    async def update_many(
        self,
        data: types.UserUpdateManyMutationInput,
        where: types.UserWhereInput,
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='updateMany',
            model='User',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def count(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.UserWhereInput] = None,
        cursor: Optional[types.UserWhereUniqueInput] = None,
        order: Optional[Union[types.UserOrderByInput, List[types.UserOrderByInput]]] = None,
    ) -> int:
        # TODO: support select
        resp = await self._client._execute(
            operation='query',
            method='aggregate',
            model='User',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
            },
            root_selection=['count { _all }'],
        )
        return cast(int, resp['data']['result']['count']['_all'])

    async def delete_many(
        self,
        where: Optional[types.UserWhereInput] = None
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='deleteMany',
            model='User',
            arguments={'where': where},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])


# NOTE: some arguments are meaningless in this context but are included
# for completeness sake
class UserBatchActions:
    def __init__(self, batcher: Batch) -> None:
        self._batcher = batcher

    def create(
        self,
        data: types.UserCreateInput,
        include: Optional[types.UserInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='createOne',
            model='User',
            arguments={
                'data': data,
                'include': include,
            },
        )

    def create_many(
        self,
        data: List[types.UserCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> None:
        if self._batcher._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        self._batcher._add(
            operation='mutation',
            method='createMany',
            model='User',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )

    def delete(
        self,
        where: types.UserWhereUniqueInput,
        include: Optional[types.UserInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteOne',
            model='User',
            arguments={
                'where': where,
                'include': include,
            },
        )

    def update(
        self,
        data: types.UserUpdateInput,
        where: types.UserWhereUniqueInput,
        include: Optional[types.UserInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateOne',
            model='User',
            arguments={
                'data': data,
                'where': where,
                'include': include,
            },
        )

    def upsert(
        self,
        where: types.UserWhereUniqueInput,
        data: types.UserUpsertInput,
        include: Optional[types.UserInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='upsertOne',
            model='User',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )

    def update_many(
        self,
        data: types.UserUpdateManyMutationInput,
        where: types.UserWhereInput,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateMany',
            model='User',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )

    def delete_many(
        self,
        where: Optional[types.UserWhereInput] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteMany',
            model='User',
            arguments={'where': where},
            root_selection=['count'],
        )



class CategoryActions:
    def __init__(self, client: Client):
        self._client = client

    async def create(
        self,
        data: types.CategoryCreateInput,
        include: Optional[types.CategoryInclude] = None
    ) -> models.Category:
        resp = await self._client._execute(
            operation='mutation',
            method='createOne',
            model='Category',
            arguments={
                'data': data,
                'include': include,
            },
        )
        return models.Category.parse_obj(resp['data']['result'])

    async def create_many(
        self,
        data: List[types.CategoryCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> int:
        if self._client._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        resp = await self._client._execute(
            operation='mutation',
            method='createMany',
            model='Category',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def delete(
        self,
        where: types.CategoryWhereUniqueInput,
        include: Optional[types.CategoryInclude] = None
    ) -> Optional[models.Category]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='deleteOne',
                model='Category',
                arguments={
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.Category.parse_obj(resp['data']['result'])

    async def find_unique(
        self,
        where: types.CategoryWhereUniqueInput,
        include: Optional[types.CategoryInclude] = None
    ) -> Optional[models.Category]:
        resp = await self._client._execute(
            operation='query',
            method='findUnique',
            model='Category',
            arguments={
                'where': where,
                'include': include,
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.Category.parse_obj(result)

    async def find_many(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.CategoryWhereInput] = None,
        cursor: Optional[types.CategoryWhereUniqueInput] = None,
        include: Optional[types.CategoryInclude] = None,
        order: Optional[Union[types.CategoryOrderByInput, List[types.CategoryOrderByInput]]] = None,
    ) -> List[models.Category]:
        resp = await self._client._execute(
            operation='query',
            method='findMany',
            model='Category',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include,
            },
        )
        return [models.Category.parse_obj(r) for r in resp['data']['result']]

    async def find_first(
        self,
        skip: Optional[int] = None,
        where: Optional[types.CategoryWhereInput] = None,
        cursor: Optional[types.CategoryWhereUniqueInput] = None,
        include: Optional[types.CategoryInclude] = None,
        order: Optional[Union[types.CategoryOrderByInput, List[types.CategoryOrderByInput]]] = None,
    ) -> Optional[models.Category]:
        resp = await self._client._execute(
            operation='query',
            method='findFirst',
            model='Category',
            arguments={
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.Category.parse_obj(result)

    async def update(
        self,
        data: types.CategoryUpdateInput,
        where: types.CategoryWhereUniqueInput,
        include: Optional[types.CategoryInclude] = None
    ) -> Optional[models.Category]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='updateOne',
                model='Category',
                arguments={
                    'data': data,
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.Category.parse_obj(resp['data']['result'])

    async def upsert(
        self,
        where: types.CategoryWhereUniqueInput,
        data: types.CategoryUpsertInput,
        include: Optional[types.CategoryInclude] = None,
    ) -> models.Category:
        resp = await self._client._execute(
            operation='mutation',
            method='upsertOne',
            model='Category',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )
        return models.Category.parse_obj(resp['data']['result'])

    async def update_many(
        self,
        data: types.CategoryUpdateManyMutationInput,
        where: types.CategoryWhereInput,
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='updateMany',
            model='Category',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def count(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.CategoryWhereInput] = None,
        cursor: Optional[types.CategoryWhereUniqueInput] = None,
        order: Optional[Union[types.CategoryOrderByInput, List[types.CategoryOrderByInput]]] = None,
    ) -> int:
        # TODO: support select
        resp = await self._client._execute(
            operation='query',
            method='aggregate',
            model='Category',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
            },
            root_selection=['count { _all }'],
        )
        return cast(int, resp['data']['result']['count']['_all'])

    async def delete_many(
        self,
        where: Optional[types.CategoryWhereInput] = None
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='deleteMany',
            model='Category',
            arguments={'where': where},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])


# NOTE: some arguments are meaningless in this context but are included
# for completeness sake
class CategoryBatchActions:
    def __init__(self, batcher: Batch) -> None:
        self._batcher = batcher

    def create(
        self,
        data: types.CategoryCreateInput,
        include: Optional[types.CategoryInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='createOne',
            model='Category',
            arguments={
                'data': data,
                'include': include,
            },
        )

    def create_many(
        self,
        data: List[types.CategoryCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> None:
        if self._batcher._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        self._batcher._add(
            operation='mutation',
            method='createMany',
            model='Category',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )

    def delete(
        self,
        where: types.CategoryWhereUniqueInput,
        include: Optional[types.CategoryInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteOne',
            model='Category',
            arguments={
                'where': where,
                'include': include,
            },
        )

    def update(
        self,
        data: types.CategoryUpdateInput,
        where: types.CategoryWhereUniqueInput,
        include: Optional[types.CategoryInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateOne',
            model='Category',
            arguments={
                'data': data,
                'where': where,
                'include': include,
            },
        )

    def upsert(
        self,
        where: types.CategoryWhereUniqueInput,
        data: types.CategoryUpsertInput,
        include: Optional[types.CategoryInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='upsertOne',
            model='Category',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )

    def update_many(
        self,
        data: types.CategoryUpdateManyMutationInput,
        where: types.CategoryWhereInput,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateMany',
            model='Category',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )

    def delete_many(
        self,
        where: Optional[types.CategoryWhereInput] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteMany',
            model='Category',
            arguments={'where': where},
            root_selection=['count'],
        )



class ProfileActions:
    def __init__(self, client: Client):
        self._client = client

    async def create(
        self,
        data: types.ProfileCreateInput,
        include: Optional[types.ProfileInclude] = None
    ) -> models.Profile:
        resp = await self._client._execute(
            operation='mutation',
            method='createOne',
            model='Profile',
            arguments={
                'data': data,
                'include': include,
            },
        )
        return models.Profile.parse_obj(resp['data']['result'])

    async def create_many(
        self,
        data: List[types.ProfileCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> int:
        if self._client._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        resp = await self._client._execute(
            operation='mutation',
            method='createMany',
            model='Profile',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def delete(
        self,
        where: types.ProfileWhereUniqueInput,
        include: Optional[types.ProfileInclude] = None
    ) -> Optional[models.Profile]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='deleteOne',
                model='Profile',
                arguments={
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.Profile.parse_obj(resp['data']['result'])

    async def find_unique(
        self,
        where: types.ProfileWhereUniqueInput,
        include: Optional[types.ProfileInclude] = None
    ) -> Optional[models.Profile]:
        resp = await self._client._execute(
            operation='query',
            method='findUnique',
            model='Profile',
            arguments={
                'where': where,
                'include': include,
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.Profile.parse_obj(result)

    async def find_many(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.ProfileWhereInput] = None,
        cursor: Optional[types.ProfileWhereUniqueInput] = None,
        include: Optional[types.ProfileInclude] = None,
        order: Optional[Union[types.ProfileOrderByInput, List[types.ProfileOrderByInput]]] = None,
    ) -> List[models.Profile]:
        resp = await self._client._execute(
            operation='query',
            method='findMany',
            model='Profile',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include,
            },
        )
        return [models.Profile.parse_obj(r) for r in resp['data']['result']]

    async def find_first(
        self,
        skip: Optional[int] = None,
        where: Optional[types.ProfileWhereInput] = None,
        cursor: Optional[types.ProfileWhereUniqueInput] = None,
        include: Optional[types.ProfileInclude] = None,
        order: Optional[Union[types.ProfileOrderByInput, List[types.ProfileOrderByInput]]] = None,
    ) -> Optional[models.Profile]:
        resp = await self._client._execute(
            operation='query',
            method='findFirst',
            model='Profile',
            arguments={
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
                'include': include
            },
        )
        result = resp['data']['result']
        if result is None:
            return None
        return models.Profile.parse_obj(result)

    async def update(
        self,
        data: types.ProfileUpdateInput,
        where: types.ProfileWhereUniqueInput,
        include: Optional[types.ProfileInclude] = None
    ) -> Optional[models.Profile]:
        try:
            resp = await self._client._execute(
                operation='mutation',
                method='updateOne',
                model='Profile',
                arguments={
                    'data': data,
                    'where': where,
                    'include': include,
                },
            )
        except errors.RecordNotFoundError:
            return None

        return models.Profile.parse_obj(resp['data']['result'])

    async def upsert(
        self,
        where: types.ProfileWhereUniqueInput,
        data: types.ProfileUpsertInput,
        include: Optional[types.ProfileInclude] = None,
    ) -> models.Profile:
        resp = await self._client._execute(
            operation='mutation',
            method='upsertOne',
            model='Profile',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )
        return models.Profile.parse_obj(resp['data']['result'])

    async def update_many(
        self,
        data: types.ProfileUpdateManyMutationInput,
        where: types.ProfileWhereInput,
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='updateMany',
            model='Profile',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])

    async def count(
        self,
        take: Optional[int] = None,
        skip: Optional[int] = None,
        where: Optional[types.ProfileWhereInput] = None,
        cursor: Optional[types.ProfileWhereUniqueInput] = None,
        order: Optional[Union[types.ProfileOrderByInput, List[types.ProfileOrderByInput]]] = None,
    ) -> int:
        # TODO: support select
        resp = await self._client._execute(
            operation='query',
            method='aggregate',
            model='Profile',
            arguments={
                'take': take,
                'skip': skip,
                'where': where,
                'order_by': order,
                'cursor': cursor,
            },
            root_selection=['count { _all }'],
        )
        return cast(int, resp['data']['result']['count']['_all'])

    async def delete_many(
        self,
        where: Optional[types.ProfileWhereInput] = None
    ) -> int:
        resp = await self._client._execute(
            operation='mutation',
            method='deleteMany',
            model='Profile',
            arguments={'where': where},
            root_selection=['count'],
        )
        return int(resp['data']['result']['count'])


# NOTE: some arguments are meaningless in this context but are included
# for completeness sake
class ProfileBatchActions:
    def __init__(self, batcher: Batch) -> None:
        self._batcher = batcher

    def create(
        self,
        data: types.ProfileCreateInput,
        include: Optional[types.ProfileInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='createOne',
            model='Profile',
            arguments={
                'data': data,
                'include': include,
            },
        )

    def create_many(
        self,
        data: List[types.ProfileCreateWithoutRelationsInput],
        *,
        skip_duplicates: Optional[bool] = None,
    ) -> None:
        if self._batcher._active_provider == 'sqlite':
            raise errors.UnsupportedDatabaseError('sqlite', 'create_many()')

        self._batcher._add(
            operation='mutation',
            method='createMany',
            model='Profile',
            arguments={
                'data': data,
                'skipDuplicates': skip_duplicates,
            },
            root_selection=['count'],
        )

    def delete(
        self,
        where: types.ProfileWhereUniqueInput,
        include: Optional[types.ProfileInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteOne',
            model='Profile',
            arguments={
                'where': where,
                'include': include,
            },
        )

    def update(
        self,
        data: types.ProfileUpdateInput,
        where: types.ProfileWhereUniqueInput,
        include: Optional[types.ProfileInclude] = None
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateOne',
            model='Profile',
            arguments={
                'data': data,
                'where': where,
                'include': include,
            },
        )

    def upsert(
        self,
        where: types.ProfileWhereUniqueInput,
        data: types.ProfileUpsertInput,
        include: Optional[types.ProfileInclude] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='upsertOne',
            model='Profile',
            arguments={
                'where': where,
                'include': include,
                'create': data.get('create'),
                'update': data.get('update'),
            },
        )

    def update_many(
        self,
        data: types.ProfileUpdateManyMutationInput,
        where: types.ProfileWhereInput,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='updateMany',
            model='Profile',
            arguments={'data': data, 'where': where,},
            root_selection=['count'],
        )

    def delete_many(
        self,
        where: Optional[types.ProfileWhereInput] = None,
    ) -> None:
        self._batcher._add(
            operation='mutation',
            method='deleteMany',
            model='Profile',
            arguments={'where': where},
            root_selection=['count'],
        )


