# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthIdpExternalJwtArgs', 'FusionAuthIdpExternalJwt']

@pulumi.input_type
class FusionAuthIdpExternalJwtArgs:
    def __init__(__self__, *,
                 header_key_parameter: pulumi.Input[str],
                 unique_identity_claim: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]] = None,
                 claim_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a FusionAuthIdpExternalJwt resource.
        :param pulumi.Input[str] header_key_parameter: The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        :param pulumi.Input[str] unique_identity_claim: The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[Mapping[str, Any]] claim_map: A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
               from the configured identity provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: An array of domains that are managed by this Identity Provider.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of the Identity Provider.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        :param pulumi.Input[str] oauth2_token_endpoint: TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        pulumi.set(__self__, "header_key_parameter", header_key_parameter)
        pulumi.set(__self__, "unique_identity_claim", unique_identity_claim)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if claim_map is not None:
            pulumi.set(__self__, "claim_map", claim_map)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorization_endpoint is not None:
            pulumi.set(__self__, "oauth2_authorization_endpoint", oauth2_authorization_endpoint)
        if oauth2_token_endpoint is not None:
            pulumi.set(__self__, "oauth2_token_endpoint", oauth2_token_endpoint)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="headerKeyParameter")
    def header_key_parameter(self) -> pulumi.Input[str]:
        """
        The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        """
        return pulumi.get(self, "header_key_parameter")

    @header_key_parameter.setter
    def header_key_parameter(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_key_parameter", value)

    @property
    @pulumi.getter(name="uniqueIdentityClaim")
    def unique_identity_claim(self) -> pulumi.Input[str]:
        """
        The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        """
        return pulumi.get(self, "unique_identity_claim")

    @unique_identity_claim.setter
    def unique_identity_claim(self, value: pulumi.Input[str]):
        pulumi.set(self, "unique_identity_claim", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="claimMap")
    def claim_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
        from the configured identity provider.
        """
        return pulumi.get(self, "claim_map")

    @claim_map.setter
    def claim_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "claim_map", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of domains that are managed by this Identity Provider.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Identity Provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauth2AuthorizationEndpoint")
    def oauth2_authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        """
        return pulumi.get(self, "oauth2_authorization_endpoint")

    @oauth2_authorization_endpoint.setter
    def oauth2_authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorization_endpoint", value)

    @property
    @pulumi.getter(name="oauth2TokenEndpoint")
    def oauth2_token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        """
        return pulumi.get(self, "oauth2_token_endpoint")

    @oauth2_token_endpoint.setter
    def oauth2_token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_token_endpoint", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


@pulumi.input_type
class _FusionAuthIdpExternalJwtState:
    def __init__(__self__, *,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]] = None,
                 claim_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 header_key_parameter: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]] = None,
                 unique_identity_claim: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthIdpExternalJwt resources.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[Mapping[str, Any]] claim_map: A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
               from the configured identity provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: An array of domains that are managed by this Identity Provider.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] header_key_parameter: The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of the Identity Provider.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        :param pulumi.Input[str] oauth2_token_endpoint: TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[str] unique_identity_claim: The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        """
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if claim_map is not None:
            pulumi.set(__self__, "claim_map", claim_map)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if header_key_parameter is not None:
            pulumi.set(__self__, "header_key_parameter", header_key_parameter)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorization_endpoint is not None:
            pulumi.set(__self__, "oauth2_authorization_endpoint", oauth2_authorization_endpoint)
        if oauth2_token_endpoint is not None:
            pulumi.set(__self__, "oauth2_token_endpoint", oauth2_token_endpoint)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)
        if unique_identity_claim is not None:
            pulumi.set(__self__, "unique_identity_claim", unique_identity_claim)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="claimMap")
    def claim_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
        from the configured identity provider.
        """
        return pulumi.get(self, "claim_map")

    @claim_map.setter
    def claim_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "claim_map", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of domains that are managed by this Identity Provider.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="headerKeyParameter")
    def header_key_parameter(self) -> Optional[pulumi.Input[str]]:
        """
        The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        """
        return pulumi.get(self, "header_key_parameter")

    @header_key_parameter.setter
    def header_key_parameter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header_key_parameter", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Identity Provider.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauth2AuthorizationEndpoint")
    def oauth2_authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        """
        return pulumi.get(self, "oauth2_authorization_endpoint")

    @oauth2_authorization_endpoint.setter
    def oauth2_authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorization_endpoint", value)

    @property
    @pulumi.getter(name="oauth2TokenEndpoint")
    def oauth2_token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        """
        return pulumi.get(self, "oauth2_token_endpoint")

    @oauth2_token_endpoint.setter
    def oauth2_token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_token_endpoint", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)

    @property
    @pulumi.getter(name="uniqueIdentityClaim")
    def unique_identity_claim(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        """
        return pulumi.get(self, "unique_identity_claim")

    @unique_identity_claim.setter
    def unique_identity_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_identity_claim", value)


class FusionAuthIdpExternalJwt(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]] = None,
                 claim_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 header_key_parameter: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]] = None,
                 unique_identity_claim: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # External JWT Identity Provider Resource

        This is a special type of identity provider that is only used via the JWT Reconcile API. This identity provider defines the claims inside the incoming JWT and how they map to fields in the FusionAuth User object.

        In order for this identity provider to use the JWT, it also needs the public key or HMAC secret that the JWT was signed with. FusionAuth will verify that the JWT is valid and has not expired. Once the JWT has been validated, FusionAuth will reconcile it to ensure that the User exists and is up-to-date.

        [External JWT Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/external-jwt/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        jwt = fusionauth.FusionAuthIdpExternalJwt("jwt",
            claim_map={
                "dept": "RegistrationData",
                "first_name": "firstName",
                "last_name": "lastName",
            },
            debug=False,
            enabled=True,
            header_key_parameter="kid",
            oauth2_authorization_endpoint="https://acme.com/adfs/oauth2/authorize?client_id=cf3b00da-9551-460a-ad18-33232e6cbff0&response_type=code&redirect_uri=https://acme.com/oauth2/redirect",
            oauth2_token_endpoint="https://acme.com/adfs/oauth2/token",
            unique_identity_claim="email")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[Mapping[str, Any]] claim_map: A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
               from the configured identity provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: An array of domains that are managed by this Identity Provider.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] header_key_parameter: The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of the Identity Provider.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        :param pulumi.Input[str] oauth2_token_endpoint: TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[str] unique_identity_claim: The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthIdpExternalJwtArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # External JWT Identity Provider Resource

        This is a special type of identity provider that is only used via the JWT Reconcile API. This identity provider defines the claims inside the incoming JWT and how they map to fields in the FusionAuth User object.

        In order for this identity provider to use the JWT, it also needs the public key or HMAC secret that the JWT was signed with. FusionAuth will verify that the JWT is valid and has not expired. Once the JWT has been validated, FusionAuth will reconcile it to ensure that the User exists and is up-to-date.

        [External JWT Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/external-jwt/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        jwt = fusionauth.FusionAuthIdpExternalJwt("jwt",
            claim_map={
                "dept": "RegistrationData",
                "first_name": "firstName",
                "last_name": "lastName",
            },
            debug=False,
            enabled=True,
            header_key_parameter="kid",
            oauth2_authorization_endpoint="https://acme.com/adfs/oauth2/authorize?client_id=cf3b00da-9551-460a-ad18-33232e6cbff0&response_type=code&redirect_uri=https://acme.com/oauth2/redirect",
            oauth2_token_endpoint="https://acme.com/adfs/oauth2/token",
            unique_identity_claim="email")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthIdpExternalJwtArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthIdpExternalJwtArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]] = None,
                 claim_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 header_key_parameter: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]] = None,
                 unique_identity_claim: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthIdpExternalJwtArgs.__new__(FusionAuthIdpExternalJwtArgs)

            __props__.__dict__["application_configurations"] = application_configurations
            __props__.__dict__["claim_map"] = claim_map
            __props__.__dict__["debug"] = debug
            __props__.__dict__["domains"] = domains
            __props__.__dict__["enabled"] = enabled
            if header_key_parameter is None and not opts.urn:
                raise TypeError("Missing required property 'header_key_parameter'")
            __props__.__dict__["header_key_parameter"] = header_key_parameter
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
            __props__.__dict__["linking_strategy"] = linking_strategy
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth2_authorization_endpoint"] = oauth2_authorization_endpoint
            __props__.__dict__["oauth2_token_endpoint"] = oauth2_token_endpoint
            __props__.__dict__["tenant_configurations"] = tenant_configurations
            if unique_identity_claim is None and not opts.urn:
                raise TypeError("Missing required property 'unique_identity_claim'")
            __props__.__dict__["unique_identity_claim"] = unique_identity_claim
        super(FusionAuthIdpExternalJwt, __self__).__init__(
            'fusionauth:index/fusionAuthIdpExternalJwt:FusionAuthIdpExternalJwt',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]]] = None,
            claim_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            header_key_parameter: Optional[pulumi.Input[str]] = None,
            idp_id: Optional[pulumi.Input[str]] = None,
            lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
            linking_strategy: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
            oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
            tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]]] = None,
            unique_identity_claim: Optional[pulumi.Input[str]] = None) -> 'FusionAuthIdpExternalJwt':
        """
        Get an existing FusionAuthIdpExternalJwt resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[Mapping[str, Any]] claim_map: A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
               from the configured identity provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: An array of domains that are managed by this Identity Provider.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] header_key_parameter: The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of the Identity Provider.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        :param pulumi.Input[str] oauth2_token_endpoint: TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpExternalJwtTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[str] unique_identity_claim: The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthIdpExternalJwtState.__new__(_FusionAuthIdpExternalJwtState)

        __props__.__dict__["application_configurations"] = application_configurations
        __props__.__dict__["claim_map"] = claim_map
        __props__.__dict__["debug"] = debug
        __props__.__dict__["domains"] = domains
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["header_key_parameter"] = header_key_parameter
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
        __props__.__dict__["linking_strategy"] = linking_strategy
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth2_authorization_endpoint"] = oauth2_authorization_endpoint
        __props__.__dict__["oauth2_token_endpoint"] = oauth2_token_endpoint
        __props__.__dict__["tenant_configurations"] = tenant_configurations
        __props__.__dict__["unique_identity_claim"] = unique_identity_claim
        return FusionAuthIdpExternalJwt(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpExternalJwtApplicationConfiguration']]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="claimMap")
    def claim_map(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map of incoming claims to User fields, User data or Registration data. The key of the map is the incoming claim name
        from the configured identity provider.
        """
        return pulumi.get(self, "claim_map")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of domains that are managed by this Identity Provider.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="headerKeyParameter")
    def header_key_parameter(self) -> pulumi.Output[str]:
        """
        The name header claim that identifies the public key used to verify the signature. In most cases this be kid or x5t.
        """
        return pulumi.get(self, "header_key_parameter")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> pulumi.Output[str]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Identity Provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauth2AuthorizationEndpoint")
    def oauth2_authorization_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The authorization endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to perform the browser redirect to the OAuth2 authorize endpoint.
        """
        return pulumi.get(self, "oauth2_authorization_endpoint")

    @property
    @pulumi.getter(name="oauth2TokenEndpoint")
    def oauth2_token_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        TThe token endpoint for this Identity Provider. This value is not utilized by FusionAuth is only provided to be returned by the Lookup Identity Provider API response. During integration you may then utilize this value to complete the OAuth2 grant workflow.
        """
        return pulumi.get(self, "oauth2_token_endpoint")

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpExternalJwtTenantConfiguration']]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @property
    @pulumi.getter(name="uniqueIdentityClaim")
    def unique_identity_claim(self) -> pulumi.Output[str]:
        """
        The name of the claim that represents the unique identify of the User. This will generally be email or the name of the claim that provides the email address.
        """
        return pulumi.get(self, "unique_identity_claim")

