# --------------------------------------------------------
# Fast R-CNN
# Copyright (c) 2015 Microsoft
# Licensed under The MIT License [see LICENSE for details]
# Written by Samson Wang
# --------------------------------------------------------

from __future__ import print_function

from Cython.Build import cythonize
from Cython.Distutils import build_ext
from setuptools import Extension
from setuptools import setup

import numpy as np


# Obtain the numpy include directory.  This logic works across numpy versions.
try:
    numpy_include = np.get_include()
except AttributeError:
    numpy_include = np.get_numpy_include()

with open("README.md", "r") as fh:
    long_description = fh.read()

ext_modules = [
    Extension(
        name='cython_bbox_nguyenchien',
        sources=['src/cython_bbox.pyx'],
        extra_compile_args=['-Wno-cpp'],
        include_dirs=[numpy_include]
    )
]

setup(
    name='cython_bbox_nguyenchien',
    ext_modules=cythonize(ext_modules),
    version = '0.1.3',
    description = 'Standalone cython_bbox',
    long_description=long_description,
    long_description_content_type="text/markdown",
    author = 'Chien',
    author_email = 'firefliesqn1102@gmail.com',
    url = 'https://github.com/firefliesqn1102/first_package.git', 
    keywords = ['cython_bbox_nguyenchien']
)

