# Generated by Django 1.9.6 on 2016-07-05 05:21
from __future__ import unicode_literals

from dartcms import get_model
from django.db import migrations
from django.utils import translation
from django.utils.translation import gettext_lazy as _


def insert_homepage(apps, schema):
    from django.conf import settings
    translation.activate(settings.LANGUAGE_CODE)

    PageModule = get_model('pages', 'PageModule')
    Page = get_model('pages', 'Page')

    if PageModule.objects.filter(slug='homepage').exists():
        return

    homepage_module = PageModule.objects.create(
        slug='homepage',
        name=_('Homepage')
    )

    homepage = {
        'parent': None,
        'title': _('Homepage'),
        'slug': '',
        'url': '/',
        'module': homepage_module
    }
    Page.objects.create(**homepage)

    translation.deactivate()


def drop_homepage(apps, schema):
    PageModule = apps.get_model('pages', 'PageModule')
    Page = apps.get_model('pages', 'Page')

    Page.objects.filter(module__slug='homepage').delete()
    PageModule.objects.filter(slug='homepage').delete()


class Migration(migrations.Migration):
    dependencies = [
        ('pages', '0010_auto_20161214_0258'),
    ]

    operations = [
        migrations.RunPython(insert_homepage, drop_homepage)
    ]
