# Generated by Django 1.9.6 on 2016-07-05 05:15
from __future__ import unicode_literals

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Module',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('sort', models.IntegerField(default=1, verbose_name='Sort')),
                ('description', models.TextField(blank=True, default=b'', verbose_name='Description')),
                ('slug', models.SlugField(unique=True, verbose_name='Slug')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Is Enabled')),
            ],
            options={
                'ordering': ['group', 'sort'],
                'verbose_name': 'Module',
                'verbose_name_plural': 'Modules',
            },
        ),
        migrations.CreateModel(
            name='ModuleGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(unique=True, verbose_name='Slug')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('fa', models.SlugField(verbose_name='FontAwesome class')),
                ('sort', models.IntegerField(default=1, verbose_name='Sort')),
                ('description', models.TextField(blank=True, default=b'', verbose_name='Description')),
            ],
            options={
                'ordering': ['sort'],
                'verbose_name': 'Module Group',
                'verbose_name_plural': 'Module Groups',
            },
        ),
        migrations.AddField(
            model_name='module',
            name='group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='modules', to='modules.ModuleGroup', to_field='slug', verbose_name='Group'),
        ),
        migrations.AddField(
            model_name='module',
            name='user',
            field=models.ManyToManyField(to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
    ]
