"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCluster = exports.toJson_KubernetesApiAccessEntry = exports.toJson_Provider = exports.toJson_CfnClusterPropsTags = exports.toJson_CfnClusterPropsKubernetesApiAccess = exports.toJson_EncryptionConfigEntry = exports.toJson_CfnClusterPropsResourcesVpcConfig = exports.toJson_CfnClusterPropsKubernetesNetworkConfig = exports.toJson_CfnClusterProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnClusterProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterProps(obj) {
    var _b, _c, _d;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'RoleArn': obj.roleArn,
        'LambdaRoleName': obj.lambdaRoleName,
        'Version': obj.version,
        'KubernetesNetworkConfig': toJson_CfnClusterPropsKubernetesNetworkConfig(obj.kubernetesNetworkConfig),
        'ResourcesVpcConfig': toJson_CfnClusterPropsResourcesVpcConfig(obj.resourcesVpcConfig),
        'EnabledClusterLoggingTypes': (_b = obj.enabledClusterLoggingTypes) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'EncryptionConfig': (_c = obj.encryptionConfig) === null || _c === void 0 ? void 0 : _c.map(y => toJson_EncryptionConfigEntry(y)),
        'KubernetesApiAccess': toJson_CfnClusterPropsKubernetesApiAccess(obj.kubernetesApiAccess),
        'Tags': (_d = obj.tags) === null || _d === void 0 ? void 0 : _d.map(y => toJson_CfnClusterPropsTags(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterProps = toJson_CfnClusterProps;
/**
 * Converts an object of type 'CfnClusterPropsKubernetesNetworkConfig' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsKubernetesNetworkConfig(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ServiceIpv4Cidr': obj.serviceIpv4Cidr,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsKubernetesNetworkConfig = toJson_CfnClusterPropsKubernetesNetworkConfig;
/**
 * Converts an object of type 'CfnClusterPropsResourcesVpcConfig' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsResourcesVpcConfig(obj) {
    var _b, _c, _d;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SecurityGroupIds': (_b = obj.securityGroupIds) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'SubnetIds': (_c = obj.subnetIds) === null || _c === void 0 ? void 0 : _c.map(y => y),
        'EndpointPublicAccess': obj.endpointPublicAccess,
        'EndpointPrivateAccess': obj.endpointPrivateAccess,
        'PublicAccessCidrs': (_d = obj.publicAccessCidrs) === null || _d === void 0 ? void 0 : _d.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsResourcesVpcConfig = toJson_CfnClusterPropsResourcesVpcConfig;
/**
 * Converts an object of type 'EncryptionConfigEntry' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_EncryptionConfigEntry(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Resources': (_b = obj.resources) === null || _b === void 0 ? void 0 : _b.map(y => y),
        'Provider': toJson_Provider(obj.provider),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_EncryptionConfigEntry = toJson_EncryptionConfigEntry;
/**
 * Converts an object of type 'CfnClusterPropsKubernetesApiAccess' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsKubernetesApiAccess(obj) {
    var _b, _c;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Roles': (_b = obj.roles) === null || _b === void 0 ? void 0 : _b.map(y => toJson_KubernetesApiAccessEntry(y)),
        'Users': (_c = obj.users) === null || _c === void 0 ? void 0 : _c.map(y => toJson_KubernetesApiAccessEntry(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsKubernetesApiAccess = toJson_CfnClusterPropsKubernetesApiAccess;
/**
 * Converts an object of type 'CfnClusterPropsTags' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnClusterPropsTags(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Value': obj.value,
        'Key': obj.key,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnClusterPropsTags = toJson_CfnClusterPropsTags;
/**
 * Converts an object of type 'Provider' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Provider(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'KeyArn': obj.keyArn,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Provider = toJson_Provider;
/**
 * Converts an object of type 'KubernetesApiAccessEntry' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_KubernetesApiAccessEntry(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Arn': obj.arn,
        'Username': obj.username,
        'Groups': (_b = obj.groups) === null || _b === void 0 ? void 0 : _b.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_KubernetesApiAccessEntry = toJson_KubernetesApiAccessEntry;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `AWSQS::EKS::Cluster`
 *
 * @cloudformationResource AWSQS::EKS::Cluster
 * @stability external
 * @link https://github.com/aws-quickstart/quickstart-amazon-eks-cluster-resource-provider.git
 */
class CfnCluster extends cdk.CfnResource {
    /**
     * Create a new `AWSQS::EKS::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCluster.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnClusterProps(props) });
        this.props = props;
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.attrClusterSecurityGroupId = cdk.Token.asString(this.getAtt('ClusterSecurityGroupId'));
        this.attrCertificateAuthorityData = cdk.Token.asString(this.getAtt('CertificateAuthorityData'));
        this.attrEncryptionConfigKeyArn = cdk.Token.asString(this.getAtt('EncryptionConfigKeyArn'));
        this.attrOIDCIssuerURL = cdk.Token.asString(this.getAtt('OIDCIssuerURL'));
    }
}
exports.CfnCluster = CfnCluster;
_a = JSII_RTTI_SYMBOL_1;
CfnCluster[_a] = { fqn: "@cdk-cloudformation/awsqs-eks-cluster.CfnCluster", version: "1.12.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCluster.CFN_RESOURCE_TYPE_NAME = "AWSQS::EKS::Cluster";
//# sourceMappingURL=data:application/json;base64,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