# Contributing Guidelines

gp2040ce-binary-tools is made available under the GPLv3 (or later). Contributions are welcome via pull requests.  This
document outlines the process to get your contribution accepted.

## Sign Offs/Custody of Contributions

The [Developer Certificate of Origin (DCO)](https://developercertificate.org/), reproduced below, is a way for
contributors to certify that they wrote or otherwise have the right to license their code contributions to the project.
Contributors must sign-off that they adhere to these requirements by adding a `Signed-off-by` line to their commit
message, and/or, for frequent contributors, by signing off on their entry in `MAINTAINERS.md`.

```
Developer Certificate of Origin
Version 1.1

Copyright (C) 2004, 2006 The Linux Foundation and its contributors.

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.


Developer's Certificate of Origin 1.1

By making a contribution to this project, I certify that:

(a) The contribution was created in whole or in part by me and I
    have the right to submit it under the open source license
    indicated in the file; or

(b) The contribution is based upon previous work that, to the best
    of my knowledge, is covered under an appropriate open source
    license and I have the right under that license to submit that
    work with modifications, whether created in whole or in part
    by me, under the same open source license (unless I am
    permitted to submit under a different license), as indicated
    in the file; or

(c) The contribution was provided directly to me by some other
    person who certified (a), (b) or (c) and I have not modified
    it.

(d) I understand and agree that this project and the contribution
    are public and that a record of the contribution (including all
    personal information I submit with it, including my sign-off) is
    maintained indefinitely and may be redistributed consistent with
    this project or the open source license(s) involved.
```

This process is followed by a number of open source projects, most notably the Linux kernel. Here's the gist of it:

```
[Your normal Git commit message here.]

Signed-off-by: Random J Developer <random@developer.example.org>
```

`git help commit` has more info on adding this:

```
-s, --signoff
    Add Signed-off-by line by the committer at the end of the commit log
    message. The meaning of a signoff depends on the project, but it typically
    certifies that committer has the rights to submit this work under the same
    license and agrees to a Developer Certificate of Origin (see
    http://developercertificate.org/ for more information).
```
