import string
from typing import Any, Iterable, Iterator, List, Optional, Union

from psycopg2 import extensions as ext
from psycopg2.extensions import _SQLType, connection
from psycopg2.extras import _CursorLike

_formatter: string.Formatter

_Context = Union[connection, _CursorLike]

class Composable:
    def __init__(self, wrapped: _SQLType) -> None: ...
    def as_string(self, context: _Context) -> str: ...
    def __add__(self, other: Any) -> Composed: ...
    def __mul__(self, n: int) -> Composed: ...
    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class Composed(Composable):
    def __init__(self, seq: Iterable[Composable]) -> None: ...
    @property
    def seq(self) -> List[Composable]: ...
    def as_string(self, context: _Context) -> str: ...
    def __iter__(self) -> Iterator[Composable]: ...
    def __add__(self, other: object) -> Composed: ...
    def join(self, joiner: Union[str, SQL]) -> Composed: ...

class SQL(Composable):
    def __init__(self, string: str) -> None: ...
    @property
    def string(self) -> str: ...
    def as_string(self, context: _Context) -> str: ...
    def format(self, *args: Any, **kwargs: Any) -> Composed: ...
    def join(self, seq: Iterable[Composable]) -> Composed: ...

class Identifier(Composable):
    def __init__(self, *strings: str) -> None: ...
    @property
    def strings(self) -> List[str]: ...
    @property
    def string(self) -> str: ...
    def as_string(self, context: _Context) -> str: ...

class Literal(Composable):
    @property
    def wrapped(self) -> Any: ...
    def as_string(self, context: _Context) -> str: ...

class Placeholder(Composable):
    def __init__(self, name: Optional[str] = ...) -> None: ...
    @property
    def name(self) -> Optional[str]: ...
    def as_string(self, context: _Context) -> str: ...

NULL: SQL
DEFAULT: SQL
