from typing import Any, Callable, Dict, Iterable, List, Optional, Union

from django.core.exceptions import ImproperlyConfigured

class InvalidCacheBackendError(ImproperlyConfigured): ...
class CacheKeyWarning(RuntimeWarning): ...

DEFAULT_TIMEOUT: int
MEMCACHE_MAX_KEY_LENGTH: int

def default_key_func(key: str, key_prefix: str, version: Any) -> str: ...
def get_key_func(
    key_func: Optional[Union[Callable[..., Any], str]]
) -> Callable[..., Any]: ...

class BaseCache:
    default_timeout: int = ...
    key_prefix: str = ...
    version: int = ...
    key_func: Callable[..., Any] = ...
    def __init__(self, params: Dict[str, Any]) -> None: ...
    def get_backend_timeout(self, timeout: Optional[int] = ...) -> Optional[float]: ...
    def make_key(self, key: str, version: Optional[int] = ...) -> str: ...
    def add(
        self,
        key: str,
        value: Any,
        timeout: Optional[int] = ...,
        version: Optional[int] = ...,
    ) -> bool: ...
    def get(
        self, key: str, default: Optional[Any] = ..., version: Optional[int] = ...
    ) -> Any: ...
    def set(
        self,
        key: str,
        value: Any,
        timeout: Optional[int] = ...,
        version: Optional[int] = ...,
    ) -> None: ...
    def touch(
        self, key: str, timeout: Optional[int] = ..., version: Optional[int] = ...
    ) -> bool: ...
    def delete(self, key: str, version: Optional[int] = ...) -> None: ...
    def get_many(
        self, keys: List[str], version: Optional[int] = ...
    ) -> Dict[str, Union[int, str]]: ...
    def get_or_set(
        self,
        key: str,
        default: Optional[Any],
        timeout: Optional[int] = ...,
        version: Optional[int] = ...,
    ) -> Optional[Any]: ...
    def has_key(self, key: str, version: Optional[int] = ...) -> bool: ...
    def incr(self, key: str, delta: int = ..., version: Optional[int] = ...) -> int: ...
    def decr(self, key: str, delta: int = ..., version: Optional[int] = ...) -> int: ...
    def __contains__(self, key: str) -> bool: ...
    def set_many(
        self,
        data: Dict[str, Any],
        timeout: Optional[int] = ...,
        version: Optional[int] = ...,
    ) -> List[Any]: ...
    def delete_many(
        self, keys: Iterable[str], version: Optional[int] = ...
    ) -> None: ...
    def clear(self) -> None: ...
    def validate_key(self, key: str) -> None: ...
    def incr_version(
        self, key: str, delta: int = ..., version: Optional[int] = ...
    ) -> int: ...
    def decr_version(
        self, key: str, delta: int = ..., version: Optional[int] = ...
    ) -> int: ...
    def close(self, **kwargs: Any) -> None: ...
