# fastutils

Collection of simple utils.

## Install

```shell
pip install fastutils
```

## Installed Utils

- aesutils # use cipherutils instead
- cacheutils
   - get_cached_value
- cipherutils
   - AesCipher    # standard cipher, default to aes-128-ecb with sha1prng_key.
   - S12Cipher    # self-designed, turn 1 byte data to 2 byte data with random gap.
   - IvCipher     # self-designed, trun integer number increase randomly.
   - IvfCipher    # self-designed, based on IvCihper, for float number encrypt and decrypt.
- dictutils
   - deep_merge
   - select
   - update
   - ignore_none_item   # None, [], {} will be ignored. 0, False, "" and other empty element will keep.
- funcutils
   - get_inject_params
   - call_with_inject
- hashutils
   - get_file_md5
   - get_file_sha
   - get_file_sha1
   - get_file_sha224
   - get_file_sha256
   - get_file_sha384
   - get_file_sha512
   - get_md5
   - get_sha
   - get_sha1
   - get_sha224
   - get_sha256
   - get_sha384
   - get_sha512
   - get_md5_base64
   - get_sha_base64
   - get_sha1_base64
   - get_sha224_base64
   - get_sha256_base64
   - get_sha384_base64
   - get_sha512_base64
   - get_pbkdf2_hmac
   - get_pbkdf2_md5
   - get_pbkdf2_sha
   - get_pbkdf2_sha1
   - get_pbkdf2_sha224
   - get_pbkdf2_sha256
   - get_pbkdf2_sha384
   - get_pbkdf2_sha512
   - validate_pbkdf2_hmac
   - validate_pbkdf2_md5
   - validate_pbkdf2_sha
   - validate_pbkdf2_sha1
   - validate_pbkdf2_sha224
   - validate_pbkdf2_sha256
   - validate_pbkdf2_sha384
   - validate_pbkdf2_sha512
- imageutils
   - get_image_bytes
   - get_base64image
   - parse_base64image
   - resize
- jsonutils
   - SimpleJsonEncoder
   - simple_json_dumps
   - register_global_encoder
- listutils
   - int_list_to_bytes # deprecated, see strutils.ints2bytes
   - pad
   - chunk
   - clean_none
   - ignore_none_element # alias of clean_none
   - unique
   - replace
   - append_new
   - group
- randomutils
   - Random
      - random
      - randint
      - get_bytes
      - choice
      - choices
      - shuffle
- rsautils
   - newkeys
   - load_private_key
   - load_public_key
   - load_public_key_from_private_key
   - encrypt
   - decrypt
   - export_key
- sixutils
- strutils
   - random_string
   - char_force_to_int
   - force_bytes
   - force_text
   - force_int
   - force_float
   - force_numeric
   - wholestrip
   - split
   - str_composed_by
   - is_str_composed_by_the_choices (alias of str_composed_by)
   - is_hex_digits
   - join_lines
   - is_urlsafeb64_decodable
   - is_base64_decodable
   - is_unhexlifiable
   - text_display_length
   - text_display_shorten
   - smart_get_binary_data
   - is_chinese_character
   - binarify
   - unbinarify
   - ints2bytes
   - int2bytes
- threadutils
   - Service
   - ServiceBase
- typingutils


## Help

### Mostly get help by help( ... ) in ipython

*Example*

```
In [9]: from fastutils import strutils

In [10]: help(strutils.random_string)
Help on function random_string in module fastutils.strutils:

random_string(length, choices='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')

```

### Some function using *args, **kwargs paramters, see help below.

### cipherutils.IvCipher

*Instance Init Parameters*

- password: required.

### cipherutils.IvfCipher

*Instance Init Parameters*

- password: required.
- encoder: default to cipherutils.RawDataEncoder(), choices are: cipherutils.HexlifyEncoder(), cipherutils.Base64Encoder(), cipherutils.SafeBase64Encoder().
- kwargs: dict type.
   - int_digits: default to 12
   - float_digits: default to 4

*Note*

- When float_digits=0, the plain number is treat as integer value.

### cipherutils.AesCipher

*Instance Init Parameters*

- password: required.
- encoder: default to cipherutils.RawDataEncoder(), choices are: cipherutils.HexlifyEncoder(), cipherutils.Base64Encoder(), cipherutils.SafeBase64Encoder()
- kwargs: dict type.
   - padding: default to cipherutils.aes_padding_pkcs5.
   - key: default to cipherutils.sha1prng_key.
   - mode: default to AES.MODE_ECB (from Crypto.Cipher import AES).

*Example*

```shell
In [1]: from fastutils import cipherutils

In [2]: cipher = cipherutils.AesCipher(password="testpwd", encoder=cipherutils.HexlifyEncoder(), kwargs={"key": cipherutils.mysql_aes_key}, force_text=True)
   ...:

In [3]: text1 = "test content"

In [4]: text2 = cipher.encrypt(text1)

In [5]: print(text2)
299aa4e15a40d69e56674a94d9b66cc3

In [6]: text3 = cipher.decrypt(text2)

In [7]: print(text3)
test content

In [8]: text1 == text3
Out[8]: True

In [9]:

```

## Bug report

Please report any issues at https://github.com/zencore-cn/zencore-issues.

## Releases

### v0.13.4 2020-07-11

- Use new algorithm to improve randomutils.shuffle's performance.

### v0.13.3 2020-07-11

- Add randomutils.shuffle.
- Change randomutils.randint parameters from (max, min=0) to (a, b=None).

### v0.13.2 2020-07-10

- Add listutils.group.
- Add rsautils.export_key. And rsautils use Crypto.PublicKey.RSA for the base engine.

### v0.13.1 2020-07-01

- Add strutils.force_float and strutils.force_numeric.
- Add typingutils.cast_numeric support.

### v0.13.0 2020-06-26

- IvfCihper accept integer value when float_digits=0.
- Fix IvfCihper deviation problem which is caused by wrong module used in decrypt.
- IvfCihper use new algorithm in computing module and max_value, **so that result encrypted by version v0.12.0 can not decrypted by version v0.13.0**.

### v0.12.0 2020-06-25

- Add IvfCihper for float number encrypt and decrypt. The output of IvfCipher.encrypt is string.

### v0.11.1 2020-06-23

- Use class instead of raw api for s12 and iv ciphers. It's can avoid many times in generating seeds.

### v0.11.0 2020-06-20

- Add cipherutils.
- Add strutils.binarify and strutils.unbinarify.
- Add randomutils.Random.
- Change aesutils functions' return type. Note: use cipherutils instead.

### v0.10.1 2020-05-19

- Add bizerror dependency.

### v0.10.0 2020-04-23

- Add strutils.is_chinese_character to test if the character is a chinese character.
- Add cacheutils.get_cached_value to get or set cached value.

### v0.9.0 2020-03-05

- Add listutils.append_new to append new value and only new value to the list.

### v0.8.0 2020-01-15

- Add strutils.smart_get_binary_data.
- Add rsautils.

### v0.7.0 2020-01-14

- Add hashutils.get_file_hash.
- Add extra install requires for python 2.x.
- Add imageutils.parse_base64image and imageutils.get_image_bytes.
- Fix jsonutils.make_simple_json_encoder ignore bases problem.

### v0.6.0 2020-01-07

- Add imageutils, add imageutils.get_base64image to make base64 image that can be rendered by web browser.
- Add imageutils.resize to scale image size.
- Add Image-Object-Encode support in jsonutils.
- Add threadutils, add threadutils.Service to simplify long-run-service programming.
- Raise bizerror.MissingParameter error in funcutils.get_inject_params while missing required parameter.

### v0.5.4 2019-12-10

- Fix hashutils.get_hash_hexdigest and hashutils.get_hash_base64 problem.

### v0.5.3 2019-12-08

- Using typingutils.smart_cast in funcutils.get_inject_params.

### v0.5.2 2019-12-08

- Add unit test cases for typingutils.
- Fix cast_list, do strip for every element in comma-separated-list.
- Fix base64 import missing in typingutils.

### v0.5.1 2019-12-08

- Add typingutils.cast_str.

### v0.5.0 2019-12-08

- Set library property in get_encoder in jsonutils.
- Add typingutils.

### v0.4.0 2019.12.07

- Add jsonutils, provides simple json encoder register system.

### v0.3.2 2019.10.29

- Fix problems for python 2.7.
- Fix name error of funcutils.

### v0.3.1 2019.10.28

- Fix problem casued by str.isascii() which is new from python 3.7.

### v0.3.0 2019.09.24

- Add listutils.unique to remove duplicated elements from the list.
- Add listutils.replace to replace element value in thelist with new_value in collection of map.

### v0.2.0 2019.09.10

- Add functuils.get_inject_params to smartly choose parameters from candidates by determine with the function's signature.
- Add functuils.call_with_inject to smartly call the function by smartly choose parameters.

### v0.1.1 2019.08.27

- Add strutils.wholestrip function, use to remove all white spaces in text.
- Fix strutils.is_urlsafeb64_decodable, strutils.is_base64_decodable and strutils.is_unhexlifiable functions, that have problem to test text contains whitespaces.

### v0.1.0 2019.08.23

- Add simple utils about operations of aes, dict, hash, list and str.
