![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)
[![GitHub Issues](https://img.shields.io/github/issues/lf1-io/padl-extensions.svg)](https://github.com/lf1-io/padl-extensions/issues)
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/lf1-io/padl-extensions/)
[![LF1 on Twitter](https://badgen.net/badge/icon/twitter?icon=twitter&label)](https://twitter.com/lf1_io)

# PADL-Extensions
Trainers, monitors, connectors for PADL

**PADL-Extensions** was developed at [LF1](https://lf1.io/), an AI innovation lab based in Berlin, Germany.

## Installation
```
pip install padl-extensions
```

## Extras Installation
```
pip install padl-extensions[pytorch_lightning]
pip install padl-extensions[torchserve]
pip install padl-extensions[trainer]
```

If you are installing locally use
```
pip install -e ".[pytorch_lightning]"
pip install -e ".[torchserve]"
pip install -e ".[trainer]"
```

## Notebooks on colab

1. [Trainer](https://colab.research.google.com/github/lf1-io/padl-extensions/blob/main/notebooks/trainer.ipynb)
1. [TorchServe](https://colab.research.google.com/github/lf1-io/padl-extensions/blob/main/notebooks/torchserve.ipynb)
1. [PyTorch Lightning](https://colab.research.google.com/github/lf1-io/padl-extensions/blob/main/notebooks/pytorch_lightning.ipynb)
1. [Hugging Face](https://colab.research.google.com/github/lf1-io/padl-extensions/blob/main/notebooks/hugging_face.ipynb)
