# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class ProjectUpdateResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'state': 'str',
        'due_date': 'int',
        'archived': 'bool',
        'metadata': 'object',
        'sample_review_percentage': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'state': 'state',
        'due_date': 'due_date',
        'archived': 'archived',
        'metadata': 'metadata',
        'sample_review_percentage': 'sample_review_percentage'
    }

    def __init__(self, id=None, name=None, state=None, due_date=None, archived=None, metadata=None, sample_review_percentage=None, local_vars_configuration=None):  # noqa: E501
        """ProjectUpdateResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._state = None
        self._due_date = None
        self._archived = None
        self._metadata = None
        self._sample_review_percentage = None
        self.discriminator = None

        self.id = id
        if name is not None:
            self.name = name
        if state is not None:
            self.state = state
        if due_date is not None:
            self.due_date = due_date
        if archived is not None:
            self.archived = archived
        if metadata is not None:
            self.metadata = metadata
        if sample_review_percentage is not None:
            self.sample_review_percentage = sample_review_percentage

    @property
    def id(self):
        """Gets the id of this ProjectUpdateResponse.  # noqa: E501

        A unique Project identifier.  # noqa: E501

        :return: The id of this ProjectUpdateResponse.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProjectUpdateResponse.

        A unique Project identifier.  # noqa: E501

        :param id: The id of this ProjectUpdateResponse.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this ProjectUpdateResponse.  # noqa: E501

        The Project name.  # noqa: E501

        :return: The name of this ProjectUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectUpdateResponse.

        The Project name.  # noqa: E501

        :param name: The name of this ProjectUpdateResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def state(self):
        """Gets the state of this ProjectUpdateResponse.  # noqa: E501

        The project's state. The possible states are 'backlog', 'inProgress', 'inReview', 'inQA', and 'done'  # noqa: E501

        :return: The state of this ProjectUpdateResponse.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ProjectUpdateResponse.

        The project's state. The possible states are 'backlog', 'inProgress', 'inReview', 'inQA', and 'done'  # noqa: E501

        :param state: The state of this ProjectUpdateResponse.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def due_date(self):
        """Gets the due_date of this ProjectUpdateResponse.  # noqa: E501

        The due date. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The due_date of this ProjectUpdateResponse.  # noqa: E501
        :rtype: int
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this ProjectUpdateResponse.

        The due date. Measured in seconds since the Unix epoch.  # noqa: E501

        :param due_date: The due_date of this ProjectUpdateResponse.  # noqa: E501
        :type: int
        """

        self._due_date = due_date

    @property
    def archived(self):
        """Gets the archived of this ProjectUpdateResponse.  # noqa: E501

        True if the project is archived. Otherwise, false.  # noqa: E501

        :return: The archived of this ProjectUpdateResponse.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this ProjectUpdateResponse.

        True if the project is archived. Otherwise, false.  # noqa: E501

        :param archived: The archived of this ProjectUpdateResponse.  # noqa: E501
        :type: bool
        """

        self._archived = archived

    @property
    def metadata(self):
        """Gets the metadata of this ProjectUpdateResponse.  # noqa: E501

        Metadata associated with a project. This field must be valid JSON.  # noqa: E501

        :return: The metadata of this ProjectUpdateResponse.  # noqa: E501
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this ProjectUpdateResponse.

        Metadata associated with a project. This field must be valid JSON.  # noqa: E501

        :param metadata: The metadata of this ProjectUpdateResponse.  # noqa: E501
        :type: object
        """

        self._metadata = metadata

    @property
    def sample_review_percentage(self):
        """Gets the sample_review_percentage of this ProjectUpdateResponse.  # noqa: E501

        The Project's sample review percentage. Must be an integer between 10 and 100, a multiple of 10 and greater than minimum value (displayed in error message).  # noqa: E501

        :return: The sample_review_percentage of this ProjectUpdateResponse.  # noqa: E501
        :rtype: int
        """
        return self._sample_review_percentage

    @sample_review_percentage.setter
    def sample_review_percentage(self, sample_review_percentage):
        """Sets the sample_review_percentage of this ProjectUpdateResponse.

        The Project's sample review percentage. Must be an integer between 10 and 100, a multiple of 10 and greater than minimum value (displayed in error message).  # noqa: E501

        :param sample_review_percentage: The sample_review_percentage of this ProjectUpdateResponse.  # noqa: E501
        :type: int
        """

        self._sample_review_percentage = sample_review_percentage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectUpdateResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProjectUpdateResponse):
            return True

        return self.to_dict() != other.to_dict()
