# PageBotOSX

Mac OS X context for PageBot, based on DrawBot.

# Installation

Pagebot runs on Python 3. We recommend updating to version 3.7 / 3.8.

## System Wide

To install `pagebotosx` as a general Python package:

    pip install pagebotosx

Upgrade to the latest if already installed:

    pip install pagebot pagebotosx --upgrade

## Virtual Environment

To setup `pagebotosx` and its requirements in a virtual environemnt environment:

    pip install virtualenv
    mkdir ~/virtualenvironment
    virtualenv ~/virtualenvironment/pagebot
    cd ~/virtualenvironment/pagebot/bin
    source activate
    pip-3.8 install pagebotosx

# Usage

See [github.com/PageBot/PageBot](https://github.com/PageBot/PageBot).

# Issue Tracking 

Bugs, enhancements and requested features can be added to the GitHub issue tracker:

 * https://github.com/PageBot/PageBotOSX/issues
 * https://github.com/PageBot/PageBotOSX/projects
 * https://github.com/PageBot/PageBotOSX/milestones

# External Links

- Download: [PyPi](https://pypi.org/project/pagebotosx/)
- Continuous Integration: [Travis](https://travis-ci.org/PageBot/PageBotOSX)
- Documentation: [ReadTheDocs](https://pagebotosx.readthedocs.io/en/latest/)
- Main PageBot repository: [github.com/PageBot/PageBot](https://github.com/PageBot/PageBot)
- Examples repository: [github.com/PageBot/PageBotExamples](https://github.com/PageBot/PageBotExamples)

# Licencing

- The core library, tutorials and basic examples for PageBot are available
  under the MIT Open Source license. Some depencendies have been included in
  this repository and are available under their own licenses. See also the
  [LICENSE](https://github.com/PageBot/PageBotOSX/blob/master/LICENSE.md).

> PageBot® is a registered trademark 
> U.S. Serial Number: 87-457,280
> Owner: Buro Petr van Blokland + Claudia Mens VOF
> Docket/Reference Number: 1538-25     
