"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
The MIT License

Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import temporalio.api.common.v1.message_pb2
import temporalio.api.enums.v1.batch_operation_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class BatchOperationInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    START_TIME_FIELD_NUMBER: builtins.int
    CLOSE_TIME_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """Batch job ID"""
    state: temporalio.api.enums.v1.batch_operation_pb2.BatchOperationState.ValueType
    """Batch operation state"""
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Batch operation start time"""
    @property
    def close_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Batch operation close time"""
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        state: temporalio.api.enums.v1.batch_operation_pb2.BatchOperationState.ValueType = ...,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        close_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "close_time", b"close_time", "start_time", b"start_time"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "close_time",
            b"close_time",
            "job_id",
            b"job_id",
            "start_time",
            b"start_time",
            "state",
            b"state",
        ],
    ) -> None: ...

global___BatchOperationInfo = BatchOperationInfo

class BatchOperationTermination(google.protobuf.message.Message):
    """BatchOperationTermination sends terminate requests to batch workflows.
    Keep the parameter in sync with temporalio.api.workflowservice.v1.TerminateWorkflowExecutionRequest.
    Ignore first_execution_run_id because this is used for single workflow operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DETAILS_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    @property
    def details(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized value(s) to provide to the termination event"""
    identity: builtins.str
    """The identity of the worker/client"""
    def __init__(
        self,
        *,
        details: temporalio.api.common.v1.message_pb2.Payloads | None = ...,
        identity: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["details", b"details"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "details", b"details", "identity", b"identity"
        ],
    ) -> None: ...

global___BatchOperationTermination = BatchOperationTermination

class BatchOperationSignal(google.protobuf.message.Message):
    """BatchOperationSignal sends signals to batch workflows.
    Keep the parameter in sync with temporalio.api.workflowservice.v1.SignalWorkflowExecutionRequest.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNAL_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    signal: builtins.str
    """The workflow author-defined name of the signal to send to the workflow"""
    @property
    def input(self) -> temporalio.api.common.v1.message_pb2.Payloads:
        """Serialized value(s) to provide with the signal"""
    @property
    def header(self) -> temporalio.api.common.v1.message_pb2.Header:
        """Headers that are passed with the signal to the processing workflow.
        These can include things like auth or tracing tokens.
        """
    identity: builtins.str
    """The identity of the worker/client"""
    def __init__(
        self,
        *,
        signal: builtins.str = ...,
        input: temporalio.api.common.v1.message_pb2.Payloads | None = ...,
        header: temporalio.api.common.v1.message_pb2.Header | None = ...,
        identity: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal["header", b"header", "input", b"input"],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "identity",
            b"identity",
            "input",
            b"input",
            "signal",
            b"signal",
        ],
    ) -> None: ...

global___BatchOperationSignal = BatchOperationSignal

class BatchOperationCancellation(google.protobuf.message.Message):
    """BatchOperationCancellation sends cancel requests to batch workflows.
    Keep the parameter in sync with temporalio.api.workflowservice.v1.RequestCancelWorkflowExecutionRequest.
    Ignore first_execution_run_id because this is used for single workflow operation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDENTITY_FIELD_NUMBER: builtins.int
    identity: builtins.str
    """The identity of the worker/client"""
    def __init__(
        self,
        *,
        identity: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["identity", b"identity"]
    ) -> None: ...

global___BatchOperationCancellation = BatchOperationCancellation
