# Generated by Django 4.0.7 on 2022-08-17 18:32

from django.db import migrations


def forwards(apps, schema_editor):
    Notification = apps.get_model("structures", "Notification")
    qs = Notification.objects.filter(sender__category=5)
    print(f"Updating {qs.count()} notifications with 'other' senders.")
    qs.update(sender=None)


def backwards(apps, schema_editor):
    EveEntity = apps.get_model("structures", "EveEntity")
    ded, _ = EveEntity.objects.get_or_create(
        id=1000137, defaults={"name": "DED", "category": 2}
    )
    Notification = apps.get_model("structures", "Notification")
    qs = Notification.objects.filter(sender__isnull=True)
    print(f"Patching {qs.count()} notifications without a sender.")
    qs.update(sender=ded)


class Migration(migrations.Migration):

    dependencies = [
        ("structures", "0041_notification_sender_can_be_null"),
    ]

    operations = [
        migrations.RunPython(forwards, backwards),
    ]
