# Generated by Django 4.0.7 on 2022-08-11 17:14

import multiselectfield.db.fields

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("structures", "0039_ownercharacter_error_count"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="notification",
            options={"verbose_name": "eve notification"},
        ),
        migrations.AlterField(
            model_name="notification",
            name="notif_type",
            field=models.CharField(
                db_index=True,
                default="",
                help_text="type of this notification",
                max_length=100,
                verbose_name="type",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="owner",
            field=models.ForeignKey(
                help_text="Corporation that owns this notification",
                on_delete=django.db.models.deletion.CASCADE,
                to="structures.owner",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="structures",
            field=models.ManyToManyField(
                help_text="Structures this notification is about (if any)",
                to="structures.structure",
            ),
        ),
        migrations.AlterField(
            model_name="webhook",
            name="notification_types",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    ("StructureAnchoring", "Upwell structure anchoring"),
                    ("StructureOnline", "Upwell structure went online"),
                    (
                        "StructureServicesOffline",
                        "Upwell structure services went offline",
                    ),
                    ("StructureWentHighPower", "Upwell structure went high power"),
                    ("StructureWentLowPower", "Upwell structure went low power"),
                    ("StructureUnanchoring", "Upwell structure unanchoring"),
                    ("StructureFuelAlert", "Upwell structure fuel alert"),
                    ("StructureRefueledExtra", "Upwell structure refueled"),
                    ("StructureJumpFuelAlert", "Upwell structure jump fuel alert"),
                    ("StructureUnderAttack", "Upwell structure is under attack"),
                    ("StructureLostShields", "Upwell structure lost shields"),
                    ("StructureLostArmor", "Upwell structure lost armor"),
                    ("StructureDestroyed", "Upwell structure destroyed"),
                    (
                        "StructuresReinforcementChanged",
                        "Upwell structure reinforcement time changed",
                    ),
                    ("OwnershipTransferred", "Upwell structure ownership transferred"),
                    ("OrbitalAttacked", "Customs office attacked"),
                    ("OrbitalReinforced", "Customs office reinforced"),
                    ("TowerAlertMsg", "Starbase attacked"),
                    ("TowerResourceAlertMsg", "Starbase fuel alert"),
                    ("TowerRefueledExtra", "Starbase refueled (BETA)"),
                    ("TowerReinforcedExtra", "Starbase reinforced (BETA)"),
                    ("MoonminingExtractionStarted", "Moonmining extraction started"),
                    ("MoonminingLaserFired", "Moonmining laser fired"),
                    (
                        "MoonminingExtractionCancelled",
                        "Moonmining extraction cancelled",
                    ),
                    ("MoonminingExtractionFinished", "Moonmining extraction finished"),
                    (
                        "MoonminingAutomaticFracture",
                        "Moonmining automatic fracture triggered",
                    ),
                    ("SovStructureReinforced", "Sovereignty structure reinforced"),
                    ("SovStructureDestroyed", "Sovereignty structure destroyed"),
                    ("EntosisCaptureStarted", "Sovereignty entosis capture started"),
                    (
                        "SovCommandNodeEventStarted",
                        "Sovereignty command node event started",
                    ),
                    ("SovAllClaimAquiredMsg", "Sovereignty claim acknowledgment"),
                    ("SovAllClaimLostMsg", "Sovereignty lost"),
                    ("AllAnchoringMsg", "Structure anchoring in alliance space"),
                    ("WarDeclared", "War declared"),
                    ("AllyJoinedWarAggressorMsg", "War ally joined aggressor"),
                    ("AllyJoinedWarAllyMsg", "War ally joined ally"),
                    ("AllyJoinedWarDefenderMsg", "War ally joined defender"),
                    ("WarAdopted", "War adopted"),
                    ("WarInherited", "War inherited"),
                    ("CorpWarSurrenderMsg", "War party surrendered"),
                    ("WarRetractedByConcord", "War retracted by Concord"),
                    ("CorpBecameWarEligible", "War corporation became eligible"),
                    ("CorpNoLongerWarEligible", "War corporation no longer eligible"),
                    ("WarSurrenderOfferMsg", "War surrender offered"),
                    ("CorpAppNewMsg", "Character submitted application"),
                    ("CorpAppInvitedMsg", "Character invited to join corporation"),
                    ("CorpAppRejectCustomMsg", "Corp application rejected"),
                    ("CharAppWithdrawMsg", "Character withdrew application"),
                    ("CharAppAcceptMsg", "Character joins corporation"),
                    ("CharLeftCorpMsg", "Character leaves corporation"),
                    ("BillOutOfMoneyMsg", "Bill out of money"),
                    (
                        "InfrastructureHubBillAboutToExpire",
                        "I-HUB bill about to expire",
                    ),
                    ("IHubDestroyedByBillFailure", "I_HUB destroyed by bill failure"),
                ],
                default=[
                    "StructureAnchoring",
                    "StructureDestroyed",
                    "StructureFuelAlert",
                    "StructureLostArmor",
                    "StructureLostShields",
                    "StructureOnline",
                    "StructureServicesOffline",
                    "StructureUnderAttack",
                    "StructureWentHighPower",
                    "StructureWentLowPower",
                    "OrbitalAttacked",
                    "OrbitalReinforced",
                    "TowerAlertMsg",
                    "TowerResourceAlertMsg",
                    "SovStructureReinforced",
                    "SovStructureDestroyed",
                ],
                help_text="select which type of notifications should be forwarded to this webhook",
                max_length=1123,
            ),
        ),
        migrations.CreateModel(
            name="GeneratedNotification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "is_sent",
                    models.BooleanField(
                        default=False,
                        help_text="True when this notification has been forwarded to Discord",
                    ),
                ),
                (
                    "is_timer_added",
                    models.BooleanField(
                        default=False,
                        help_text="True when a timer has been added for this notification",
                        null=True,
                    ),
                ),
                (
                    "notif_type",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="type of this notification",
                        max_length=100,
                        verbose_name="type",
                    ),
                ),
                ("details", models.JSONField(default=dict)),
                ("last_updated", models.DateTimeField(auto_now=True)),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "owner",
                    models.ForeignKey(
                        help_text="Corporation that owns this notification",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="structures.owner",
                    ),
                ),
                (
                    "structures",
                    models.ManyToManyField(
                        help_text="Structures this notification is about (if any)",
                        to="structures.structure",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
