<!-- PROJECT LOGO -->
<br />
<p align="center">
  <a href="https://github.com/vasqua/argus_dynamixel">
    <img src="images/logo.png" alt="Logo">
  </a>

  <h3 align="center">argus_dynamixel</h3>

  <p align="center">
    A Python wrapper with the necessary methods to enable Dynamixel usage on Argus Array hardware.
    <br />
    <a href="https://github.com/vasqua/argus_dynamixel"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="https://github.com/vasqua/argus_dynamixel">View Demo</a>
    ·
    <a href="https://github.com/vasqua/argus_dynamixel/issues">Report Bug</a>
    ·
    <a href="https://github.com/vasqua/argus_dynamixel/issues">Request Feature</a>
  </p>
</p>

<!-- TABLE OF CONTENTS -->
<details open="open">
  <summary><h2 style="display: inline-block">Table of Contents</h2></summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With</a></li>
      </ul>
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
      <ul>
        <li><a href="#prerequisites">Prerequisites</a></li>
        <li><a href="#installation">Installation</a></li>
      </ul>
    </li>
    <li><a href="#usage">Usage</a></li>
    <li><a href="#roadmap">Roadmap</a></li>
    <li><a href="#contributing">Contributing</a></li>
    <li><a href="#license">License</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#acknowledgements">Acknowledgements</a></li>
  </ol>
</details>

<!-- ABOUT THE PROJECT -->
## About The Project

`argus_dynamixel` is a Python package that provides a wrapper for the Dynamixel SDK, specifically tailored for the Argus Array project. This package simplifies the integration and control of Dynamixel motors within the Argus Array hardware setup.

### Built With

* [Python](https://www.python.org/)
* [Dynamixel SDK](https://github.com/ROBOTIS-GIT/DynamixelSDK)
* [Poetry](https://python-poetry.org/)

<!-- GETTING STARTED -->
## Getting Started

To get a local copy up and running follow these simple steps.

### Prerequisites

* [Poetry](https://python-poetry.org)
* Python 3.10 or later

### Installation

1. Clone the repo
   ```sh
   git clone https://github.com/vasqua/argus_dynamixel
   ```
2. Create the Poetry environment
   ```sh
   cd argus_dynamixel/
   poetry install
   ```
3. Activate the shell and run the package
   ```sh
   poetry shell
   poetry run ...
   ```

<!-- USAGE EXAMPLES -->
## Usage

Here are some examples of how to use the `argus_dynamixel` package:

```python
from argus_dynamixel import DynamixelController

# Initialize the controller
controller = DynamixelController(port='/dev/ttyUSB0', baudrate=57600)

# Enable a motor
controller.enable_motor(dxl_id=1)

# Set motor position
controller.set_position(dxl_id=1, position=512)

# Get motor position
position = controller.get_position(dxl_id=1)
print(f"Motor position: {position}")

# Disable the motor
controller.disable_motor(dxl_id=1)
```

_For more examples, please refer to the [Documentation](https://github.com/vasqua/argus_dynamixel)_

<!-- ROADMAP -->
## Roadmap

See the [open issues](https://github.com/vasqua/argus_dynamixel/issues) for a list of proposed features (and known issues).

<!-- CONTRIBUTING -->
## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**.

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

<!-- LICENSE -->
## License

Distributed under the MIT License. See `LICENSE` for more information.

<!-- CONTACT -->
## Contact

Alan Vasquez - vasqua@unc.edu

Project Link: [https://github.com/vasqua/argus_dynamixel](https://github.com/vasqua/argus_dynamixel)

<!-- ACKNOWLEDGEMENTS -->
## Acknowledgements

* [ROBOTIS-GIT](https://github.com/ROBOTIS-GIT)
* [Python Software Foundation](https://www.python.org/psf/)
* [Poetry](https://python-poetry.org/)
