"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitoringAgentProcess = exports.MonitoringAgentProcessProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "MonitoringAgentProcessProperty", { enumerable: true, get: function () { return cms_generated_1.RosMonitoringAgentProcess; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::MonitoringAgentProcess`
 */
class MonitoringAgentProcess extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::MonitoringAgentProcess`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosMonitoringAgentProcess = new cms_generated_1.RosMonitoringAgentProcess(this, id, {
            processName: props.processName,
            instanceId: props.instanceId,
            processUser: props.processUser,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMonitoringAgentProcess;
        this.attrId = rosMonitoringAgentProcess.attrId;
    }
}
exports.MonitoringAgentProcess = MonitoringAgentProcess;
//# sourceMappingURL=data:application/json;base64,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