"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupMetricRule = exports.GroupMetricRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "GroupMetricRuleProperty", { enumerable: true, get: function () { return cms_generated_1.RosGroupMetricRule; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::GroupMetricRule`
 */
class GroupMetricRule extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::GroupMetricRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosGroupMetricRule = new cms_generated_1.RosGroupMetricRule(this, id, {
            noEffectiveInterval: props.noEffectiveInterval,
            silenceTime: props.silenceTime,
            category: props.category,
            ruleId: props.ruleId,
            dimensions: props.dimensions,
            period: props.period,
            effectiveInterval: props.effectiveInterval,
            namespace: props.namespace,
            groupId: props.groupId,
            metricName: props.metricName,
            escalations: props.escalations,
            emailSubject: props.emailSubject,
            webhook: props.webhook,
            ruleName: props.ruleName,
            interval: props.interval,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosGroupMetricRule;
        this.attrRuleId = rosGroupMetricRule.attrRuleId;
    }
}
exports.GroupMetricRule = GroupMetricRule;
//# sourceMappingURL=data:application/json;base64,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