"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventRule = exports.EventRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "EventRuleProperty", { enumerable: true, get: function () { return cms_generated_1.RosEventRule; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::EventRule`
 */
class EventRule extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::EventRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosEventRule = new cms_generated_1.RosEventRule(this, id, {
            eventPattern: props.eventPattern,
            description: props.description,
            eventType: props.eventType,
            state: props.state,
            ruleName: props.ruleName,
            groupId: props.groupId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosEventRule;
        this.attrData = rosEventRule.attrData;
    }
}
exports.EventRule = EventRule;
//# sourceMappingURL=data:application/json;base64,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