﻿
#Область ОписаниеПеременных

&НаКлиенте
Перем Операции;

&НаКлиенте
Перем ТекстовыйДокумент;

#КонецОбласти

#Область ОбработчикиСобытий

&НаКлиенте
Процедура ПриОткрытии(Отказ)
	
	ПутьКПлатформе = ПолучитьПутьКПлатформе();
	СтрокаПодключенияКБазе = СтрокаСоединенияИнформационнойБазы();
	Логин = ИмяПользователяНаСервере();

	ЗаполнитьСписокВыбораТипаОперации();
	ПрочитатьПутьКРепозитарию();
	
	Если ПустаяСтрока(ТипОперации) Тогда
		ТипОперации = Операции.ПолнаяВыгрузкаCF;
	КонецЕсли;
	
КонецПроцедуры

&НаСервере
Процедура ОбработкаПроверкиЗаполненияНаСервере(Отказ, ПроверяемыеРеквизиты)
	
	Если Не ПустаяСтрока(Логин) Тогда
		ПроверяемыеРеквизиты.Добавить("Пароль");
	КонецЕсли;
	
КонецПроцедуры

#КонецОбласти

#Область ОбработчикиКомандФормы

&НаКлиенте
Процедура Сделать(Команда)
	
	Если Не ПроверитьЗаполнение() Тогда
		Возврат;
	КонецЕсли;
	
	Оповещение = Новый ОписаниеОповещения("ВыполнитьОперациюСВопросомЗавершение", ЭтаФорма);
	
	Если ТипОперации = Операции.СоздатьEPF Тогда
		ПоказатьВопрос(Новый ОписаниеОповещения("РезультатВопросаПередОперациейСозданияEpf", ЭтаФорма, Оповещение),
		               "Будут заново созданы файлы. Продолжить?",
		               РежимДиалогаВопрос.ДаНет,
		               60,
		               КодВозвратаДиалога.Нет,
		               "Внимание",
		               КодВозвратаДиалога.Нет);
	Иначе
		ВыполнитьОбработкуОповещения(Оповещение, Истина);
	КонецЕсли;
	
КонецПроцедуры

#КонецОбласти

#Область ОбработчикиСобытийЭлементовШапкиФормы

&НаКлиенте
Процедура ПутьКПлатформеНачалоВыбора(Элемент, ДанныеВыбора, СтандартнаяОбработка)
	НачалоВыбораФайла(Элемент, СтандартнаяОбработка);
КонецПроцедуры

&НаКлиенте
Процедура ПапкаВыгрузкиНачалоВыбора(Элемент, ДанныеВыбора, СтандартнаяОбработка)
	НачалоВыбораФайла(Элемент, СтандартнаяОбработка);
КонецПроцедуры

#КонецОбласти

#Область СлужебныйПрограммныйИнтерфейс

&НаКлиенте
Процедура УстановитьПапкуВыгрузкиПоПутиВФайле(Знач Существует, Знач ДополнительныеПараметры) Экспорт
	
	Если Не Существует Тогда
		Возврат;
	КонецЕсли;
	
	ЧтениеТекста = Новый ЧтениеТекста(ДополнительныеПараметры.ИмяФайла);
	ПутьКРепозитарию = ЧтениеТекста.ПрочитатьСтроку();
	ЧтениеТекста.Закрыть();
	
	ПапкаВыгрузки = ПутьКРепозитарию + "\";
	
КонецПроцедуры

&НаКлиенте
Процедура УстановитьВыбранныйПуть(Знач ВыбранныеФайлы, Знач ДополнительныеПараметры) Экспорт
	
	Если ВыбранныеФайлы = Неопределено Тогда
		Возврат;
	КонецЕсли;
	
	ЭтаФорма[ДополнительныеПараметры.ИмяЭлемента] = ВыбранныеФайлы[0] + "\";
	
КонецПроцедуры

&НаКлиенте
Процедура РезультатВопросаПередОперациейСозданияEpf(Знач РезультатВопроса, Знач ДополнительныеПараметры) Экспорт
	ВыполнитьОбработкуОповещения(ДополнительныеПараметры, РезультатВопроса = КодВозвратаДиалога.Да);
КонецПроцедуры

&НаКлиенте
Процедура ВыполнитьОперациюСВопросомЗавершение(Знач Результат, Знач ДополнительныеПараметры) Экспорт
	
	Если Не Результат Тогда
		Возврат;
	КонецЕсли;
	
	ВыполнитьОперацию(ТипОперации);
	
КонецПроцедуры

&НаКлиенте
Процедура ЧтениеЛогаЗавершение(Знач ДополнительныеПараметры) Экспорт
	ТекстовыйДокумент.Показать("Ошибка при выполнении операции");
	НачатьУдалениеФайлов(Неопределено, ДополнительныеПараметры.Лог);
КонецПроцедуры

&НаКлиенте
Процедура ЗапуститьКомандуЗавершение(Знач КодВозврата, Знач ДополнительныеПараметры) Экспорт
	
	Если КодВозврата = 0 Тогда
		Возврат;
	КонецЕсли;
		
	ТекстовыйДокумент = Новый ТекстовыйДокумент;
	ТекстовыйДокумент.НачатьЧтение(Новый ОписаниеОповещения("ЧтениеЛогаЗавершение",
	                                                        ЭтаФорма,
	                                                        Новый Структура("Лог", ДополнительныеПараметры.Лог)),
	                               ДополнительныеПараметры.Лог,
	                               КодировкаТекста.UTF8);
	
КонецПроцедуры

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

&НаКлиенте
Функция ПолучитьПутьКПлатформе()
	Возврат СтрЗаменить(КаталогПрограммы(), "\bin", "");
КонецФункции

&НаКлиенте
Процедура ВыполнитьОперацию(Знач ВыбраннаяОперация)
	
	СтрокаДляЗапуска = "";
	ПараметрыКоманднойСтроки = РеквизитыФормыВСтруктуру();
	
	Если ВыбраннаяОперация = Операции.ПолнаяВыгрузкаCF Или ВыбраннаяОперация = Операции.ЧастичнаяВыгрузкаCF Тогда
		ПараметрыКоманднойСтроки.Вставить("Команда", "dump_config");
		СтрокаДляЗапуска = "--folder ""%ПапкаВыгрузкиКонфигурации%""";
		Если КонфигурацияСОшибкамиВыгрузки() Тогда
			СтрокаДляЗапуска = СтрокаДляЗапуска + " --repair"
		КонецЕсли;
		Если ВыбраннаяОперация = Операции.ЧастичнаяВыгрузкаCF Тогда
			СтрокаДляЗапуска = СтрокаДляЗапуска + " --update"
		КонецЕсли;
	ИначеЕсли ВыбраннаяОперация = Операции.ВыгрузкаCFE Тогда
		ПараметрыКоманднойСтроки.Вставить("Команда", "dump_extensions");
		СтрокаДляЗапуска = "--folder ""%ПапкаВыгрузкиРасширений%""";
	ИначеЕсли ВыбраннаяОперация = Операции.ВыгрузкаEPF Тогда
		ПараметрыКоманднойСтроки.Вставить("Команда", "sync");
		СтрокаДляЗапуска = "--folder ""%ПапкаВыгрузки%""";
	ИначеЕсли ВыбраннаяОперация = Операции.СоздатьEPF Тогда
		ПараметрыКоманднойСтроки.Вставить("Команда", "sync");
		СтрокаДляЗапуска = "--folder ""%ПапкаВыгрузки%"" --create";
	КонецЕсли;
	
	ЗапуститьКоманду(СтрокаДляЗапуска, ПараметрыКоманднойСтроки);
	
КонецПроцедуры

&НаКлиенте
Процедура ЗапуститьКоманду(Знач СтрокаДляЗапуска, Знач ПараметрыКоманднойСтроки)
	
	Команда = ПодставитьПараметрыВСтроку(СтрокаЗапускаСкрипта(Истина, Отладка) + " " + СтрокаДляЗапуска, ПараметрыКоманднойСтроки);
	
	Если Отладка Тогда
		Сообщение(Команда);
	Иначе
		НачатьЗапускПриложения(Новый ОписаниеОповещения("ЗапуститьКомандуЗавершение",
		                                                ЭтаФорма,
		                                                Новый Структура("Лог", ПараметрыКоманднойСтроки.Лог)),
		                       Команда,
		                       ,
		                       Истина);
	КонецЕсли;
	
КонецПроцедуры

&НаКлиенте
Функция РеквизитыФормыВСтруктуру()
	
	Структура = Новый Структура;
	Структура.Вставить("КодРазблокировки",          ?(ПустаяСтрока(КодРазблокировки), "None", КодРазблокировки));
	Структура.Вставить("Логин",                     Логин);
	Структура.Вставить("ПапкаВыгрузки",             Лев(ПапкаВыгрузки, СтрДлина(ПапкаВыгрузки)-1));
	Структура.Вставить("ПапкаВыгрузкиКонфигурации", Структура.ПапкаВыгрузки + "\cf");
	Структура.Вставить("ПапкаВыгрузкиРасширений",   Структура.ПапкаВыгрузки + "\lib\ext");
	Структура.Вставить("Пароль",                    Пароль);
	Структура.Вставить("ПутьКПлатформе",            Лев(ПутьКПлатформе, СтрДлина(ПутьКПлатформе)-1));
	Структура.Вставить("СтрокаПодключенияКБазе",    СтрокаПодключенияКБазе);
	Структура.Вставить("Лог",                       ПолучитьИмяВременногоФайла("txt"));
	
	Возврат Структура;
	
КонецФункции

&НаСервереБезКонтекста
Функция ИмяПользователяНаСервере()
	Возврат ИмяПользователя();
КонецФункции

&НаКлиенте
Процедура ЗаполнитьСписокВыбораТипаОперации()
	
	Для Каждого ТипОперции Из Операции Цикл
		Элементы.ТипОперации.СписокВыбора.Добавить(ТипОперции.Значение);
	КонецЦикла;

КонецПроцедуры

&НаКлиенте
Процедура ПрочитатьПутьКРепозитарию()
	
	Если Не ИнформационнаяБазаФайловая(СтрокаПодключенияКБазе) Тогда
		Возврат;
	КонецЕсли;
	
	Структура = ПолучитьПараметрыИзСтроки(СтрокаПодключенияКБазе);
	
	ПутьКФайлуРепозитария = Структура.File + "\GitPath.txt";
	
	Файл = Новый Файл(ПутьКФайлуРепозитария);
	Файл.НачатьПроверкуСуществования(Новый ОписаниеОповещения("УстановитьПапкуВыгрузкиПоПутиВФайле",
	                                                          ЭтаФорма,
	                                                          Новый Структура("ИмяФайла", ПутьКФайлуРепозитария)));
	
КонецПроцедуры

&НаКлиенте
Процедура НачалоВыбораФайла(Знач Элемент, СтандартнаяОбработка)
	
	СтандартнаяОбработка = Ложь;
	
	ДиалогВыбораФайла = Новый ДиалогВыбораФайла(РежимДиалогаВыбораФайла.ВыборКаталога);
		
	Если ЗначениеЗаполнено(Элемент.ТекстРедактирования) Тогда
		
		Файл = Новый Файл(Элемент.ТекстРедактирования);
		ДиалогВыбораФайла.Каталог = Файл.Путь;
		
	КонецЕсли;
	
	ДиалогВыбораФайла.Показать(Новый ОписаниеОповещения("УстановитьВыбранныйПуть",
	                                                    ЭтаФорма,
	                                                    Новый Структура("ИмяЭлемента", Элемент.Имя)));
	
КонецПроцедуры

&НаСервереБезКонтекста
Функция КонфигурацияСОшибкамиВыгрузки()
	
	Если Метаданные.РегистрыСведений.Найти("ВерсииПодсистем")<>Неопределено Тогда
		Возврат Истина;
	ИначеЕсли Метаданные.Имя = "УправлениеТорговлей" И Лев(Метаданные.Версия, 4) = "10.3" Тогда
		Возврат Истина;
	КонецЕсли;
	
	Возврат Ложь;
	
КонецФункции

&НаКлиенте
Функция СтрокаЗапускаСкрипта(Знач ТекущаяБаза = Истина, Знач Отладка = Ложь)
	
	Шаблон = "runner1c";
	Если Отладка Тогда
		Шаблон = Шаблон + " --debug";
	КонецЕсли;
	Шаблон = Шаблон + " %Команда%";
	
	ПараметрыДляДобавления = Новый Массив;
	
	Если ТекущаяБаза Тогда
		
		ПараметрыДляДобавления.Добавить(" --log ""%Лог%""");
		ПараметрыДляДобавления.Добавить("silent");
		ПараметрыДляДобавления.Добавить("path ""%ПутьКПлатформе%""");
	
		Если Не ПустаяСтрока(КодРазблокировки) Тогда
			ПараметрыДляДобавления.Добавить("access %КодРазблокировки%");
		КонецЕсли;
		
		Если Не ПустаяСтрока(Логин) Тогда
			ПараметрыДляДобавления.Добавить("login ""%Логин%""");
			ПараметрыДляДобавления.Добавить("password %Пароль%");
		КонецЕсли;
		
		ПараметрыДляДобавления.Добавить("connection ""%СтрокаПодключенияКБазе%""");
		
	КонецЕсли;
	
	Возврат Шаблон + Соединить(ПараметрыДляДобавления, " --");
	
КонецФункции

&НаКлиенте
Функция ИнформационнаяБазаФайловая(Знач СтрокаСоединенияИнформационнойБазы = "")
			
	Если ПустаяСтрока(СтрокаСоединенияИнформационнойБазы) Тогда
		СтрокаСоединенияИнформационнойБазы =  СтрокаСоединенияИнформационнойБазы();
	КонецЕсли;
	Возврат Найти(Врег(СтрокаСоединенияИнформационнойБазы), "FILE=") = 1;
	
КонецФункции

&НаКлиенте
Функция ПолучитьПараметрыИзСтроки(Знач СтрокаПараметров)
	
	Результат = Новый Структура;
	
	СимволДвойныеКавычки = Символ(34); // (")
	
	МассивПодстрок = РазложитьСтрокуВМассивПодстрок(СтрокаПараметров, ";");
	
	Для Каждого СтрокаПараметра Из МассивПодстрок Цикл
		
		ПозицияПервогоЗнакаРавенства = Найти(СтрокаПараметра, "=");
		
		// Получаем имя параметра
		ИмяПараметра = СокрЛП(Лев(СтрокаПараметра, ПозицияПервогоЗнакаРавенства - 1));
		
		// Получаем значение параметра.
		ЗначениеПараметра = СокрЛП(Сред(СтрокаПараметра, ПозицияПервогоЗнакаРавенства + 1));
		
		Если  Лев(ЗначениеПараметра, 1) = СимволДвойныеКавычки
			И Прав(ЗначениеПараметра, 1) = СимволДвойныеКавычки Тогда
			
			ЗначениеПараметра = Сред(ЗначениеПараметра, 2, СтрДлина(ЗначениеПараметра) - 2);
			
		КонецЕсли;
		
		Если Не ПустаяСтрока(ИмяПараметра) Тогда
			
			Результат.Вставить(ИмяПараметра, ЗначениеПараметра);
			
		КонецЕсли;
		
	КонецЦикла;
	
	Возврат Результат;
КонецФункции

&НаКлиенте
Функция РазложитьСтрокуВМассивПодстрок(Знач Стр, Разделитель = ",")
	
	МассивСтрок = Новый Массив();
	Если Разделитель = " " Тогда
		Стр = СокрЛП(Стр);
		Пока Истина Цикл
			Поз = Найти(Стр,Разделитель);
			Если Поз=0 Тогда
				МассивСтрок.Добавить(Стр);
				Возврат МассивСтрок;
			КонецЕсли;
			МассивСтрок.Добавить(Лев(Стр,Поз-1));
			Стр = СокрЛ(Сред(Стр,Поз));
		КонецЦикла;
	Иначе
		ДлинаРазделителя = СтрДлина(Разделитель);
		Пока Истина Цикл
			Поз = Найти(Стр,Разделитель);
			Если Поз=0 Тогда
				МассивСтрок.Добавить(Стр);
				Возврат МассивСтрок;
			КонецЕсли;
			МассивСтрок.Добавить(Лев(Стр,Поз-1));
			Стр = Сред(Стр,Поз+ДлинаРазделителя);
		КонецЦикла;
	КонецЕсли;
	
КонецФункции

&НаКлиенте
Функция ПодставитьПараметрыВСтроку(Шаблон, Знач ПарметрыСтроки)
	
	Строка = Шаблон;
	Для Каждого Элемент Из ПарметрыСтроки Цикл
		Строка = СтрЗаменить(Строка, "%" + Элемент.Ключ+ "%", Элемент.Значение);
	КонецЦикла;
		
	Возврат Строка;
	
КонецФункции

&НаКлиенте
Процедура Сообщение(Знач Текст)
	
	СообщениеПользователю = Новый СообщениеПользователю;
	СообщениеПользователю.Текст = Текст;
	СообщениеПользователю.Сообщить();
	
КонецПроцедуры

&НаКлиенте
Функция Соединить(Знач Строки, Знач Разделитель)
	
	Результат = "";
	
	Для Каждого Строка Из Строки Цикл
		Результат = Результат + ?(ПустаяСтрока(Результат), "", Разделитель) + Строка;
	КонецЦикла;
	
	Возврат Результат;
	
КонецФункции

#КонецОбласти

#Область Инициализация

Операции = Новый Структура;
Операции.Вставить("ПолнаяВыгрузкаCF", "CF Полная Выгрузка");
Операции.Вставить("ЧастичнаяВыгрузкаCF", "CF Частичная Выгрузка");
Операции.Вставить("ВыгрузкаEPF", "EPF Выгрузка");
Операции.Вставить("СоздатьEPF", "EPF Создать");
Операции.Вставить("ВыгрузкаCFE", "CFE Выгрузка");

#КонецОбласти
