# Data-driven solver for truss structures

[![travis](https://img.shields.io/travis/tianyikillua/ddtruss.svg?style=flat-square)](https://travis-ci.org/tianyikillua/ddtruss)
[![codecov](https://img.shields.io/codecov/c/github/tianyikillua/ddtruss.svg?style=flat-square)](https://codecov.io/gh/tianyikillua/ddtruss)
[![readthedocs](https://readthedocs.org/projects/ddtruss/badge/?version=latest&style=flat-square)](https://readthedocs.org/projects/ddtruss/?badge=latest)
[![pypi](https://img.shields.io/pypi/v/ddtruss.svg?style=flat-square)](https://pypi.org/project/ddtruss)

This repository provides a Python implementation of the data-driven solver for truss structures described in [Kirchdoerfer, T., & Ortiz, M. (2016). Data-driven computational mechanics. Computer Methods in Applied Mechanics and Engineering, 304, 81-101](https://www.sciencedirect.com/science/article/pii/S0045782516300238).

![](https://user-images.githubusercontent.com/4027283/63096980-9561cb00-bf6f-11e9-88a7-d07081138f19.png)

Some notebook examples can be found in `examples`.

Documentation is available [here](https://ddtruss.readthedocs.io).

### Installation

To install `ddtruss`, you are invited to use `pip` and its associated options
```
pip install -U ddtruss
```

### Testing

To run the `ddtruss` unit tests, check out this repository and type
```
pytest
```

### License

`ddtruss` is published under the [MIT license](https://en.wikipedia.org/wiki/MIT_License).
