# Djangae

**NOTE: If you are using Django 1.11 / Python 2.7, please use the 1.x branch - master will not work for you**

[![Join the chat at https://gitter.im/potatolondon/djangae](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/potatolondon/djangae?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![build-status-image]][travis]

The best way to run Django on Google App Engine.

Djangae (djan-gee) is a Django app that allows you to run Django applications on Google App Engine, including (if you
want to) using Django's models with the App Engine Datastore as the underlying database.

:earth_africa:&nbsp;&nbsp;[Website](https://djangae.org)&nbsp;&nbsp;|&nbsp;&nbsp;
:octocat:&nbsp;&nbsp;[GitHub](https://github.com/potatolondon/djangae)&nbsp;&nbsp;|&nbsp;&nbsp;
:closed_book:&nbsp;&nbsp; [Docs](https://djangae.readthedocs.io/)&nbsp;&nbsp;|&nbsp;&nbsp;
:speech_balloon:&nbsp;&nbsp;[Gitter](https://gitter.im/potatolondon/djangae)&nbsp;&nbsp;|&nbsp;&nbsp;
:busts_in_silhouette:&nbsp;&nbsp;[Google Group](https://groups.google.com/forum/#!forum/djangae-users)

**Note: Djangae is under heavy development, stability is not guaranteed. See [1.0 release changes issue](https://github.com/potatolondon/djangae/issues/593) to follow progress on Djangae 1.0 release.**

## Features

* A WSGI middleware that provides a clean way via which your Django app is plugged into App Engine.
* A hook to allow App Engine's deferred tasks and mapreduce handlers to run through the same environment.
* The ability to use the Datastore as the database for Django's models.  See **The Database Backend** for details.
  You can also use App Engine's NDB, or you can use Google Cloud SQL (via the standard django MySQL backend) instead of
  or along side the Datastore. Or use all 3!
* `djangae.contrib.gauth` which provides user models (both concrete and extendable abstract versions), an auth backend, and a middleware; which allow you to authenticate users using the App Engine's built-in Google Accounts authentication, and also allow you to use Django's permissions system on the Datastore (i.e. without being caught out by the Many-To-Many relationships).
* A `runserver` command which fires up the App Engine SDK to serve your app (while still using Django's code reloading).
* The ability to run management commands locally or on the remote App Engine Datastore.
* A `shell` command that correctly sets up the environment/database. (Note, we should support this set up for any
  custom commands as well, see TODO.md).

## Documentation

https://djangae.readthedocs.io/

## Supported Django Versions

The intention is always to support the currently-supported versions of Django, although older versions may work. Currently
Django 1.8, 1.9, 1.10 and 1.11 are supported.

# Installation

See https://djangae.readthedocs.io/en/latest/installation/


# Contributing to Djangae

Djangae is actively developed and maintained, so if you're thinking of contributing to the codebase, here is how to get started.

## Get started with development

1. First off, head to [our Github page](https://github.com/potatolondon/djangae) and fork the repository to have your own copy of it.
2. Clone it locally to start setting up your development environment
3. Run all tests to make sure your local version is working: `./runtests.sh`. This will also install all necessary dependencies.

## Pick an issue & send a pull request

If you spotted a bug in Djangae that you want to fix, it's a good idea to start
off by [adding an issue](https://github.com/potatolondon/djangae/issues/new).
This will allow us to verify that your issue is valid, and suggest ideas for fixing it, so
no time is wasted for you.

For help with creating the pull request, check out [Github documentation](https://help.github.com/articles/creating-a-pull-request/).

## Code style

Code style should follow PEP-8 with a loose line length of 100 characters.

## Need help?

Reach out to us on [djangae-users](https://groups.google.com/forum/#!forum/djangae-users) mailing list.

## Pull request requirements

For pull request to be merged, following requirements should be met:

- Tests covering new or changed code are added or updated
- Relevant documentation should be updated or added
- Line item should be added to CHANGELOG.md, unless change is really irrelevant

# Running tests

For running the tests, you just need to run:

    $ ./runtests.sh

On the first run this will download the App Engine SDK, pip install a bunch of stuff locally (into a folder, no virtualenv needed), download the Django tests and run them.  Subsequent runs will just run the tests. If you want to run the tests on a specific Django version, you can switch the installed version by doing:

    $ DJANGO_VERSION=1.11 ./runtests.sh --install_deps

Currently the default is 1.8. TravisCI runs on 1.8, 1.9, 1.10 and 1.11 currently.

If you want to run the tests on a specific App Engine SDK version, then you can switch the installed version by doing:

    $ SDK_VERSION=1.9.35 ./runtests.sh --install_sdk

Note that this also re-installs the dependencies, so will reset the Django version to the default of 1.8.



You can run specific tests in the usual way by doing:

    ./runtests.sh some_app.SomeTestCase.some_test_method


[build-status-image]: https://secure.travis-ci.org/potatolondon/djangae.png?branch=master
[travis]: https://travis-ci.org/potatolondon/djangae?branch=master
