# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class UserCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'first_name': 'str',
        'last_name': 'str',
        'email': 'str',
        'application_role_code': 'ApplicationRoleCode',
        'corporations': 'list[UserRequestCorporationChild]',
        'locations': 'list[UserRequestLocationChild]'
    }

    attribute_map = {
        'first_name': 'FirstName',
        'last_name': 'LastName',
        'email': 'Email',
        'application_role_code': 'ApplicationRoleCode',
        'corporations': 'Corporations',
        'locations': 'Locations'
    }

    def __init__(self, first_name=None, last_name=None, email=None, application_role_code=None, corporations=None, locations=None):  # noqa: E501
        """UserCreateRequest - a model defined in Swagger"""  # noqa: E501
        self._first_name = None
        self._last_name = None
        self._email = None
        self._application_role_code = None
        self._corporations = None
        self._locations = None
        self.discriminator = None
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.application_role_code = application_role_code
        if corporations is not None:
            self.corporations = corporations
        if locations is not None:
            self.locations = locations

    @property
    def first_name(self):
        """Gets the first_name of this UserCreateRequest.  # noqa: E501

        The user's first name  # noqa: E501

        :return: The first_name of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this UserCreateRequest.

        The user's first name  # noqa: E501

        :param first_name: The first_name of this UserCreateRequest.  # noqa: E501
        :type: str
        """
        if first_name is None:
            raise ValueError("Invalid value for `first_name`, must not be `None`")  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this UserCreateRequest.  # noqa: E501

        The user's last name  # noqa: E501

        :return: The last_name of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this UserCreateRequest.

        The user's last name  # noqa: E501

        :param last_name: The last_name of this UserCreateRequest.  # noqa: E501
        :type: str
        """
        if last_name is None:
            raise ValueError("Invalid value for `last_name`, must not be `None`")  # noqa: E501

        self._last_name = last_name

    @property
    def email(self):
        """Gets the email of this UserCreateRequest.  # noqa: E501

        User's email  # noqa: E501

        :return: The email of this UserCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserCreateRequest.

        User's email  # noqa: E501

        :param email: The email of this UserCreateRequest.  # noqa: E501
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def application_role_code(self):
        """Gets the application_role_code of this UserCreateRequest.  # noqa: E501


        :return: The application_role_code of this UserCreateRequest.  # noqa: E501
        :rtype: ApplicationRoleCode
        """
        return self._application_role_code

    @application_role_code.setter
    def application_role_code(self, application_role_code):
        """Sets the application_role_code of this UserCreateRequest.


        :param application_role_code: The application_role_code of this UserCreateRequest.  # noqa: E501
        :type: ApplicationRoleCode
        """
        if application_role_code is None:
            raise ValueError("Invalid value for `application_role_code`, must not be `None`")  # noqa: E501

        self._application_role_code = application_role_code

    @property
    def corporations(self):
        """Gets the corporations of this UserCreateRequest.  # noqa: E501

        The corporations the user belongs to. Saas users should not belong to any corporations  # noqa: E501

        :return: The corporations of this UserCreateRequest.  # noqa: E501
        :rtype: list[UserRequestCorporationChild]
        """
        return self._corporations

    @corporations.setter
    def corporations(self, corporations):
        """Sets the corporations of this UserCreateRequest.

        The corporations the user belongs to. Saas users should not belong to any corporations  # noqa: E501

        :param corporations: The corporations of this UserCreateRequest.  # noqa: E501
        :type: list[UserRequestCorporationChild]
        """

        self._corporations = corporations

    @property
    def locations(self):
        """Gets the locations of this UserCreateRequest.  # noqa: E501

        The locations the user belongs to. Saas users should not belong to any locations  # noqa: E501

        :return: The locations of this UserCreateRequest.  # noqa: E501
        :rtype: list[UserRequestLocationChild]
        """
        return self._locations

    @locations.setter
    def locations(self, locations):
        """Sets the locations of this UserCreateRequest.

        The locations the user belongs to. Saas users should not belong to any locations  # noqa: E501

        :param locations: The locations of this UserCreateRequest.  # noqa: E501
        :type: list[UserRequestLocationChild]
        """

        self._locations = locations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
