# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class HubsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_hub(self, hub_id, **kwargs):  # noqa: E501
        """Returns a single Hub with the supplied Id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hub(hub_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int hub_id: The Id of the Hub (required)
        :param bool include_online_status:
        :return: HubResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hub_with_http_info(hub_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hub_with_http_info(hub_id, **kwargs)  # noqa: E501
            return data

    def get_hub_with_http_info(self, hub_id, **kwargs):  # noqa: E501
        """Returns a single Hub with the supplied Id  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hub_with_http_info(hub_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int hub_id: The Id of the Hub (required)
        :param bool include_online_status:
        :return: HubResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['hub_id', 'include_online_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hub" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'hub_id' is set
        if ('hub_id' not in params or
                params['hub_id'] is None):
            raise ValueError("Missing the required parameter `hub_id` when calling `get_hub`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'hub_id' in params:
            path_params['hubId'] = params['hub_id']  # noqa: E501

        query_params = []
        if 'include_online_status' in params:
            query_params.append(('includeOnlineStatus', params['include_online_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Hubs/{hubId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hubs(self, **kwargs):  # noqa: E501
        """Gets all hubs a user has access to  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hubs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_online_status:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `HubType` | HubType? | `eq, neq, in` | | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `PowerType` | HubPowerType? | `eq, neq, in` | | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` | | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverName` | String | `eq, neq, like, in` | | `ReceiverNetworkId` | String | `eq, neq, like, in` | | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverSerialNumber` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `Created` | DateTime | | `FirmwareVersion` | String | | `HubType` | HubType? | | `LocationName` | String | | `Name` | String | | `PowerType` | HubPowerType? | | `ReceiverFirmwareVersion` | String | | `ReceiverName` | String | | `ReceiverNetworkId` | String | | `ReceiverPendingRfChannel` | Int32? | | `ReceiverRfChannel` | Int32? | | `SerialNumber` | String | | `Updated` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Name`, `SerialNumber`.
        :return: PagedResultsModelHubResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hubs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hubs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hubs_with_http_info(self, **kwargs):  # noqa: E501
        """Gets all hubs a user has access to  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hubs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_online_status:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `CorporationAbbreviation` | String | `eq, neq, like, in` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, like, in` | | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `FirmwareVersion` | String | `eq, neq, like, in` | | `HubType` | HubType? | `eq, neq, in` | | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Name` | String | `eq, neq, like, in` | | `PowerType` | HubPowerType? | `eq, neq, in` | | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` | | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverName` | String | `eq, neq, like, in` | | `ReceiverNetworkId` | String | `eq, neq, like, in` | | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` | | `ReceiverSerialNumber` | String | `eq, neq, like, in` | | `SerialNumber` | String | `eq, neq, like, in` | | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `CorporationName` | String | | `Created` | DateTime | | `FirmwareVersion` | String | | `HubType` | HubType? | | `LocationName` | String | | `Name` | String | | `PowerType` | HubPowerType? | | `ReceiverFirmwareVersion` | String | | `ReceiverName` | String | | `ReceiverNetworkId` | String | | `ReceiverPendingRfChannel` | Int32? | | `ReceiverRfChannel` | Int32? | | `SerialNumber` | String | | `Updated` | DateTime |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Name`, `SerialNumber`.
        :return: PagedResultsModelHubResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_online_status', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hubs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'include_online_status' in params:
            query_params.append(('includeOnlineStatus', params['include_online_status']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Hubs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelHubResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
