# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class ActivityEventsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_activity_event(self, **kwargs):  # noqa: E501
        """Create an activity event  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_event(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventCreateRequest body: Activity event create request
        :return: ActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_activity_event_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_activity_event_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_activity_event_with_http_info(self, **kwargs):  # noqa: E501
        """Create an activity event  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_event_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventCreateRequest body: Activity event create request
        :return: ActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity_event" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_activity_event_category_relationship(self, **kwargs):  # noqa: E501
        """Create an activity event category relationship  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_event_category_relationship(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventCategoryRelationshipCreateRequest body: Activity event category relationship create request
        :return: ActivityEventCategoryRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_activity_event_category_relationship_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_activity_event_category_relationship_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_activity_event_category_relationship_with_http_info(self, **kwargs):  # noqa: E501
        """Create an activity event category relationship  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_event_category_relationship_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventCategoryRelationshipCreateRequest body: Activity event category relationship create request
        :return: ActivityEventCategoryRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity_event_category_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/CategoryRelationships', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventCategoryRelationshipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_activity_event_relationship(self, **kwargs):  # noqa: E501
        """Create an activity event relationship  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_event_relationship(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventRelationshipCreateRequest body: Activity event relationship create request
        :return: ActivityEventRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_activity_event_relationship_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_activity_event_relationship_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_activity_event_relationship_with_http_info(self, **kwargs):  # noqa: E501
        """Create an activity event relationship  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_event_relationship_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventRelationshipCreateRequest body: Activity event relationship create request
        :return: ActivityEventRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity_event_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Relationships', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventRelationshipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_activity_event(self, activity_event_id, **kwargs):  # noqa: E501
        """Delete an activity event  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_event(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of the activity event (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_activity_event_with_http_info(activity_event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_activity_event_with_http_info(activity_event_id, **kwargs)  # noqa: E501
            return data

    def delete_activity_event_with_http_info(self, activity_event_id, **kwargs):  # noqa: E501
        """Delete an activity event  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_event_with_http_info(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of the activity event (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_activity_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_id' is set
        if ('activity_event_id' not in params or
                params['activity_event_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_id` when calling `delete_activity_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_id' in params:
            path_params['activityEventId'] = params['activity_event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/{activityEventId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_activity_event_category_relationship(self, activity_event_category_relationship_id, **kwargs):  # noqa: E501
        """Delete an activity event category relationship  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_event_category_relationship(activity_event_category_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_category_relationship_id: Id of the activity event category relationship (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_activity_event_category_relationship_with_http_info(activity_event_category_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_activity_event_category_relationship_with_http_info(activity_event_category_relationship_id, **kwargs)  # noqa: E501
            return data

    def delete_activity_event_category_relationship_with_http_info(self, activity_event_category_relationship_id, **kwargs):  # noqa: E501
        """Delete an activity event category relationship  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_event_category_relationship_with_http_info(activity_event_category_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_category_relationship_id: Id of the activity event category relationship (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_category_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_activity_event_category_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_category_relationship_id' is set
        if ('activity_event_category_relationship_id' not in params or
                params['activity_event_category_relationship_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_category_relationship_id` when calling `delete_activity_event_category_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_category_relationship_id' in params:
            path_params['activityEventCategoryRelationshipId'] = params['activity_event_category_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/CategoryRelationships/{activityEventCategoryRelationshipId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_activity_event_relationship(self, activity_event_relationship_id, **kwargs):  # noqa: E501
        """Delete an activity event relationship  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_event_relationship(activity_event_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_relationship_id: Id of the activity event relationship (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_activity_event_relationship_with_http_info(activity_event_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_activity_event_relationship_with_http_info(activity_event_relationship_id, **kwargs)  # noqa: E501
            return data

    def delete_activity_event_relationship_with_http_info(self, activity_event_relationship_id, **kwargs):  # noqa: E501
        """Delete an activity event relationship  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_event_relationship_with_http_info(activity_event_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_relationship_id: Id of the activity event relationship (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_activity_event_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_relationship_id' is set
        if ('activity_event_relationship_id' not in params or
                params['activity_event_relationship_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_relationship_id` when calling `delete_activity_event_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_relationship_id' in params:
            path_params['activityEventRelationshipId'] = params['activity_event_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Relationships/{activityEventRelationshipId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event(self, activity_event_id, **kwargs):  # noqa: E501
        """Gets an activity event  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of activity event to return (required)
        :return: ActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_with_http_info(activity_event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_with_http_info(activity_event_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_with_http_info(self, activity_event_id, **kwargs):  # noqa: E501
        """Gets an activity event  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_with_http_info(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of activity event to return (required)
        :return: ActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_id' is set
        if ('activity_event_id' not in params or
                params['activity_event_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_id` when calling `get_activity_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_id' in params:
            path_params['activityEventId'] = params['activity_event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/{activityEventId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_categories(self, **kwargs):  # noqa: E501
        """Gets activity event categories  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ActivityLineEnabled` | Boolean | `eq, neq` | | `AssetCardEnabled` | Boolean | `eq, neq` | | `CategoryFlag` | ActivityEventCategoryFlag? | `eq, neq, in` | | `Code` | String | `eq, neq, like, in` | | `Description` | String | `eq, neq, like, in` | | `Internal` | Boolean | `eq, neq` | | `Name` | String | `eq, neq, like, in` | | `OwnerType` | ActivityEventOwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Code` | String | | `Description` | String | | `Name` | String |
        :return: PagedResultsModelActivityEventCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activity_event_categories_with_http_info(self, **kwargs):  # noqa: E501
        """Gets activity event categories  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ActivityLineEnabled` | Boolean | `eq, neq` | | `AssetCardEnabled` | Boolean | `eq, neq` | | `CategoryFlag` | ActivityEventCategoryFlag? | `eq, neq, in` | | `Code` | String | `eq, neq, like, in` | | `Description` | String | `eq, neq, like, in` | | `Internal` | Boolean | `eq, neq` | | `Name` | String | `eq, neq, like, in` | | `OwnerType` | ActivityEventOwnerType | `eq, neq, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Code` | String | | `Description` | String | | `Name` | String |
        :return: PagedResultsModelActivityEventCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_categories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelActivityEventCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_category(self, activity_event_category_id, **kwargs):  # noqa: E501
        """Gets an activity event category  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_category(activity_event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_event_category_id: Id of activity event category to return (required)
        :return: ActivityEventCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_category_with_http_info(activity_event_category_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_category_with_http_info(activity_event_category_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_category_with_http_info(self, activity_event_category_id, **kwargs):  # noqa: E501
        """Gets an activity event category  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_category_with_http_info(activity_event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_event_category_id: Id of activity event category to return (required)
        :return: ActivityEventCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_category_id' is set
        if ('activity_event_category_id' not in params or
                params['activity_event_category_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_category_id` when calling `get_activity_event_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_category_id' in params:
            path_params['activityEventCategoryId'] = params['activity_event_category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Categories/{activityEventCategoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_category_fields(self, activity_event_category_id, **kwargs):  # noqa: E501
        """Get activity event category fields  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_category_fields(activity_event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_event_category_id: Id of the activity event category (required)
        :return: list[ActivityEventFieldResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_category_fields_with_http_info(activity_event_category_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_category_fields_with_http_info(activity_event_category_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_category_fields_with_http_info(self, activity_event_category_id, **kwargs):  # noqa: E501
        """Get activity event category fields  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_category_fields_with_http_info(activity_event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_event_category_id: Id of the activity event category (required)
        :return: list[ActivityEventFieldResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_category_fields" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_category_id' is set
        if ('activity_event_category_id' not in params or
                params['activity_event_category_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_category_id` when calling `get_activity_event_category_fields`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_category_id' in params:
            path_params['activityEventCategoryId'] = params['activity_event_category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Categories/{activityEventCategoryId}/fields', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ActivityEventFieldResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_category_relationship(self, activity_event_category_relationship_id, **kwargs):  # noqa: E501
        """Gets an activity event category relationship  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_category_relationship(activity_event_category_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_category_relationship_id: Id of activity event category relationship to return (required)
        :return: ActivityEventCategoryRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_category_relationship_with_http_info(activity_event_category_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_category_relationship_with_http_info(activity_event_category_relationship_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_category_relationship_with_http_info(self, activity_event_category_relationship_id, **kwargs):  # noqa: E501
        """Gets an activity event category relationship  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_category_relationship_with_http_info(activity_event_category_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_category_relationship_id: Id of activity event category relationship to return (required)
        :return: ActivityEventCategoryRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_category_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_category_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_category_relationship_id' is set
        if ('activity_event_category_relationship_id' not in params or
                params['activity_event_category_relationship_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_category_relationship_id` when calling `get_activity_event_category_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_category_relationship_id' in params:
            path_params['activityEventCategoryRelationshipId'] = params['activity_event_category_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/CategoryRelationships/{activityEventCategoryRelationshipId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventCategoryRelationshipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_detail(self, activity_event_id, **kwargs):  # noqa: E501
        """Gets an activity event details. Expands on standard get activity event (by id) method  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_detail(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of activity event to return (required)
        :return: ActivityEventDetailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_detail_with_http_info(activity_event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_detail_with_http_info(activity_event_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_detail_with_http_info(self, activity_event_id, **kwargs):  # noqa: E501
        """Gets an activity event details. Expands on standard get activity event (by id) method  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_detail_with_http_info(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of activity event to return (required)
        :return: ActivityEventDetailResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_detail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_id' is set
        if ('activity_event_id' not in params or
                params['activity_event_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_id` when calling `get_activity_event_detail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_id' in params:
            path_params['activityEventId'] = params['activity_event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/{activityEventId}/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventDetailResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_field_values(self, activity_event_field_id, **kwargs):  # noqa: E501
        """Get activity event field values (if any)  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_field_values(activity_event_field_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_field_id: Id of the activity event field (required)
        :param ActivityEventBindType bind_type: Optional bind type.
        :param str bind_id: Optional bind id (requires bind type).
        :param bool allow_query_fallback: Allow query fallback if no matches for bind type / bind id
        :return: list[ActivityEventFieldValueResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_field_values_with_http_info(activity_event_field_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_field_values_with_http_info(activity_event_field_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_field_values_with_http_info(self, activity_event_field_id, **kwargs):  # noqa: E501
        """Get activity event field values (if any)  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_field_values_with_http_info(activity_event_field_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_field_id: Id of the activity event field (required)
        :param ActivityEventBindType bind_type: Optional bind type.
        :param str bind_id: Optional bind id (requires bind type).
        :param bool allow_query_fallback: Allow query fallback if no matches for bind type / bind id
        :return: list[ActivityEventFieldValueResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_field_id', 'bind_type', 'bind_id', 'allow_query_fallback']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_field_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_field_id' is set
        if ('activity_event_field_id' not in params or
                params['activity_event_field_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_field_id` when calling `get_activity_event_field_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_field_id' in params:
            path_params['activityEventFieldId'] = params['activity_event_field_id']  # noqa: E501

        query_params = []
        if 'bind_type' in params:
            query_params.append(('bindType', params['bind_type']))  # noqa: E501
        if 'bind_id' in params:
            query_params.append(('bindId', params['bind_id']))  # noqa: E501
        if 'allow_query_fallback' in params:
            query_params.append(('allowQueryFallback', params['allow_query_fallback']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Fields/{activityEventFieldId}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ActivityEventFieldValueResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_relationship(self, activity_event_relationship_id, **kwargs):  # noqa: E501
        """Gets an activity event relationship  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_relationship(activity_event_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_relationship_id: Id of activity event relationship to return (required)
        :return: ActivityEventRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_relationship_with_http_info(activity_event_relationship_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_relationship_with_http_info(activity_event_relationship_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_relationship_with_http_info(self, activity_event_relationship_id, **kwargs):  # noqa: E501
        """Gets an activity event relationship  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_relationship_with_http_info(activity_event_relationship_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_relationship_id: Id of activity event relationship to return (required)
        :return: ActivityEventRelationshipResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_relationship_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_relationship" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_relationship_id' is set
        if ('activity_event_relationship_id' not in params or
                params['activity_event_relationship_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_relationship_id` when calling `get_activity_event_relationship`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_relationship_id' in params:
            path_params['activityEventRelationshipId'] = params['activity_event_relationship_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Relationships/{activityEventRelationshipId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventRelationshipResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_event_subcategories(self, activity_event_category_id, **kwargs):  # noqa: E501
        """Get activity event subcategories  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_subcategories(activity_event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_event_category_id: Id of parent activity event category (required)
        :param str location_id: Optional location id
        :return: list[ActivityEventSubcategoryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_event_subcategories_with_http_info(activity_event_category_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_event_subcategories_with_http_info(activity_event_category_id, **kwargs)  # noqa: E501
            return data

    def get_activity_event_subcategories_with_http_info(self, activity_event_category_id, **kwargs):  # noqa: E501
        """Get activity event subcategories  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_event_subcategories_with_http_info(activity_event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int activity_event_category_id: Id of parent activity event category (required)
        :param str location_id: Optional location id
        :return: list[ActivityEventSubcategoryResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_category_id', 'location_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_event_subcategories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_category_id' is set
        if ('activity_event_category_id' not in params or
                params['activity_event_category_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_category_id` when calling `get_activity_event_subcategories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_category_id' in params:
            path_params['activityEventCategoryId'] = params['activity_event_category_id']  # noqa: E501

        query_params = []
        if 'location_id' in params:
            query_params.append(('locationId', params['location_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Categories/{activityEventCategoryId}/subcategories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ActivityEventSubcategoryResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_events(self, **kwargs):  # noqa: E501
        """Gets activity events  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ActivityLineEnabled` | Boolean | `eq, neq` | | `AssetCardEnabled` | Boolean | `eq, neq` | | `BindId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `BindType` | ActivityEventBindType? | `eq, neq, in` | | `CategoryCode` | String | `eq, neq, like, in` | | `CategoryFlag` | ActivityEventCategoryFlag? | `eq, neq, in` | | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `CategoryOwnerType` | ActivityEventOwnerType? | `eq, neq, in` | | `Description` | String | `eq, neq, like, in` | | `EndDateTime` | DateTime? | `eq, neq, in, lt, gt, leq, geq` | | `FieldCode` | String | `eq, neq, like, in` | | `FieldId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `FieldType` | ActivityEventFieldType? | `eq, neq, in` | | `FieldValue` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Note` | String | `eq, neq, like, in` | | `RelationshipFromId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `RelationshipToId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `RelationshipType` | ActivityEventRelationshipType? | `eq, neq, in` | | `StartDateTime` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `SubcategoryCode` | String | `eq, neq, like, in` | | `SubcategoryId` | Guid | `eq, neq, in` | | `Title` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Description` | String | | `EndDateTime` | DateTime? | | `LocationName` | String | | `Note` | String | | `StartDateTime` | DateTime | | `Title` | String |
        :return: PagedResultsModelActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_events_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_events_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activity_events_with_http_info(self, **kwargs):  # noqa: E501
        """Gets activity events  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ActivityLineEnabled` | Boolean | `eq, neq` | | `AssetCardEnabled` | Boolean | `eq, neq` | | `BindId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `BindType` | ActivityEventBindType? | `eq, neq, in` | | `CategoryCode` | String | `eq, neq, like, in` | | `CategoryFlag` | ActivityEventCategoryFlag? | `eq, neq, in` | | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` | | `CategoryOwnerType` | ActivityEventOwnerType? | `eq, neq, in` | | `Description` | String | `eq, neq, like, in` | | `EndDateTime` | DateTime? | `eq, neq, in, lt, gt, leq, geq` | | `FieldCode` | String | `eq, neq, like, in` | | `FieldId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `FieldType` | ActivityEventFieldType? | `eq, neq, in` | | `FieldValue` | String | `eq, neq, like, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `Note` | String | `eq, neq, like, in` | | `RelationshipFromId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `RelationshipToId` | Guid? | `eq, neq, in, lt, gt, leq, geq` | | `RelationshipType` | ActivityEventRelationshipType? | `eq, neq, in` | | `StartDateTime` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `SubcategoryCode` | String | `eq, neq, like, in` | | `SubcategoryId` | Guid | `eq, neq, in` | | `Title` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Description` | String | | `EndDateTime` | DateTime? | | `LocationName` | String | | `Note` | String | | `StartDateTime` | DateTime | | `Title` | String |
        :return: PagedResultsModelActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_events" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelActivityEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hierarchy_activity_events_post(self, **kwargs):  # noqa: E501
        """Gets activity events for hierarchy groups  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hierarchy_activity_events_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventHierarchyGroupRequest body: ActivityEventHierarchyGroupRequest instance
        :param bool is_slim: Set to true for slim (less properties) response list
        :param bool is_export:
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime? | | `CreatedBy` | String | | `Description` | String | | `EndDateTime` | DateTime? | | `LocationName` | String | | `StartDateTime` | DateTime | | `Title` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CategoryDescription`, `CreatedBy`, `Description`, `HierarchySearch`, `Title`.
        :return: PagedResultsModelActivityEventHierarchyGroupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hierarchy_activity_events_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hierarchy_activity_events_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hierarchy_activity_events_post_with_http_info(self, **kwargs):  # noqa: E501
        """Gets activity events for hierarchy groups  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hierarchy_activity_events_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityEventHierarchyGroupRequest body: ActivityEventHierarchyGroupRequest instance
        :param bool is_slim: Set to true for slim (less properties) response list
        :param bool is_export:
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Created` | DateTime? | | `CreatedBy` | String | | `Description` | String | | `EndDateTime` | DateTime? | | `LocationName` | String | | `StartDateTime` | DateTime | | `Title` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CategoryDescription`, `CreatedBy`, `Description`, `HierarchySearch`, `Title`.
        :return: PagedResultsModelActivityEventHierarchyGroupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'is_slim', 'is_export', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hierarchy_activity_events_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'is_slim' in params:
            query_params.append(('isSlim', params['is_slim']))  # noqa: E501
        if 'is_export' in params:
            query_params.append(('isExport', params['is_export']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/HierarchyGroups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelActivityEventHierarchyGroupResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_activity_event(self, activity_event_id, **kwargs):  # noqa: E501
        """Update an activity event  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity_event(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of the activity event (required)
        :param ActivityEventUpdateRequest body: Activity event update request
        :return: ActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_activity_event_with_http_info(activity_event_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_activity_event_with_http_info(activity_event_id, **kwargs)  # noqa: E501
            return data

    def update_activity_event_with_http_info(self, activity_event_id, **kwargs):  # noqa: E501
        """Update an activity event  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity_event_with_http_info(activity_event_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_id: Id of the activity event (required)
        :param ActivityEventUpdateRequest body: Activity event update request
        :return: ActivityEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_activity_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_id' is set
        if ('activity_event_id' not in params or
                params['activity_event_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_id` when calling `update_activity_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_id' in params:
            path_params['activityEventId'] = params['activity_event_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/{activityEventId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_activity_event_field_values(self, activity_event_field_id, **kwargs):  # noqa: E501
        """Update / replace activity event field values list  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity_event_field_values(activity_event_field_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_field_id: Id of the activity event field (required)
        :param list[ActivityEventFieldValueRequest] body:
        :param ActivityEventBindType bind_type: Optional bind type.
        :param str bind_id: Optional bind id (requires bind type).
        :return: list[ActivityEventFieldValueResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_activity_event_field_values_with_http_info(activity_event_field_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_activity_event_field_values_with_http_info(activity_event_field_id, **kwargs)  # noqa: E501
            return data

    def update_activity_event_field_values_with_http_info(self, activity_event_field_id, **kwargs):  # noqa: E501
        """Update / replace activity event field values list  # noqa: E501

        Required Permissions: System Admin / Sentry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity_event_field_values_with_http_info(activity_event_field_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_event_field_id: Id of the activity event field (required)
        :param list[ActivityEventFieldValueRequest] body:
        :param ActivityEventBindType bind_type: Optional bind type.
        :param str bind_id: Optional bind id (requires bind type).
        :return: list[ActivityEventFieldValueResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_event_field_id', 'body', 'bind_type', 'bind_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_activity_event_field_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_event_field_id' is set
        if ('activity_event_field_id' not in params or
                params['activity_event_field_id'] is None):
            raise ValueError("Missing the required parameter `activity_event_field_id` when calling `update_activity_event_field_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_event_field_id' in params:
            path_params['activityEventFieldId'] = params['activity_event_field_id']  # noqa: E501

        query_params = []
        if 'bind_type' in params:
            query_params.append(('bindType', params['bind_type']))  # noqa: E501
        if 'bind_id' in params:
            query_params.append(('bindId', params['bind_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/ActivityEvents/Fields/{activityEventFieldId}/values', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ActivityEventFieldValueResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
