# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class ActivitiesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_activity(self, **kwargs):  # noqa: E501
        """Creates an Activity  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityCreateRequest body: Activity details
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_activity_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_activity_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_activity_with_http_info(self, **kwargs):  # noqa: E501
        """Creates an Activity  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_activity_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ActivityCreateRequest body: Activity details
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_activity" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_activity(self, activity_id, **kwargs):  # noqa: E501
        """Deletes an activity  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: Id of the activity (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_activity_with_http_info(activity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_activity_with_http_info(activity_id, **kwargs)  # noqa: E501
            return data

    def delete_activity_with_http_info(self, activity_id, **kwargs):  # noqa: E501
        """Deletes an activity  # noqa: E501

        Required Permissions: Location Admin  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_activity_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: Id of the activity (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params or
                params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `delete_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities/{activityId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activities(self, **kwargs):  # noqa: E501
        """Gets Activities  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ActivityCategory` | CaseContentType | `eq, neq, in` | | `ActivityCodeId` | Guid | `eq, neq, in` | | `CreatedBy` | String | `eq, neq, like, in` | | `DateOccurred` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Description` | String | `eq, neq, like, in` | | `GroupId` | Guid | `eq, neq, in` | | `IndicatorId` | Guid | `eq, neq, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `ModifiedBy` | String | `eq, neq, like, in` | | `Savings` | Single | `eq, neq, in, lt, gt, leq, geq` | | `Title` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `ActivityCategory` | CaseContentType | | `Created` | DateTime | | `CreatedBy` | String | | `DateOccurred` | DateTime | | `Description` | String | | `GroupName` | String | | `LocationName` | String | | `Modified` | DateTime | | `ModifiedBy` | String | | `Savings` | Single | | `Title` | String |
        :return: PagedResultsModelActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activities_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Activities  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `ActivityCategory` | CaseContentType | `eq, neq, in` | | `ActivityCodeId` | Guid | `eq, neq, in` | | `CreatedBy` | String | `eq, neq, like, in` | | `DateOccurred` | DateTime | `eq, neq, in, lt, gt, leq, geq` | | `Description` | String | `eq, neq, like, in` | | `GroupId` | Guid | `eq, neq, in` | | `IndicatorId` | Guid | `eq, neq, in` | | `LocationAbbreviation` | String | `eq, neq, like, in` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, like, in` | | `ModifiedBy` | String | `eq, neq, like, in` | | `Savings` | Single | `eq, neq, in, lt, gt, leq, geq` | | `Title` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `ActivityCategory` | CaseContentType | | `Created` | DateTime | | `CreatedBy` | String | | `DateOccurred` | DateTime | | `Description` | String | | `GroupName` | String | | `LocationName` | String | | `Modified` | DateTime | | `ModifiedBy` | String | | `Savings` | Single | | `Title` | String |
        :return: PagedResultsModelActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelActivityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity(self, activity_id, **kwargs):  # noqa: E501
        """Gets an Activity  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: Id of the activity (required)
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_with_http_info(activity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_with_http_info(activity_id, **kwargs)  # noqa: E501
            return data

    def get_activity_with_http_info(self, activity_id, **kwargs):  # noqa: E501
        """Gets an Activity  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: Id of the activity (required)
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params or
                params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `get_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities/{activityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_categories(self, **kwargs):  # noqa: E501
        """Gets activity categories  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String |
        :return: PagedResultsModelActivityCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_activity_categories_with_http_info(self, **kwargs):  # noqa: E501
        """Gets activity categories  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String |
        :return: PagedResultsModelActivityCategoryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_categories" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities/Categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelActivityCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_activity_codes(self, category_type, **kwargs):  # noqa: E501
        """Gets activity codes for category type  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_codes(category_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CaseContentType category_type: The category to get the associated codes (required)
        :param str location_id: Optional param to get location specific codes
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String |
        :return: PagedResultsModelActivityCodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_activity_codes_with_http_info(category_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_activity_codes_with_http_info(category_type, **kwargs)  # noqa: E501
            return data

    def get_activity_codes_with_http_info(self, category_type, **kwargs):  # noqa: E501
        """Gets activity codes for category type  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_activity_codes_with_http_info(category_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CaseContentType category_type: The category to get the associated codes (required)
        :param str location_id: Optional param to get location specific codes
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Name` | String | `eq, neq, like, in` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Name` | String |
        :return: PagedResultsModelActivityCodeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_type', 'location_id', 'filter', 'page', 'page_limit', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_activity_codes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'category_type' is set
        if ('category_type' not in params or
                params['category_type'] is None):
            raise ValueError("Missing the required parameter `category_type` when calling `get_activity_codes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'category_type' in params:
            path_params['categoryType'] = params['category_type']  # noqa: E501

        query_params = []
        if 'location_id' in params:
            query_params.append(('locationId', params['location_id']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities/Categories/{categoryType}/codes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelActivityCodeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_activity(self, activity_id, **kwargs):  # noqa: E501
        """Updates an Activity  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: (required)
        :param ActivityUpdateRequest body: Activity details
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_activity_with_http_info(activity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_activity_with_http_info(activity_id, **kwargs)  # noqa: E501
            return data

    def update_activity_with_http_info(self, activity_id, **kwargs):  # noqa: E501
        """Updates an Activity  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_activity_with_http_info(activity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str activity_id: (required)
        :param ActivityUpdateRequest body: Activity details
        :return: ActivityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_activity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params or
                params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `update_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Activities/{activityId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ActivityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
