# Changelog

## 4.0.0

Aug 29, 2017

- **NEW**: Details extension will now derive a title from the class if only a class is provided (https://github.com/facelessuser/pymdown-extensions/issues/107).
- **NEW**: Remove deprecated legacy emoji generator format.
- **NEW**: Remove deprecated `use_codehilite_settings`.
- **NEW**: Remove deprecated `spoilers` extension redirect.
- **NEW**: Update emoji databases: EmojiOne (3.1.2) and Twemoji to (2.5.0).

## 3.5.0

Jun 13, 2017

- **NEW**: Add new slugs to preserve case (https://github.com/facelessuser/pymdown-extensions/pull/103).
- **NEW**: Add new GFM specific slug (both percent encoded and normal) that only lowercases ASCII chars just like GFM does (https://github.com/facelessuser/pymdown-extensions/issues/101).
- **FIX**: PathConverter should not try and convert obscured email address (with HTML entities) (https://github.com/facelessuser/pymdown-extensions/issues/100).
- **FIX**: Don't normalize Unicode in slugs with `NFKD`, use `NFC` instead (https://github.com/facelessuser/pymdown-extensions/issues/98).
- **FIX**: Don't let EscapeAll escape CriticMarkup placeholders.  EscapeAll will no longer escape `STX` and `ETX`; they will just pass through (https://github.com/facelessuser/pymdown-extensions/issues/95).
- **FIX**: Replace CriticMarkup placeholders after replacing raw HTML placeholders (https://github.com/facelessuser/pymdown-extensions/issues/95).

## 3.4.0

Jun 1, 2017

- **NEW**: Renamed Spoilers to Details
- **NEW**: No longer attach the `spoilers` class to `details` tags.
- **NEW**: Provide better example of UML script in documents.

## 3.3.0

May 26, 2017

- **NEW**: Added support for pull request link shortening in MagicLink (https://github.com/facelessuser/pymdown-extensions/pull/88).
- **NEW**: Added new Spoilers extension (https://github.com/facelessuser/pymdown-extensions/issues/85).

## 3.2.1

May 23, 2017

- **FIX**: Cannot set Highlight's CSS class.

## 3.2.0

May 15, 2017

- **NEW**: Add support for Twemoji 2.3.5.
- **NEW**: Update to EmojiOne 3.0.2.
- **NEW**: Emoji generators now also take `category` which is also no included in all indexes.
- **FIX**: Excessive new lines at end of code blocks.

## 3.1.0

May 7, 2017

- **NEW**: Highlight extension now runs normal indented code blocks through highlighter.
- **FIX**: When Pygments is disabled, `linenums` class was attached to code blocks even if `linenums` was disabled and not enabled via fence headers.

## 3.0.0

Apr 16, 2017

- **NEW**: Added Keys extension.
- **NEW**: Generalized custom fences (https://github.com/facelessuser/pymdown-extensions/issues/60). `flow` and `sequence` fence are now just custom fences and can be disabled simply by overwriting the `custom_fences` setting.
- **NEW**: Remove deprecated `no_nl2br` in GitHub extension (https://github.com/facelessuser/pymdown-extensions/issues/24).
- **NEW**: Remove deprecated HeaderAnchor extension (https://github.com/facelessuser/pymdown-extensions/issues/24).
- **NEW**: Remove deprecated PyMdown extension (https://github.com/facelessuser/pymdown-extensions/issues/24).
- **NEW**: Remove deprecated GitHubEmoji extension (https://github.com/facelessuser/pymdown-extensions/issues/24).
- **NEW**: Remove deprecated `nested` option in SuperFences (https://github.com/facelessuser/pymdown-extensions/issues/24).
- **NEW**: Wrapper extensions (such as GitHub and Extra) can now allow setting the included sub extensions settings (https://github.com/facelessuser/pymdown-extensions/issues/61). Workaround settings that directly set specific extensions settings has been removed.
- **NEW**: Deprecated `use_codehilite_settings` in SuperFences and InlineHilite and now does nothing.  The settings will be removed in the future.  If `pymdownx.highlight` is used, it's settings will be used instead of CodeHilite. Eventually, the both SuperFences and InlineHilite will require `pymdownx.highlight` to be used and will have CodeHilite support stripped.
- **FIX**: Fix MathJax CDN references and usage in documentation.  MathJax CDN is shutting down and must now use Cloudflare CDN (https://github.com/facelessuser/pymdown-extensions/issues/63).

## 2.0.0

Feb 12, 2017

- **NEW**: SuperFences and InlineHilite can be configured via the new Highlight extension.
- **NEW**: InlineHilite now has all highlighting features pushed to the Highlight extension.  This removes all the CodeHilite code that used to be in it and instead relocates it to Highlight.
- **NEW**: Deprecate the nesting option in SuperFences.  Nesting is default and the only acceptable behavior moving forward.  The ability to turn off nesting will be removed in 3.0.

## 1.8.0

Jan 27, 2017

- **NEW**: MagicLink special repository link shortener for GitHub, GitLab, and Bitbucket (https://github.com/facelessuser/pymdown-extensions/issues/49).
- **FIX**: GitHub asterisk emphasis should never have had smart enabled for it (https://github.com/facelessuser/pymdown-extensions/issues/50).
- **FIX**: MagicLink fix for compatibility with wrapped symbols like `~`, `*` etc. which are commonly used.
- **FIX**: MagicLink encodes emails like Python Markdown does for consistency.
- **FIX**: MagicLink doesn't allow Unicode for email and does allow Unicode in a URL (https://github.com/facelessuser/pymdown-extensions/issues/53).
- **FIX**: InlineHilite now returns a proper `etree` element so that the `attr_list` extension and function properly with it (https://github.com/facelessuser/pymdown-extensions/issues/48).
- **FIX**: InlineHilite will no longer break if Pygments is not installed (https://github.com/facelessuser/pymdown-extensions/commit/478b410a2199d55f3e70b452516511d3810c61a5).

## 1.7.0

Jan 21, 2017

- **NEW**: Arithmatex now supports `\(...\)`, `\[...\]`, and `\begin{}...\end{}`.
- **NEW**: Arithmatex has an option to embed the math code in MathJax script tags.
- **FIX**: Unfortunately the wrap option is now run through an HTML escaper and HTML tags can no longer be fed in this way.  Arithmatex also now wraps "wrapped" content with spans to containerize content and keep one equation from bleeding into the next.
- **FIX**: Better handling of escaped Arithmatex inline tokens.
- **FIX**: Better handling of escaped InlineHilite tokens.
- **FIX**: Update InlineHilite and SuperFences so that the language option can accept things like `c#` and `.net` etc.
- **FIX**: Snippets now removes carriage returns from imported files to prevent breakage.

## 1.6.1

Jan 16, 2017

- **FIX**: Don't install tools or tests folder when installing from Pypi.

## 1.6.0

Jan 15, 2017

- **NEW**: EscapeAll has the option to perform more like Pandoc in that you can enable escaped newlines to be `hardbreaks`, and escaped spaces to be `nbsp`.
- **NEW**: Rework poorly thought out snippets format to require quoting file names with single line format.  Add a block format.  Allow commenting out lines temporarily.  And allow a way to escape them by placing a space after them.
- **FIX**: Fix documentation issues.

## 1.5.0

Jan 13, 2017

- **NEW**: New EscapeAll extension.
- **NEW**: New Snippets extension for including external files into a Markdown file.
- **NEW**: Arithmatex now has configurable output wrapper.
- **NEW**: PathConverter no longer verifies existence of path to allow it more flexible usage.
- **NEW**: PathConverter now only converts relative paths when converting to a relative or absolute location.
- **NEW**: Improved support for path path identification for PathConverter and B64.
- **FIX**: Fixed issue where Arithmatex was un-escaping `$` within math region.
- **FIX**: Fixed issue where plugins would append globally changing the escape list opposed to just in the in the Markdown instance.
- **FIX**: Fixed logic issue where the `mark`, `caret`, and `tilde` extension weren't quite modeling `betterem` inline behavior.
- **FIX**: Critics shouldn't allow escaping critic marks as it is not in the spec.

## 1.4.0

Jan 5, 2017

- **NEW**: HeaderAnchor extension is now deprecated.  It will be removed in a future version.
- **NEW**: HeaderAnchor is no longer included in the `pymdownx.github` extension.
- **NEW**: Slugify functions are moved to `pymdownx.slug` in preparation of HeaderAnchor removal.
- **FIX**: GitHubEmoji is not "pending" deprecation, but is actually deprecated.

## 1.3.0

Jan 1, 2017

- **NEW**: New Emoji extension that aims to replace GitHubEmoji.  By default it is configured for EmojiOne and Gemoji (GitHub's emoji).
- **NEW**: GitHubEmoji is deprecated. Please use the Emoji extension instead.
- **NEW**: PyMdown extension is deprecated.  PyMdown extension was just a wrapper, please configure the desired individual extension(s) instead of relying on PyMdown.
- **NEW**: `github` extension now turns off `nl2br` by default in order properly emulate recent changes in GFM.  `no_nl2br` option is deprecated and will be removed in the future as it no longer reflects GFM behavior.

## 1.2.0

Nov 1, 2016

- **NEW**: Add option to output task lists in a more customizable way.

## 1.1.0

Mar 1, 2016

- **NEW**: Add pypi 3.5 info in setup
- **NEW**: Add option to MagicLink extension to allow the stripping of link protocols (`http://` etc.).
- **NEW**: Add option to `github` extension to disable the use of `nl2br` to reflect recent changes to GitHub Flavored Markdown.  Currently the default is the legacy (uses `nl2br`), but a warning will be displayed.  In the future, the option will be defaulted to not use `nl2br`.

## 1.0.1

Dec 10, 2015

- **FIX**: Ordinal number 11th, 12th, and 13th

## 1.0.0

Dec 8, 2015

- **NEW**: Initial release.

--8<-- "refs.md"
