"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcceleratorType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
/**
 * Supported Elastic Inference (EI) instance types for SageMaker instance-based production variants.
 * EI instances provide on-demand GPU computing for inference.
 */
class AcceleratorType {
    constructor(acceleratorType) {
        if (cdk.Token.isUnresolved(acceleratorType) || acceleratorType.startsWith('ml.')) {
            this.acceleratorTypeIdentifier = acceleratorType;
        }
        else {
            throw new Error(`instance type must start with 'ml.'; (got ${acceleratorType})`);
        }
    }
    /**
     * Builds an AcceleratorType from a given string or token (such as a CfnParameter).
     * @param acceleratorType An accelerator type as string
     * @returns A strongly typed AcceleratorType
     */
    static of(acceleratorType) {
        return new AcceleratorType(acceleratorType);
    }
    /**
     * Return the accelerator type as a string
     * @returns The accelerator type as a string
     */
    toString() {
        return this.acceleratorTypeIdentifier;
    }
}
exports.AcceleratorType = AcceleratorType;
_a = JSII_RTTI_SYMBOL_1;
AcceleratorType[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.AcceleratorType", version: "2.52.1-alpha.0" };
/**
 * ml.eia1.large
 */
AcceleratorType.EIA1_LARGE = AcceleratorType.of('ml.eia1.large');
/**
 * ml.eia1.medium
 */
AcceleratorType.EIA1_MEDIUM = AcceleratorType.of('ml.eia1.medium');
/**
 * ml.eia1.xlarge
 */
AcceleratorType.EIA1_XLARGE = AcceleratorType.of('ml.eia1.xlarge');
/**
 * ml.eia2.large
 */
AcceleratorType.EIA2_LARGE = AcceleratorType.of('ml.eia2.large');
/**
 * ml.eia2.medium
 */
AcceleratorType.EIA2_MEDIUM = AcceleratorType.of('ml.eia2.medium');
/**
 * ml.eia2.xlarge
 */
AcceleratorType.EIA2_XLARGE = AcceleratorType.of('ml.eia2.xlarge');
//# sourceMappingURL=data:application/json;base64,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