# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, constr

from .. import EnvScopedObjectReference, GlobalObjectReference
from .. import ListMeta
from .. import ObjectMeta


class ApiVersion(Enum):
    tableflow_v1 = 'tableflow/v1'


class Kind(Enum):
    region = 'Region'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/tableflow/v1/regions/r-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/region=r-12345'
        ],
    )


class Region(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider that hosts the region.',
        examples=['AWS'],
    )
    region: Optional[str] = Field(
        None, description='The cloud service provider region.', examples=['us-east-2']
    )


class Kind1Model(Enum):
    tableflow_topic = 'TableflowTopic'


class Metadata1Model(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/tableflow/v1/tableflow-topics/tt-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/tableflow-topic=tt-12345'
        ],
    )


class TableflowTopicStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: Optional[str] = Field(
        None,
        description='The lifecycle phase of the Tableflow:\n\n  PENDING: Tableflow setup is pending;\n\n  RUNNING: Tableflow is currently running;\n\n  FAILED: Tableflow failed\n',
        examples=['PENDING'],
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if Tableflow topic is in an error state',
        examples=['Could not enable catalog integration'],
    )


class Kind1Model1(Enum):
    catalog_integration = 'CatalogIntegration'


class Metadata1Model1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/catalog-integrations/tci-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/catalog-integration=tci-12345'
        ],
    )


class CatalogIntegrationStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: Optional[str] = Field(
        None,
        description='The lifecycle phase of the catalog integration:\n\n  PENDING: sync to catalog integration is pending;\n\n  CONNECTED: catalog integration is connected and syncing;\n\n  FAILED: catalog integration failed.\n',
        examples=['CONNECTED'],
    )
    error_message: Optional[str] = Field(
        None,
        description='Displayable error message if catalog integration is in a failed state.',
        examples=['Could not enable catalog integration'],
    )
    last_sync_at: Optional[str] = Field(
        None,
        description='The date and time at which the catalog was last synced. It is represented in RFC3339 format and is in UTC.\n',
    )


class TableFlowTopicConfigsSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    enable_compaction: Optional[bool] = Field(
        None,
        description='This flag determines whether to enable compaction for the Tableflow enabled topic.',
        examples=[True],
    )
    enable_partitioning: Optional[bool] = Field(
        None,
        description='This flag determines whether to enable partitioning for the Tableflow enabled topic.',
        examples=[True],
    )
    retention_ms: Optional[str] = Field(
        None,
        description='The maximum age, in milliseconds, of snapshots (for Iceberg) or versions (for Delta)\nto retain in the table for the Tableflow-enabled topic (snapshot/version expiration)\n\nThe default value is "604800000" milliseconds (equivalent to 7 days).\n\nThe minimum allowed value is "86400000" milliseconds (equivalent to 24 hours).\n',
        examples=['7776000000'],
    )
    record_failure_strategy: Optional[str] = Field(
        'SUSPEND',
        description='The strategy to handle record failures in the Tableflow enabled topic during materialization.\n\nFor `SKIP`, we skip the bad records and move to the next record,\n\nand for `SUSPEND`, we suspend the materialization of the topic.\n',
    )


class Kind1Model2(Enum):
    byob_aws = 'ByobAws'


class ByobAwsSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['ByobAws'] = Field(..., description='The storage type\n')
    bucket_name: str = Field(..., description='Bucket name', examples=['bucket_1'])
    bucket_region: Optional[str] = Field(
        None, description='Bucket region', examples=['us-east-1']
    )
    table_path: str = Field(..., description='Table path', examples=['table_path'])
    provider_integration_id: str = Field(
        ..., description='The provider integration id', examples=['cspi-stgce89r7']
    )


class Kind1Model3(Enum):
    managed = 'Managed'


class ManagedStorageSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Managed'] = Field(..., description='The storage type.\n')


class Kind1Model4(Enum):
    aws_glue = 'AwsGlue'


class CatalogIntegrationAwsGlueSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsGlue'] = Field(
        ..., description='The type of the catalog integration.'
    )
    provider_integration_id: str = Field(
        ..., description='The provider integration id.', examples=['cspi-stgce89r7']
    )


class Kind1Model5(Enum):
    snowflake = 'Snowflake'


class CatalogIntegrationSnowflakeSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Snowflake'] = Field(
        ..., description='The type of the catalog integration.'
    )
    endpoint: str = Field(
        ...,
        description='The catalog integration connection endpoint for Snowflake Open Catalog.\n',
        examples=['https://vuser1_polaris.snowflakecomputing.com/'],
    )
    client_id: str = Field(..., description='The client ID of the catalog integration.')
    client_secret: str = Field(
        ..., description='The client secret of the catalog integration.'
    )
    warehouse: str = Field(
        ..., description='Warehouse name of the Snowflake Open Catalog.'
    )
    allowed_scope: str = Field(
        ..., description='Allowed scope of the Snowflake Open Catalog.'
    )


class CatalogIntegrationSnowflakeUpdateSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Snowflake'] = Field(
        ..., description='The type of the catalog integration.'
    )
    endpoint: Optional[str] = Field(
        None,
        description='The catalog integration connection endpoint for Snowflake Open Catalog.',
        examples=['https://vuser1_polaris.snowflakecomputing.com/'],
    )
    client_id: Optional[str] = Field(
        None, description='The client ID of the catalog integration.'
    )
    client_secret: Optional[str] = Field(
        None, description='The client secret of the catalog integration.'
    )
    warehouse: Optional[str] = Field(
        None, description='Warehouse name of the Snowflake Open Catalog.'
    )
    allowed_scope: Optional[str] = Field(
        None, description='Allowed scope of the Snowflake Open Catalog.'
    )


class Kind1Model6(Enum):
    aws_glue = 'AwsGlue'


class CatalogIntegrationAwsGlueUpdateSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsGlue'] = Field(
        ..., description='The type of the catalog integration.'
    )


class Kind1Model7(Enum):
    catalog_integration_update_request = 'CatalogIntegrationUpdateRequest'


class Metadata1Model2(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/catalog-integration-update-requests/ciur-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/catalog-integration-update-request=ciur-12345'
        ],
    )


class CatalogIntegrationUpdateSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the catalog integration',
        examples=['catalog_integration_1'],
    )
    suspended: Optional[bool] = Field(
        None,
        description='Indicates whether the Catalog Integration should be suspended.',
        examples=[False],
    )
    config: Union[
        CatalogIntegrationAwsGlueUpdateSpec, CatalogIntegrationSnowflakeUpdateSpec
    ] = Field(..., description='The integration config', discriminator='kind')
    environment: GlobalObjectReference = Field(
        ...,
        description='The environment to which the target Kafka cluster belongs.',
        examples=[{'id': 'env-00000'}],
    )
    kafka_cluster: EnvScopedObjectReference = Field(
        ...,
        description='The kafka cluster of the topic for which Tableflow is enabled',
        examples=[{'id': 'lkc-00000'}],
    )


class Kind1Model8(Enum):
    region_list = 'RegionList'


class Metadata1Model3(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/tableflow/v1/regions']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/regions?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/regions?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/regions?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class RegionList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model8 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model3
    data: List[Region] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Kind1Model9(Enum):
    tableflow_topic_list = 'TableflowTopicList'


class Metadata1Model4(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/tableflow/v1/tableflow-topics']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/tableflow-topics?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/tableflow-topics?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/tableflow-topics?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class TableflowTopicSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the Kafka topic for which Tableflow is enabled.',
        examples=['topic_1'],
    )
    suspended: Optional[bool] = Field(
        None,
        description='Indicates whether the Tableflow should be suspended. The API allows setting it only to `false` i.e., to resume the Tableflow. Pausing the Tableflow on-demand is not currently supported.',
        examples=[False],
    )
    config: Optional[TableFlowTopicConfigsSpec] = Field(
        None, description='The config for the Tableflow enabled topic'
    )
    storage: Optional[Union[ByobAwsSpec, ManagedStorageSpec]] = Field(
        None, description='The storage config', discriminator='kind'
    )
    table_formats: Optional[List[str]] = Field(
        ['ICEBERG'],
        description='The supported table formats for the Tableflow-enabled topic.\n',
        examples=[['DELTA']],
        min_length=1,
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which the target Kafka cluster belongs.'
    )
    kafka_cluster: Optional[EnvScopedObjectReference] = Field(
        None,
        description='The kafka cluster of the topic for which Tableflow is enabled',
    )


class Kind1Model10(Enum):
    catalog_integration_list = 'CatalogIntegrationList'


class Metadata1Model5(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/tableflow/v1/catalog-integrations']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/catalog-integrations?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/catalog-integrations?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/tableflow/v1/catalog-integrations?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class CatalogIntegrationSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[str] = Field(
        None,
        description='The name of the catalog integration',
        examples=['catalog_integration_1'],
    )
    suspended: Optional[bool] = Field(
        None,
        description='Indicates whether the Catalog Integration should be suspended. The API allows setting it only to `false` i.e., to resume the Catalog Integration. Pausing the Catalog Integration on-demand is not currently supported.',
        examples=[False],
    )
    config: Optional[
        Union[CatalogIntegrationAwsGlueSpec, CatalogIntegrationSnowflakeSpec]
    ] = Field(None, description='The integration config', discriminator='kind')
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which the target Kafka cluster belongs.'
    )
    kafka_cluster: Optional[EnvScopedObjectReference] = Field(
        None,
        description='The kafka cluster of the topic for which Tableflow is enabled',
    )


class TableflowTopicSpecUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    suspended: Optional[bool] = Field(
        None,
        description='Indicates whether the Tableflow should be suspended. The API allows setting it only to `false` i.e., to resume the Tableflow. Pausing the Tableflow on-demand is not currently supported.',
        examples=[False],
    )
    config: Optional[TableFlowTopicConfigsSpec] = Field(
        None, description='The config for the Tableflow enabled topic'
    )
    table_formats: Optional[List[str]] = Field(
        ['ICEBERG'],
        description='The supported table formats for the Tableflow-enabled topic.\n',
        examples=[['DELTA']],
        min_length=1,
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which the target Kafka cluster belongs.'
    )
    kafka_cluster: Optional[EnvScopedObjectReference] = Field(
        None,
        description='The kafka cluster of the topic for which Tableflow is enabled',
    )


class Kind1Model11(Enum):
    tableflow_topic = 'TableflowTopic'


class Metadata1Model6(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/tableflow/v1/tableflow-topics/tt-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/tableflow-topic=tt-12345'
        ],
    )


class TableflowTopicUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model11] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    metadata: Optional[Metadata1Model6] = None
    spec: Optional[TableflowTopicSpecUpdate] = None
    status: Optional[TableflowTopicStatus] = None


class TableflowTopic(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    metadata: Optional[Metadata1Model] = None
    spec: Optional[TableflowTopicSpec] = None
    status: Optional[TableflowTopicStatus] = None


class CatalogIntegration(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model1] = None
    spec: Optional[CatalogIntegrationSpec] = None
    status: Optional[CatalogIntegrationStatus] = None


class CatalogIntegrationUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model7] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model2] = None
    spec: Optional[CatalogIntegrationUpdateSpec] = None


class Datum(TableflowTopic):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class TableflowTopicList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model9 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model4
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class Datum1Model(CatalogIntegration):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class CatalogIntegrationList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model10 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model5
    data: List[Datum1Model] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
