# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, conint, constr

from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    sts_v1 = 'sts/v1'


class Kind(Enum):
    token_exchange_request = 'TokenExchangeRequest'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/sts/v1/token-exchange-requests/ter-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/token-exchange-request=ter-12345'
        ],
    )


class TokenExchangeRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    grant_type: Optional[str] = Field(
        None,
        description='The grant type. Must be urn:ietf:params:oauth:grant-type:token-exchange, which indicates a token exchange.\n',
        examples=['urn:ietf:params:oauth:grant-type:token-exchange'],
    )
    subject_token: Optional[str] = Field(
        None,
        description='Confluent Cloud only accepts JSON Web Token (JWT) access tokens from customer identity provider',
        examples=['test_jwt_token'],
    )
    identity_pool_id: Optional[str] = Field(
        None,
        description='Identity pool is a group of external identities that are assigned a certain level of access based on policy\n',
        examples=['pool_1'],
    )
    subject_token_type: Optional[str] = Field(
        None,
        description='An identifier for the type of requested security token. Supported values\nis urn:ietf:params:oauth:token-type:jwt.\n',
        examples=['urn:ietf:params:oauth:token-type:jwt'],
    )
    requested_token_type: Optional[str] = Field(
        None,
        description='An identifier for the type of requested security token.\nSupported values is urn:ietf:params:oauth:token-type:access_token.\n',
        examples=['urn:ietf:params:oauth:token-type:access_token'],
    )
    expires_in: Optional[conint(le=900)] = Field(
        900,
        description='The amount of time, in seconds, between the time when the access token was issued\nand the time when the access token will expire\n',
    )


class TokenExchangeReply(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    access_token: str = Field(
        ...,
        description='An JWT access token, issued by Confluent, in response to the token exchange request.\nClient application could use the access token to access confluent public api\n',
    )
    issued_token_type: str = Field(
        ...,
        description='The token type. Always matches the value of requested_token_type from the request.',
        examples=['urn:ietf:params:oauth:token-type:access_token'],
    )
    token_type: str = Field(
        ...,
        description='Indicates the token type value. The only type that Confluent supports is Bearer',
        examples=['Bearer'],
    )
    expires_in: int = Field(
        ...,
        description='The length of time, in seconds, that the access token is valid.',
        examples=[3600],
    )
