# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import date
from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, ConfigDict, Field, constr

from ..CostListMeta import CostListMeta


class ApiVersion(Enum):
    billing_v1 = 'billing/v1'


class Kind(Enum):
    cost = 'Cost'


class Environment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[str] = Field(
        None, description='ID of the environment.', examples=['env-123']
    )


class Kind1Model(Enum):
    cost_list = 'CostList'


class Resource(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[str] = Field(
        None, description='ID of the resource.', examples=['lkc-12345']
    )
    display_name: Optional[str] = Field(
        None,
        description='Display name of the resource.',
        examples=['prod-kafka-cluster'],
    )
    environment: Optional[Environment] = Field(
        None, description='The environment associated with this resource'
    )


class Metadata(CostListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/billing/v1/costs?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Cost(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    start_date: Optional[date] = Field(
        None,
        description='Start date of time period (inclusive) to retrieve billing costs. It is represented in RFC3339 format and is in UTC.',
        examples=['2022-10-12'],
    )
    end_date: Optional[date] = Field(
        None,
        description='End date of time period (exclusive) to retrieve billing costs. It is represented in RFC3339 format and is in UTC.',
        examples=['2022-10-15'],
    )
    granularity: Optional[str] = Field(
        'DAILY', description='Granularity at which each line item is aggregated.'
    )
    network_access_type: Optional[str] = Field(
        None, description='Network access type for the cluster.', examples=['INTERNET']
    )
    product: Optional[str] = Field(
        None, description='Product name.', examples=['KAFKA']
    )
    line_type: Optional[str] = Field(
        None, description='Type of the line item.', examples=['KAFKA_NUM_CKUS']
    )
    price: Optional[float] = Field(
        None, description='Price for the line item in dollars.', examples=[1.5]
    )
    unit: Optional[str] = Field(
        None, description='Unit of the line item.', examples=['GB']
    )
    quantity: Optional[float] = Field(
        None, description='Quantity of the line item.', examples=[99.9]
    )
    original_amount: Optional[float] = Field(
        None,
        description='Original amount accrued for this line item.',
        examples=[149.85],
    )
    discount_amount: Optional[float] = Field(
        None,
        description='Amount discounted from the original amount in dollars.',
        examples=[20.85],
    )
    amount: Optional[float] = Field(
        None, description='Final amount after deducting discounts.', examples=[129]
    )
    resource: Optional[Resource] = Field(
        None, description='The resource for a given object'
    )


class CostList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata
    data: List[Cost] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
