/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.SuffixRule;
import uk.ac.cam.ch.wwmm.opsin.SuffixRuleType;

class SuffixRules {
    private final Map<String, Map<String, List<ApplicableSuffix>>> suffixApplicability;

    SuffixRules(ResourceGetter resourceGetter) throws IOException {
        Map<String, List<SuffixRule>> suffixRulesMap = this.generateSuffixRulesMap(resourceGetter);
        this.suffixApplicability = this.generateSuffixApplicabilityMap(resourceGetter, suffixRulesMap);
    }

    private Map<String, List<SuffixRule>> generateSuffixRulesMap(ResourceGetter resourceGetter) throws IOException {
        HashMap<String, List<SuffixRule>> suffixRulesMap = new HashMap<String, List<SuffixRule>>();
        XMLStreamReader reader = resourceGetter.getXMLStreamReader("suffixRules.xml");
        try {
            while (reader.hasNext()) {
                if (reader.next() != 1 || !reader.getLocalName().equals("rule")) continue;
                String ruleValue = reader.getAttributeValue(null, "value");
                if (suffixRulesMap.get(ruleValue) != null) {
                    throw new RuntimeException("Suffix: " + ruleValue + " appears multiple times in suffixRules.xml");
                }
                suffixRulesMap.put(ruleValue, this.processSuffixRules(reader));
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading suffixRules.xml", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading suffixRules.xml", e);
            }
        }
        return suffixRulesMap;
    }

    private List<SuffixRule> processSuffixRules(XMLStreamReader reader) throws XMLStreamException {
        String startingElName = reader.getLocalName();
        ArrayList<SuffixRule> rules = new ArrayList<SuffixRule>();
        while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String tagName = reader.getLocalName();
                    SuffixRuleType type = SuffixRuleType.valueOf(tagName);
                    ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                    int l = reader.getAttributeCount();
                    for (int i = 0; i < l; ++i) {
                        attributes.add(new Attribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i)));
                    }
                    rules.add(new SuffixRule(type, attributes));
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals(startingElName)) break;
                    return rules;
                }
            }
        }
        throw new RuntimeException("Malformed suffixRules.xml");
    }

    private Map<String, Map<String, List<ApplicableSuffix>>> generateSuffixApplicabilityMap(ResourceGetter resourceGetter, Map<String, List<SuffixRule>> suffixRulesMap) throws IOException {
        HashMap<String, Map<String, List<ApplicableSuffix>>> suffixApplicability = new HashMap<String, Map<String, List<ApplicableSuffix>>>();
        XMLStreamReader reader = resourceGetter.getXMLStreamReader("suffixApplicability.xml");
        try {
            block9: while (reader.hasNext()) {
                if (reader.next() != 1 || !reader.getLocalName().equals("groupType")) continue;
                HashMap suffixToRuleMap = new HashMap();
                suffixApplicability.put(reader.getAttributeValue(null, "type"), suffixToRuleMap);
                while (reader.hasNext()) {
                    int event = reader.next();
                    if (event == 1 && reader.getLocalName().equals("suffix")) {
                        String suffixValue = reader.getAttributeValue(null, "value");
                        ArrayList<ApplicableSuffix> suffixList = (ArrayList<ApplicableSuffix>)suffixToRuleMap.get(suffixValue);
                        if (suffixToRuleMap.get(suffixValue) == null) {
                            suffixList = new ArrayList<ApplicableSuffix>();
                            suffixToRuleMap.put(suffixValue, suffixList);
                        }
                        String requiredSubType = reader.getAttributeValue(null, "subType");
                        String suffixRuleName = reader.getElementText();
                        List<SuffixRule> suffixRules = suffixRulesMap.get(suffixRuleName);
                        if (suffixRules == null) {
                            throw new RuntimeException("Suffix: " + suffixRuleName + " does not have a rule associated with it in suffixRules.xml");
                        }
                        suffixList.add(new ApplicableSuffix(requiredSubType, suffixRules));
                        continue;
                    }
                    if (event != 2 || !reader.getLocalName().equals("groupType")) continue;
                    continue block9;
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing exception occurred while reading suffixApplicability.xml", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException("Parsing exception occurred while reading suffixApplicability.xml", e);
            }
        }
        return suffixApplicability;
    }

    List<SuffixRule> getSuffixRuleTags(String suffixTypeToUse, String suffixValue, String subgroupType) throws ComponentGenerationException {
        Map<String, List<ApplicableSuffix>> groupToSuffixMap = this.suffixApplicability.get(suffixTypeToUse);
        if (groupToSuffixMap == null) {
            throw new ComponentGenerationException("Suffix Type: " + suffixTypeToUse + " does not have a corresponding groupType entry in suffixApplicability.xml");
        }
        List<ApplicableSuffix> potentiallyApplicableSuffixes = groupToSuffixMap.get(suffixValue);
        if (potentiallyApplicableSuffixes == null || potentiallyApplicableSuffixes.isEmpty()) {
            throw new ComponentGenerationException("Suffix: " + suffixValue + " does not apply to the group it was associated with (type: " + suffixTypeToUse + ") according to suffixApplicability.xml");
        }
        List suffixRules = null;
        for (ApplicableSuffix suffix : potentiallyApplicableSuffixes) {
            if (suffix.requiredSubType != null && !suffix.requiredSubType.equals(subgroupType)) continue;
            if (suffixRules != null) {
                throw new ComponentGenerationException("Suffix: " + suffixValue + " appears multiple times in suffixApplicability.xml");
            }
            suffixRules = suffix.suffixRules;
        }
        if (suffixRules == null) {
            throw new ComponentGenerationException("Suffix: " + suffixValue + " does not apply to the group it was associated with (type: " + suffixTypeToUse + ") due to the group's subType: " + subgroupType + " according to suffixApplicability.xml");
        }
        return suffixRules;
    }

    boolean isGroupTypeWithSpecificSuffixRules(String groupType) {
        return this.suffixApplicability.containsKey(groupType);
    }

    private static class ApplicableSuffix {
        private final String requiredSubType;
        private final List<SuffixRule> suffixRules;

        public ApplicableSuffix(String requiredSubType, List<SuffixRule> suffixRules) {
            this.requiredSubType = requiredSubType;
            this.suffixRules = suffixRules;
        }
    }
}

