/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.CMLWriter;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.OpsinWarning;
import uk.ac.cam.ch.wwmm.opsin.SMILESWriter;

public class OpsinResult {
    private static final Logger LOG = LogManager.getLogger(OpsinResult.class);
    private final Fragment structure;
    private final OPSIN_RESULT_STATUS status;
    private final String message;
    private final String chemicalName;
    private final List<OpsinWarning> warnings;

    OpsinResult(Fragment frag, OPSIN_RESULT_STATUS status, List<OpsinWarning> warnings, String chemicalName) {
        this.structure = frag;
        this.status = status;
        StringBuilder sb = new StringBuilder();
        int l = warnings.size();
        for (int i = 0; i < l; ++i) {
            OpsinWarning warning = warnings.get(i);
            sb.append(warning.getType().toString());
            sb.append(": ");
            sb.append(warning.getMessage());
            if (i + 1 >= l) continue;
            sb.append("; ");
        }
        this.message = sb.toString();
        this.chemicalName = chemicalName;
        this.warnings = warnings;
    }

    OpsinResult(Fragment frag, OPSIN_RESULT_STATUS status, String message, String chemicalName) {
        this.structure = frag;
        this.status = status;
        this.message = message;
        this.chemicalName = chemicalName;
        this.warnings = Collections.emptyList();
    }

    Fragment getStructure() {
        return this.structure;
    }

    public OPSIN_RESULT_STATUS getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getChemicalName() {
        return this.chemicalName;
    }

    public String getCml() {
        if (this.structure != null) {
            try {
                return CMLWriter.generateCml(this.structure, this.chemicalName);
            }
            catch (Exception e) {
                LOG.debug("CML generation failed", (Throwable)e);
            }
        }
        return null;
    }

    public String getPrettyPrintedCml() {
        if (this.structure != null) {
            try {
                return CMLWriter.generateIndentedCml(this.structure, this.chemicalName);
            }
            catch (Exception e) {
                LOG.debug("CML generation failed", (Throwable)e);
            }
        }
        return null;
    }

    public String getSmiles() {
        return this.getSmiles(0);
    }

    public String getSmiles(int options) {
        if (this.structure != null) {
            try {
                return SMILESWriter.generateSmiles(this.structure, options);
            }
            catch (Exception e) {
                LOG.debug("SMILES generation failed", (Throwable)e);
            }
        }
        return null;
    }

    public String getExtendedSmiles() {
        if (this.structure != null) {
            try {
                return SMILESWriter.generateSmiles(this.structure, 15);
            }
            catch (Exception e) {
                LOG.debug("Extended SMILES generation failed", (Throwable)e);
            }
        }
        return null;
    }

    public List<OpsinWarning> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public boolean nameAppearsToBeAmbiguous() {
        for (OpsinWarning warning : this.warnings) {
            if (warning.getType() != OpsinWarning.OpsinWarningType.APPEARS_AMBIGUOUS) continue;
            return true;
        }
        return false;
    }

    public boolean stereochemistryIgnored() {
        for (OpsinWarning warning : this.warnings) {
            if (warning.getType() != OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED) continue;
            return true;
        }
        return false;
    }

    public static enum OPSIN_RESULT_STATUS {
        SUCCESS,
        WARNING,
        FAILURE;

    }
}

